/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2018-11-27 17:14:18 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `jmkn_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `jmkn_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=1243 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1078 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=311 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `jmkn_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: jmkn_comments */
INSERT INTO `jmkn_comments` VALUES("1", "1", "Un commentateur WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2018-11-22 17:59:28", "2018-11-22 16:59:28", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "post-trashed", "", "", "0", "0");

/* INSERT TABLE DATA: jmkn_duplicator_packages */
INSERT INTO `jmkn_duplicator_packages` VALUES("2", "20181127_yamoussoukroinphbalumni", "bcf2e9ff9cdff5cb1497_20181127171343", "20", "2018-11-27 17:14:17", "jmak", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-27 17:13:43\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.26\";s:10:\"VersionPHP\";s:6:\"5.6.25\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:2;s:4:\"Name\";s:32:\"20181127_yamoussoukroinphbalumni\";s:4:\"Hash\";s:35:\"bcf2e9ff9cdff5cb1497_20181127171343\";s:8:\"NameHash\";s:68:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:37:\"C:/wamp64/www/alumni/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://localhost:5050/alumni/wp-snapshots/\";s:8:\"ScanFile\";s:78:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:4:\"jmak\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:80:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:20:\"C:/wamp64/www/alumni\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-27 17:13:43\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.26\";s:10:\"VersionPHP\";s:6:\"5.6.25\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20181127_yamoussoukroinphbalumni\";s:4:\"Hash\";s:35:\"bcf2e9ff9cdff5cb1497_20181127171343\";s:8:\"NameHash\";s:68:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:37:\"C:/wamp64/www/alumni/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://localhost:5050/alumni/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:82:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:1;s:14:\"OptsSecurePass\";s:12:\"YXplcnR5MTIz\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:81:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:29:\"C:/wamp64/www/alumni/wp-admin\";i:1;s:39:\"C:/wamp64/www/alumni/wp-content/uploads\";i:2;s:41:\"C:/wamp64/www/alumni/wp-content/languages\";i:3;s:39:\"C:/wamp64/www/alumni/wp-content/plugins\";i:4;s:38:\"C:/wamp64/www/alumni/wp-content/themes\";i:5;s:32:\"C:/wamp64/www/alumni/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}");

/* INSERT TABLE DATA: jmkn_options */
INSERT INTO `jmkn_options` VALUES("1", "siteurl", "http://localhost:5050/alumni", "yes");
INSERT INTO `jmkn_options` VALUES("2", "home", "http://localhost:5050/alumni", "yes");
INSERT INTO `jmkn_options` VALUES("3", "blogname", "Yamoussoukro INP-HB ALUMNI", "yes");
INSERT INTO `jmkn_options` VALUES("4", "blogdescription", "INP-HB Alumni est le réseau des 57000 diplômés des formations de l&#039;INP-HB de Yamoussoukro, dont 8000 (de 5 nationalités) vivent hors de la Côte d&#039;Ivoire", "yes");
INSERT INTO `jmkn_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `jmkn_options` VALUES("6", "admin_email", "jmakdesign@gmail.com", "yes");
INSERT INTO `jmkn_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `jmkn_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `jmkn_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `jmkn_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `jmkn_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `jmkn_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `jmkn_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `jmkn_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `jmkn_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `jmkn_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `jmkn_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `jmkn_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `jmkn_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `jmkn_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `jmkn_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `jmkn_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `jmkn_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `jmkn_options` VALUES("24", "time_format", "G \\h i \\m\\i\\n", "yes");
INSERT INTO `jmkn_options` VALUES("25", "links_updated_date_format", "j F Y G \\h i \\m\\i\\n", "yes");
INSERT INTO `jmkn_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `jmkn_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `jmkn_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `jmkn_options` VALUES("29", "rewrite_rules", "a:401:{s:41:\"um-api/([^/]+)/([^/]+)/([^/]+)/([^/]+)/?$\";s:111:\"index.php?um_page=api&um_action=$matches[1]&um_resource=$matches[2]&um_method=$matches[3]&um_verify=$matches[4]\";s:46:\"um-download/([^/]+)/([^/]+)/([^/]+)/([^/]+)/?$\";s:111:\"index.php?um_action=download&um_form=$matches[1]&um_field=$matches[2]&um_user=$matches[3]&um_verify=$matches[4]\";s:15:\"user/([^/]+)/?$\";s:46:\"index.php?page_id=57&um_user=$matches[1]&lang=\";s:17:\"account/([^/]+)?$\";s:45:\"index.php?page_id=62&um_tab=$matches[1]&lang=\";s:16:\"feeds_sources/?$\";s:34:\"index.php?post_type=wpfcrf_sources\";s:46:\"feeds_sources/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=wpfcrf_sources&feed=$matches[1]\";s:41:\"feeds_sources/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?post_type=wpfcrf_sources&feed=$matches[1]\";s:33:\"feeds_sources/page/([0-9]{1,})/?$\";s:52:\"index.php?post_type=wpfcrf_sources&paged=$matches[1]\";s:14:\"feeds_items/?$\";s:32:\"index.php?post_type=wpfcrf_feeds\";s:44:\"feeds_items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=wpfcrf_feeds&feed=$matches[1]\";s:39:\"feeds_items/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=wpfcrf_feeds&feed=$matches[1]\";s:31:\"feeds_items/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=wpfcrf_feeds&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:8:\"story/?$\";s:25:\"index.php?post_type=story\";s:38:\"story/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=story&feed=$matches[1]\";s:33:\"story/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=story&feed=$matches[1]\";s:25:\"story/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=story&paged=$matches[1]\";s:8:\"event/?$\";s:25:\"index.php?post_type=event\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=event&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=event&paged=$matches[1]\";s:9:\"career/?$\";s:26:\"index.php?post_type=career\";s:39:\"career/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=career&feed=$matches[1]\";s:34:\"career/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=career&feed=$matches[1]\";s:26:\"career/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=career&paged=$matches[1]\";s:9:\"blocks/?$\";s:26:\"index.php?post_type=blocks\";s:39:\"blocks/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=blocks&feed=$matches[1]\";s:34:\"blocks/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=blocks&feed=$matches[1]\";s:26:\"blocks/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=blocks&paged=$matches[1]\";s:10:\"gallery/?$\";s:27:\"index.php?post_type=gallery\";s:40:\"gallery/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:35:\"gallery/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=gallery&feed=$matches[1]\";s:27:\"gallery/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=gallery&paged=$matches[1]\";s:12:\"directory/?$\";s:29:\"index.php?post_type=directory\";s:42:\"directory/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=directory&feed=$matches[1]\";s:37:\"directory/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=directory&feed=$matches[1]\";s:29:\"directory/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=directory&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/um-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&um-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/um-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&um-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:41:\"feeds_sources/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"feeds_sources/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"feeds_sources/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"feeds_sources/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"feeds_sources/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"feeds_sources/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"feeds_sources/([^/]+)/embed/?$\";s:53:\"index.php?wpfcrf_feeds_sources=$matches[1]&embed=true\";s:34:\"feeds_sources/([^/]+)/trackback/?$\";s:47:\"index.php?wpfcrf_feeds_sources=$matches[1]&tb=1\";s:54:\"feeds_sources/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?wpfcrf_feeds_sources=$matches[1]&feed=$matches[2]\";s:49:\"feeds_sources/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?wpfcrf_feeds_sources=$matches[1]&feed=$matches[2]\";s:42:\"feeds_sources/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?wpfcrf_feeds_sources=$matches[1]&paged=$matches[2]\";s:49:\"feeds_sources/([^/]+)/comment-page-([0-9]{1,})/?$\";s:60:\"index.php?wpfcrf_feeds_sources=$matches[1]&cpage=$matches[2]\";s:39:\"feeds_sources/([^/]+)/um-api(/(.*))?/?$\";s:61:\"index.php?wpfcrf_feeds_sources=$matches[1]&um-api=$matches[3]\";s:45:\"feeds_sources/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:56:\"feeds_sources/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:38:\"feeds_sources/([^/]+)(?:/([0-9]+))?/?$\";s:59:\"index.php?wpfcrf_feeds_sources=$matches[1]&page=$matches[2]\";s:30:\"feeds_sources/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"feeds_sources/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"feeds_sources/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"feeds_sources/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"feeds_sources/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"feeds_sources/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"feeds_items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"feeds_items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"feeds_items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"feeds_items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"feeds_items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"feeds_items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"feeds_items/([^/]+)/embed/?$\";s:45:\"index.php?wpfcrf_feeds=$matches[1]&embed=true\";s:32:\"feeds_items/([^/]+)/trackback/?$\";s:39:\"index.php?wpfcrf_feeds=$matches[1]&tb=1\";s:52:\"feeds_items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wpfcrf_feeds=$matches[1]&feed=$matches[2]\";s:47:\"feeds_items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wpfcrf_feeds=$matches[1]&feed=$matches[2]\";s:40:\"feeds_items/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?wpfcrf_feeds=$matches[1]&paged=$matches[2]\";s:47:\"feeds_items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?wpfcrf_feeds=$matches[1]&cpage=$matches[2]\";s:37:\"feeds_items/([^/]+)/um-api(/(.*))?/?$\";s:53:\"index.php?wpfcrf_feeds=$matches[1]&um-api=$matches[3]\";s:43:\"feeds_items/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:54:\"feeds_items/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:36:\"feeds_items/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?wpfcrf_feeds=$matches[1]&page=$matches[2]\";s:28:\"feeds_items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"feeds_items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"feeds_items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"feeds_items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"feeds_items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"feeds_items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"um_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"um_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"um_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"um_form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"um_form/([^/]+)/embed/?$\";s:40:\"index.php?um_form=$matches[1]&embed=true\";s:28:\"um_form/([^/]+)/trackback/?$\";s:34:\"index.php?um_form=$matches[1]&tb=1\";s:36:\"um_form/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?um_form=$matches[1]&paged=$matches[2]\";s:43:\"um_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?um_form=$matches[1]&cpage=$matches[2]\";s:33:\"um_form/([^/]+)/um-api(/(.*))?/?$\";s:48:\"index.php?um_form=$matches[1]&um-api=$matches[3]\";s:39:\"um_form/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:50:\"um_form/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:32:\"um_form/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?um_form=$matches[1]&page=$matches[2]\";s:24:\"um_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"um_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"um_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"um_form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"um_directory/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"um_directory/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"um_directory/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"um_directory/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"um_directory/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"um_directory/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"um_directory/([^/]+)/embed/?$\";s:45:\"index.php?um_directory=$matches[1]&embed=true\";s:33:\"um_directory/([^/]+)/trackback/?$\";s:39:\"index.php?um_directory=$matches[1]&tb=1\";s:41:\"um_directory/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?um_directory=$matches[1]&paged=$matches[2]\";s:48:\"um_directory/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?um_directory=$matches[1]&cpage=$matches[2]\";s:38:\"um_directory/([^/]+)/um-api(/(.*))?/?$\";s:53:\"index.php?um_directory=$matches[1]&um-api=$matches[3]\";s:44:\"um_directory/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:55:\"um_directory/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:37:\"um_directory/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?um_directory=$matches[1]&page=$matches[2]\";s:29:\"um_directory/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"um_directory/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"um_directory/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"um_directory/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"um_directory/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"um_directory/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"story/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"story/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"story/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"story/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"story/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"story/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:20:\"story/(.+?)/embed/?$\";s:38:\"index.php?story=$matches[1]&embed=true\";s:24:\"story/(.+?)/trackback/?$\";s:32:\"index.php?story=$matches[1]&tb=1\";s:44:\"story/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?story=$matches[1]&feed=$matches[2]\";s:39:\"story/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?story=$matches[1]&feed=$matches[2]\";s:32:\"story/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?story=$matches[1]&paged=$matches[2]\";s:39:\"story/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?story=$matches[1]&cpage=$matches[2]\";s:29:\"story/(.+?)/um-api(/(.*))?/?$\";s:46:\"index.php?story=$matches[1]&um-api=$matches[3]\";s:35:\"story/.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:46:\"story/.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:28:\"story/(.+?)(?:/([0-9]+))?/?$\";s:44:\"index.php?story=$matches[1]&page=$matches[2]\";s:55:\"story_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?story_category=$matches[1]&feed=$matches[2]\";s:50:\"story_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?story_category=$matches[1]&feed=$matches[2]\";s:31:\"story_category/([^/]+)/embed/?$\";s:47:\"index.php?story_category=$matches[1]&embed=true\";s:43:\"story_category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?story_category=$matches[1]&paged=$matches[2]\";s:25:\"story_category/([^/]+)/?$\";s:36:\"index.php?story_category=$matches[1]\";s:50:\"story_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?story_tag=$matches[1]&feed=$matches[2]\";s:45:\"story_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?story_tag=$matches[1]&feed=$matches[2]\";s:26:\"story_tag/([^/]+)/embed/?$\";s:42:\"index.php?story_tag=$matches[1]&embed=true\";s:38:\"story_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?story_tag=$matches[1]&paged=$matches[2]\";s:20:\"story_tag/([^/]+)/?$\";s:31:\"index.php?story_tag=$matches[1]\";s:31:\"event/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"event/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"event/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"event/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"event/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"event/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:20:\"event/(.+?)/embed/?$\";s:38:\"index.php?event=$matches[1]&embed=true\";s:24:\"event/(.+?)/trackback/?$\";s:32:\"index.php?event=$matches[1]&tb=1\";s:44:\"event/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:39:\"event/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?event=$matches[1]&feed=$matches[2]\";s:32:\"event/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&paged=$matches[2]\";s:39:\"event/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?event=$matches[1]&cpage=$matches[2]\";s:29:\"event/(.+?)/um-api(/(.*))?/?$\";s:46:\"index.php?event=$matches[1]&um-api=$matches[3]\";s:35:\"event/.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:46:\"event/.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:28:\"event/(.+?)(?:/([0-9]+))?/?$\";s:44:\"index.php?event=$matches[1]&page=$matches[2]\";s:55:\"event_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event_category=$matches[1]&feed=$matches[2]\";s:50:\"event_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?event_category=$matches[1]&feed=$matches[2]\";s:31:\"event_category/([^/]+)/embed/?$\";s:47:\"index.php?event_category=$matches[1]&embed=true\";s:43:\"event_category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?event_category=$matches[1]&paged=$matches[2]\";s:25:\"event_category/([^/]+)/?$\";s:36:\"index.php?event_category=$matches[1]\";s:50:\"event_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?event_tag=$matches[1]&feed=$matches[2]\";s:45:\"event_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?event_tag=$matches[1]&feed=$matches[2]\";s:26:\"event_tag/([^/]+)/embed/?$\";s:42:\"index.php?event_tag=$matches[1]&embed=true\";s:38:\"event_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?event_tag=$matches[1]&paged=$matches[2]\";s:20:\"event_tag/([^/]+)/?$\";s:31:\"index.php?event_tag=$matches[1]\";s:32:\"career/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"career/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"career/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"career/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"career/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"career/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"career/(.+?)/embed/?$\";s:39:\"index.php?career=$matches[1]&embed=true\";s:25:\"career/(.+?)/trackback/?$\";s:33:\"index.php?career=$matches[1]&tb=1\";s:45:\"career/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?career=$matches[1]&feed=$matches[2]\";s:40:\"career/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?career=$matches[1]&feed=$matches[2]\";s:33:\"career/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?career=$matches[1]&paged=$matches[2]\";s:40:\"career/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?career=$matches[1]&cpage=$matches[2]\";s:30:\"career/(.+?)/um-api(/(.*))?/?$\";s:47:\"index.php?career=$matches[1]&um-api=$matches[3]\";s:36:\"career/.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:47:\"career/.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:29:\"career/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?career=$matches[1]&page=$matches[2]\";s:56:\"career_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?career_category=$matches[1]&feed=$matches[2]\";s:51:\"career_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?career_category=$matches[1]&feed=$matches[2]\";s:32:\"career_category/([^/]+)/embed/?$\";s:48:\"index.php?career_category=$matches[1]&embed=true\";s:44:\"career_category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?career_category=$matches[1]&paged=$matches[2]\";s:26:\"career_category/([^/]+)/?$\";s:37:\"index.php?career_category=$matches[1]\";s:51:\"career_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?career_tag=$matches[1]&feed=$matches[2]\";s:46:\"career_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?career_tag=$matches[1]&feed=$matches[2]\";s:27:\"career_tag/([^/]+)/embed/?$\";s:43:\"index.php?career_tag=$matches[1]&embed=true\";s:39:\"career_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?career_tag=$matches[1]&paged=$matches[2]\";s:21:\"career_tag/([^/]+)/?$\";s:32:\"index.php?career_tag=$matches[1]\";s:32:\"blocks/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"blocks/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"blocks/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"blocks/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"blocks/(.+?)/embed/?$\";s:39:\"index.php?blocks=$matches[1]&embed=true\";s:25:\"blocks/(.+?)/trackback/?$\";s:33:\"index.php?blocks=$matches[1]&tb=1\";s:45:\"blocks/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?blocks=$matches[1]&feed=$matches[2]\";s:40:\"blocks/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?blocks=$matches[1]&feed=$matches[2]\";s:33:\"blocks/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&paged=$matches[2]\";s:40:\"blocks/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&cpage=$matches[2]\";s:30:\"blocks/(.+?)/um-api(/(.*))?/?$\";s:47:\"index.php?blocks=$matches[1]&um-api=$matches[3]\";s:36:\"blocks/.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:47:\"blocks/.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:29:\"blocks/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?blocks=$matches[1]&page=$matches[2]\";s:55:\"block_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?block_category=$matches[1]&feed=$matches[2]\";s:50:\"block_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?block_category=$matches[1]&feed=$matches[2]\";s:31:\"block_category/([^/]+)/embed/?$\";s:47:\"index.php?block_category=$matches[1]&embed=true\";s:43:\"block_category/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?block_category=$matches[1]&paged=$matches[2]\";s:25:\"block_category/([^/]+)/?$\";s:36:\"index.php?block_category=$matches[1]\";s:50:\"block_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?block_tag=$matches[1]&feed=$matches[2]\";s:45:\"block_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?block_tag=$matches[1]&feed=$matches[2]\";s:26:\"block_tag/([^/]+)/embed/?$\";s:42:\"index.php?block_tag=$matches[1]&embed=true\";s:38:\"block_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?block_tag=$matches[1]&paged=$matches[2]\";s:20:\"block_tag/([^/]+)/?$\";s:31:\"index.php?block_tag=$matches[1]\";s:33:\"gallery/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"gallery/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"gallery/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"gallery/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"gallery/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"gallery/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"gallery/(.+?)/embed/?$\";s:40:\"index.php?gallery=$matches[1]&embed=true\";s:26:\"gallery/(.+?)/trackback/?$\";s:34:\"index.php?gallery=$matches[1]&tb=1\";s:46:\"gallery/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:41:\"gallery/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?gallery=$matches[1]&feed=$matches[2]\";s:34:\"gallery/(.+?)/page/?([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&paged=$matches[2]\";s:41:\"gallery/(.+?)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?gallery=$matches[1]&cpage=$matches[2]\";s:31:\"gallery/(.+?)/um-api(/(.*))?/?$\";s:48:\"index.php?gallery=$matches[1]&um-api=$matches[3]\";s:37:\"gallery/.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:48:\"gallery/.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:30:\"gallery/(.+?)(?:/([0-9]+))?/?$\";s:46:\"index.php?gallery=$matches[1]&page=$matches[2]\";s:57:\"gallery_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery_category=$matches[1]&feed=$matches[2]\";s:52:\"gallery_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?gallery_category=$matches[1]&feed=$matches[2]\";s:33:\"gallery_category/([^/]+)/embed/?$\";s:49:\"index.php?gallery_category=$matches[1]&embed=true\";s:45:\"gallery_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?gallery_category=$matches[1]&paged=$matches[2]\";s:27:\"gallery_category/([^/]+)/?$\";s:38:\"index.php?gallery_category=$matches[1]\";s:52:\"gallery_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?gallery_tag=$matches[1]&feed=$matches[2]\";s:47:\"gallery_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?gallery_tag=$matches[1]&feed=$matches[2]\";s:28:\"gallery_tag/([^/]+)/embed/?$\";s:44:\"index.php?gallery_tag=$matches[1]&embed=true\";s:40:\"gallery_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?gallery_tag=$matches[1]&paged=$matches[2]\";s:22:\"gallery_tag/([^/]+)/?$\";s:33:\"index.php?gallery_tag=$matches[1]\";s:35:\"directory/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"directory/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"directory/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"directory/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"directory/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"directory/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"directory/(.+?)/embed/?$\";s:42:\"index.php?directory=$matches[1]&embed=true\";s:28:\"directory/(.+?)/trackback/?$\";s:36:\"index.php?directory=$matches[1]&tb=1\";s:48:\"directory/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?directory=$matches[1]&feed=$matches[2]\";s:43:\"directory/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?directory=$matches[1]&feed=$matches[2]\";s:36:\"directory/(.+?)/page/?([0-9]{1,})/?$\";s:49:\"index.php?directory=$matches[1]&paged=$matches[2]\";s:43:\"directory/(.+?)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?directory=$matches[1]&cpage=$matches[2]\";s:33:\"directory/(.+?)/um-api(/(.*))?/?$\";s:50:\"index.php?directory=$matches[1]&um-api=$matches[3]\";s:39:\"directory/.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:50:\"directory/.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:32:\"directory/(.+?)(?:/([0-9]+))?/?$\";s:48:\"index.php?directory=$matches[1]&page=$matches[2]\";s:59:\"directory_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?directory_category=$matches[1]&feed=$matches[2]\";s:54:\"directory_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?directory_category=$matches[1]&feed=$matches[2]\";s:35:\"directory_category/([^/]+)/embed/?$\";s:51:\"index.php?directory_category=$matches[1]&embed=true\";s:47:\"directory_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?directory_category=$matches[1]&paged=$matches[2]\";s:29:\"directory_category/([^/]+)/?$\";s:40:\"index.php?directory_category=$matches[1]\";s:54:\"directory_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?directory_tag=$matches[1]&feed=$matches[2]\";s:49:\"directory_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?directory_tag=$matches[1]&feed=$matches[2]\";s:30:\"directory_tag/([^/]+)/embed/?$\";s:46:\"index.php?directory_tag=$matches[1]&embed=true\";s:42:\"directory_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?directory_tag=$matches[1]&paged=$matches[2]\";s:24:\"directory_tag/([^/]+)/?$\";s:35:\"index.php?directory_tag=$matches[1]\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&um-api=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=50&cpage=$matches[1]\";s:17:\"um-api(/(.*))?/?$\";s:29:\"index.php?&um-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/um-api(/(.*))?/?$\";s:29:\"index.php?&um-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/um-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&um-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/um-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&um-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/um-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&um-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/um-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&um-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/um-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&um-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/um-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&um-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/um-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&um-api=$matches[3]\";s:31:\".?.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `jmkn_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `jmkn_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `jmkn_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `jmkn_options` VALUES("33", "active_plugins", "a:19:{i:0;s:19:\"akismet/akismet.php\";i:1;s:27:\"autoptimize/autoptimize.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:13:\"cmb2/init.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:9:\"hello.php\";i:7;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:8;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:9;s:53:\"re-add-underline-justify/re-add-underline-justify.php\";i:10;s:49:\"read-more-excerpt-link/read-more-excerpt-link.php\";i:11;s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";i:12;s:23:\"sayidan-plugin/init.php\";i:13;s:59:\"simple-scroll-to-top-button/simple-scroll-to-top-button.php\";i:14;s:39:\"siteorigin-panels/siteorigin-panels.php\";i:15;s:39:\"so-widgets-bundle/so-widgets-bundle.php\";i:16;s:37:\"super-socializer/super_socializer.php\";i:17;s:35:\"ultimate-member/ultimate-member.php\";i:18;s:59:\"wp-filter-combine-rss-feeds/wp-filter-combine-rss-feeds.php\";}", "yes");
INSERT INTO `jmkn_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `jmkn_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `jmkn_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `jmkn_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `jmkn_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `jmkn_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `jmkn_options` VALUES("40", "template", "sayidan", "yes");
INSERT INTO `jmkn_options` VALUES("41", "stylesheet", "sayidan", "yes");
INSERT INTO `jmkn_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `jmkn_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `jmkn_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `jmkn_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `jmkn_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `jmkn_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `jmkn_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `jmkn_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `jmkn_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `jmkn_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `jmkn_options` VALUES("52", "default_link_category", "0", "yes");
INSERT INTO `jmkn_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `jmkn_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `jmkn_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `jmkn_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `jmkn_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `jmkn_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `jmkn_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `jmkn_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `jmkn_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `jmkn_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `jmkn_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `jmkn_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `jmkn_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `jmkn_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `jmkn_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `jmkn_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `jmkn_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `jmkn_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `jmkn_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `jmkn_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `jmkn_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `jmkn_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `jmkn_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `jmkn_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `jmkn_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `jmkn_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("80", "widget_rss", "a:5:{i:1;a:0:{}i:2;a:6:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:3:\"url\";s:63:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/\";s:5:\"items\";i:10;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;}i:3;a:8:{s:5:\"title\";s:11:\"OFFRES CFAO\";s:3:\"url\";s:61:\"http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036\";s:4:\"link\";s:61:\"http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036\";s:5:\"items\";i:10;s:5:\"error\";b:0;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;}i:4;a:8:{s:5:\"title\";s:27:\"ACTUALITES EN COTE D\'IVOIRE\";s:3:\"url\";s:44:\"http://news.abidjan.net/xml/actu_all_rss.xml\";s:4:\"link\";s:25:\"https://news.abidjan.net/\";s:5:\"items\";i:10;s:5:\"error\";b:0;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("81", "uninstall_plugins", "a:3:{s:27:\"autoptimize/autoptimize.php\";s:29:\"autoptimizeMain::on_uninstall\";s:59:\"simple-scroll-to-top-button/simple-scroll-to-top-button.php\";s:26:\"spacexchimp_p008_uninstall\";s:53:\"re-add-underline-justify/re-add-underline-justify.php\";s:14:\"ratb_uninstall\";}", "no");
INSERT INTO `jmkn_options` VALUES("82", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `jmkn_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `jmkn_options` VALUES("84", "page_on_front", "50", "yes");
INSERT INTO `jmkn_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `jmkn_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `jmkn_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `jmkn_options` VALUES("88", "site_icon", "14", "yes");
INSERT INTO `jmkn_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `jmkn_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `jmkn_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `jmkn_options` VALUES("92", "show_comments_cookies_opt_in", "0", "yes");
INSERT INTO `jmkn_options` VALUES("93", "initial_db_version", "38590", "yes");
INSERT INTO `jmkn_options` VALUES("94", "jmkn_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `jmkn_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `jmkn_options` VALUES("96", "WPLANG", "fr_FR", "yes");
INSERT INTO `jmkn_options` VALUES("97", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("98", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("99", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("100", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("101", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("102", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:4:{i:0;s:23:\"sayidan_events_widget-2\";i:1;s:5:\"rss-4\";i:2;s:5:\"rss-2\";i:3;s:5:\"rss-3\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `jmkn_options` VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("106", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("107", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("108", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("109", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("110", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("111", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("112", "cron", "a:243:{i:1543339625;a:1:{s:26:\"um_hourly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1543341275;a:1:{s:15:\"wpfcfc_cron_job\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:2:\"1d\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1543341296;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1543341572;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1543343225;a:2:{s:30:\"um_twicedaily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:25:\"um_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1543357325;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357335;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357391;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357430;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357458;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357462;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357522;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357533;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357540;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357554;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357559;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357604;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357611;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357719;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357779;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357806;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357811;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543357946;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358003;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358012;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358027;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358049;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358060;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358070;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358147;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358166;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358172;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358180;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358300;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358421;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358541;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358661;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358782;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358844;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358904;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358910;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358920;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543358986;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359046;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359168;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359210;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359217;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359224;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359228;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359260;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359267;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359358;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359381;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359385;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359395;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359417;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359442;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359448;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359576;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359588;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359595;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359602;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359643;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359649;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359658;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359714;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359721;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359729;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359776;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359782;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359790;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359838;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359850;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359854;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359882;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543359914;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360035;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360092;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360114;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360131;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360154;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360219;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360340;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360400;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360521;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360642;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360702;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360762;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360798;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360820;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360828;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360842;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360850;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360856;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360862;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360875;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360889;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360896;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360935;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360958;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360982;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543360995;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361014;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361036;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361055;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361080;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361115;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361142;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361157;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361175;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361199;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361220;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361235;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361240;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361264;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361295;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361316;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361327;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361336;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361346;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361406;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361435;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361466;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361526;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361586;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361635;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361641;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361648;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361705;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361710;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361756;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361763;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361770;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361789;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361817;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361823;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361831;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361891;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361939;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543361946;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362008;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362036;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362041;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362111;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362134;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362142;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362152;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362161;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362171;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362185;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362191;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362208;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362213;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362237;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362245;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362305;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362312;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362322;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362351;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362361;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362367;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362376;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362436;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362450;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362460;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362465;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362531;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362540;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362552;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362562;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362568;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362576;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362618;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362627;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362635;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362641;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362650;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362655;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362721;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362782;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543362903;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543363024;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543363145;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543363266;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543370874;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543370987;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543371107;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543371167;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543371288;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543371409;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543371530;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543371650;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543377550;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543377555;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543377681;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543377801;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543377921;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378041;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378162;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378283;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378404;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378525;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378646;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378767;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543378888;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379009;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379129;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379251;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379371;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379493;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379613;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379734;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379856;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543379977;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380098;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380219;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380340;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380461;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380582;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380702;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380823;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543380944;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381065;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381172;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381173;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381182;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381197;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381216;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381265;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381325;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381361;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381366;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381395;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381399;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381521;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381641;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543381743;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1543386960;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1543424437;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1543424858;a:1:{s:28:\"um_check_extensions_licenses\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1543424925;a:1:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1543516025;a:1:{s:26:\"um_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `jmkn_options` VALUES("113", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1542906150;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `jmkn_options` VALUES("124", "_site_transient_timeout_browser_88948936c8355fa92108d4448c2520d0", "1543510800", "no");
INSERT INTO `jmkn_options` VALUES("125", "_site_transient_browser_88948936c8355fa92108d4448c2520d0", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"70.0.3538.102\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `jmkn_options` VALUES("131", "can_compress_scripts", "1", "no");
INSERT INTO `jmkn_options` VALUES("146", "theme_mods_sayidan", "a:7:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:31;}s:6:\"kenzap\";s:17:\"http://kenzap.com\";s:12:\"sayidan_logo\";s:72:\"http://localhost:5050/alumni/wp-content/uploads/2018/11/default-logo.png\";s:19:\"sayidan_logo_mobile\";s:72:\"http://localhost:5050/alumni/wp-content/uploads/2018/11/default-logo.png\";s:19:\"sayidan_logo_footer\";s:72:\"http://localhost:5050/alumni/wp-content/uploads/2018/11/default-logo.png\";s:16:\"sayidan_footnote\";s:121:\"© Yamoussoukro INP-HB Alumni, l\'association du réseau des ingénieurs, docteurs et élèves de l\'INP-HB de Yamoussoukro\";}", "yes");
INSERT INTO `jmkn_options` VALUES("151", "current_theme", "Sayidan", "yes");
INSERT INTO `jmkn_options` VALUES("152", "theme_switched", "", "yes");
INSERT INTO `jmkn_options` VALUES("154", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.0.5\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1542910057;s:7:\"version\";s:5:\"5.0.5\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `jmkn_options` VALUES("155", "siteorigin_panels_settings", "a:23:{s:10:\"post-types\";a:3:{i:0;s:4:\"page\";i:1;s:4:\"post\";i:2;s:5:\"event\";}s:22:\"live-editor-quick-link\";b:1;s:18:\"admin-widget-count\";b:0;s:15:\"parallax-motion\";s:0:\"\";s:17:\"sidebars-emulator\";b:1;s:14:\"display-teaser\";b:1;s:14:\"load-on-attach\";b:0;s:10:\"title-html\";s:39:\"<h3 class=\"widget-title\">{{title}}</h3>\";s:16:\"add-widget-class\";b:1;s:15:\"bundled-widgets\";b:0;s:19:\"recommended-widgets\";b:1;s:20:\"instant-open-widgets\";b:0;s:10:\"responsive\";b:1;s:13:\"tablet-layout\";b:0;s:13:\"legacy-layout\";s:4:\"auto\";s:12:\"tablet-width\";i:1024;s:12:\"mobile-width\";i:780;s:13:\"margin-bottom\";i:30;s:22:\"margin-bottom-last-row\";b:0;s:12:\"margin-sides\";i:30;s:20:\"full-width-container\";s:4:\"body\";s:12:\"copy-content\";b:1;s:11:\"copy-styles\";b:0;}", "yes");
INSERT INTO `jmkn_options` VALUES("156", "siteorigin_panels_initial_version", "2.9.2", "no");
INSERT INTO `jmkn_options` VALUES("157", "the_champ_general", "a:5:{s:13:\"footer_script\";s:1:\"1\";s:14:\"delete_options\";s:1:\"1\";s:18:\"browser_msg_enable\";s:1:\"1\";s:11:\"browser_msg\";s:121:\"Your browser is blocking some features of this website. Please follow the instructions at {support_url} to unblock these.\";s:10:\"custom_css\";s:0:\"\";}", "yes");
INSERT INTO `jmkn_options` VALUES("158", "the_champ_login", "a:16:{s:5:\"title\";s:25:\"Login with your Social ID\";s:19:\"email_error_message\";s:50:\"Email you entered is already registered or invalid\";s:6:\"avatar\";i:1;s:14:\"email_required\";i:1;s:14:\"password_email\";i:1;s:20:\"new_user_admin_email\";i:1;s:16:\"email_popup_text\";s:70:\"Please enter a valid email address. You might be required to verify it\";s:13:\"enableAtLogin\";i:1;s:16:\"enableAtRegister\";i:1;s:15:\"enableAtComment\";i:1;s:9:\"scl_title\";s:65:\"Link your social account to login to your account at this website\";s:12:\"link_account\";i:1;s:11:\"gdpr_enable\";i:1;s:18:\"privacy_policy_url\";s:0:\"\";s:25:\"privacy_policy_optin_text\";s:71:\"I agree to my personal data being stored and used as per Privacy Policy\";s:15:\"ppu_placeholder\";s:14:\"Privacy Policy\";}", "yes");
INSERT INTO `jmkn_options` VALUES("159", "the_champ_facebook", "a:11:{s:17:\"enable_commenting\";s:1:\"1\";s:17:\"enable_fbcomments\";s:1:\"1\";s:11:\"enable_page\";s:1:\"1\";s:11:\"enable_post\";s:1:\"1\";s:12:\"comment_lang\";s:5:\"fr_FR\";s:16:\"commenting_order\";s:36:\"wordpress,facebook,googleplus,disqus\";s:16:\"commenting_label\";s:13:\"Leave a reply\";s:24:\"label_wordpress_comments\";s:16:\"Default Comments\";s:23:\"label_facebook_comments\";s:17:\"Facebook Comments\";s:25:\"label_googleplus_comments\";s:11:\"G+ Comments\";s:21:\"label_disqus_comments\";s:15:\"Disqus Comments\";}", "yes");
INSERT INTO `jmkn_options` VALUES("160", "the_champ_sharing", "a:73:{s:6:\"enable\";s:1:\"1\";s:24:\"horizontal_sharing_shape\";s:5:\"round\";s:23:\"horizontal_sharing_size\";s:2:\"35\";s:24:\"horizontal_sharing_width\";s:2:\"70\";s:25:\"horizontal_sharing_height\";s:2:\"35\";s:24:\"horizontal_border_radius\";s:0:\"\";s:29:\"horizontal_font_color_default\";s:0:\"\";s:32:\"horizontal_sharing_replace_color\";s:4:\"#fff\";s:27:\"horizontal_font_color_hover\";s:0:\"\";s:38:\"horizontal_sharing_replace_color_hover\";s:4:\"#fff\";s:27:\"horizontal_bg_color_default\";s:0:\"\";s:25:\"horizontal_bg_color_hover\";s:0:\"\";s:31:\"horizontal_border_width_default\";s:0:\"\";s:31:\"horizontal_border_color_default\";s:0:\"\";s:29:\"horizontal_border_width_hover\";s:0:\"\";s:29:\"horizontal_border_color_hover\";s:0:\"\";s:22:\"vertical_sharing_shape\";s:6:\"square\";s:21:\"vertical_sharing_size\";s:2:\"40\";s:22:\"vertical_sharing_width\";s:2:\"80\";s:23:\"vertical_sharing_height\";s:2:\"40\";s:22:\"vertical_border_radius\";s:0:\"\";s:27:\"vertical_font_color_default\";s:0:\"\";s:30:\"vertical_sharing_replace_color\";s:4:\"#fff\";s:25:\"vertical_font_color_hover\";s:0:\"\";s:36:\"vertical_sharing_replace_color_hover\";s:4:\"#fff\";s:25:\"vertical_bg_color_default\";s:0:\"\";s:23:\"vertical_bg_color_hover\";s:0:\"\";s:29:\"vertical_border_width_default\";s:0:\"\";s:29:\"vertical_border_color_default\";s:0:\"\";s:27:\"vertical_border_width_hover\";s:0:\"\";s:27:\"vertical_border_color_hover\";s:0:\"\";s:10:\"hor_enable\";s:1:\"1\";s:21:\"horizontal_target_url\";s:7:\"default\";s:28:\"horizontal_target_url_custom\";s:0:\"\";s:5:\"title\";s:15:\"Spread the love\";s:18:\"instagram_username\";s:0:\"\";s:20:\"comment_container_id\";s:7:\"respond\";s:23:\"horizontal_re_providers\";a:9:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:11:\"google_plus\";i:3;s:8:\"linkedin\";i:4;s:9:\"pinterest\";i:5;s:6:\"reddit\";i:6;s:9:\"delicious\";i:7;s:3:\"mix\";i:8;s:8:\"whatsapp\";}s:21:\"hor_sharing_alignment\";s:4:\"left\";s:3:\"top\";s:1:\"1\";s:4:\"post\";s:1:\"1\";s:4:\"page\";s:1:\"1\";s:15:\"horizontal_more\";s:1:\"1\";s:15:\"vertical_enable\";s:1:\"1\";s:19:\"vertical_target_url\";s:7:\"default\";s:26:\"vertical_target_url_custom\";s:0:\"\";s:27:\"vertical_instagram_username\";s:0:\"\";s:29:\"vertical_comment_container_id\";s:7:\"respond\";s:21:\"vertical_re_providers\";a:9:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:11:\"google_plus\";i:3;s:8:\"linkedin\";i:4;s:9:\"pinterest\";i:5;s:6:\"reddit\";i:6;s:9:\"delicious\";i:7;s:3:\"mix\";i:8;s:8:\"whatsapp\";}s:11:\"vertical_bg\";s:0:\"\";s:9:\"alignment\";s:4:\"left\";s:11:\"left_offset\";s:3:\"-10\";s:12:\"right_offset\";s:3:\"-10\";s:10:\"top_offset\";s:3:\"100\";s:13:\"vertical_post\";s:1:\"1\";s:13:\"vertical_page\";s:1:\"1\";s:13:\"vertical_home\";s:1:\"1\";s:13:\"vertical_more\";s:1:\"1\";s:19:\"hide_mobile_sharing\";s:1:\"1\";s:21:\"vertical_screen_width\";s:3:\"783\";s:21:\"bottom_mobile_sharing\";s:1:\"1\";s:23:\"horizontal_screen_width\";s:3:\"783\";s:23:\"bottom_sharing_position\";s:1:\"0\";s:24:\"bottom_sharing_alignment\";s:4:\"left\";s:29:\"bottom_sharing_position_radio\";s:10:\"responsive\";s:14:\"bitly_username\";s:0:\"\";s:9:\"bitly_key\";s:0:\"\";s:31:\"share_count_cache_refresh_count\";s:2:\"10\";s:30:\"share_count_cache_refresh_unit\";s:7:\"minutes\";s:8:\"language\";s:5:\"fr_FR\";s:16:\"twitter_username\";s:0:\"\";s:15:\"buffer_username\";s:0:\"\";s:19:\"tweet_count_service\";s:14:\"opensharecount\";}", "yes");
INSERT INTO `jmkn_options` VALUES("161", "the_champ_counter", "a:4:{s:11:\"left_offset\";s:3:\"-10\";s:12:\"right_offset\";s:3:\"-10\";s:10:\"top_offset\";s:3:\"100\";s:9:\"alignment\";s:4:\"left\";}", "yes");
INSERT INTO `jmkn_options` VALUES("162", "the_champ_ss_version", "7.12.4", "yes");
INSERT INTO `jmkn_options` VALUES("163", "um_last_version_upgrade", "2.0.33", "yes");
INSERT INTO `jmkn_options` VALUES("164", "um_first_activation_date", "1542906458", "yes");
INSERT INTO `jmkn_options` VALUES("165", "um_version", "2.0.33", "yes");
INSERT INTO `jmkn_options` VALUES("166", "__ultimatemember_sitekey", "localhost:5050/alumni-evK0k7tPnXm1VL71ZJyJ", "yes");
INSERT INTO `jmkn_options` VALUES("167", "um_is_installed", "1", "yes");
INSERT INTO `jmkn_options` VALUES("168", "um_core_forms", "a:3:{s:8:\"register\";i:8;s:5:\"login\";i:9;s:7:\"profile\";i:10;}", "yes");
INSERT INTO `jmkn_options` VALUES("169", "um_core_directories", "a:1:{s:7:\"members\";i:11;}", "yes");
INSERT INTO `jmkn_options` VALUES("170", "um_options", "a:152:{s:30:\"restricted_access_post_metabox\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:19:\"uninstall_on_delete\";i:0;s:14:\"permalink_base\";s:10:\"user_login\";s:12:\"display_name\";s:9:\"full_name\";s:18:\"display_name_field\";s:0:\"\";s:15:\"author_redirect\";i:1;s:12:\"members_page\";i:1;s:13:\"use_gravatars\";i:0;s:37:\"use_um_gravatar_default_builtin_image\";s:7:\"default\";s:29:\"use_um_gravatar_default_image\";i:0;s:24:\"reset_require_strongpass\";i:0;s:20:\"account_tab_password\";i:1;s:19:\"account_tab_privacy\";i:1;s:25:\"account_tab_notifications\";i:1;s:18:\"account_tab_delete\";i:1;s:19:\"delete_account_text\";s:150:\"Are you sure you want to delete your account? This will erase all of your account data from the site. To delete your account enter your password below\";s:12:\"account_name\";i:1;s:20:\"account_name_disable\";i:0;s:20:\"account_name_require\";i:1;s:13:\"account_email\";i:1;s:25:\"account_hide_in_directory\";i:1;s:26:\"account_require_strongpass\";i:0;s:17:\"photo_thumb_sizes\";a:3:{i:0;i:40;i:1;i:80;i:2;i:190;}s:17:\"cover_thumb_sizes\";a:2:{i:0;i:300;i:1;i:600;}s:10:\"accessible\";i:0;s:15:\"access_redirect\";s:0:\"\";s:19:\"access_exclude_uris\";a:0:{}s:20:\"home_page_accessible\";i:1;s:24:\"category_page_accessible\";i:1;s:27:\"enable_reset_password_limit\";i:1;s:27:\"reset_password_limit_number\";i:3;s:14:\"blocked_emails\";s:0:\"\";s:13:\"blocked_words\";s:47:\"admin\r\nadministrator\r\nwebmaster\r\nsupport\r\nstaff\";s:14:\"default_avatar\";s:0:\"\";s:13:\"default_cover\";s:0:\"\";s:21:\"profile_show_metaicon\";i:0;s:12:\"profile_menu\";i:1;s:24:\"profile_menu_default_tab\";s:4:\"main\";s:18:\"profile_menu_icons\";i:1;s:13:\"form_asterisk\";i:0;s:13:\"profile_title\";s:28:\"{display_name} | {site_name}\";s:12:\"profile_desc\";s:83:\"{display_name} is on {site_name}. Join {site_name} to view {display_name}\'s profile\";s:11:\"admin_email\";s:20:\"jmakdesign@gmail.com\";s:9:\"mail_from\";s:26:\"Yamoussoukro INP-HB ALUMNI\";s:14:\"mail_from_addr\";s:20:\"jmakdesign@gmail.com\";s:10:\"email_html\";i:1;s:17:\"image_compression\";i:60;s:15:\"image_max_width\";i:1000;s:15:\"cover_min_width\";i:1000;s:22:\"profile_photo_max_size\";i:999999999;s:20:\"cover_photo_max_size\";i:999999999;s:22:\"custom_roles_increment\";i:1;s:16:\"profile_tab_main\";i:1;s:24:\"profile_tab_main_privacy\";i:0;s:22:\"profile_tab_main_roles\";s:0:\"\";s:17:\"profile_tab_posts\";i:1;s:25:\"profile_tab_posts_privacy\";i:0;s:23:\"profile_tab_posts_roles\";s:0:\"\";s:20:\"profile_tab_comments\";i:1;s:28:\"profile_tab_comments_privacy\";i:0;s:26:\"profile_tab_comments_roles\";s:0:\"\";s:16:\"welcome_email_on\";b:1;s:17:\"welcome_email_sub\";s:23:\"Welcome to {site_name}!\";s:13:\"welcome_email\";s:365:\"Hi {display_name},<br /><br />Thank you for signing up with {site_name}! Your account is now active.<br /><br />To login please visit the following url:<br /><br />{login_url} <br /><br />Your account e-mail: {email} <br />Your account username: {username} <br /><br />If you have any problems, please contact us at {admin_email}<br /><br />Thanks,<br />{site_name}\";s:18:\"checkmail_email_on\";s:1:\"1\";s:19:\"checkmail_email_sub\";s:28:\"Please activate your account\";s:15:\"checkmail_email\";s:304:\"Hi {display_name},<br /><br />Thank you for signing up with {site_name}! To activate your account, please click the link below to confirm your email address:<br /><br />{account_activation_link} <br /><br />If you have any problems, please contact us at {admin_email}<br /><br />Thanks, <br />{site_name}\";s:16:\"pending_email_on\";b:0;s:17:\"pending_email_sub\";s:30:\"[{site_name}] New user account\";s:13:\"pending_email\";s:309:\"Hi {display_name}, <br /><br />Thank you for signing up with {site_name}! Your account is currently being reviewed by a member of our team.<br /><br />Please allow us some time to process your request.<br /><br />If you have any problems, please contact us at {admin_email}<br /><br />Thanks,<br />{site_name}\";s:17:\"approved_email_on\";b:0;s:18:\"approved_email_sub\";s:41:\"Your account at {site_name} is now active\";s:14:\"approved_email\";s:438:\"Hi {display_name},<br /><br />Thank you for signing up with {site_name}! Your account has been approved and is now active.<br /><br />To login please visit the following url:<br /><br />{login_url}<br /><br />Your account e-mail: {email}<br />Your account username: {username}<br />Set your account password: {password_reset_link}<br /><br />If you have any problems, please contact us at {admin_email}<br /><br />Thanks,<br />{site_name}\";s:17:\"rejected_email_on\";b:0;s:18:\"rejected_email_sub\";s:30:\"Your account has been rejected\";s:14:\"rejected_email\";s:288:\"Hi {display_name},<br /><br />Thank you for applying for membership to {site_name}! We have reviewed your information and unfortunately we are unable to accept you as a member at this moment.<br /><br />Please feel free to apply again at a future date.<br /><br />Thanks,<br />{site_name}\";s:17:\"inactive_email_on\";b:1;s:18:\"inactive_email_sub\";s:33:\"Your account has been deactivated\";s:14:\"inactive_email\";s:250:\"Hi {display_name},<br /><br />This is an automated email to let you know your {site_name} account has been deactivated.<br /><br />If you would like your account to be reactivated please contact us at {admin_email}<br /><br />Thanks,<br />{site_name}\";s:17:\"deletion_email_on\";b:1;s:18:\"deletion_email_sub\";s:29:\"Your account has been deleted\";s:14:\"deletion_email\";s:355:\"Hi {display_name},<br /><br />This is an automated email to let you know your {site_name} account has been deleted. All of your personal information has been permanently deleted and you will no longer be able to login to {site_name}.<br /><br />If your account has been deleted by accident please contact us at {admin_email} <br />Thanks,<br />{site_name}\";s:16:\"resetpw_email_on\";b:1;s:17:\"resetpw_email_sub\";s:19:\"Reset your password\";s:13:\"resetpw_email\";s:303:\"Hi {display_name},<br /><br />We received a request to reset the password for your account. If you made this request, click the link below to change your password:<br /><br />{password_reset_link}<br /><br />If you didn\'t make this request, you can ignore this email <br /><br />Thanks,<br />{site_name}\";s:18:\"changedpw_email_on\";b:1;s:19:\"changedpw_email_sub\";s:42:\"Your {site_name} password has been changed\";s:15:\"changedpw_email\";s:307:\"Hi {display_name},<br /><br />You recently changed the password associated with your {site_name} account.<br /><br />If you did not make this change and believe your {site_name} account has been compromised, please contact us at the following email address: {admin_email}<br /><br />Thanks,<br />{site_name}\";s:23:\"changedaccount_email_on\";b:1;s:24:\"changedaccount_email_sub\";s:39:\"Your account at {site_name} was updated\";s:20:\"changedaccount_email\";s:278:\"Hi {display_name},<br /><br />You recently updated your {site_name} account.<br /><br />If you did not make this change and believe your {site_name} account has been compromised, please contact us at the following email address: {admin_email}<br /><br />Thanks,<br />{site_name}\";s:24:\"notification_new_user_on\";b:1;s:25:\"notification_new_user_sub\";s:30:\"[{site_name}] New user account\";s:21:\"notification_new_user\";s:211:\"{display_name} has just created an account on {site_name}. To view their profile click here:<br /><br />{user_profile_link}<br /><br />Here is the submitted registration form:<br /><br />{submitted_registration}\";s:22:\"notification_review_on\";b:0;s:23:\"notification_review_sub\";s:38:\"[{site_name}] New user awaiting review\";s:19:\"notification_review\";s:277:\"{display_name} has just applied for membership to {site_name} and is waiting to be reviewed.<br /><br />To review this member please click the following link:<br /><br />{user_profile_link}<br /><br />Here is the submitted registration form:<br /><br />{submitted_registration}\";s:24:\"notification_deletion_on\";b:0;s:25:\"notification_deletion_sub\";s:29:\"[{site_name}] Account deleted\";s:21:\"notification_deletion\";s:58:\"{display_name} has just deleted their {site_name} account.\";s:9:\"core_user\";s:2:\"57\";s:10:\"core_login\";s:2:\"58\";s:13:\"core_register\";s:2:\"59\";s:12:\"core_members\";s:2:\"60\";s:11:\"core_logout\";s:2:\"61\";s:12:\"core_account\";s:2:\"62\";s:19:\"core_password-reset\";s:2:\"63\";s:17:\"profile_show_name\";i:1;s:25:\"profile_show_social_links\";i:0;s:16:\"profile_show_bio\";i:1;s:21:\"profile_show_html_bio\";i:0;s:20:\"profile_bio_maxchars\";i:180;s:19:\"profile_header_menu\";s:2:\"bc\";s:18:\"profile_empty_text\";i:1;s:22:\"profile_empty_text_emo\";i:1;s:12:\"profile_role\";a:0:{}s:16:\"profile_template\";s:7:\"profile\";s:17:\"profile_max_width\";s:6:\"1000px\";s:22:\"profile_area_max_width\";s:5:\"600px\";s:13:\"profile_align\";s:6:\"center\";s:13:\"profile_icons\";s:5:\"label\";s:21:\"profile_cover_enabled\";i:1;s:19:\"profile_cover_ratio\";s:5:\"2.7:1\";s:17:\"profile_photosize\";s:5:\"190px\";s:19:\"profile_photocorner\";s:1:\"1\";s:17:\"profile_header_bg\";s:0:\"\";s:24:\"profile_primary_btn_word\";s:14:\"Update Profile\";s:21:\"profile_secondary_btn\";s:1:\"1\";s:26:\"profile_secondary_btn_word\";s:6:\"Cancel\";s:13:\"register_role\";s:1:\"0\";s:17:\"register_template\";s:8:\"register\";s:18:\"register_max_width\";s:5:\"450px\";s:14:\"register_align\";s:6:\"center\";s:14:\"register_icons\";s:5:\"label\";s:25:\"register_primary_btn_word\";s:8:\"Register\";s:22:\"register_secondary_btn\";i:1;s:27:\"register_secondary_btn_word\";s:5:\"Login\";s:26:\"register_secondary_btn_url\";s:0:\"\";s:14:\"login_template\";s:5:\"login\";s:15:\"login_max_width\";s:5:\"450px\";s:11:\"login_align\";s:6:\"center\";s:11:\"login_icons\";s:5:\"label\";s:22:\"login_primary_btn_word\";s:5:\"Login\";s:22:\"login_forgot_pass_link\";s:1:\"1\";s:21:\"login_show_rememberme\";s:1:\"1\";s:19:\"login_secondary_btn\";s:1:\"1\";s:24:\"login_secondary_btn_word\";s:8:\"Register\";s:23:\"login_secondary_btn_url\";s:0:\"\";s:18:\"directory_template\";s:7:\"members\";s:16:\"directory_header\";s:21:\"{total_users} Members\";s:23:\"directory_header_single\";s:20:\"{total_users} Member\";s:14:\"pages_settings\";s:0:\"\";}", "yes");
INSERT INTO `jmkn_options` VALUES("171", "um_role_subscriber_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `jmkn_options` VALUES("172", "um_role_author_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `jmkn_options` VALUES("173", "um_role_contributor_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `jmkn_options` VALUES("174", "um_role_editor_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `jmkn_options` VALUES("175", "um_role_administrator_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:1;s:24:\"_um_can_not_see_adminbar\";i:0;s:21:\"_um_can_edit_everyone\";i:1;s:23:\"_um_can_delete_everyone\";i:1;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:20:\"_um_default_homepage\";i:1;s:15:\"_um_after_login\";s:14:\"redirect_admin\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:1;s:30:\"_um_can_access_private_profile\";i:1;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `jmkn_options` VALUES("176", "recently_activated", "a:0:{}", "yes");
INSERT INTO `jmkn_options` VALUES("177", "autoptimize_version", "2.4.2", "yes");
INSERT INTO `jmkn_options` VALUES("178", "autoptimize_service_availablity", "a:2:{s:12:\"extra_imgopt\";a:3:{s:6:\"status\";s:2:\"up\";s:5:\"hosts\";a:1:{i:1;s:26:\"https://cdn.shortpixel.ai/\";}s:16:\"launch-threshold\";s:4:\"4096\";}s:7:\"critcss\";a:2:{s:6:\"status\";s:2:\"up\";s:5:\"hosts\";a:1:{i:1;s:24:\"https://criticalcss.com/\";}}}", "yes");
INSERT INTO `jmkn_options` VALUES("179", "siteorigin_panels_active_version", "2.9.2", "yes");
INSERT INTO `jmkn_options` VALUES("180", "widget_siteorigin-panels-post-content", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("181", "widget_siteorigin-panels-postloop", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("182", "widget_siteorigin-panels-builder", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("183", "widget_sayidan_aboutus_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("184", "widget_sayidan_feature_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("185", "widget_sayidan_banner_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("186", "widget_sayidan_stories_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("187", "widget_sayidan_newsletter_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("188", "widget_sayidan_application_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("189", "widget_sayidan_career_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("190", "widget_sayidan_contact_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("191", "widget_sayidan_gallery_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("192", "widget_sayidan_slider_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("193", "widget_sayidan_singleevent_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("194", "widget_sayidan_info_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("195", "widget_sayidan_blocks_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("196", "widget_sayidan_twitter2_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("197", "widget_sayidan_events_widget", "a:2:{i:2;a:7:{s:5:\"title\";s:11:\"Evènements\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"154055bf8434cdf28c598529481\";s:19:\"_sow_form_timestamp\";s:13:\"1542997484363\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("198", "widget_sayidan_directory_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("199", "widget_sayidan_news_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("200", "widget_sayidan_ourstory_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("201", "widget_sayidan_map_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("202", "widget_sow-button", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("203", "widget_sow-google-map", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("204", "widget_sow-image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("205", "widget_sow-slider", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("206", "widget_sow-post-carousel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("207", "widget_sow-editor", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("208", "widget_thechamplogin", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("209", "widget_thechamphorizontalsharing", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("210", "widget_thechampverticalsharing", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("211", "widget_thechamphorizontalcounter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("212", "widget_thechampverticalcounter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("213", "widget_thechampfollow", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("214", "widget_um_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("215", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("216", "um_cache_userdata_1", "a:97:{s:2:\"ID\";i:1;s:10:\"user_login\";s:4:\"jmak\";s:9:\"user_pass\";s:34:\"$P$Bl2ka1vjwjktGN5BlYJarV6beOqmJC0\";s:13:\"user_nicename\";s:4:\"jmak\";s:10:\"user_email\";s:20:\"jmakdesign@gmail.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-11-22 16:59:27\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:4:\"jmak\";s:13:\"administrator\";b:1;s:8:\"wp_roles\";s:13:\"administrator\";s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:6:\"filter\";N;s:16:\"\0WP_User\0site_id\";i:1;s:8:\"nickname\";s:4:\"jmak\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"rich_editing\";s:4:\"true\";s:19:\"syntax_highlighting\";s:4:\"true\";s:17:\"comment_shortcuts\";s:5:\"false\";s:11:\"admin_color\";s:5:\"fresh\";s:7:\"use_ssl\";s:1:\"0\";s:20:\"show_admin_bar_front\";s:4:\"true\";s:6:\"locale\";s:0:\"\";s:17:\"jmkn_capabilities\";s:31:\"a:1:{s:13:\"administrator\";b:1;}\";s:15:\"jmkn_user_level\";s:2:\"10\";s:18:\"show_welcome_panel\";s:1:\"1\";s:39:\"jmkn_dashboard_quick_press_last_post_id\";s:1:\"4\";s:14:\"account_status\";s:8:\"approved\";s:19:\"account_status_name\";s:8:\"Approved\";s:4:\"role\";s:13:\"administrator\";s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:18:\"can_access_wpadmin\";i:1;s:20:\"can_not_see_adminbar\";i:0;s:17:\"can_edit_everyone\";i:1;s:19:\"can_delete_everyone\";i:1;s:16:\"can_edit_profile\";i:1;s:18:\"can_delete_profile\";i:1;s:16:\"default_homepage\";i:1;s:11:\"after_login\";s:14:\"redirect_admin\";s:12:\"after_logout\";s:13:\"redirect_home\";s:12:\"can_view_all\";i:1;s:24:\"can_make_private_profile\";i:1;s:26:\"can_access_private_profile\";i:1;s:6:\"status\";s:8:\"approved\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:11:\"super_admin\";i:1;}", "no");
INSERT INTO `jmkn_options` VALUES("218", "siteorigin_widget_bundle_version", "1.13.3", "yes");
INSERT INTO `jmkn_options` VALUES("219", "siteorigin_widgets_old_widgets", "C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/accordion/accordion.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/button/button.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/cta/cta.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/contact/contact.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/editor/editor.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/features/features.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/google-map/google-map.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/headline/headline.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/hero/hero.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/icon/icon.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/image/image.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/image-grid/image-grid.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/slider/slider.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/layout-slider/layout-slider.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/post-carousel/post-carousel.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/price-table/price-table.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/simple-masonry/simple-masonry.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/social-media-buttons/social-media-buttons.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/tabs/tabs.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/taxonomy/taxonomy.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/testimonial/testimonial.php,C:\\wamp64\\www\\alumni\\wp-content\\plugins\\so-widgets-bundle/widgets/video/video.php", "yes");
INSERT INTO `jmkn_options` VALUES("220", "mc4wp_version", "4.2.5", "yes");
INSERT INTO `jmkn_options` VALUES("224", "autoptimize_imgopt_launched", "on", "yes");
INSERT INTO `jmkn_options` VALUES("225", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `jmkn_options` VALUES("237", "sayidan_last_pingback", "1542988381", "yes");
INSERT INTO `jmkn_options` VALUES("238", "sayidan_plugin_version", "0", "yes");
INSERT INTO `jmkn_options` VALUES("239", "sayidan_site_notice", "<h1>Copyright Infringement Notice</h1> One or more products stored on your server violates Kenzap Terms of Service. In order to prevent infringement and resolve the problem please contact <a href=\'http://kenzap.com/contacts/\' >Kenzap Support Team here.</a>", "yes");
INSERT INTO `jmkn_options` VALUES("240", "sayidan_admin_notice", "<div class=\"notice notice-error\">\n			            <h1>Copyright Infringement Notice</h1>\n			              <p>Your theme violates Kenzap Terms of Service. In order to prevent infringement and resolve the problem please contact Kenzap Support Team. For faster resolution please provide your:<b> <ul><li>Your Full Name</li><li>Purchase code</li><li>Country of residence</li><li></li></ul></b></p>\n			                <a href=\'http://kenzap.com/contacts/\' ><input type=\"submit\" name=\"save\" id=\"save-post\" class=\"button button-primary\" value=\"Contact Support\"></a>\n\n			                <br><br>\n			             </div>", "yes");
INSERT INTO `jmkn_options` VALUES("241", "widget_sayidan_popular_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("242", "widget_sayidan_twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("243", "widget_sayidan_popular_tags", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("246", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `jmkn_options` VALUES("254", "um_cache_fonticons", "a:1218:{i:0;s:13:\"um-icon-alert\";i:1;s:21:\"um-icon-alert-circled\";i:2;s:19:\"um-icon-android-add\";i:3;s:26:\"um-icon-android-add-circle\";i:4;s:27:\"um-icon-android-alarm-clock\";i:5;s:21:\"um-icon-android-alert\";i:6;s:20:\"um-icon-android-apps\";i:7;s:23:\"um-icon-android-archive\";i:8;s:26:\"um-icon-android-arrow-back\";i:9;s:26:\"um-icon-android-arrow-down\";i:10;s:30:\"um-icon-android-arrow-dropdown\";i:11;s:37:\"um-icon-android-arrow-dropdown-circle\";i:12;s:30:\"um-icon-android-arrow-dropleft\";i:13;s:37:\"um-icon-android-arrow-dropleft-circle\";i:14;s:31:\"um-icon-android-arrow-dropright\";i:15;s:38:\"um-icon-android-arrow-dropright-circle\";i:16;s:28:\"um-icon-android-arrow-dropup\";i:17;s:35:\"um-icon-android-arrow-dropup-circle\";i:18;s:29:\"um-icon-android-arrow-forward\";i:19;s:24:\"um-icon-android-arrow-up\";i:20;s:22:\"um-icon-android-attach\";i:21;s:19:\"um-icon-android-bar\";i:22;s:23:\"um-icon-android-bicycle\";i:23;s:20:\"um-icon-android-boat\";i:24;s:24:\"um-icon-android-bookmark\";i:25;s:20:\"um-icon-android-bulb\";i:26;s:19:\"um-icon-android-bus\";i:27;s:24:\"um-icon-android-calendar\";i:28;s:20:\"um-icon-android-call\";i:29;s:22:\"um-icon-android-camera\";i:30;s:22:\"um-icon-android-cancel\";i:31;s:19:\"um-icon-android-car\";i:32;s:20:\"um-icon-android-cart\";i:33;s:20:\"um-icon-android-chat\";i:34;s:24:\"um-icon-android-checkbox\";i:35;s:30:\"um-icon-android-checkbox-blank\";i:36;s:32:\"um-icon-android-checkbox-outline\";i:37;s:38:\"um-icon-android-checkbox-outline-blank\";i:38;s:32:\"um-icon-android-checkmark-circle\";i:39;s:25:\"um-icon-android-clipboard\";i:40;s:21:\"um-icon-android-close\";i:41;s:21:\"um-icon-android-cloud\";i:42;s:28:\"um-icon-android-cloud-circle\";i:43;s:26:\"um-icon-android-cloud-done\";i:44;s:29:\"um-icon-android-cloud-outline\";i:45;s:29:\"um-icon-android-color-palette\";i:46;s:23:\"um-icon-android-compass\";i:47;s:23:\"um-icon-android-contact\";i:48;s:24:\"um-icon-android-contacts\";i:49;s:24:\"um-icon-android-contract\";i:50;s:22:\"um-icon-android-create\";i:51;s:22:\"um-icon-android-delete\";i:52;s:23:\"um-icon-android-desktop\";i:53;s:24:\"um-icon-android-document\";i:54;s:20:\"um-icon-android-done\";i:55;s:24:\"um-icon-android-done-all\";i:56;s:24:\"um-icon-android-download\";i:57;s:22:\"um-icon-android-drafts\";i:58;s:20:\"um-icon-android-exit\";i:59;s:22:\"um-icon-android-expand\";i:60;s:24:\"um-icon-android-favorite\";i:61;s:32:\"um-icon-android-favorite-outline\";i:62;s:20:\"um-icon-android-film\";i:63;s:22:\"um-icon-android-folder\";i:64;s:27:\"um-icon-android-folder-open\";i:65;s:22:\"um-icon-android-funnel\";i:66;s:21:\"um-icon-android-globe\";i:67;s:20:\"um-icon-android-hand\";i:68;s:23:\"um-icon-android-hangout\";i:69;s:21:\"um-icon-android-happy\";i:70;s:20:\"um-icon-android-home\";i:71;s:21:\"um-icon-android-image\";i:72;s:22:\"um-icon-android-laptop\";i:73;s:20:\"um-icon-android-list\";i:74;s:22:\"um-icon-android-locate\";i:75;s:20:\"um-icon-android-lock\";i:76;s:20:\"um-icon-android-mail\";i:77;s:19:\"um-icon-android-map\";i:78;s:20:\"um-icon-android-menu\";i:79;s:26:\"um-icon-android-microphone\";i:80;s:30:\"um-icon-android-microphone-off\";i:81;s:31:\"um-icon-android-more-horizontal\";i:82;s:29:\"um-icon-android-more-vertical\";i:83;s:24:\"um-icon-android-navigate\";i:84;s:29:\"um-icon-android-notifications\";i:85;s:34:\"um-icon-android-notifications-none\";i:86;s:33:\"um-icon-android-notifications-off\";i:87;s:20:\"um-icon-android-open\";i:88;s:23:\"um-icon-android-options\";i:89;s:22:\"um-icon-android-people\";i:90;s:22:\"um-icon-android-person\";i:91;s:26:\"um-icon-android-person-add\";i:92;s:31:\"um-icon-android-phone-landscape\";i:93;s:30:\"um-icon-android-phone-portrait\";i:94;s:19:\"um-icon-android-pin\";i:95;s:21:\"um-icon-android-plane\";i:96;s:25:\"um-icon-android-playstore\";i:97;s:21:\"um-icon-android-print\";i:98;s:32:\"um-icon-android-radio-button-off\";i:99;s:31:\"um-icon-android-radio-button-on\";i:100;s:23:\"um-icon-android-refresh\";i:101;s:22:\"um-icon-android-remove\";i:102;s:29:\"um-icon-android-remove-circle\";i:103;s:26:\"um-icon-android-restaurant\";i:104;s:19:\"um-icon-android-sad\";i:105;s:22:\"um-icon-android-search\";i:106;s:20:\"um-icon-android-send\";i:107;s:24:\"um-icon-android-settings\";i:108;s:21:\"um-icon-android-share\";i:109;s:25:\"um-icon-android-share-alt\";i:110;s:20:\"um-icon-android-star\";i:111;s:25:\"um-icon-android-star-half\";i:112;s:28:\"um-icon-android-star-outline\";i:113;s:25:\"um-icon-android-stopwatch\";i:114;s:22:\"um-icon-android-subway\";i:115;s:21:\"um-icon-android-sunny\";i:116;s:20:\"um-icon-android-sync\";i:117;s:23:\"um-icon-android-textsms\";i:118;s:20:\"um-icon-android-time\";i:119;s:21:\"um-icon-android-train\";i:120;s:22:\"um-icon-android-unlock\";i:121;s:22:\"um-icon-android-upload\";i:122;s:27:\"um-icon-android-volume-down\";i:123;s:27:\"um-icon-android-volume-mute\";i:124;s:26:\"um-icon-android-volume-off\";i:125;s:25:\"um-icon-android-volume-up\";i:126;s:20:\"um-icon-android-walk\";i:127;s:23:\"um-icon-android-warning\";i:128;s:21:\"um-icon-android-watch\";i:129;s:20:\"um-icon-android-wifi\";i:130;s:16:\"um-icon-aperture\";i:131;s:15:\"um-icon-archive\";i:132;s:20:\"um-icon-arrow-down-a\";i:133;s:20:\"um-icon-arrow-down-b\";i:134;s:20:\"um-icon-arrow-down-c\";i:135;s:20:\"um-icon-arrow-expand\";i:136;s:29:\"um-icon-arrow-graph-down-left\";i:137;s:30:\"um-icon-arrow-graph-down-right\";i:138;s:27:\"um-icon-arrow-graph-up-left\";i:139;s:28:\"um-icon-arrow-graph-up-right\";i:140;s:20:\"um-icon-arrow-left-a\";i:141;s:20:\"um-icon-arrow-left-b\";i:142;s:20:\"um-icon-arrow-left-c\";i:143;s:18:\"um-icon-arrow-move\";i:144;s:20:\"um-icon-arrow-resize\";i:145;s:25:\"um-icon-arrow-return-left\";i:146;s:26:\"um-icon-arrow-return-right\";i:147;s:21:\"um-icon-arrow-right-a\";i:148;s:21:\"um-icon-arrow-right-b\";i:149;s:21:\"um-icon-arrow-right-c\";i:150;s:20:\"um-icon-arrow-shrink\";i:151;s:18:\"um-icon-arrow-swap\";i:152;s:18:\"um-icon-arrow-up-a\";i:153;s:18:\"um-icon-arrow-up-b\";i:154;s:18:\"um-icon-arrow-up-c\";i:155;s:16:\"um-icon-asterisk\";i:156;s:10:\"um-icon-at\";i:157;s:17:\"um-icon-backspace\";i:158;s:25:\"um-icon-backspace-outline\";i:159;s:11:\"um-icon-bag\";i:160;s:24:\"um-icon-battery-charging\";i:161;s:21:\"um-icon-battery-empty\";i:162;s:20:\"um-icon-battery-full\";i:163;s:20:\"um-icon-battery-half\";i:164;s:19:\"um-icon-battery-low\";i:165;s:14:\"um-icon-beaker\";i:166;s:12:\"um-icon-beer\";i:167;s:17:\"um-icon-bluetooth\";i:168;s:15:\"um-icon-bonfire\";i:169;s:16:\"um-icon-bookmark\";i:170;s:14:\"um-icon-bowtie\";i:171;s:17:\"um-icon-briefcase\";i:172;s:11:\"um-icon-bug\";i:173;s:18:\"um-icon-calculator\";i:174;s:16:\"um-icon-calendar\";i:175;s:14:\"um-icon-camera\";i:176;s:12:\"um-icon-card\";i:177;s:12:\"um-icon-cash\";i:178;s:15:\"um-icon-chatbox\";i:179;s:23:\"um-icon-chatbox-working\";i:180;s:17:\"um-icon-chatboxes\";i:181;s:18:\"um-icon-chatbubble\";i:182;s:26:\"um-icon-chatbubble-working\";i:183;s:19:\"um-icon-chatbubbles\";i:184;s:17:\"um-icon-checkmark\";i:185;s:25:\"um-icon-checkmark-circled\";i:186;s:23:\"um-icon-checkmark-round\";i:187;s:20:\"um-icon-chevron-down\";i:188;s:20:\"um-icon-chevron-left\";i:189;s:21:\"um-icon-chevron-right\";i:190;s:18:\"um-icon-chevron-up\";i:191;s:17:\"um-icon-clipboard\";i:192;s:13:\"um-icon-clock\";i:193;s:13:\"um-icon-close\";i:194;s:21:\"um-icon-close-circled\";i:195;s:19:\"um-icon-close-round\";i:196;s:25:\"um-icon-closed-captioning\";i:197;s:13:\"um-icon-cloud\";i:198;s:12:\"um-icon-code\";i:199;s:21:\"um-icon-code-download\";i:200;s:20:\"um-icon-code-working\";i:201;s:14:\"um-icon-coffee\";i:202;s:15:\"um-icon-compass\";i:203;s:15:\"um-icon-compose\";i:204;s:23:\"um-icon-connection-bars\";i:205;s:16:\"um-icon-contrast\";i:206;s:12:\"um-icon-crop\";i:207;s:12:\"um-icon-cube\";i:208;s:12:\"um-icon-disc\";i:209;s:16:\"um-icon-document\";i:210;s:21:\"um-icon-document-text\";i:211;s:12:\"um-icon-drag\";i:212;s:13:\"um-icon-earth\";i:213;s:13:\"um-icon-easel\";i:214;s:12:\"um-icon-edit\";i:215;s:11:\"um-icon-egg\";i:216;s:13:\"um-icon-eject\";i:217;s:13:\"um-icon-email\";i:218;s:20:\"um-icon-email-unread\";i:219;s:24:\"um-icon-erlenmeyer-flask\";i:220;s:32:\"um-icon-erlenmeyer-flask-bubbles\";i:221;s:11:\"um-icon-eye\";i:222;s:20:\"um-icon-eye-disabled\";i:223;s:14:\"um-icon-female\";i:224;s:14:\"um-icon-filing\";i:225;s:19:\"um-icon-film-marker\";i:226;s:16:\"um-icon-fireball\";i:227;s:12:\"um-icon-flag\";i:228;s:13:\"um-icon-flame\";i:229;s:13:\"um-icon-flash\";i:230;s:17:\"um-icon-flash-off\";i:231;s:14:\"um-icon-folder\";i:232;s:12:\"um-icon-fork\";i:233;s:17:\"um-icon-fork-repo\";i:234;s:15:\"um-icon-forward\";i:235;s:14:\"um-icon-funnel\";i:236;s:14:\"um-icon-gear-a\";i:237;s:14:\"um-icon-gear-b\";i:238;s:12:\"um-icon-grid\";i:239;s:14:\"um-icon-hammer\";i:240;s:13:\"um-icon-happy\";i:241;s:21:\"um-icon-happy-outline\";i:242;s:17:\"um-icon-headphone\";i:243;s:13:\"um-icon-heart\";i:244;s:20:\"um-icon-heart-broken\";i:245;s:12:\"um-icon-help\";i:246;s:17:\"um-icon-help-buoy\";i:247;s:20:\"um-icon-help-circled\";i:248;s:12:\"um-icon-home\";i:249;s:16:\"um-icon-icecream\";i:250;s:13:\"um-icon-image\";i:251;s:14:\"um-icon-images\";i:252;s:19:\"um-icon-information\";i:253;s:27:\"um-icon-information-circled\";i:254;s:13:\"um-icon-ionic\";i:255;s:17:\"um-icon-ios-alarm\";i:256;s:25:\"um-icon-ios-alarm-outline\";i:257;s:18:\"um-icon-ios-albums\";i:258;s:26:\"um-icon-ios-albums-outline\";i:259;s:28:\"um-icon-ios-americanfootball\";i:260;s:36:\"um-icon-ios-americanfootball-outline\";i:261;s:21:\"um-icon-ios-analytics\";i:262;s:29:\"um-icon-ios-analytics-outline\";i:263;s:22:\"um-icon-ios-arrow-back\";i:264;s:22:\"um-icon-ios-arrow-down\";i:265;s:25:\"um-icon-ios-arrow-forward\";i:266;s:22:\"um-icon-ios-arrow-left\";i:267;s:23:\"um-icon-ios-arrow-right\";i:268;s:27:\"um-icon-ios-arrow-thin-down\";i:269;s:27:\"um-icon-ios-arrow-thin-left\";i:270;s:28:\"um-icon-ios-arrow-thin-right\";i:271;s:25:\"um-icon-ios-arrow-thin-up\";i:272;s:20:\"um-icon-ios-arrow-up\";i:273;s:14:\"um-icon-ios-at\";i:274;s:22:\"um-icon-ios-at-outline\";i:275;s:19:\"um-icon-ios-barcode\";i:276;s:27:\"um-icon-ios-barcode-outline\";i:277;s:20:\"um-icon-ios-baseball\";i:278;s:28:\"um-icon-ios-baseball-outline\";i:279;s:22:\"um-icon-ios-basketball\";i:280;s:30:\"um-icon-ios-basketball-outline\";i:281;s:16:\"um-icon-ios-bell\";i:282;s:24:\"um-icon-ios-bell-outline\";i:283;s:16:\"um-icon-ios-body\";i:284;s:24:\"um-icon-ios-body-outline\";i:285;s:16:\"um-icon-ios-bolt\";i:286;s:24:\"um-icon-ios-bolt-outline\";i:287;s:16:\"um-icon-ios-book\";i:288;s:24:\"um-icon-ios-book-outline\";i:289;s:21:\"um-icon-ios-bookmarks\";i:290;s:29:\"um-icon-ios-bookmarks-outline\";i:291;s:15:\"um-icon-ios-box\";i:292;s:23:\"um-icon-ios-box-outline\";i:293;s:21:\"um-icon-ios-briefcase\";i:294;s:29:\"um-icon-ios-briefcase-outline\";i:295;s:20:\"um-icon-ios-browsers\";i:296;s:28:\"um-icon-ios-browsers-outline\";i:297;s:22:\"um-icon-ios-calculator\";i:298;s:30:\"um-icon-ios-calculator-outline\";i:299;s:20:\"um-icon-ios-calendar\";i:300;s:28:\"um-icon-ios-calendar-outline\";i:301;s:18:\"um-icon-ios-camera\";i:302;s:26:\"um-icon-ios-camera-outline\";i:303;s:16:\"um-icon-ios-cart\";i:304;s:24:\"um-icon-ios-cart-outline\";i:305;s:21:\"um-icon-ios-chatboxes\";i:306;s:29:\"um-icon-ios-chatboxes-outline\";i:307;s:22:\"um-icon-ios-chatbubble\";i:308;s:30:\"um-icon-ios-chatbubble-outline\";i:309;s:21:\"um-icon-ios-checkmark\";i:310;s:27:\"um-icon-ios-checkmark-empty\";i:311;s:29:\"um-icon-ios-checkmark-outline\";i:312;s:25:\"um-icon-ios-circle-filled\";i:313;s:26:\"um-icon-ios-circle-outline\";i:314;s:17:\"um-icon-ios-clock\";i:315;s:25:\"um-icon-ios-clock-outline\";i:316;s:17:\"um-icon-ios-close\";i:317;s:23:\"um-icon-ios-close-empty\";i:318;s:25:\"um-icon-ios-close-outline\";i:319;s:17:\"um-icon-ios-cloud\";i:320;s:26:\"um-icon-ios-cloud-download\";i:321;s:34:\"um-icon-ios-cloud-download-outline\";i:322;s:25:\"um-icon-ios-cloud-outline\";i:323;s:24:\"um-icon-ios-cloud-upload\";i:324;s:32:\"um-icon-ios-cloud-upload-outline\";i:325;s:18:\"um-icon-ios-cloudy\";i:326;s:24:\"um-icon-ios-cloudy-night\";i:327;s:32:\"um-icon-ios-cloudy-night-outline\";i:328;s:26:\"um-icon-ios-cloudy-outline\";i:329;s:15:\"um-icon-ios-cog\";i:330;s:23:\"um-icon-ios-cog-outline\";i:331;s:24:\"um-icon-ios-color-filter\";i:332;s:32:\"um-icon-ios-color-filter-outline\";i:333;s:22:\"um-icon-ios-color-wand\";i:334;s:30:\"um-icon-ios-color-wand-outline\";i:335;s:19:\"um-icon-ios-compose\";i:336;s:27:\"um-icon-ios-compose-outline\";i:337;s:19:\"um-icon-ios-contact\";i:338;s:27:\"um-icon-ios-contact-outline\";i:339;s:16:\"um-icon-ios-copy\";i:340;s:24:\"um-icon-ios-copy-outline\";i:341;s:16:\"um-icon-ios-crop\";i:342;s:23:\"um-icon-ios-crop-strong\";i:343;s:20:\"um-icon-ios-download\";i:344;s:28:\"um-icon-ios-download-outline\";i:345;s:16:\"um-icon-ios-drag\";i:346;s:17:\"um-icon-ios-email\";i:347;s:25:\"um-icon-ios-email-outline\";i:348;s:15:\"um-icon-ios-eye\";i:349;s:23:\"um-icon-ios-eye-outline\";i:350;s:23:\"um-icon-ios-fastforward\";i:351;s:31:\"um-icon-ios-fastforward-outline\";i:352;s:18:\"um-icon-ios-filing\";i:353;s:26:\"um-icon-ios-filing-outline\";i:354;s:16:\"um-icon-ios-film\";i:355;s:24:\"um-icon-ios-film-outline\";i:356;s:16:\"um-icon-ios-flag\";i:357;s:24:\"um-icon-ios-flag-outline\";i:358;s:17:\"um-icon-ios-flame\";i:359;s:25:\"um-icon-ios-flame-outline\";i:360;s:17:\"um-icon-ios-flask\";i:361;s:25:\"um-icon-ios-flask-outline\";i:362;s:18:\"um-icon-ios-flower\";i:363;s:26:\"um-icon-ios-flower-outline\";i:364;s:18:\"um-icon-ios-folder\";i:365;s:26:\"um-icon-ios-folder-outline\";i:366;s:20:\"um-icon-ios-football\";i:367;s:28:\"um-icon-ios-football-outline\";i:368;s:29:\"um-icon-ios-game-controller-a\";i:369;s:37:\"um-icon-ios-game-controller-a-outline\";i:370;s:29:\"um-icon-ios-game-controller-b\";i:371;s:37:\"um-icon-ios-game-controller-b-outline\";i:372;s:16:\"um-icon-ios-gear\";i:373;s:24:\"um-icon-ios-gear-outline\";i:374;s:19:\"um-icon-ios-glasses\";i:375;s:27:\"um-icon-ios-glasses-outline\";i:376;s:21:\"um-icon-ios-grid-view\";i:377;s:29:\"um-icon-ios-grid-view-outline\";i:378;s:17:\"um-icon-ios-heart\";i:379;s:25:\"um-icon-ios-heart-outline\";i:380;s:16:\"um-icon-ios-help\";i:381;s:22:\"um-icon-ios-help-empty\";i:382;s:24:\"um-icon-ios-help-outline\";i:383;s:16:\"um-icon-ios-home\";i:384;s:24:\"um-icon-ios-home-outline\";i:385;s:20:\"um-icon-ios-infinite\";i:386;s:28:\"um-icon-ios-infinite-outline\";i:387;s:23:\"um-icon-ios-information\";i:388;s:29:\"um-icon-ios-information-empty\";i:389;s:31:\"um-icon-ios-information-outline\";i:390;s:25:\"um-icon-ios-ionic-outline\";i:391;s:18:\"um-icon-ios-keypad\";i:392;s:26:\"um-icon-ios-keypad-outline\";i:393;s:21:\"um-icon-ios-lightbulb\";i:394;s:29:\"um-icon-ios-lightbulb-outline\";i:395;s:16:\"um-icon-ios-list\";i:396;s:24:\"um-icon-ios-list-outline\";i:397;s:20:\"um-icon-ios-location\";i:398;s:28:\"um-icon-ios-location-outline\";i:399;s:18:\"um-icon-ios-locked\";i:400;s:26:\"um-icon-ios-locked-outline\";i:401;s:16:\"um-icon-ios-loop\";i:402;s:23:\"um-icon-ios-loop-strong\";i:403;s:19:\"um-icon-ios-medical\";i:404;s:27:\"um-icon-ios-medical-outline\";i:405;s:18:\"um-icon-ios-medkit\";i:406;s:26:\"um-icon-ios-medkit-outline\";i:407;s:15:\"um-icon-ios-mic\";i:408;s:19:\"um-icon-ios-mic-off\";i:409;s:23:\"um-icon-ios-mic-outline\";i:410;s:17:\"um-icon-ios-minus\";i:411;s:23:\"um-icon-ios-minus-empty\";i:412;s:25:\"um-icon-ios-minus-outline\";i:413;s:19:\"um-icon-ios-monitor\";i:414;s:27:\"um-icon-ios-monitor-outline\";i:415;s:16:\"um-icon-ios-moon\";i:416;s:24:\"um-icon-ios-moon-outline\";i:417;s:16:\"um-icon-ios-more\";i:418;s:24:\"um-icon-ios-more-outline\";i:419;s:24:\"um-icon-ios-musical-note\";i:420;s:25:\"um-icon-ios-musical-notes\";i:421;s:20:\"um-icon-ios-navigate\";i:422;s:28:\"um-icon-ios-navigate-outline\";i:423;s:21:\"um-icon-ios-nutrition\";i:424;s:29:\"um-icon-ios-nutrition-outline\";i:425;s:17:\"um-icon-ios-paper\";i:426;s:25:\"um-icon-ios-paper-outline\";i:427;s:22:\"um-icon-ios-paperplane\";i:428;s:30:\"um-icon-ios-paperplane-outline\";i:429;s:23:\"um-icon-ios-partlysunny\";i:430;s:31:\"um-icon-ios-partlysunny-outline\";i:431;s:17:\"um-icon-ios-pause\";i:432;s:25:\"um-icon-ios-pause-outline\";i:433;s:15:\"um-icon-ios-paw\";i:434;s:23:\"um-icon-ios-paw-outline\";i:435;s:18:\"um-icon-ios-people\";i:436;s:26:\"um-icon-ios-people-outline\";i:437;s:18:\"um-icon-ios-person\";i:438;s:26:\"um-icon-ios-person-outline\";i:439;s:21:\"um-icon-ios-personadd\";i:440;s:29:\"um-icon-ios-personadd-outline\";i:441;s:18:\"um-icon-ios-photos\";i:442;s:26:\"um-icon-ios-photos-outline\";i:443;s:15:\"um-icon-ios-pie\";i:444;s:23:\"um-icon-ios-pie-outline\";i:445;s:16:\"um-icon-ios-pint\";i:446;s:24:\"um-icon-ios-pint-outline\";i:447;s:16:\"um-icon-ios-play\";i:448;s:24:\"um-icon-ios-play-outline\";i:449;s:16:\"um-icon-ios-plus\";i:450;s:22:\"um-icon-ios-plus-empty\";i:451;s:24:\"um-icon-ios-plus-outline\";i:452;s:20:\"um-icon-ios-pricetag\";i:453;s:28:\"um-icon-ios-pricetag-outline\";i:454;s:21:\"um-icon-ios-pricetags\";i:455;s:29:\"um-icon-ios-pricetags-outline\";i:456;s:19:\"um-icon-ios-printer\";i:457;s:27:\"um-icon-ios-printer-outline\";i:458;s:17:\"um-icon-ios-pulse\";i:459;s:24:\"um-icon-ios-pulse-strong\";i:460;s:17:\"um-icon-ios-rainy\";i:461;s:25:\"um-icon-ios-rainy-outline\";i:462;s:21:\"um-icon-ios-recording\";i:463;s:29:\"um-icon-ios-recording-outline\";i:464;s:16:\"um-icon-ios-redo\";i:465;s:24:\"um-icon-ios-redo-outline\";i:466;s:19:\"um-icon-ios-refresh\";i:467;s:25:\"um-icon-ios-refresh-empty\";i:468;s:27:\"um-icon-ios-refresh-outline\";i:469;s:18:\"um-icon-ios-reload\";i:470;s:26:\"um-icon-ios-reverse-camera\";i:471;s:34:\"um-icon-ios-reverse-camera-outline\";i:472;s:18:\"um-icon-ios-rewind\";i:473;s:26:\"um-icon-ios-rewind-outline\";i:474;s:16:\"um-icon-ios-rose\";i:475;s:24:\"um-icon-ios-rose-outline\";i:476;s:18:\"um-icon-ios-search\";i:477;s:25:\"um-icon-ios-search-strong\";i:478;s:20:\"um-icon-ios-settings\";i:479;s:27:\"um-icon-ios-settings-strong\";i:480;s:19:\"um-icon-ios-shuffle\";i:481;s:26:\"um-icon-ios-shuffle-strong\";i:482;s:24:\"um-icon-ios-skipbackward\";i:483;s:32:\"um-icon-ios-skipbackward-outline\";i:484;s:23:\"um-icon-ios-skipforward\";i:485;s:31:\"um-icon-ios-skipforward-outline\";i:486;s:17:\"um-icon-ios-snowy\";i:487;s:23:\"um-icon-ios-speedometer\";i:488;s:31:\"um-icon-ios-speedometer-outline\";i:489;s:16:\"um-icon-ios-star\";i:490;s:21:\"um-icon-ios-star-half\";i:491;s:24:\"um-icon-ios-star-outline\";i:492;s:21:\"um-icon-ios-stopwatch\";i:493;s:29:\"um-icon-ios-stopwatch-outline\";i:494;s:17:\"um-icon-ios-sunny\";i:495;s:25:\"um-icon-ios-sunny-outline\";i:496;s:21:\"um-icon-ios-telephone\";i:497;s:29:\"um-icon-ios-telephone-outline\";i:498;s:22:\"um-icon-ios-tennisball\";i:499;s:30:\"um-icon-ios-tennisball-outline\";i:500;s:24:\"um-icon-ios-thunderstorm\";i:501;s:32:\"um-icon-ios-thunderstorm-outline\";i:502;s:16:\"um-icon-ios-time\";i:503;s:24:\"um-icon-ios-time-outline\";i:504;s:17:\"um-icon-ios-timer\";i:505;s:25:\"um-icon-ios-timer-outline\";i:506;s:18:\"um-icon-ios-toggle\";i:507;s:26:\"um-icon-ios-toggle-outline\";i:508;s:17:\"um-icon-ios-trash\";i:509;s:25:\"um-icon-ios-trash-outline\";i:510;s:16:\"um-icon-ios-undo\";i:511;s:24:\"um-icon-ios-undo-outline\";i:512;s:20:\"um-icon-ios-unlocked\";i:513;s:28:\"um-icon-ios-unlocked-outline\";i:514;s:18:\"um-icon-ios-upload\";i:515;s:26:\"um-icon-ios-upload-outline\";i:516;s:20:\"um-icon-ios-videocam\";i:517;s:28:\"um-icon-ios-videocam-outline\";i:518;s:23:\"um-icon-ios-volume-high\";i:519;s:22:\"um-icon-ios-volume-low\";i:520;s:21:\"um-icon-ios-wineglass\";i:521;s:29:\"um-icon-ios-wineglass-outline\";i:522;s:17:\"um-icon-ios-world\";i:523;s:25:\"um-icon-ios-world-outline\";i:524;s:12:\"um-icon-ipad\";i:525;s:14:\"um-icon-iphone\";i:526;s:12:\"um-icon-ipod\";i:527;s:11:\"um-icon-jet\";i:528;s:11:\"um-icon-key\";i:529;s:13:\"um-icon-knife\";i:530;s:14:\"um-icon-laptop\";i:531;s:12:\"um-icon-leaf\";i:532;s:14:\"um-icon-levels\";i:533;s:17:\"um-icon-lightbulb\";i:534;s:12:\"um-icon-link\";i:535;s:14:\"um-icon-load-a\";i:536;s:14:\"um-icon-load-b\";i:537;s:14:\"um-icon-load-c\";i:538;s:14:\"um-icon-load-d\";i:539;s:16:\"um-icon-location\";i:540;s:24:\"um-icon-lock-combination\";i:541;s:14:\"um-icon-locked\";i:542;s:14:\"um-icon-log-in\";i:543;s:15:\"um-icon-log-out\";i:544;s:12:\"um-icon-loop\";i:545;s:14:\"um-icon-magnet\";i:546;s:12:\"um-icon-male\";i:547;s:11:\"um-icon-man\";i:548;s:11:\"um-icon-map\";i:549;s:14:\"um-icon-medkit\";i:550;s:13:\"um-icon-merge\";i:551;s:13:\"um-icon-mic-a\";i:552;s:13:\"um-icon-mic-b\";i:553;s:13:\"um-icon-mic-c\";i:554;s:13:\"um-icon-minus\";i:555;s:21:\"um-icon-minus-circled\";i:556;s:19:\"um-icon-minus-round\";i:557;s:15:\"um-icon-model-s\";i:558;s:15:\"um-icon-monitor\";i:559;s:12:\"um-icon-more\";i:560;s:13:\"um-icon-mouse\";i:561;s:18:\"um-icon-music-note\";i:562;s:15:\"um-icon-navicon\";i:563;s:21:\"um-icon-navicon-round\";i:564;s:16:\"um-icon-navigate\";i:565;s:15:\"um-icon-network\";i:566;s:18:\"um-icon-no-smoking\";i:567;s:15:\"um-icon-nuclear\";i:568;s:14:\"um-icon-outlet\";i:569;s:18:\"um-icon-paintbrush\";i:570;s:19:\"um-icon-paintbucket\";i:571;s:22:\"um-icon-paper-airplane\";i:572;s:17:\"um-icon-paperclip\";i:573;s:13:\"um-icon-pause\";i:574;s:14:\"um-icon-person\";i:575;s:18:\"um-icon-person-add\";i:576;s:22:\"um-icon-person-stalker\";i:577;s:17:\"um-icon-pie-graph\";i:578;s:11:\"um-icon-pin\";i:579;s:16:\"um-icon-pinpoint\";i:580;s:13:\"um-icon-pizza\";i:581;s:13:\"um-icon-plane\";i:582;s:14:\"um-icon-planet\";i:583;s:12:\"um-icon-play\";i:584;s:19:\"um-icon-playstation\";i:585;s:12:\"um-icon-plus\";i:586;s:20:\"um-icon-plus-circled\";i:587;s:18:\"um-icon-plus-round\";i:588;s:14:\"um-icon-podium\";i:589;s:13:\"um-icon-pound\";i:590;s:13:\"um-icon-power\";i:591;s:16:\"um-icon-pricetag\";i:592;s:17:\"um-icon-pricetags\";i:593;s:15:\"um-icon-printer\";i:594;s:20:\"um-icon-pull-request\";i:595;s:18:\"um-icon-qr-scanner\";i:596;s:13:\"um-icon-quote\";i:597;s:19:\"um-icon-radio-waves\";i:598;s:14:\"um-icon-record\";i:599;s:15:\"um-icon-refresh\";i:600;s:13:\"um-icon-reply\";i:601;s:17:\"um-icon-reply-all\";i:602;s:16:\"um-icon-ribbon-a\";i:603;s:16:\"um-icon-ribbon-b\";i:604;s:11:\"um-icon-sad\";i:605;s:19:\"um-icon-sad-outline\";i:606;s:16:\"um-icon-scissors\";i:607;s:14:\"um-icon-search\";i:608;s:16:\"um-icon-settings\";i:609;s:13:\"um-icon-share\";i:610;s:15:\"um-icon-shuffle\";i:611;s:21:\"um-icon-skip-backward\";i:612;s:20:\"um-icon-skip-forward\";i:613;s:22:\"um-icon-social-android\";i:614;s:30:\"um-icon-social-android-outline\";i:615;s:22:\"um-icon-social-angular\";i:616;s:30:\"um-icon-social-angular-outline\";i:617;s:20:\"um-icon-social-apple\";i:618;s:28:\"um-icon-social-apple-outline\";i:619;s:22:\"um-icon-social-bitcoin\";i:620;s:30:\"um-icon-social-bitcoin-outline\";i:621;s:21:\"um-icon-social-buffer\";i:622;s:29:\"um-icon-social-buffer-outline\";i:623;s:21:\"um-icon-social-chrome\";i:624;s:29:\"um-icon-social-chrome-outline\";i:625;s:22:\"um-icon-social-codepen\";i:626;s:30:\"um-icon-social-codepen-outline\";i:627;s:19:\"um-icon-social-css3\";i:628;s:27:\"um-icon-social-css3-outline\";i:629;s:27:\"um-icon-social-designernews\";i:630;s:35:\"um-icon-social-designernews-outline\";i:631;s:23:\"um-icon-social-dribbble\";i:632;s:31:\"um-icon-social-dribbble-outline\";i:633;s:22:\"um-icon-social-dropbox\";i:634;s:30:\"um-icon-social-dropbox-outline\";i:635;s:19:\"um-icon-social-euro\";i:636;s:27:\"um-icon-social-euro-outline\";i:637;s:23:\"um-icon-social-facebook\";i:638;s:31:\"um-icon-social-facebook-outline\";i:639;s:25:\"um-icon-social-foursquare\";i:640;s:33:\"um-icon-social-foursquare-outline\";i:641;s:28:\"um-icon-social-freebsd-devil\";i:642;s:21:\"um-icon-social-github\";i:643;s:29:\"um-icon-social-github-outline\";i:644;s:21:\"um-icon-social-google\";i:645;s:29:\"um-icon-social-google-outline\";i:646;s:25:\"um-icon-social-googleplus\";i:647;s:33:\"um-icon-social-googleplus-outline\";i:648;s:25:\"um-icon-social-hackernews\";i:649;s:33:\"um-icon-social-hackernews-outline\";i:650;s:20:\"um-icon-social-html5\";i:651;s:28:\"um-icon-social-html5-outline\";i:652;s:24:\"um-icon-social-instagram\";i:653;s:32:\"um-icon-social-instagram-outline\";i:654;s:25:\"um-icon-social-javascript\";i:655;s:33:\"um-icon-social-javascript-outline\";i:656;s:23:\"um-icon-social-linkedin\";i:657;s:31:\"um-icon-social-linkedin-outline\";i:658;s:23:\"um-icon-social-markdown\";i:659;s:21:\"um-icon-social-nodejs\";i:660;s:22:\"um-icon-social-octocat\";i:661;s:24:\"um-icon-social-pinterest\";i:662;s:32:\"um-icon-social-pinterest-outline\";i:663;s:21:\"um-icon-social-python\";i:664;s:21:\"um-icon-social-reddit\";i:665;s:29:\"um-icon-social-reddit-outline\";i:666;s:18:\"um-icon-social-rss\";i:667;s:26:\"um-icon-social-rss-outline\";i:668;s:19:\"um-icon-social-sass\";i:669;s:20:\"um-icon-social-skype\";i:670;s:28:\"um-icon-social-skype-outline\";i:671;s:23:\"um-icon-social-snapchat\";i:672;s:31:\"um-icon-social-snapchat-outline\";i:673;s:21:\"um-icon-social-tumblr\";i:674;s:29:\"um-icon-social-tumblr-outline\";i:675;s:18:\"um-icon-social-tux\";i:676;s:21:\"um-icon-social-twitch\";i:677;s:29:\"um-icon-social-twitch-outline\";i:678;s:22:\"um-icon-social-twitter\";i:679;s:30:\"um-icon-social-twitter-outline\";i:680;s:18:\"um-icon-social-usd\";i:681;s:26:\"um-icon-social-usd-outline\";i:682;s:20:\"um-icon-social-vimeo\";i:683;s:28:\"um-icon-social-vimeo-outline\";i:684;s:23:\"um-icon-social-whatsapp\";i:685;s:31:\"um-icon-social-whatsapp-outline\";i:686;s:22:\"um-icon-social-windows\";i:687;s:30:\"um-icon-social-windows-outline\";i:688;s:24:\"um-icon-social-wordpress\";i:689;s:32:\"um-icon-social-wordpress-outline\";i:690;s:20:\"um-icon-social-yahoo\";i:691;s:28:\"um-icon-social-yahoo-outline\";i:692;s:18:\"um-icon-social-yen\";i:693;s:26:\"um-icon-social-yen-outline\";i:694;s:22:\"um-icon-social-youtube\";i:695;s:30:\"um-icon-social-youtube-outline\";i:696;s:16:\"um-icon-soup-can\";i:697;s:24:\"um-icon-soup-can-outline\";i:698;s:20:\"um-icon-speakerphone\";i:699;s:19:\"um-icon-speedometer\";i:700;s:13:\"um-icon-spoon\";i:701;s:12:\"um-icon-star\";i:702;s:18:\"um-icon-stats-bars\";i:703;s:13:\"um-icon-steam\";i:704;s:12:\"um-icon-stop\";i:705;s:19:\"um-icon-thermometer\";i:706;s:18:\"um-icon-thumbsdown\";i:707;s:16:\"um-icon-thumbsup\";i:708;s:14:\"um-icon-toggle\";i:709;s:21:\"um-icon-toggle-filled\";i:710;s:19:\"um-icon-transgender\";i:711;s:15:\"um-icon-trash-a\";i:712;s:15:\"um-icon-trash-b\";i:713;s:14:\"um-icon-trophy\";i:714;s:14:\"um-icon-tshirt\";i:715;s:22:\"um-icon-tshirt-outline\";i:716;s:16:\"um-icon-umbrella\";i:717;s:18:\"um-icon-university\";i:718;s:16:\"um-icon-unlocked\";i:719;s:14:\"um-icon-upload\";i:720;s:11:\"um-icon-usb\";i:721;s:19:\"um-icon-videocamera\";i:722;s:19:\"um-icon-volume-high\";i:723;s:18:\"um-icon-volume-low\";i:724;s:21:\"um-icon-volume-medium\";i:725;s:19:\"um-icon-volume-mute\";i:726;s:12:\"um-icon-wand\";i:727;s:17:\"um-icon-waterdrop\";i:728;s:12:\"um-icon-wifi\";i:729;s:17:\"um-icon-wineglass\";i:730;s:13:\"um-icon-woman\";i:731;s:14:\"um-icon-wrench\";i:732;s:12:\"um-icon-xbox\";i:733;s:15:\"um-faicon-glass\";i:734;s:15:\"um-faicon-music\";i:735;s:16:\"um-faicon-search\";i:736;s:20:\"um-faicon-envelope-o\";i:737;s:15:\"um-faicon-heart\";i:738;s:14:\"um-faicon-star\";i:739;s:16:\"um-faicon-star-o\";i:740;s:14:\"um-faicon-user\";i:741;s:14:\"um-faicon-film\";i:742;s:18:\"um-faicon-th-large\";i:743;s:12:\"um-faicon-th\";i:744;s:17:\"um-faicon-th-list\";i:745;s:15:\"um-faicon-check\";i:746;s:15:\"um-faicon-times\";i:747;s:21:\"um-faicon-search-plus\";i:748;s:22:\"um-faicon-search-minus\";i:749;s:19:\"um-faicon-power-off\";i:750;s:16:\"um-faicon-signal\";i:751;s:13:\"um-faicon-cog\";i:752;s:17:\"um-faicon-trash-o\";i:753;s:14:\"um-faicon-home\";i:754;s:16:\"um-faicon-file-o\";i:755;s:17:\"um-faicon-clock-o\";i:756;s:14:\"um-faicon-road\";i:757;s:18:\"um-faicon-download\";i:758;s:29:\"um-faicon-arrow-circle-o-down\";i:759;s:27:\"um-faicon-arrow-circle-o-up\";i:760;s:15:\"um-faicon-inbox\";i:761;s:23:\"um-faicon-play-circle-o\";i:762;s:16:\"um-faicon-repeat\";i:763;s:17:\"um-faicon-refresh\";i:764;s:18:\"um-faicon-list-alt\";i:765;s:14:\"um-faicon-lock\";i:766;s:14:\"um-faicon-flag\";i:767;s:20:\"um-faicon-headphones\";i:768;s:20:\"um-faicon-volume-off\";i:769;s:21:\"um-faicon-volume-down\";i:770;s:19:\"um-faicon-volume-up\";i:771;s:16:\"um-faicon-qrcode\";i:772;s:17:\"um-faicon-barcode\";i:773;s:13:\"um-faicon-tag\";i:774;s:14:\"um-faicon-tags\";i:775;s:14:\"um-faicon-book\";i:776;s:18:\"um-faicon-bookmark\";i:777;s:15:\"um-faicon-print\";i:778;s:16:\"um-faicon-camera\";i:779;s:14:\"um-faicon-font\";i:780;s:14:\"um-faicon-bold\";i:781;s:16:\"um-faicon-italic\";i:782;s:21:\"um-faicon-text-height\";i:783;s:20:\"um-faicon-text-width\";i:784;s:20:\"um-faicon-align-left\";i:785;s:22:\"um-faicon-align-center\";i:786;s:21:\"um-faicon-align-right\";i:787;s:23:\"um-faicon-align-justify\";i:788;s:14:\"um-faicon-list\";i:789;s:17:\"um-faicon-outdent\";i:790;s:16:\"um-faicon-indent\";i:791;s:22:\"um-faicon-video-camera\";i:792;s:19:\"um-faicon-picture-o\";i:793;s:16:\"um-faicon-pencil\";i:794;s:20:\"um-faicon-map-marker\";i:795;s:16:\"um-faicon-adjust\";i:796;s:14:\"um-faicon-tint\";i:797;s:25:\"um-faicon-pencil-square-o\";i:798;s:24:\"um-faicon-share-square-o\";i:799;s:24:\"um-faicon-check-square-o\";i:800;s:16:\"um-faicon-arrows\";i:801;s:23:\"um-faicon-step-backward\";i:802;s:23:\"um-faicon-fast-backward\";i:803;s:18:\"um-faicon-backward\";i:804;s:14:\"um-faicon-play\";i:805;s:15:\"um-faicon-pause\";i:806;s:14:\"um-faicon-stop\";i:807;s:17:\"um-faicon-forward\";i:808;s:22:\"um-faicon-fast-forward\";i:809;s:22:\"um-faicon-step-forward\";i:810;s:15:\"um-faicon-eject\";i:811;s:22:\"um-faicon-chevron-left\";i:812;s:23:\"um-faicon-chevron-right\";i:813;s:21:\"um-faicon-plus-circle\";i:814;s:22:\"um-faicon-minus-circle\";i:815;s:22:\"um-faicon-times-circle\";i:816;s:22:\"um-faicon-check-circle\";i:817;s:25:\"um-faicon-question-circle\";i:818;s:21:\"um-faicon-info-circle\";i:819;s:20:\"um-faicon-crosshairs\";i:820;s:24:\"um-faicon-times-circle-o\";i:821;s:24:\"um-faicon-check-circle-o\";i:822;s:13:\"um-faicon-ban\";i:823;s:20:\"um-faicon-arrow-left\";i:824;s:21:\"um-faicon-arrow-right\";i:825;s:18:\"um-faicon-arrow-up\";i:826;s:20:\"um-faicon-arrow-down\";i:827;s:15:\"um-faicon-share\";i:828;s:16:\"um-faicon-expand\";i:829;s:18:\"um-faicon-compress\";i:830;s:14:\"um-faicon-plus\";i:831;s:15:\"um-faicon-minus\";i:832;s:18:\"um-faicon-asterisk\";i:833;s:28:\"um-faicon-exclamation-circle\";i:834;s:14:\"um-faicon-gift\";i:835;s:14:\"um-faicon-leaf\";i:836;s:14:\"um-faicon-fire\";i:837;s:13:\"um-faicon-eye\";i:838;s:19:\"um-faicon-eye-slash\";i:839;s:30:\"um-faicon-exclamation-triangle\";i:840;s:15:\"um-faicon-plane\";i:841;s:18:\"um-faicon-calendar\";i:842;s:16:\"um-faicon-random\";i:843;s:17:\"um-faicon-comment\";i:844;s:16:\"um-faicon-magnet\";i:845;s:20:\"um-faicon-chevron-up\";i:846;s:22:\"um-faicon-chevron-down\";i:847;s:17:\"um-faicon-retweet\";i:848;s:23:\"um-faicon-shopping-cart\";i:849;s:16:\"um-faicon-folder\";i:850;s:21:\"um-faicon-folder-open\";i:851;s:18:\"um-faicon-arrows-v\";i:852;s:18:\"um-faicon-arrows-h\";i:853;s:19:\"um-faicon-bar-chart\";i:854;s:24:\"um-faicon-twitter-square\";i:855;s:25:\"um-faicon-facebook-square\";i:856;s:22:\"um-faicon-camera-retro\";i:857;s:13:\"um-faicon-key\";i:858;s:14:\"um-faicon-cogs\";i:859;s:18:\"um-faicon-comments\";i:860;s:21:\"um-faicon-thumbs-o-up\";i:861;s:23:\"um-faicon-thumbs-o-down\";i:862;s:19:\"um-faicon-star-half\";i:863;s:17:\"um-faicon-heart-o\";i:864;s:18:\"um-faicon-sign-out\";i:865;s:25:\"um-faicon-linkedin-square\";i:866;s:20:\"um-faicon-thumb-tack\";i:867;s:23:\"um-faicon-external-link\";i:868;s:17:\"um-faicon-sign-in\";i:869;s:16:\"um-faicon-trophy\";i:870;s:23:\"um-faicon-github-square\";i:871;s:16:\"um-faicon-upload\";i:872;s:17:\"um-faicon-lemon-o\";i:873;s:15:\"um-faicon-phone\";i:874;s:18:\"um-faicon-square-o\";i:875;s:20:\"um-faicon-bookmark-o\";i:876;s:22:\"um-faicon-phone-square\";i:877;s:17:\"um-faicon-twitter\";i:878;s:18:\"um-faicon-facebook\";i:879;s:16:\"um-faicon-github\";i:880;s:16:\"um-faicon-unlock\";i:881;s:21:\"um-faicon-credit-card\";i:882;s:13:\"um-faicon-rss\";i:883;s:15:\"um-faicon-hdd-o\";i:884;s:18:\"um-faicon-bullhorn\";i:885;s:14:\"um-faicon-bell\";i:886;s:21:\"um-faicon-certificate\";i:887;s:22:\"um-faicon-hand-o-right\";i:888;s:21:\"um-faicon-hand-o-left\";i:889;s:19:\"um-faicon-hand-o-up\";i:890;s:21:\"um-faicon-hand-o-down\";i:891;s:27:\"um-faicon-arrow-circle-left\";i:892;s:28:\"um-faicon-arrow-circle-right\";i:893;s:25:\"um-faicon-arrow-circle-up\";i:894;s:27:\"um-faicon-arrow-circle-down\";i:895;s:15:\"um-faicon-globe\";i:896;s:16:\"um-faicon-wrench\";i:897;s:15:\"um-faicon-tasks\";i:898;s:16:\"um-faicon-filter\";i:899;s:19:\"um-faicon-briefcase\";i:900;s:20:\"um-faicon-arrows-alt\";i:901;s:15:\"um-faicon-users\";i:902;s:14:\"um-faicon-link\";i:903;s:15:\"um-faicon-cloud\";i:904;s:15:\"um-faicon-flask\";i:905;s:18:\"um-faicon-scissors\";i:906;s:17:\"um-faicon-files-o\";i:907;s:19:\"um-faicon-paperclip\";i:908;s:18:\"um-faicon-floppy-o\";i:909;s:16:\"um-faicon-square\";i:910;s:14:\"um-faicon-bars\";i:911;s:17:\"um-faicon-list-ul\";i:912;s:17:\"um-faicon-list-ol\";i:913;s:23:\"um-faicon-strikethrough\";i:914;s:19:\"um-faicon-underline\";i:915;s:15:\"um-faicon-table\";i:916;s:15:\"um-faicon-magic\";i:917;s:15:\"um-faicon-truck\";i:918;s:19:\"um-faicon-pinterest\";i:919;s:26:\"um-faicon-pinterest-square\";i:920;s:28:\"um-faicon-google-plus-square\";i:921;s:21:\"um-faicon-google-plus\";i:922;s:15:\"um-faicon-money\";i:923;s:20:\"um-faicon-caret-down\";i:924;s:18:\"um-faicon-caret-up\";i:925;s:20:\"um-faicon-caret-left\";i:926;s:21:\"um-faicon-caret-right\";i:927;s:17:\"um-faicon-columns\";i:928;s:14:\"um-faicon-sort\";i:929;s:19:\"um-faicon-sort-desc\";i:930;s:18:\"um-faicon-sort-asc\";i:931;s:18:\"um-faicon-envelope\";i:932;s:18:\"um-faicon-linkedin\";i:933;s:14:\"um-faicon-undo\";i:934;s:15:\"um-faicon-gavel\";i:935;s:20:\"um-faicon-tachometer\";i:936;s:19:\"um-faicon-comment-o\";i:937;s:20:\"um-faicon-comments-o\";i:938;s:14:\"um-faicon-bolt\";i:939;s:17:\"um-faicon-sitemap\";i:940;s:18:\"um-faicon-umbrella\";i:941;s:19:\"um-faicon-clipboard\";i:942;s:21:\"um-faicon-lightbulb-o\";i:943;s:18:\"um-faicon-exchange\";i:944;s:24:\"um-faicon-cloud-download\";i:945;s:22:\"um-faicon-cloud-upload\";i:946;s:17:\"um-faicon-user-md\";i:947;s:21:\"um-faicon-stethoscope\";i:948;s:18:\"um-faicon-suitcase\";i:949;s:16:\"um-faicon-bell-o\";i:950;s:16:\"um-faicon-coffee\";i:951;s:17:\"um-faicon-cutlery\";i:952;s:21:\"um-faicon-file-text-o\";i:953;s:20:\"um-faicon-building-o\";i:954;s:20:\"um-faicon-hospital-o\";i:955;s:19:\"um-faicon-ambulance\";i:956;s:16:\"um-faicon-medkit\";i:957;s:21:\"um-faicon-fighter-jet\";i:958;s:14:\"um-faicon-beer\";i:959;s:18:\"um-faicon-h-square\";i:960;s:21:\"um-faicon-plus-square\";i:961;s:27:\"um-faicon-angle-double-left\";i:962;s:28:\"um-faicon-angle-double-right\";i:963;s:25:\"um-faicon-angle-double-up\";i:964;s:27:\"um-faicon-angle-double-down\";i:965;s:20:\"um-faicon-angle-left\";i:966;s:21:\"um-faicon-angle-right\";i:967;s:18:\"um-faicon-angle-up\";i:968;s:20:\"um-faicon-angle-down\";i:969;s:17:\"um-faicon-desktop\";i:970;s:16:\"um-faicon-laptop\";i:971;s:16:\"um-faicon-tablet\";i:972;s:16:\"um-faicon-mobile\";i:973;s:18:\"um-faicon-circle-o\";i:974;s:20:\"um-faicon-quote-left\";i:975;s:21:\"um-faicon-quote-right\";i:976;s:17:\"um-faicon-spinner\";i:977;s:14:\"um-faicon-spin\";i:978;s:16:\"um-faicon-circle\";i:979;s:15:\"um-faicon-reply\";i:980;s:20:\"um-faicon-github-alt\";i:981;s:18:\"um-faicon-folder-o\";i:982;s:23:\"um-faicon-folder-open-o\";i:983;s:17:\"um-faicon-smile-o\";i:984;s:17:\"um-faicon-frown-o\";i:985;s:15:\"um-faicon-meh-o\";i:986;s:17:\"um-faicon-gamepad\";i:987;s:20:\"um-faicon-keyboard-o\";i:988;s:16:\"um-faicon-flag-o\";i:989;s:24:\"um-faicon-flag-checkered\";i:990;s:18:\"um-faicon-terminal\";i:991;s:14:\"um-faicon-code\";i:992;s:19:\"um-faicon-reply-all\";i:993;s:21:\"um-faicon-star-half-o\";i:994;s:24:\"um-faicon-location-arrow\";i:995;s:14:\"um-faicon-crop\";i:996;s:19:\"um-faicon-code-fork\";i:997;s:22:\"um-faicon-chain-broken\";i:998;s:18:\"um-faicon-question\";i:999;s:14:\"um-faicon-info\";i:1000;s:21:\"um-faicon-exclamation\";i:1001;s:21:\"um-faicon-superscript\";i:1002;s:19:\"um-faicon-subscript\";i:1003;s:16:\"um-faicon-eraser\";i:1004;s:22:\"um-faicon-puzzle-piece\";i:1005;s:20:\"um-faicon-microphone\";i:1006;s:26:\"um-faicon-microphone-slash\";i:1007;s:16:\"um-faicon-shield\";i:1008;s:20:\"um-faicon-calendar-o\";i:1009;s:27:\"um-faicon-fire-extinguisher\";i:1010;s:16:\"um-faicon-rocket\";i:1011;s:16:\"um-faicon-maxcdn\";i:1012;s:29:\"um-faicon-chevron-circle-left\";i:1013;s:30:\"um-faicon-chevron-circle-right\";i:1014;s:27:\"um-faicon-chevron-circle-up\";i:1015;s:29:\"um-faicon-chevron-circle-down\";i:1016;s:15:\"um-faicon-html5\";i:1017;s:14:\"um-faicon-css3\";i:1018;s:16:\"um-faicon-anchor\";i:1019;s:20:\"um-faicon-unlock-alt\";i:1020;s:18:\"um-faicon-bullseye\";i:1021;s:20:\"um-faicon-ellipsis-h\";i:1022;s:20:\"um-faicon-ellipsis-v\";i:1023;s:20:\"um-faicon-rss-square\";i:1024;s:21:\"um-faicon-play-circle\";i:1025;s:16:\"um-faicon-ticket\";i:1026;s:22:\"um-faicon-minus-square\";i:1027;s:24:\"um-faicon-minus-square-o\";i:1028;s:18:\"um-faicon-level-up\";i:1029;s:20:\"um-faicon-level-down\";i:1030;s:22:\"um-faicon-check-square\";i:1031;s:23:\"um-faicon-pencil-square\";i:1032;s:30:\"um-faicon-external-link-square\";i:1033;s:22:\"um-faicon-share-square\";i:1034;s:17:\"um-faicon-compass\";i:1035;s:29:\"um-faicon-caret-square-o-down\";i:1036;s:27:\"um-faicon-caret-square-o-up\";i:1037;s:30:\"um-faicon-caret-square-o-right\";i:1038;s:13:\"um-faicon-eur\";i:1039;s:13:\"um-faicon-gbp\";i:1040;s:13:\"um-faicon-usd\";i:1041;s:13:\"um-faicon-inr\";i:1042;s:13:\"um-faicon-jpy\";i:1043;s:13:\"um-faicon-rub\";i:1044;s:13:\"um-faicon-krw\";i:1045;s:13:\"um-faicon-btc\";i:1046;s:14:\"um-faicon-file\";i:1047;s:19:\"um-faicon-file-text\";i:1048;s:24:\"um-faicon-sort-alpha-asc\";i:1049;s:25:\"um-faicon-sort-alpha-desc\";i:1050;s:25:\"um-faicon-sort-amount-asc\";i:1051;s:26:\"um-faicon-sort-amount-desc\";i:1052;s:26:\"um-faicon-sort-numeric-asc\";i:1053;s:27:\"um-faicon-sort-numeric-desc\";i:1054;s:19:\"um-faicon-thumbs-up\";i:1055;s:21:\"um-faicon-thumbs-down\";i:1056;s:24:\"um-faicon-youtube-square\";i:1057;s:17:\"um-faicon-youtube\";i:1058;s:14:\"um-faicon-xing\";i:1059;s:21:\"um-faicon-xing-square\";i:1060;s:22:\"um-faicon-youtube-play\";i:1061;s:17:\"um-faicon-dropbox\";i:1062;s:24:\"um-faicon-stack-overflow\";i:1063;s:19:\"um-faicon-instagram\";i:1064;s:16:\"um-faicon-flickr\";i:1065;s:13:\"um-faicon-adn\";i:1066;s:19:\"um-faicon-bitbucket\";i:1067;s:26:\"um-faicon-bitbucket-square\";i:1068;s:16:\"um-faicon-tumblr\";i:1069;s:23:\"um-faicon-tumblr-square\";i:1070;s:25:\"um-faicon-long-arrow-down\";i:1071;s:23:\"um-faicon-long-arrow-up\";i:1072;s:25:\"um-faicon-long-arrow-left\";i:1073;s:26:\"um-faicon-long-arrow-right\";i:1074;s:15:\"um-faicon-apple\";i:1075;s:17:\"um-faicon-windows\";i:1076;s:17:\"um-faicon-android\";i:1077;s:15:\"um-faicon-linux\";i:1078;s:18:\"um-faicon-dribbble\";i:1079;s:15:\"um-faicon-skype\";i:1080;s:20:\"um-faicon-foursquare\";i:1081;s:16:\"um-faicon-trello\";i:1082;s:16:\"um-faicon-female\";i:1083;s:14:\"um-faicon-male\";i:1084;s:16:\"um-faicon-gittip\";i:1085;s:15:\"um-faicon-sun-o\";i:1086;s:16:\"um-faicon-moon-o\";i:1087;s:17:\"um-faicon-archive\";i:1088;s:13:\"um-faicon-bug\";i:1089;s:12:\"um-faicon-vk\";i:1090;s:15:\"um-faicon-weibo\";i:1091;s:16:\"um-faicon-renren\";i:1092;s:19:\"um-faicon-pagelines\";i:1093;s:24:\"um-faicon-stack-exchange\";i:1094;s:30:\"um-faicon-arrow-circle-o-right\";i:1095;s:29:\"um-faicon-arrow-circle-o-left\";i:1096;s:29:\"um-faicon-caret-square-o-left\";i:1097;s:22:\"um-faicon-dot-circle-o\";i:1098;s:20:\"um-faicon-wheelchair\";i:1099;s:22:\"um-faicon-vimeo-square\";i:1100;s:13:\"um-faicon-try\";i:1101;s:23:\"um-faicon-plus-square-o\";i:1102;s:23:\"um-faicon-space-shuttle\";i:1103;s:15:\"um-faicon-slack\";i:1104;s:25:\"um-faicon-envelope-square\";i:1105;s:19:\"um-faicon-wordpress\";i:1106;s:16:\"um-faicon-openid\";i:1107;s:20:\"um-faicon-university\";i:1108;s:24:\"um-faicon-graduation-cap\";i:1109;s:15:\"um-faicon-yahoo\";i:1110;s:16:\"um-faicon-google\";i:1111;s:16:\"um-faicon-reddit\";i:1112;s:23:\"um-faicon-reddit-square\";i:1113;s:28:\"um-faicon-stumbleupon-circle\";i:1114;s:21:\"um-faicon-stumbleupon\";i:1115;s:19:\"um-faicon-delicious\";i:1116;s:14:\"um-faicon-digg\";i:1117;s:20:\"um-faicon-pied-piper\";i:1118;s:24:\"um-faicon-pied-piper-alt\";i:1119;s:16:\"um-faicon-drupal\";i:1120;s:16:\"um-faicon-joomla\";i:1121;s:18:\"um-faicon-language\";i:1122;s:13:\"um-faicon-fax\";i:1123;s:18:\"um-faicon-building\";i:1124;s:15:\"um-faicon-child\";i:1125;s:13:\"um-faicon-paw\";i:1126;s:15:\"um-faicon-spoon\";i:1127;s:14:\"um-faicon-cube\";i:1128;s:15:\"um-faicon-cubes\";i:1129;s:17:\"um-faicon-behance\";i:1130;s:24:\"um-faicon-behance-square\";i:1131;s:15:\"um-faicon-steam\";i:1132;s:22:\"um-faicon-steam-square\";i:1133;s:17:\"um-faicon-recycle\";i:1134;s:13:\"um-faicon-car\";i:1135;s:14:\"um-faicon-taxi\";i:1136;s:14:\"um-faicon-tree\";i:1137;s:17:\"um-faicon-spotify\";i:1138;s:20:\"um-faicon-deviantart\";i:1139;s:20:\"um-faicon-soundcloud\";i:1140;s:18:\"um-faicon-database\";i:1141;s:20:\"um-faicon-file-pdf-o\";i:1142;s:21:\"um-faicon-file-word-o\";i:1143;s:22:\"um-faicon-file-excel-o\";i:1144;s:27:\"um-faicon-file-powerpoint-o\";i:1145;s:22:\"um-faicon-file-image-o\";i:1146;s:24:\"um-faicon-file-archive-o\";i:1147;s:22:\"um-faicon-file-audio-o\";i:1148;s:22:\"um-faicon-file-video-o\";i:1149;s:21:\"um-faicon-file-code-o\";i:1150;s:14:\"um-faicon-vine\";i:1151;s:17:\"um-faicon-codepen\";i:1152;s:18:\"um-faicon-jsfiddle\";i:1153;s:19:\"um-faicon-life-ring\";i:1154;s:24:\"um-faicon-circle-o-notch\";i:1155;s:15:\"um-faicon-rebel\";i:1156;s:16:\"um-faicon-empire\";i:1157;s:20:\"um-faicon-git-square\";i:1158;s:13:\"um-faicon-git\";i:1159;s:21:\"um-faicon-hacker-news\";i:1160;s:23:\"um-faicon-tencent-weibo\";i:1161;s:12:\"um-faicon-qq\";i:1162;s:16:\"um-faicon-weixin\";i:1163;s:21:\"um-faicon-paper-plane\";i:1164;s:23:\"um-faicon-paper-plane-o\";i:1165;s:17:\"um-faicon-history\";i:1166;s:21:\"um-faicon-circle-thin\";i:1167;s:16:\"um-faicon-header\";i:1168;s:19:\"um-faicon-paragraph\";i:1169;s:17:\"um-faicon-sliders\";i:1170;s:19:\"um-faicon-share-alt\";i:1171;s:26:\"um-faicon-share-alt-square\";i:1172;s:14:\"um-faicon-bomb\";i:1173;s:18:\"um-faicon-futbol-o\";i:1174;s:13:\"um-faicon-tty\";i:1175;s:20:\"um-faicon-binoculars\";i:1176;s:14:\"um-faicon-plug\";i:1177;s:20:\"um-faicon-slideshare\";i:1178;s:16:\"um-faicon-twitch\";i:1179;s:14:\"um-faicon-yelp\";i:1180;s:21:\"um-faicon-newspaper-o\";i:1181;s:14:\"um-faicon-wifi\";i:1182;s:20:\"um-faicon-calculator\";i:1183;s:16:\"um-faicon-paypal\";i:1184;s:23:\"um-faicon-google-wallet\";i:1185;s:17:\"um-faicon-cc-visa\";i:1186;s:23:\"um-faicon-cc-mastercard\";i:1187;s:21:\"um-faicon-cc-discover\";i:1188;s:17:\"um-faicon-cc-amex\";i:1189;s:19:\"um-faicon-cc-paypal\";i:1190;s:19:\"um-faicon-cc-stripe\";i:1191;s:20:\"um-faicon-bell-slash\";i:1192;s:22:\"um-faicon-bell-slash-o\";i:1193;s:15:\"um-faicon-trash\";i:1194;s:19:\"um-faicon-copyright\";i:1195;s:12:\"um-faicon-at\";i:1196;s:20:\"um-faicon-eyedropper\";i:1197;s:21:\"um-faicon-paint-brush\";i:1198;s:23:\"um-faicon-birthday-cake\";i:1199;s:20:\"um-faicon-area-chart\";i:1200;s:19:\"um-faicon-pie-chart\";i:1201;s:20:\"um-faicon-line-chart\";i:1202;s:16:\"um-faicon-lastfm\";i:1203;s:23:\"um-faicon-lastfm-square\";i:1204;s:20:\"um-faicon-toggle-off\";i:1205;s:19:\"um-faicon-toggle-on\";i:1206;s:17:\"um-faicon-bicycle\";i:1207;s:13:\"um-faicon-bus\";i:1208;s:17:\"um-faicon-ioxhost\";i:1209;s:19:\"um-faicon-angellist\";i:1210;s:12:\"um-faicon-cc\";i:1211;s:13:\"um-faicon-ils\";i:1212;s:18:\"um-faicon-meanpath\";i:1213;s:14:\"um-faicon-spin\";i:1214;s:14:\"um-faicon-spin\";i:1215;s:14:\"um-faicon-spin\";i:1216;s:14:\"um-faicon-spin\";i:1217;s:14:\"um-faicon-spin\";}", "yes");
INSERT INTO `jmkn_options` VALUES("306", "category_children", "a:5:{i:2;a:5:{i:0;i:7;i:1;i:8;i:2;i:9;i:3;i:10;i:4;i:11;}i:3;a:4:{i:0;i:12;i:1;i:13;i:2;i:14;i:3;i:15;}i:4;a:6:{i:0;i:16;i:1;i:17;i:2;i:18;i:3;i:19;i:4;i:20;i:5;i:21;}i:5;a:4:{i:0;i:22;i:1;i:23;i:2;i:24;i:3;i:25;}i:6;a:5:{i:0;i:26;i:1;i:27;i:2;i:28;i:3;i:29;i:4;i:30;}}", "yes");
INSERT INTO `jmkn_options` VALUES("310", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `jmkn_options` VALUES("332", "um_hidden_admin_notices", "a:1:{i:0;s:13:\"opt_in_notice\";}", "yes");
INSERT INTO `jmkn_options` VALUES("352", "_transient_sayidan_buffer", ".top-nav, .footer-wrapper, .instagream .instagram-feed-user, .our-history .history-content .list-history li .history-dot span, .event .dark_overlay, .program-upcoming-event .dark_overlay, .page-links a { background-color:#f7cf0b }.um-profile-nav { background-color:#f7cf0b!important; }.menu .nav > li > a, .alumni-dashboard .area-content .icon, .newsletter.type2 .form-inline button, h1.page-title { color:#f7cf0b }.footer-wrapper.type2{border-color:#f7cf0b }.bg-popup{ background-color:rgba(247,207,11,0.9); }.program-upcoming-event .area-img-cont:after{ background:linear-gradient(rgba(247,207,11,0.7), rgba(247,207,11,0.7)); }blockquote {border-left:4px solid rgba(247,207,11,0.7); }.top-nav ul .login a{background-color:#ffff3d }.top-nav ul .login a, .top-nav ul li a, .top-nav ul li a .icon{color:#ffff83}.input-search::-moz-placeholder{color:#ffff83}.input-search:-ms-input-placeholder{color:#ffff83}.input-search::-webkit-input-placeholder{color:#ffff83}.input-search:-moz-placeholder{color:#ffff83}.color-theme,.post__meta-item .fa, .mean-container .mean-nav ul li a:hover,.footer-wrapper .foooter-container .footer-middle .contact-footer .contact-phone-email .contact-email a:hover,.footer-wrapper .foooter-container .footer-middle .links-footer ul li a:hover,.footer-wrapper .foooter-container .footer-middle .links-social ul li a:hover,.twitter-stream .twitter-content .twitter-desc a,.job-detail .brand .brand-content a:hover, .event-calendar .event-list-content .event-list-item .date-desc-wrapper .place a:hover,.event-calendar .event-list-content .event-list-item .sold-out a:hover,.career-opportunity .top-section .sellect-career-opportunity .list-item .select .select-box li:hover,.blog-content .articles .article-item .area-content .article-right h3 a:hover, a:hover { color:#f7ca18!important }.bg-color-theme, .bnt-theme,.slider-hero .content-block .read-story,.alumni-interview .interview-wrapper .interview-see-story a:hover,.programs-services .services-content #tab_services .tab-content .list-item li:before,.our-history .history-content .list-history:before,.event-calendar .event-list-content .event-list-item .register a:hover,.career-opportunity .top-section .sellect-career-opportunity .list-item .button-set .bnt:hover,.latst-article .area-content .category a:hover,.blog-right .tag .list-inline li a:hover, .blog-content .articles .sticky .area-content .article-left .catetory-title{ background-color:#f7ca18}.programs-services .services-content #tab_services .nav-tabs > li.active > a, .programs-services .services-content #tab_services .nav-tabs > li.active > a:hover, .programs-services .services-content #tab_services .nav-tabs > li.active > a:focus,.menu .nav > li.current-menu-itema { border-bottom:2px solid #f7ca18 !important; }.slider-hero .content-block .read-story,.alumni-interview .interview-wrapper .interview-see-story a,textarea:focus, input:focus,.alumni-story .alumni-story-wrapper .alumni-story-content h3 a:hover,.event-calendar .event-list-content .event-list-item .register a,.desc-border,.career-opportunity .top-section .sellect-career-opportunity .list-item .button-set .bnt,.pagination > li > a:hover, .pagination > li > span.current, .pagination > li > span:hover, .pagination > li > a:focus, .pagination > li > span:focus{border-color:#f7ca18!important;}.galery-wrapper .galery-content ul li .galery-item .galery-content{ background-color:rgba(247,202,24,0.9);}.list-item li:before, .um-2012.um input[type=submit].um-button, .um-2012.um input[type=submit].um-button:focus, .um-2012.um a.um-button, .um-2012.um a.um-button.um-disabled:hover, .um-2012.um a.um-button.um-disabled:focus, .um-2012.um a.um-button.um-disabled:active{background-color:#f7ca18!important;}.bg-color-theme:hover,.date-links a:hover,.bnt-theme:hover,.list-inline a:hover,a.see-story:hover{color:#ffffff!important;}.alumni-interview .interview-wrapper .interview-see-story a { border:3px solid #f7ca18;}.sticky .area-content .article-left {border-right:1px solid #f7ca18 !important; }.sayidan-fact { border:2px dashed #f7ca18; }.top-section .sellect-career-opportunity .list-item .button-set .bnt{border:2px solid #f7ca18;}.alumni-directory .list-item li:before { background-color:#e5e5e5!important; }.sticky .blog-post .area-content h2{border-left:4px solid #f7ca18;}.um-2012.um .um-field-group-head, .picker__box, .picker__nav--prev:hover, .picker__nav--next:hover, .um-2012.um .um-members-pagi span.current, .um-2012.um .um-members-pagi span.current:hover, .um-2012.um .um-profile-nav-item.active a, .um-2012.um .um-profile-nav-item.active a:hover, .upload, .um-modal-header, .um-modal-btn, .um-modal-btn.disabled, .um-modal-btn.disabled:hover, div.uimob800 .um-account-side li a.current, div.uimob800 .um-account-side li a.current:hover{background-color:#ffff47!important;}.um-left input[type=submit].um-button, .um-left input[type=submit].um-button:focus, .um-left a.um-button, .um-lefta.um-button.um-disabled:hover, .um-lefta.um-button.um-disabled:focus, .um-left a.um-button.um-disabled:active, .um-password .um-button,.um-2013.um .um-members-pagi span.current{background:#f7ca18!important;}.um-2011.um .um-tip:hover, .um-2011.um .um-field-radio.active i, .um-2011.um .um-field-checkbox.active i, .um-2011.um .um-member-name a:hover, .um-2011.um .um-member-more a:hover, .um-2011.um .um-member-less a:hover, .um-2011.um .um-members-pagi a:hover, .um-2011.um .um-cover-add:hover, .um-2011.um .um-profile-subnav a.active, .um-2011.um .um-item-meta a, .um-account-name a:hover, .um-account-nav a.current, .um-account-side li a.current span.um-account-icon, .um-account-side li a.current:hover span.um-account-icon, .um-dropdown li a:hover, i.um-active-color, span.um-active-color{color:#f7ca18!important;}", "yes");
INSERT INTO `jmkn_options` VALUES("406", "autoptimize_extra_settings", "a:4:{s:31:\"autoptimize_extra_radio_field_4\";s:1:\"1\";s:32:\"autoptimize_extra_select_field_6\";s:1:\"2\";s:30:\"autoptimize_extra_text_field_2\";s:0:\"\";s:30:\"autoptimize_extra_text_field_3\";s:0:\"\";}", "yes");
INSERT INTO `jmkn_options` VALUES("429", "heateor_ss_gdpr_notification_read", "1", "yes");
INSERT INTO `jmkn_options` VALUES("430", "heateor_ss_browser_notification_read", "1", "yes");
INSERT INTO `jmkn_options` VALUES("431", "_transient_timeout_sow:cleared", "1543587852", "no");
INSERT INTO `jmkn_options` VALUES("432", "_transient_sow:cleared", "1", "no");
INSERT INTO `jmkn_options` VALUES("510", "mc4wp", "a:4:{s:7:\"api_key\";s:0:\"\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1542987566;}", "yes");
INSERT INTO `jmkn_options` VALUES("564", "wpfcrf_form_position", "none", "no");
INSERT INTO `jmkn_options` VALUES("565", "wpfcrf_form_placeholder", "Search", "no");
INSERT INTO `jmkn_options` VALUES("566", "wpfcrf_form_validation_button", "OK", "no");
INSERT INTO `jmkn_options` VALUES("567", "wpfcrf_feeds_pagination", "numbered", "no");
INSERT INTO `jmkn_options` VALUES("568", "wpfcrf_posts_per_page", "10", "no");
INSERT INTO `jmkn_options` VALUES("569", "wpfcrf_feeds_order", "DESC", "no");
INSERT INTO `jmkn_options` VALUES("570", "wpfcrf_feeds_order_by", "publish_date", "no");
INSERT INTO `jmkn_options` VALUES("571", "wpfcrf_form_hide_select_name", "0", "no");
INSERT INTO `jmkn_options` VALUES("572", "wpfcrf_form_hide_input", "0", "no");
INSERT INTO `jmkn_options` VALUES("573", "wpfcrf_form_hide_button", "0", "no");
INSERT INTO `jmkn_options` VALUES("574", "wpfcrf_date_format", "F j, Y", "no");
INSERT INTO `jmkn_options` VALUES("575", "wpfcrf_source_prefix", "Source:", "no");
INSERT INTO `jmkn_options` VALUES("576", "wpfcrf_date_prefix", "Published on", "no");
INSERT INTO `jmkn_options` VALUES("577", "wpfcrf_separator", " | ", "no");
INSERT INTO `jmkn_options` VALUES("578", "wpfcrf_target", "1", "no");
INSERT INTO `jmkn_options` VALUES("579", "wpfcrf_combine", "1", "no");
INSERT INTO `jmkn_options` VALUES("580", "wpfcrf_last_cron", "1543341275", "no");
INSERT INTO `jmkn_options` VALUES("581", "wpfcrf_frequency_cron", "1d", "no");
INSERT INTO `jmkn_options` VALUES("582", "wpfcrf_import_method", "xmlreader", "no");
INSERT INTO `jmkn_options` VALUES("583", "wpfcrf_template", "dark-1", "no");
INSERT INTO `jmkn_options` VALUES("584", "wpfcrf_version", "0.3.3", "no");
INSERT INTO `jmkn_options` VALUES("592", "_transient_timeout_sow_inst[sow-post-carousel][cb856a0f]", "1543597498", "no");
INSERT INTO `jmkn_options` VALUES("593", "_transient_sow_inst[sow-post-carousel][cb856a0f]", "a:9:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:133:\"post_type=post&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("595", "_transient_timeout_sow_inst[sow-post-carousel][9bf7ef51]", "1543597578", "no");
INSERT INTO `jmkn_options` VALUES("596", "_transient_sow_inst[sow-post-carousel][9bf7ef51]", "a:9:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:179:\"post_type=page&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992735146\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("599", "_transient_timeout_sow_inst[sow-post-carousel][817435f0]", "1543599482", "no");
INSERT INTO `jmkn_options` VALUES("600", "_transient_sow_inst[sow-post-carousel][817435f0]", "a:9:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("640", "_transient_timeout_sow_inst[sow-post-carousel][8b0bd2cb]", "1543599617", "no");
INSERT INTO `jmkn_options` VALUES("641", "_transient_sow_inst[sow-post-carousel][8b0bd2cb]", "a:9:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:189:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994719611\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("642", "_transient_timeout_sow_inst[sow-post-carousel][cacf70b6]", "1543599617", "no");
INSERT INTO `jmkn_options` VALUES("643", "_transient_sow_inst[sow-post-carousel][cacf70b6]", "a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:143:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994806903\";s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("646", "_transient_timeout_sow_inst[sow-post-carousel][6f3ce768]", "1543602508", "no");
INSERT INTO `jmkn_options` VALUES("647", "_transient_sow_inst[sow-post-carousel][6f3ce768]", "a:9:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("648", "_transient_timeout_sow_inst[sow-post-carousel][ee5c8ce5]", "1543599659", "no");
INSERT INTO `jmkn_options` VALUES("649", "_transient_sow_inst[sow-post-carousel][ee5c8ce5]", "a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:143:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994806903\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("655", "_transient_timeout_sow_inst[sow-post-carousel][23d693fc]", "1543600219", "no");
INSERT INTO `jmkn_options` VALUES("656", "_transient_sow_inst[sow-post-carousel][23d693fc]", "a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("660", "_transient_timeout_sow_inst[sow-post-carousel][65114717]", "1543599999", "no");
INSERT INTO `jmkn_options` VALUES("661", "_transient_sow_inst[sow-post-carousel][65114717]", "a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:25:\"sow-post-carousel-5010000\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("662", "_transient_timeout_sow_inst[sow-post-carousel][6d3e7387]", "1543602653", "no");
INSERT INTO `jmkn_options` VALUES("663", "_transient_sow_inst[sow-post-carousel][6d3e7387]", "a:9:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("685", "_transient_timeout_sow_inst[sow-post-carousel][2b35cbea]", "1543601560", "no");
INSERT INTO `jmkn_options` VALUES("686", "_transient_sow_inst[sow-post-carousel][2b35cbea]", "a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("687", "_transient_timeout_sow_inst[sow-post-carousel][3e6dbbe3]", "1543602429", "no");
INSERT INTO `jmkn_options` VALUES("688", "_transient_sow_inst[sow-post-carousel][3e6dbbe3]", "a:9:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("708", "_transient_timeout_sow_inst[sow-post-carousel][692d8c2e]", "1543602429", "no");
INSERT INTO `jmkn_options` VALUES("709", "_transient_sow_inst[sow-post-carousel][692d8c2e]", "a:9:{s:5:\"title\";s:4:\"ACTU\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"194185bf842c9c6f84084043469\";s:19:\"_sow_form_timestamp\";s:13:\"1542996698062\";s:2:\"id\";s:25:\"sow-post-carousel-5010004\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("715", "_transient_timeout_sow_inst[sow-post-carousel][6f68b3f1]", "1543602429", "no");
INSERT INTO `jmkn_options` VALUES("716", "_transient_sow_inst[sow-post-carousel][6f68b3f1]", "a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:6:\"medium\";s:5:\"posts\";s:189:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542996882498\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}", "no");
INSERT INTO `jmkn_options` VALUES("772", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1543381878", "no");
INSERT INTO `jmkn_options` VALUES("773", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:0:{}}", "no");
INSERT INTO `jmkn_options` VALUES("790", "duplicator_settings", "a:10:{s:7:\"version\";s:6:\"1.2.52\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `jmkn_options` VALUES("791", "duplicator_version_plugin", "1.2.52", "yes");
INSERT INTO `jmkn_options` VALUES("792", "_transient_timeout_plugin_slugs", "1543400742", "no");
INSERT INTO `jmkn_options` VALUES("793", "_transient_plugin_slugs", "a:19:{i:0;s:19:\"akismet/akismet.php\";i:1;s:27:\"autoptimize/autoptimize.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:13:\"cmb2/init.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:9:\"hello.php\";i:7;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:8;s:47:\"one-click-demo-import/one-click-demo-import.php\";i:9;s:39:\"siteorigin-panels/siteorigin-panels.php\";i:10;s:53:\"re-add-underline-justify/re-add-underline-justify.php\";i:11;s:49:\"read-more-excerpt-link/read-more-excerpt-link.php\";i:12;s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";i:13;s:23:\"sayidan-plugin/init.php\";i:14;s:59:\"simple-scroll-to-top-button/simple-scroll-to-top-button.php\";i:15;s:39:\"so-widgets-bundle/so-widgets-bundle.php\";i:16;s:37:\"super-socializer/super_socializer.php\";i:17;s:35:\"ultimate-member/ultimate-member.php\";i:18;s:59:\"wp-filter-combine-rss-feeds/wp-filter-combine-rss-feeds.php\";}", "no");
INSERT INTO `jmkn_options` VALUES("799", "spacexchimp_p008_service_info", "a:4:{s:7:\"upgrade\";s:4:\"0001\";s:7:\"version\";s:4:\"4.25\";s:11:\"old_version\";s:1:\"0\";s:15:\"activation_date\";i:1543244736;}", "yes");
INSERT INTO `jmkn_options` VALUES("803", "spacexchimp_p008_settings", "a:8:{s:13:\"enable_button\";s:2:\"on\";s:17:\"background_button\";s:9:\"fa-circle\";s:16:\"background-color\";s:4:\"#fff\";s:12:\"image_button\";s:13:\"fa-chevron-up\";s:12:\"symbol-color\";s:7:\"#1e73be\";s:11:\"size_button\";s:2:\"32\";s:15:\"scroll_duration\";s:3:\"300\";s:14:\"display-button\";s:0:\"\";}", "yes");
INSERT INTO `jmkn_options` VALUES("831", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.9.8.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.9.8.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.8\";s:7:\"version\";s:5:\"4.9.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1543337987;s:15:\"version_checked\";s:5:\"4.9.8\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `jmkn_options` VALUES("833", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1543337993;s:7:\"checked\";a:5:{s:13:\"sayidan-child\";s:5:\"1.6.3\";s:7:\"sayidan\";s:5:\"1.6.5\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `jmkn_options` VALUES("834", "classic-editor-replace", "replace", "yes");
INSERT INTO `jmkn_options` VALUES("857", "ratb_options", "a:1:{s:14:\"ratb_mce_style\";s:1:\"2\";}", "yes");
INSERT INTO `jmkn_options` VALUES("888", "_transient_timeout_feed_43f94b1d114c2aa05a6543dbe51ef010", "1543357044", "no");
INSERT INTO `jmkn_options` VALUES("889", "_transient_feed_43f94b1d114c2aa05a6543dbe51ef010", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:2:\"\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:38:\"\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Abidjan.net Actualités\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://news.abidjan.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Toute l\'actualité sur Abidjan.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"copyright\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"Copyright (c) 1998-2017 Weblogy Corporation.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:48:06 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:4:\"\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Abidjan.net Actualités\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://www.abidjan.net/images/logo_abidjan2.jpg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://news.abidjan.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Insuffisance rénale : 97 nouveaux postes de traitement rénale créés\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648552.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:72:\"https://news.abidjan.net/photos/photos/centre-hemodialyse-de-korhogo.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:36:23 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1172:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/centre-hemodialyse-de-korhogo.jpg\"/>Grâce aux investissements du gouvernement ivoirien, le nombre de postes d’hémodialyse est passé de 10 en 2011 à 107 en 2017, soit 97 nouveaux postes. Et ce sont environ 56&#8239;000 séances de dialyse qui ont été effectuées en 2017, contre 22&#8239;000 en 2015.\n\nSelon le Service d’aide médicale d’urgence (SAMU), entre 4&#8239;000 et 5&#8239;000 personnes souffrent d’insuffisance rénale en Côte d’Ivoire. Pour favoriser leur prise en charge médicale, huit centres d’hémodialyse ont été construits de 2011 à 2017. Le dernier en date est celui de Korhogo, ouvert en avril 2017. D\'autres centres suivront à San-Pedro, Aboisso, Daloa, Bondoukou et Odienné.\n\nCes investissements, couplés avec la politique de gratuité ciblée de certains soins et médicaments, ont permis de réduire le coût de la séance de dialyse. Le coût de la séance de dialyse est désormais de 1&#8239;750 FCFA dans les centres publics, contre 2&#8239;500 F CFA de 1991 à 2010. Il varie entre 60&#8239;000 et 150&#8239;000 FCFA dans les cliniques privées.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648552.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Banque Atlantique sacrée meilleure banque de Côte d’Ivoire\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648498.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:57:\"https://news.abidjan.net/photos/photos/BANQUE-0000(2).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:36:20 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3098:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/BANQUE-0000(2).jpg\"/>Filiale du Groupe Banque Centrale Populaire du Maroc, Banque Atlantique, co-leader du marché bancaire ivoirien a été désignée « Meilleure banque de Côte d’Ivoire ». \n\nLa distinction a été remise à M. Abdelmoumen NAJOUA, Directeur Général Adjoint de Banque Atlantique, lors de la cérémonie des « Awards du Financement » qui se tenait en marge de l’édition 2018 du forum « La finance s’engage ». \n\nOrganisé sous l’égide du Patronat ivoirien (Confédération Générale des Entreprises de Côte d’Ivoire « CGECI »), cet Award récompense la banque qui appréhende le mieux, les défis et les enjeux du financement des PME locales.\n\nLe prix illustre l’engagement de Banque Atlantique à proposer des solutions sur mesure, compétitives et innovantes aux PME. A travers son soutien continu aux PME, Banque Atlantique se distingue comme un acteur important de l’écosystème entrepreneurial, privilégiant la création de valeur et la promotion de l’entrepreneuriat en tant que moteur de croissance économique. \n\nCette distinction de « Meilleure Banque de Côte d’Ivoire », souligne également la progression remarquable des encours de crédits que Banque Atlantique a octroyé aux PME au cours des trois dernières années et qui dépasseront les 100 milliards FCFA à l’horizon 2018. Une partie significative de cette enveloppe a été allouée au soutien de projets portés par les femmes et les jeunes et qui couvrent les secteurs économiques les plus significatifs.\n\nAu cours du gala de remise des trophées le vendredi 23 novembre 2018, M. Abdelmoumen NAJOUA, a déclaré ceci : « Nous nous félicitons de cette distinction qui conforte le management du groupe dans ses choix de développement et confirme l’engagement de Banque Atlantique à œuvrer pour la consolidation des positions acquises en termes de soutien aux petites et moyennes entreprises. Dotée de moyens significatifs, Banque Atlantique a tissé au fil des années, une relation de confiance avec les entrepreneurs et s’impose désormais comme l’un des principaux partenaires financiers des PME. Cette distinction, décernée par un jury d’experts du monde de la finance est encourageante. Elle témoigne à la fois de la qualité du travail fourni par nos équipes pour la satisfaction de notre clientèle et de la confiance des clients, démontrant la pertinence de notre modèle économique, ». \n\nBanque Atlantique s’est engagée dans un programme de transformation de son organisation, de ses processus métiers et de son outil de production en vue de fournir au marché, des services à forte valeur ajoutée. Plusieurs conventions signées par la banque avec l’Etat et les acteurs privés, visent la promotion du rôle des PME en tant que pierre angulaire de l’édifice économique Ivoirien, confirmant les orientations de Banque Atlantique, résolument tournées vers le renforcement de la contribution de ses dernières à l’essor économique que connait le pays.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648498.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Inclusion financière : la BCEAO vise un taux d’accès aux services financiers de 75 % d’ici à 5 ans (Gouverneur)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648549.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:70:\"https://news.abidjan.net/photos/photos/sem-inc-fin-conf-press-0005.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:31:50 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5503:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/sem-inc-fin-conf-press-0005.jpg\"/>La Banque Centrale des États de l&#8217;Afrique de l&#8217;Ouest souhaite faire un grand bond en faveur de l&#8217;accès des populations aux services financiers. De 55 % en 2017, la BCEAO compte atteindre 75 % de populations de l&#8217;UEMOA ayant accès aux services financiers dans 5 ans.\n\n\"L&#8217;objectif principal est de faire passer à 75 % d&#8217;ici à 5 ans les populations de notre Union qui pourront accéder aux services financiers dans le cadre de l&#8217;inclusion financière. C&#8217;est l&#8217;objectif majeur\", a dit Tiémoko Meyliet Koné, Gouverneur de la BCEAO.\n\nEn inscrivant désormais une Semaine de l&#8217;inclusion financière dans son agenda, la Banque Centrale des États de l&#8217;Afrique de l&#8217;Ouest (BCEAO) cherche à réunir l&#8217;ensemble des acteurs intervenants dans le secteur financier pour échanger sur les défis actuels. C&#8217;est ce que le Gouverneur Tiémoko Meyliet Koné a décliné comme entres autres objectif de la rencontre ouverte, ce lundi, à Dakar au siège de la BCEAO.\n\n\"L&#8217;objectif principal, c&#8217;est de rassembler les acteurs du secteur financier en vue de discuter des problématiques importantes de l&#8217;heure en matière d&#8217;inclusion financière qui constituent des préoccupations spécifiques et des défis pour chaque pays de l&#8217;Union\", a dit le Gouverneur de la Banque Centrale des États de l&#8217;Afrique de l&#8217;Ouest (BCEAO). Tiémoko Meyliet Koné s&#8217;exprimait lors d&#8217;une conférence de presse organisée en marge du lancement de la Semaine de l&#8217;inclusion financière dans l&#8217;UEMOA, édition 2018.\n\nLa semaine de l&#8217;inclusion financière initiée par la Banque Centrale des États de l&#8217;Afrique de l&#8217;Ouest (BCEAO) a été lancée ce lundi, à Dakar sous le thème: “Inclusion financière, levier du développement économique et social“. Le lancement officiel a été présidé par le président du Conseil des ministres de l&#8217;UEMOA, en présence du gouverneur de la BCEAO. \n\nPour parvenir à cet objectif, plusieurs actions sont à mener par la BCEAO, souligne le Gouverneur de la Banque Centrale. Ces actions touchent la réglementation, la supervision, la surveillance et surtout la protection des consommateurs. \n\nPour réussir ce pari, les États ont également un rôle important à jouer. \"Le secteur public constitué en tête de pont par l&#8217;État a un rôle très important à jouer. Parce qu&#8217;il y a un certain nombre d&#8217;opérations qui peuvent aujourd&#8217;hui entraîneur beaucoup de gens dans le secteur financier surtout lorsqu&#8217;elles mettent en première position l&#8217;État et les populations. Par exemple le paiement des salaires, un certain nombre d&#8217;opérations des États qui, aujourd&#8217;hui peuvent être conçues dans un système qui englobe le maximum de personnes possibles et qui utilisent des technologies qui peuvent les renforcer, et même diminuer le coût des transactions\", révèle M. Koné.\n\nDans la zone UEMOA, deux pays ont mis en place une stratégie nationale en faveur de l&#8217;inclusion financière. Il s&#8217;agit de la Côte d&#8217;Ivoire et du Sénégal. Afin d&#8217;appuyer les efforts des États, une stratégie régionale est mise en œuvre afin de favoriser davantage l&#8217;inclusion financière dans les pays de l&#8217;Union.\n\nPour ce qui concerne le financement des Petites et moyennes entreprises, la Banque centrale a pris un certain nombre d&#8217;initiatives en vue de favoriser l&#8217;accès aux services financiers, notamment le partage des risques. \"La PME prend une partie du risque, la Banque prend une partie, et nous Banque centrale, ce qui est novateur, nous prenons une partie du risque. C&#8217;est un processus que nous mettons en place et qui devrait permettre de rassurer les banques et de rassurer tous ceux qui vont travailler dans le secteur de la PME\", a soutenu Tiémoko Meyliet Koné. \n\nLe président du Conseil des monstres Romuald Wadigni a mis l&#8217;accent sur le rôle des autorités publiques dans la réduction des coûts des services financiers pour favoriser l&#8217;inclusion financière. Il distingue cependant, le coût effectif des services et la perception que les populations peuvent avoir du coût. Il soutient alors que les médias ont un rôle majeur à jouer dans ce sens pour une plus grande adhésion des populations et à une meilleure compréhension des avantages. \n\n\"Sur la notion de coût effectif, nous en tant qu&#8217;autorités publiques, nous avons un rôle important à jouer. Maintenant, sur la notion de perception (du coût) vous, journalistes avez un rôle à jouer\", a soutenu Romuald Wadigni, ministre de l&#8217;Économie et des Finances du Bénin, président du Conseil des ministres de l&#8217;UEMOA.\n\n\nAfin de mieux vulgariser les actions entreprises en faveur de l&#8217;inclusion financière, la Banque Centrale des États de l&#8217;Afrique de l&#8217;Ouest entend inscrire la Semaine de l&#8217;inclusion financière dans son calendrier annuel. \n\nCette année, les activités vont se dérouler du 26 novembre au 1er décembre simultanément dans tous les huit pays membres de l&#8217;UEMOA. Des panels de discussions, un forum de haut niveau et une foire de l&#8217;inclusion financière sont prévus pour des échanges fructueux et une meilleure sensibilisation des acteurs.\n\nMC\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648549.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:275:\"Ouverture de la 9e conférence sur l’Initiative pour la facilité de faire des affaires à Abidjan : Adama Koné, ministre de l’économie et des finances : « la Côte d’Ivoire ambitionne de se hisser parmi les 50 premiers pays au monde, où il fait bon d’investir »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648548.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://news.abidjan.net/photos/photos/EDBI-Ouverture-0036.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:29:56 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3386:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/EDBI-Ouverture-0036.jpg\"/>Les objectifs du Gouvernement visent à hisser la Côte d’Ivoire dans le classement Doing Business 2021, parmi les 50 premiers pays au monde, où il fait bon d’investir a révélé lundi, le ministre de l’économie et des finances ivoirien, Adama Koné, à l’ouverture de la 9e conférence sur l’Initiative pour la facilité de faire des affaires à Abidjan qui se tenait pour la première fois en Afrique Francophone.\n\n \n\n« La Côte d’Ivoire a réalisé la plus forte progression sur le continent africain, au cours des dix dernières années, en matière de gouvernance, selon le rapport 2018 de la Fondation Mo Ibrahim. Elle occupe la 22ème place sur 54 pays. Malgré ces résultats encourageants, les objectifs du Gouvernement ne sont pas encore atteints. Ces objectifs visent à hisser, dans le classement Doing Business 2021, la Côte d’Ivoire parmi les 50 premiers pays au monde, où il fait bon d’investir. Cela nécessite des efforts encore plus soutenus, d’où la création le 10 juillet 2018 d’un Secrétariat d’Etat auprès du Premier Ministre, chargé de la Promotion de l’Investissement Privé, lequel a en charge la facilitation des affaires » a-t-il fait savoir.\n\n \n\nLa 9è édition de la conférence \"Ease of Doing Business Initiative\" (EDBI), se tient du 26 au 28 novembre 2018 à Abidjan, sur le thème : \"Amélioration du climat des affaires et défis de croissance économique en Afrique\". \n\n \n\nAvec 30 pays participants réunit les experts de haut niveau de différents pays africains, du Groupe de la Banque mondiale et du secteur privé qui viennent partager leurs expériences et exprimer leurs opinions sur le cadre juridique des affaires.&#8232;\n\n \n\nPour le ministre ivoirien de l’Économie et des Finances qui représentait le Premier ministre ivoirien, cette plateforme d’échanges est un cadre privilégié de mise en commun des meilleures pratiques en matière d’amélioration du climat des affaires.&#8232;\n\n \n\nElle devrait, à l’en croire, permettre à la Côte d’Ivoire de s’inspirer de l’expérience des pays africains cités en exemple dans le Doing business : « En sollicitant à la conférence de Nairobi en 2016 puis de Livingstone en 2017, l’organisation sur son sol de la 9ème édition de la conférence ‘’Ease of Doing Business Initiative’’, la Côte d’Ivoire espère bénéficier de l’expérience de tous ces pays cités en exemple dans le Doing Business en Afrique. »\n\nPar ailleurs, il a indiqué que « le Gouvernement ivoirien veut aller plus loin en vue d’accélérer son processus de transformation structurelle de l’économie par l’industrialisation, à travers la charte pour l’amélioration de l’environnement des affaires axée sur une nouvelle génération de réformes visant au renforcement des acquis, notamment par la dématérialisation des procédures administratives et l’optimisation de la fiscalité. »\n\n \n\nLa nouvelle génération de réformes a contribué au retour de la Côte d’Ivoire dans le TOP 10 des pays réformateurs dans le rapport Doing Business Focus 2019.\n\n \n\nElle a gagné 17 places comparativement au rapport 2018. Ainsi, le pays a enregistré une progression notable de 55 places dans le classement Doing Business depuis 2013. \n\n\n-P. R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648548.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"9ème édition de la Conférence sur la facilité des affaires “Ease of Doing Business initiative” (EDBI 2018) : Moussa Sanogo identifie les défis pour un meilleur classement dans le prochain Doing business\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648536.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:70:\"https://news.abidjan.net/photos/photos/EDBI-Panel-Haut-Niveau-0012.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:29:00 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6079:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/EDBI-Panel-Haut-Niveau-0012.jpg\"/>En partenariat avec le Groupe Banque Mondiale, il se tient depuis hier,  en Côte d’Ivoire, au Sofitel Hôtel Ivoire d’Abidjan, la 9ème édition de la conférence annuelle de partage d’expériences et de meilleures pratiques en matière d’amélioration de l’environnement des affaires, focus Doing Business dénommée \"Ease of Doing Business Initiative\" (EDBI).\n\nMonsieur Moussa Sanogo, Secrétaire d’Etat chargé du Budget et du Portefeuille de l’Etat, a participé à un panel de haut niveau sur le thème « Importance du programme de réforme du climat de l’investissement pour relever les défis de la croissance économique en Afrique ».    \n\nLes panélistes étaient : Soro Nagolo, de la Confédération générale des entreprises de Côte d’Ivoire (Cgeci) ; Khader Barry, conseiller spécial du Premier ministre de Guinée ; Dr Jumoke Oduwole, Conseiller spécial du président du Nigeria ; Dr Gabriel Ajeedra Aridru, ministre d’Etat, ministre de l’Economie et des Finances  de l’Ouganda ; Ibrahima Guimba Saïdou, ministre Conseiller spécial, Directeur général de l’Agence nationale pour la Société de l’information (Ansi) du Niger.\n\nLe point commun de ces pays, c’est qu’à l’instar de la Côte d’Ivoire qui figure dans le top 10 des pays les plus réformateurs au monde, tous sont engagés dans des processus qui leur ont permis de faire des bonds substantiels au classement. Les attentes sont grandes, les défis à relever pour avoir un climat totalement assaini innombrables. Mais des efforts ont été accomplis dont les résultats sont salués par la Banque mondiale et la SFI.\n\nC’est ainsi que lors des échanges, Soro Nagolo a salué les réformes qui ont impacté le secteur privé en Côte d’Ivoire. Il s’est en outre félicité de la facilitation de remboursement des crédits de Tva (Taxe sur la valeur ajoutée) ; de la création des entreprises en 24h ; de la mise en œuvre d’infrastructures ; de la disponibilité des parcelles pour aider les investisseurs à s’installer.\n\nQuant à Khader Barry de la Guinée, il a expliqué que l’environnement des affaires dans son pays s’améliore et qu’il faille que les réformes instaurées s’inscrivent dans la durée. Surtout que la Guinée a gagné une trentaine de place de 2012 à 2018. \n\nPour la Nigériane, Dr Jumoke Oduwole, son pays qui est l’un des premiers pays producteurs mondial du pétrole, a indiqué que fort des recommandations de la Banque mondiale, le Nigeria a mis en place des reformes. Celles-ci ont mis un point d’honneur sur les infrastructures ; la compétitivité des entreprises, en prime celle des Pme ; la digitalisation.\n\nPour l’Ougandais  Ajeedra Aridru, dans le cadre de l’’amélioration de l’environnement des affaires, son pays a supprimé les goulots d’étranglement liés à la compétitivité au niveau des Etats de la région Est-africaine. D’où la création d’une autorité pour faciliter les investissements. Le Niger, par le biais de Guimba Saïdou, a informé des résultats obtenus par son pays à l’issue des réformes entreprises. Des prouesses dues à l’exploitation du numérique, l’interconnectivité de l’administration, la création d’un tribunal de commerce, l’avènement de la télédéclaration, etc. Les panélistes ont tous insisté sur la poursuite des réformes dans leurs pays respectifs pour réaliser des progrès considérables.\n\nLe modérateur, Moussa Sanogo, a su conduire les débats. Mieux, par son expertise, il a souligné que le cadre des reformes de l’amélioration du climat des affaires, la Côte d’Ivoire a réalisé de bonnes performances macroéconiques au cours des cinq dernières années grâce notamment à l’investissement privé qui est passé de 11,1% du PIB en 2012 à 16,1% en 2017.\n\nPoursuivant il a indiqué des problématiques liées à l’amélioration du climat des affaires, se trouve la question de la volonté politique. Avec l’ensemble des intervenants, il pense que cette volonté doit être portée au plus haut niveau. Il a souligné également la nécessité d’avoir un dispositif performant et dynamique, animé par des acteurs spécialisés en matière de doing business. En Côte d’Ivoire, un Secrétaire d’Etat a été créé qui s’occupe exclusivement des questions d’amélioration de l’environnement des affaires et de l’investissement.\n\nMoussa Sanogo a également relevé la nécessité d’un suivi-évaluation efficace, en accord avec les autres panélistes qui ont soulevé la question de la coordination de l’action du gouvernement. Enfin, il y a tout ce qui a trait aux infrastructures de général : l’infrastructure physique comme les ponts, l’infrastructure écologique, et différents ouvrages qui devraient faciliter les affaires.\n\n« En Côte d’Ivoire, nous ne sommes pas si mal que ça ; quand on regarde les différentes réformes que nous avons mené en 2018, et qui nous ont permis d’être parmi les pays les plus réformateurs, la question  de la dématérialisation des actes est l’un des points clés », a déclaré le Secrétaire d’Etat.\n\nIl note qu’il y a également la liste la délivrance du permis de construire, la question de l’obtention de prêt qui a valu la prise de la loi sur le bureau de crédit, afin de le rendre rapidement opérationnel. Il y a eu ensuite, soutient le ministre, l’utilisation d’une plateforme électronique pour la déclaration des impôts, qui va être d’utilisation obligatoire pour toutes les entreprises d’ici peu. L’administration fiscale compte aller plus loin, surtout en matière de dématérialisation des procédures de création d’entreprises, qui peuvent être épuisées en une journée. Il a appelé les Etats africains à garder le cap, à poursuivre les efforts, pour qu’au prochain doing business, l’on puisse constater que chacun des pays a encore progressé au niveau du classement.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648536.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"5ème Édition de Abidjan By Night passe Général d’Armée\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648525.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:50:\"https://news.abidjan.net/photos/photos/file(1).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:27:03 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2102:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/file(1).jpg\"/>5ème étoile pour Abidjan By Night. La prochaine édition de ce festival organisé par le magazine Mon Abidjan se tiendra le 15 décembre 2018, au palais de la culture de Treichville.\n\nGénéral d’Armée. C’est le grade qui aurait pu être attribué au festival Abidjan By Night qui tiendra sa 5ème édition le 15 décembre prochain. Une 5ème étoile qui viendra illuminer la nuit abidjanaise et donner une allure beaucoup plus élégante et festive à cette fin 2018.\n\nCette année, Abidjan By Night qui confirme sa maturité, laissera apprécier sa technicité et sortira ses griffes. Invité spécial : La méga star du reggae mondial : Alpha Blondy. Brigadier Sabari, Massada, Mister grande gueule, Apartheid is nazism... Le répertoire musical de Koné Seydou tonnera à nouveau dans Mon Abidjan, après celui de l’artiste musicien nigérian Davido en 2017. Abidjan By night, ce sera aussi: Ariel Sheney, TNT Rocky Gold, Yung King entre autres.\nA ces spectacles, Mon Abidjan offrira aux noceurs de la capitale ivoirienne, un volet clubbing assuré par les meilleurs disc-jockeys ivoiriens avec DJ BDK et Philo Inter.\n\nDISPOSITIF ÉVÈNEMENTIEL\nLe dispositif événementiel sera de pointe et à la taille de l’évènement. Un podium géant sera dressé pour les concerts ainsi que des game zone ou espaces de jeux. Une plateforme de disc- jockeys en hauteur avec des projecteurs, des canapés et fauteuils pour constituer des salons est également prévue. Le tout sur\nun site qui sera couvert d’un éclairage architectural de dernière génération.\n\nMOOV LE SPONSOR\nLe festival Abidjan By Night est un rendez-vous qui s’adresse à la population abidjanaise, d’ores et déjà invitée à cette 5ème édition. Avec pour sponsor officiel, l’opérateur de téléphonie mobile MOOV.\nCinq mille personnes sont attendues à ce festival et comme pour les éditions précédentes, la sécurité sera au rendez-vous.\nAbidjan By Night by Mon Abidjan... Le compte à rebours est lancé.\n\nPar Bob Bamba\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648525.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:155:\"Célébration de l’élection de la Côte d’Ivoire au Conseil de l’UIT Le Ministre Claude Isaac DE : « La Côte d’Ivoire qui gagne est de retour »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648551.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://news.abidjan.net/photos/photos/ARTCI-0000(1).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:26:59 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3162:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/ARTCI-0000(1).jpg\"/>Le 5 novembre 2018, la Côte d’Ivoire a été élue au Conseil de l’Union Internationale des Télécommunications (UIT) lors de la 20ème Conférence des Plénipotentiaires qui s’est tenue à Dubaï, aux Emirats Arabes Unis. « Après 16 ans d’absence, 5 tentatives depuis 2002, la Côte d’Ivoire qui gagne, est de retour au Conseil de l’UIT », a déclaré le Ministre Claude Isaac DE, à l’occasion de la célébration du retour de la Côte d’Ivoire au sein de l’instance de l’UIT, ce lundi 26 Novembre 2018, au Radisson Blu Hôtel. Intervenant à cette tribune, le Ministre ivoirien en charge de l’Economie Numérique et de la Poste a traduit sa gratitude au Chef de l’Etat, SEM Alassane Ouattara et à l’ensemble du Gouvernement pour la confiance accordée à son équipe et pour l’intérêt porté au secteur de l’Economie Numérique et de la Poste. Poursuivant, le Ministre Claude Isaac DE a également adressé ses sincères remerciements au Ministre des Affaires Etrangères, Monsieur Marcel Amon-Tanoh, et à toute son équipe pour le fort soutien diplomatique. Toujours au chapitre des remerciements, Le Ministre Claude Isaac DE a rendu un hommage à son prédécesseur, le Ministre Bruno Nabagné KONE, « pour avoir entamé le travail  que nous avons achevé en beauté ». « C’est un honneur pour moi et pour l’ensemble de la délégation ivoirienne, de rapporter ce que nous pouvons appeler, un trophée pour le secteur de l’économie numérique », a-t-il indiqué. Pour le Ministre Claude Isaac DE, ce retour de la Côte d’Ivoire dans la plus haute instance directrice de l’UIT est la « marque de confiance, faite à notre pays (…), le témoignage des efforts consentis par tous les acteurs de notre écosystème et la reconnaissance du rôle actif que joue notre pays au sein de cette institution». Le Ministre Claude Isaac DE, au cours de son propos, n’a pas manqué de dévoiler ses ambitions pour un secteur de l’économie numérique plus fort à la hauteur de celles d’une Côte d’Ivoire qui est résolument engagée à faire de ce secteur un catalyseur puissant de son développement économique.\n\n« Les 5 dernières années, la Côte-d’Ivoire a connu un taux de croissance moyen de 8 à 9%. Le secteur du numérique a su se hisser parmi les secteurs les plus performants avec une contribution au PIB estimé à 9%. 9% c’est bien mais ce n’est pas assez. L’ambition de la Côte d’Ivoire est de porter 15% au PIB dans les 5 prochaines années », a-t-il expliqué.  Cependant, a-t-il reconnu,  « cette ambition forte ne sera possible que par la parfaite collaboration et synergie entre tous les acteurs du secteur du secteur public et du secteur privé de notre écosystème ». C’est pourquoi, il a exhorté tous les acteurs à la solidarité et à l’union. « C’est la conjugaison de nos efforts communs qui porteront le secteur de l’Economie Numérique Ivoirien vers le sommet de l’excellence la Côte d’Ivoire numérique au sommet de l’excellence », a-t-il conclu.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648551.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"Côte d’Ivoire : « Il n’y a pas de rupture entre Alassane Ouattara et moi », assure Henri Konan Bédié\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648546.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:63:\"https://news.abidjan.net/photos/photos/BEDIE -ouattara-0001.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:20:37 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1664:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/BEDIE -ouattara-0001.jpg\"/>Alors que le dialogue direct entre Alassane Ouattara et Henri Konan Bédié est rompu depuis de longues semaines, le président du PDCI assure dans une interview accordée le 26 novembre au quotidien « Nouveau Réveil », qu&#8217; « il n&#8217;y a pas de rupture » entre les deux hommes.\n\nLeur dernière rencontre remonte au 8 août et n’avait pas été des plus chaleureuses. Depuis, le dialogue direct entre Alassane Ouattara et Henri Konan Bédié est rompu, malgré les nombreuses tentatives de médiation. Le président du Parti démocratique de Côte d’Ivoire (PDCI) refuse pour autant de parler de « rupture ».\n\nDans une interview accordée au Nouveau Réveil (quotidien pro-PDCI) le 26 novembre, l’ancien chef de l’État revient les raisons qui l’ont amené à refuser d’intégrer le parti unifié, RHDP. Il déclare notamment avoir remis à Henriette Diabaté et Kandia Camara, respectivement présidente et secrétaire générale du RDR, toutes deux reçues le 6 juillet à Daoukro, des documents qui « comportaient les réserves du PDCI sur les dispositions transitoires du projet des statuts du parti unifié RHDP. Cette réserve précisait, à juste titre, la nécessité de maintenir le RHDP sous forme d’un groupement politique, conformément à la loi de 1993 relative aux partis et aux groupements politiques. Cette loi n’autorise pas la fédération des partis politiques, comme stipulée dans l’article 40 du projet des statuts du parti unifié. À ce jour, aucune suite n’a été donnée à cette réserve », dit-il.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648546.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"L’Etat ivoirien est engagé à faire du secteur des TIC, un catalyseur de son développement économique (Ministre)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648545.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:72:\"https://news.abidjan.net/photos/photos/Presentation-Voeux-MCLAU-0046.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:17:11 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1754:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/Presentation-Voeux-MCLAU-0046.jpg\"/>Abidjan – Le ministre de l’Economie numérique et de la Poste, Claude Isaac Dé a affirmé la détermination de l’Etat à faire du secteur des TIC, un puissant catalyseur de son développement.\n\nLors de la cérémonie de célébration de l’adhésion de la Côte d’Ivoire au Conseil de l’Union internationale des télécommunications (UIT), lundi à l’hôtel Radisson Blu, à Port-Bouët, à Abidjan, le ministre a engagé tous les acteurs du secteur de l’économie numérique à œuvrer à en faire un modèle d’excellence et de performance pour le pays.\n\nTout en faisant observer que le potentiel du numérique est énorme, le ministre a rappelé qu’au cours des cinq dernières années, la Côte d’Ivoire a connu un taux de croissance moyen de 8 à 9%.\n\n« Le secteur du numérique a su se hisser parmi les secteurs les plus performants avec une contribution au PIB estimé à 9% », a-t-il précisé, soulignant que l’ambition de l’Etat est de porter ce taux à 15% dans les cinq prochaines années.\n\nAprès 16 ans d’absence, la Côte d’Ivoire a signé son retour à l’UIT, le 05 novembre 2018, à l’issue d’un vote organisé à l’occasion de la Conférence des plénipotentiaires (PP18), à Dubaï.\n\nLa célébration de cette bonne nouvelle a été faite dans le cadre d’un banquet égayé par l’orchestre ‘’Les virtuoses’’ qui a réuni notamment le ministre Isaac Dé et ses collaborateurs, les représentants des structures sous sa tutelle, des membres du corps diplomatique dont le secrétaire général du ministère des Affaires étrangères et des opérateurs du secteur des TIC.\n\ncmas\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648545.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"Revue à mi-parcours du projet PEJEDEC : La Banque mondiale fait le point au Ministre Mamadou Touré\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648533.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://news.abidjan.net/photos/photos/Revue-0002(2).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:16:47 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1985:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/Revue-0002(2).jpg\"/>Ce lundi, au Plateau, le Ministre de la Promotion de la Jeunesse et de l’Emploi des jeunes a accordé une audience à une délégation de la Banque Mondiale conduite par M. Patrick Ramanantoania, spécialiste principal en Education à la Banque mondiale.  La délégation de la Banque mondiale était composée, outre de M. Patrick Ramanantoania, de Mme Laurianne Le Lem, spécialiste éducation à la Banque mondiale et de M. Hermann Toualy, coordonnateur adjoint au BCP-emplois.  Cette mission de la Banque mondiale avait pour objectif de dresser la revue à mi-parcours du Projet Emploi des Jeunes et Développement des Compétences (PEJEDEC). \nM. Patrick Ramanantoania  a indiqué que le projet PEJEDEC  débuté en 2011 se déroule bien.  Il a expliqué que pour la phase 1 du  programme débuté en décembre 2011 pour prendre fin le 30 juin 2015, ce sont plus de 30 mille jeunes qui ont bénéficié du projet.\n\nS’agissant de la phase 2 du PEJEDEC débutée en 2015 dont l’achèvement est prévu pour le 30 juin 2019, 19 662 jeunes ont déjà été accompagnés sur un objectif global de 31 500 bénéficiaires à atteindre. «  Nous prendrons en compte la différence de jeunes d’ici fin 2019 », a-t-il promis avant  de plaider pour la prolongation de 14 mois de la date de fin du projet, de la réduction du nombre de bénéficiaires des activités d’apprentissage dans les centres de formation en augmentant le nombre de bénéficiaires des activités d’appui à l’entreprenariat et la pérennisation de l’impact sur les populations.\n\nCette audience a été l’occasion pour la Banque Mondiale de réitérer l’annonce du 3ème financement au PEJEDEC dès juillet 2019. Et ce, après le succès des phases 1 et 2.\n\nLe Ministre Mamadou Touré s’est réjoui des actions de la Banque mondiale qui visent à lutter contre le chômage des jeunes en Côte d’Ivoire.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648533.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"8ème Assemblée Générale de l’AISCCUF : l’Ivoirien Diomandé Kanvaly élu à la tête de l’Organisation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648550.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:55:\"https://news.abidjan.net/photos/photos/AISCCUF-0003.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 03:14:32 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3277:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/AISCCUF-0003.jpg\"/>Le Président de la Cour des Comptes de Côte d’Ivoire, DIOMANDÉ Kanvaly est le nouveau président de L’Association des Institutions Supérieures de Contrôle ayant en commun l’usage du Français (AISCCUF). Il a été élu à l’issue de la 8ème Assemblée Générale de l’Organisation, qui a eu lieu du 21 au 22 novembre 2018 à Niamey au Niger.\n\nDIOMANDÉ Kanvaly a dit sa gratitude à ses pairs pour cette élection qui ‘’à n’en pas douter, constitue une grande marque de confiance et, par-dessus tout, un signe de l’existence d’attentes légitimes’’ qu’il s’est engagé à ne pas décevoir.\n\nIl a salué les importantes décisions prises, lors de cette Assemblée générale, qui mettent à jour les dispositions statutaires qui régissent l’organisation. ‘’Nous avons visionné d’importants acquis réalisés, depuis 2015, pour la prise en compte de nos spécificités dans l’évaluation des Institutions Supérieures de Contrôle au niveau de L’Organisation Internationale des Institutions Supérieures de Contrôle des finances publiques (INTOSAI) et pour le renforcement des capacités techniques de nos institutions. Forts de ces acquis, nous avons mis les projecteurs sur un nouveau programme réaliste d’activités de formation, qui ne manqueront pas de continuer à rehausser la qualité des travaux de nos ISC’’, a indiqué le nouveau président.\n\nRevenant sur les délibérations sur la situation financière de l’Organisation, DIOMANDE Kanvaly a exhorté ses pairs à une prise en charge plus effective des besoins de fonctionnement par l’AISCCUF à travers les cotisations qui sont la première et la principale source de financement.\n\nPour la mise en place du prochain bureau de l’Organisation, le nouveau président a souhaité pouvoir bénéficier des éclairages de ses aînés au sein du bureau de l’AISCUF et du travail collégial de cette instance. DIOMANDÉ Kanvaly n’a pas manqué de rendre hommage à ses illustres prédécesseurs. \n\n‘’C’est le lieu pour moi d’exprimer, en cet instant, toute ma fierté et d’adresser mes plus vives félicitations à ceux qui, avant moi, ont été les artisans infatigables des premiers pas aussi bien que des avancées de notre association. A cet égard, je salue le travail soutenu et remarquable du Bureau sortant conduit par feu le Président SIDIBE. Je remercie le Secrétariat Général de l’AISCCUF, en particulier le Premier Président MIGAUD et son équipe, pour son travail inlassable, abattu avec tout le tact espéré et toute la diplomatie nécessaire. Je n’oublie pas le Premier Président ROLAND, qui veille sur nos ressources en toute transparence’’, a affirmé le président DIOMANDÉ Kanvaly.\n\nL’Association des Institutions Supérieures de Contrôle ayant en Commun l’Usage du Français (AISCCUF) a été créée à Paris le 22 septembre 1994 avec dix huit institutions supérieures de contrôle. Notamment celles de : Belgique, Bénin, Burkina Faso, Cameroun, Canada, Côte d’Ivoire, France, Gabon, Guinée, Liban, Madagascar, Maroc, Mauritanie, Niger, République Centrafricaine, Sénégal, Togo et Tunisie.\n\n \n\nElisée B.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648550.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Service civique inclusif en Côte d’Ivoire : un document en cours d’élaboration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648499.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:54:\"https://news.abidjan.net/photos/photos/IMG_7066(6).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 02:24:32 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2471:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/IMG_7066(6).jpg\"/>Les 22 et 23 Novembre 2018, s’est tenu à Dabou un atelier d’élaboration d’un document de Pré-stratégie de Service Civique inclusif en Côte d’Ivoire organisé par le Secrétariat d’Etat chargé du service civique et le Conseil National de Sécurité (CNS), en partenariat avec le PNUD.\n\nSe félicitant de la tenue de cette rencontre, M. Anderson Assui directeur de cabinet du secrétariat en charge du service Civique et représentant le Ministre Siaka Ouattara, il a signifié que l’objectif en réunissant, différents acteurs à la fois étatiques et non étatiques impliqué dans le domaine du service est de favoriser un cadre pour dresser un bilan sans complaisance des actions mener à travers la thématique du civisme en Côte d’Ivoire et scruter avec discernement l’avenir. Il s’est dit convaincu que les efforts des participants  à cet atelier permettront de reconstruire les bases de l’émergence  d’un ivoirien nouveau.\n\nQuant au représentant du Conseil Nationale de sécurité M. Patrick Kassi, il  a trouvé dans cette initiative un canal pour produire une solution durable  à la question de l’incivisme en Côte  d’Ivoire. Il a également signifié  l’intérêt  du Secrétariat du Conseil National de  Sécurité quant à la problématique de l’incivisme  et de ses conséquences.\n\nReprésentant le directeur pays du Programme des Nation Unies pour le Développement, M. Assandé Arsène a réitéré l’engagement du PNUD à demeurer aux côtés du gouvernement ivoirien et particulièrement du secrétariat du conseil National de sécurité dans la poursuite et la consolidation de son processus de réforme du secteur de la sécurité, dont les résultats contribueront sans aucuns doute   engager le pays sur le chemin du  d’une paix durable.\n\nL’atelier à tenu ses promesses en délivrant à la fin des échanges un document préstratégique sur le civisme inclusif e Cote d’Ivoire.  Les participants en sont sortis satisfait du travail abattu.\n\nLe Directeur générale de l’Office du Service Civique national, M Touré Mamadou, à l’initiative de cet atelier a rappelé que le document pré-stratégie fera l’objet d’une amélioration en vue de  le soumettre au secrétariat d’état en charge du service Civique en vue de la l’élaboration de  la politique nationale du civisme Cote d’Ivoire.\n\nP. R.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648499.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Fintech Challenge : le groupe BCP inaugure depuis Abidjan son programme d’innovation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648477.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://news.abidjan.net/photos/photos/les-officiels(1).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 02:23:40 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2361:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/les-officiels(1).jpg\"/>Abidjan, le 23 novembre 2018\n \nLe groupe Banque Centrale Populaire (BCP) a procédé, ce vendredi 23 novembre à Abidjan, au lancement officiel de la première édition de son Fintech Challenge, un programme d’innovation ouvert aux Start-Up d’Afrique et d’ailleurs. A la clé de ce projet inédit, un partenariat durable et mutuellement bénéfique entre le groupe et les jeunes entreprises les plus prometteuses.\n \nA l’ordre du jour de cet événement, une conférence-débat sur le thème « Banques – Start-Up : quels modèles de collaboration, pour quels impacts ? », tenue en présence de plusieurs membres du gouvernement dont Mme Raymonde GOUDOU COFFIE, Ministre de la Modernisation de l’Administration et de l’Innovation du Service Public, M. Souleymane DIARRASSOUBA, Ministre du Commerce, de l’Industrie et de la Promotion des PME, M. Claude Isaac DE, Ministre de l&#8217;Economie Numérique et de la Poste ainsi que de S.E.M. Abdelmalek KETTANI, Ambassadeur du Royaume du Maroc en Côte d’Ivoire. Cette conférence a connu la participation de plusieurs panélistes de renommée internationale : Cabinet de stratégie, Expert en digital, Incubateur, Start-Up... Des interventions de grande qualité qui ont donné lieu à des conclusions aussi riches que complémentaires.\nLe programme Fintech Challenge intervient en pleine transformation du groupe BCP, qui vise à offrir à ses clients un meilleur accès à ses services ainsi qu’une plus grande valeur ajoutée.\n \nEn effet, dans un monde caractérisé par une évolution rapide des usages et des attentes, l’innovation est devenue le maître-mot. « Le groupe BCP connaît actuellement une réelle transformation, qui vise notamment à optimiser l’expérience client, dans laquelle le digital joue un rôle majeur. Afin d’accompagner cette dynamique, la nourrir et l’accélérer, notre groupe a décidé de s’ouvrir aux sources d’innovation externes, en particulier les Start-Up, afin de co-concevoir avec elles et déployer des solutions agiles et à fort impact, permettant de mieux répondre aux nouveaux besoins préalablement identifiés en relation avec les métiers », explique M. Kamal MOKDAD, Directeur Général du groupe BCP, en charge de l’International.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648477.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Lancement de la campagne nationale d’adhésion et d’immatriculation du PDCI-RDA: discours d’ouverture du secrétaire  exécutif du PDCI-RDA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648474.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:59:\"https://news.abidjan.net/photos/photos/PDCI-RDA-0013(2).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 01:37:29 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6030:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/PDCI-RDA-0013(2).jpg\"/>Mesdames les Vice-présidentes \nMonsieur le Secrétaire Exécutif Chargé des Nouvelles Adhésions et du Recrutement\nMesdames et Messieurs les membres du Secrétariat Exécutif du PDCI- RDA\nHonorables membres des instances du Parti\nChères Militantes, chères militants \nChères sympathisantes, Chers sympathisants, \nChers amis de la presse nationale et internationale,\nHonorables invités,\nMesdames et messieurs.\n\nGrande est ma joie de voir ici rassemblés, à la maison du parti, les militantes, militants, sympathisantes, sympathisants et l’ensemble des Ivoiriens  dans leur diversité, pour honorer de leur présence la cérémonie de lancement de la campagne nationale d’immatriculation des militants et recrutement de nouveaux militants du PDCI-RDA.\n\nAvant tout autre propos, permettez-moi de vous transmettre les vives salutations et félicitations de SEM Henri KONAN BEDIE, Président du PDCI-RDA, pour la parfaite organisation de cette cérémonie placée sous son regard bienveillant.\n\nLa belle mobilisation de ce jour nous réjouit et montre une fois encore, à quel point nos concitoyens, toutes origines sociales et ethniques confondues, se reconnaissent dans les valeurs du Père fondateur de la Côte d’Ivoire moderne, le Président Félix HOUPHOUET BOIGNY. \n\nMesdames les Vice-Présidentes, les membres du Secrétariat Exécutif, les Délégués Départementaux et Communaux et les membres des Instances du Parti soyez remerciés pour votre soutien à cette initiative.\n\nLa chaleur militante que nous notons en cette heureuse circonstance démontre une fois de plus que les piliers et les fondements du PDCI- RDA restent inoxydables.\nMilitantes, Militants\nSympathisantes, Sympathisants\nMesdames et Messieurs\n\nL’actualité politique de notre pays a été particulièrement riche ces derniers mois. Un faisceau d’éléments politiques interdépendants nous ont amenés à tenir, le 15 octobre dernier à Daoukro, le 6ème congrès extraordinaire de notre Parti. Le thème en était : « Le PDCI-RDA : stabilité et clarification pour une marche harmonieuse vers 2020 ».\n\nAu sortir de ces assises, l’ambition de notre parti de reconquérir le pouvoir d’Etat en 2020 a été plus que réaffirmée et définitivement gravée dans le marbre. \nC’est pourquoi, pendant que des mains obscures continuent vainement de nourrir et ourdir des initiatives diverses pour déstabiliser notre parti et ses instances dirigeantes, nous conduirons notre mission qui est de maintenir le cap.\nLe Sage disait à juste titre : « Un miracle, comme un pari, cela se prépare, cela se conditionne, cela se mesure, cela se décide et cela se réalise à force de volonté et de persévérance. » \nNous nous donnons ainsi  les moyens et les chances pour relever le défi de 2020 et gagner  notre pari de retour au Pouvoir d’Etat.\n\nC’est d’ailleurs dans cette perspective que se sont inscrites les récentes instructions du Président Henri KONAN BEDIE, relatives à la remobilisation de toutes les structures de base du Parti.\n\nMesdames et messieurs\nLa cérémonie de lancement de ce jour, inscrite dans la matrice des actions de remobilisation de tous nos militants, marque le « TOP DEPART » d’une grande campagne nationale d’adhésion dénommée «Pour la Côte d’Ivoire. Je prends mes responsabilités et j’adhère au PDCI-RDA». \n\nCette campagne conduite sur toute l’étendue du territoire national par le Secrétaire Exécutif chargé  des Nouvelles Adhésions et du Recrutement, sera permanente. Elle vise à permettre au PDCI-RDA d’enregistrer officiellement et effectivement dans sa base de données tous ses militants. Elle donnera également l’occasion à tous ses sympathisants qui veulent le rejoindre, de pouvoir le faire en toute facilité et simplicité. Grâce à cette opération, tous nos militants, les anciens comme les nouveaux, d’ici ou de la diaspora, auront leur carte de membre. \n\nJ’invite  à cet effet, l’ensemble des Délégués Départementaux et Communaux, tous les Responsables politiques du parti, à s’organiser et à se tenir prêts à recevoir les prochaines missions.\n\nAvant de clore mon propos, je voudrais m’adresser aux jeunes \n\nChers amis jeunes,\nLa fierté du Président du Parti, SEM  Henri KONAN BEDIE est grande de noter votre mobilisation exceptionnelle à cette cérémonie de lancement de la campagne pilotée par des jeunes et qui nous permettra d’immatriculer l’ensemble de nos militants qui devront être à 99%, des militants convaincus  prêts à conduire le PDCI RDA au pouvoir d’Etat en 2020 pour le bonheur des populations vivant en Côte d’Ivoire.\nLes trois (3) piliers de cette opération et campagne sont des jeunes de moins de quarante ans.\n&#8722;	monsieur AKA APPIA Ange Isaac, Secrétaire Exécutif Chargé des Nouvelles Adhésions et du Recrutement \n&#8722;	madame Djenebou ZONGO, Directrice de la Communication \n&#8722;	Hervé Franck AKAFFOU, Directeur de l’Identification et de l’Immatriculation des militants du PDCI-RDA\n ce sont les trois mousquetaires du PDCI-RDA\nAmis jeunes, il n’y a jamais eu de conflit de générations dans notre Parti. Les jeunes y ont toujours eu leur place. Les anciens seront toujours là pour vous encadrer et vous aider à monter en puissance.\n\nLe Président du Parti vous fixe comme objectif à atteindre au terme de cette campagne : un million de militants enregistrés dans la base de données du parti. C’est ambitieux, mais le Président du Parti vous engage à rassembler toutes vos forces pour l’atteindre, voire le dépasser.\n \nAu nom de SEM Henri KONAN BEDIE, Président du PDCI-RDA, Haut Patron  de cette cérémonie, je souhaite pleins succès à la campagne d’immatriculation et de recrutement des militants du PDCI-RDA.\n\nLongue vie au PDCI RDA\n \nJe vous remercie.\n\nFait à Abidjan, le 24 novembre 2018\n \n\nPr. Maurice KAKOU  GUIKAHUE,\nSecrétaire Exécutif du PDCI-RDA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648474.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:5:\"\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"Conflit foncier/Abobo Baoulé- Bahouakoi: La réunion du chef destitué annulée par le commandant de brigade\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648501.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:09:43 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648501.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:5:\"\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Education nationale-Région de l’Iffou/Amélioration du cadre de vie des écoliers et enseignants: Un nouveau bâtiment de 3 classes inauguré\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648503.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:09:41 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648503.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Action sociale : l’Amicale Ahnouanzé, remet des dons aux orphelines de Grand-Bassam\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648537.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:70:\"https://news.abidjan.net/photos/photos/Ahnouanze-Grand-Bassam-0001.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:09:10 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1195:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/Ahnouanze-Grand-Bassam-0001.jpg\"/>Le samedi 24 novembre dernier, les membres de l’Amicale Ahnouanzé ont procédé à une cérémonie de remise de dons aux pensionnaires de l’Orphelinat national des filles de Grand-Bassam.\n\n« Il y a certes de l’émotion dans l’air, mais on retiendra surtout le plaisir de donner à ces êtres innocents auxquels le destin n’a pas encore souri » a confié Kouamé Emile, président de l‘Amicale Ahnouanzé qui avec ses frères ont apporté un peu de joie aux pensionnaires.\n\nPuis d’ajouter « Nous sommes avec vous les enfants. Vous êtes des êtres chers et innocents. Il était important pour nous de passer ces instants avec vous afin de vous témoigner notre amour. »\n\nLes membres de l’Amicale Ahnouanzé ont ensuite remis des lots de produits de toute nature aux orphelines et leurs encadreuses allant des denrées alimentaires, aux effets vestimentaires et cosmétiques, couches jetables, Machine à laver, des cartons de médicaments, 20 matelas et bien d’autres. Le tout soutenu d’un partage nourriture avec les enfants dans la joie et la gaieté.\n\nAtapointe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648537.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"Côte d&amp;#8217;Ivoire : 123 agents de Fraternité Matin en sit-in pour dénoncer un «licenciement abusif»\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648543.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:54:\"https://news.abidjan.net/photos/photos/Sit-in-0000.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:08:33 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3480:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/Sit-in-0000.jpg\"/>Abidjan (Côte d\'Ivoire) - Un collectif des 123 agents dont 11 journalistes concernés par le licenciement pour motifs économiques annoncé par Fraternité Matin, le quotidien pro-gouvernemental ivoirien, a été créé lundi à Abidjan au terme d\'une Assemblée générale extraordinaire (AGO) marquée par un sit-in pour dénoncer un « licenciement abusif », a constaté APA sur place.\n\nCette nouvelle organisation dont l\'objectif est de défendre les intérêts des travailleurs concernés par ce licenciement a pour porte-parole, Marcelline Gneproust, une journaliste et ancienne lauréate du prix Ebony récompensant les meilleurs journalistes ivoiriens.\n\n« Il ne s\'agit pas d\'un licenciement pour motifs économiques. Mais plutôt, d\'un règlement de compte  car 98% des travailleurs concernés par ce licenciement ne rentrent pas dans les critères établis par la direction », a estimé Mme Gneproust dénonçant une « irrégularité dans la procédure».\n\nPoursuivant, la journaliste a indiqué que ce que « nous attendons en ce moment, c\'est de continuer les échanges avec les autorités pour que les départs se fassent dans la dignité ».  Avant elle, Marc Yevou, le porte-parole des syndicats des travailleurs de ce journal à capitaux publics, s\'est étonné de ce projet de licenciement dénonçant à son tour, une chasse aux sorcières.\n\n « Il y a une irrégularité qui entache la liste de ceux qui partent. Dans 80% des cas figurant sur cette liste, nous sommes dans un licenciement abusif », a-t-il soutenu appelant les initiateurs de ce « projet de licenciement » à « revoir leur copie ».\n\n M. Yévou a, par ailleurs, encouragé ses camarades concernés par le licenciement à l\'union. « Nous syndicats, nous allons jouer pleinement notre partition. Nous allons défendre bec et ongle  nos camarades », a-t-il assuré.\n\nAvec des bandeaux rouges, des membres du collectif des 123 agents licenciés,  ont organisé au terme de cette AG extraordinaire, un sit-in d\'une heure dans l\'enceinte du groupe Fraternité Matin pour exprimer leur mécontentement.\n\nLa semaine dernière, la nouvelle société de presse et d\'édition de Côte d\'Ivoire ( SNPECI), éditrice du quotidien pro-gouvernemental ivoirien, Fraternité Matin a annoncé le licenciement pour motifs économiques de 123 agents dont 11 journalistes.\n\nCes derniers, selon la direction de l\'entreprise devraient effectivement cesser toute activité au sein de ce groupe le mardi 18 décembre prochain.\n\n\nMais avant cette cessation définitive d\'activités des travailleurs concernés, une réunion d\'explications et d\'informations est prévue le 11 décembre prochain à l\'inspection du travail avec les délégués du personnel.\n\n Dans une note d\'information adressée aux délégués du personnel, la SNPECI justifiait ce licenciement collectif par trois difficultés opérationnelles auxquelles elle est confrontée. Notamment, la dégradation de son outil de production, le niveau pléthorique de son effectif et l\'absence d\'une vision stratégique clairement définie et acceptée par tous.\n\nTrois critères, à en croire cette note, ont également guidé le choix des travailleurs concernés par ce licenciement. Il s\'agit  des emplois à faible valeur ajoutée, les employés peu qualifiés et le personnel en situation particulière (grands malades, longues indisponibilité...).\n\nLB/ls\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648543.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Le tourisme et l’évolution numérique au centre d’une conférence  à Songon Kassemblé\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648538.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:64:\"https://news.abidjan.net/photos/photos/Tourisme-Songon--0003.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:08:03 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1426:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/Tourisme-Songon--0003.jpg\"/>Songon - Le tourisme et l’évolution numérique étaient au  centre d’une conférence animée par le recteur de l’Université Charles Louis de Montesquieu, Pr Amoa Urbain, à l’hôtel Vent du Sud de Songon Kassemblé.\n\nLors de cette intervention publique vendredi, à l’occasion de la célébration de la journée mondiale du tourisme (JMT), Pr Amoa Urbain a défini le tourisme comme la science des rêves du beau, du Sacré et du rêve dont la pratique fait appel à l’évasion et au rêve, porteur de connaissances liées à la diversité culturelle.\n\n« Le tourisme ainsi perçu est donc cette science du  « Sentir » et « du Vivre » qu’offrent les délices des découvertes dans le dessein de contribuer au développement de tout l’Etre et de Tout être à Tout âge. (…) Le numérique est un moyen de célébration et de vulgarisation touristique dans chaque région.», a-t-il déclaré.\n\nPour l’universitaire, à l’ère du numérique audio-visuel, le tourisme offre beaucoup d’atouts y compris l’illusion d’une réalité touristique à laquelle il faut faire attention dans la mesure où le réel ne saurait nullement se substituer au « Sentir » et aux vibrations ou sensations du Réel.\n\nLa JMT est placée sur le thème « Le tourisme et la transformation numérique ».\n\n\ntg/gak/tm\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648538.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"Côte d’Ivoire: plus de la moitié des impôts payée en ligne à fin juin 2018 (ministre)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648540.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:49:\"https://news.abidjan.net/photos/photos/6(263).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:07:19 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2882:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/6(263).jpg\"/>Abidjan (Côte d’Ivoire) - Plus de la moitié des impôts en Côte d\'Ivoire, pour l’année fiscale 2018, a été payée en ligne à fin juin, a indiqué lundi le ministre ivoirien de l’Économie et des finances, Adama Koné, à l’ouverture de la 9è conférence annuelle de Ease Doing Business Initiative (EDBI), à Abidjan.\n\n« A fin juin 2018, plus de la moitié des impôts a été payée en ligne », a dit M. Adama Koné, dans un discours à l’ouverture de la 9è conférence annuelle de Ease Doing Business Initiative (EDBI), qui se déroule du 26 au 27 novembre 2018 à Abidjan.\n\nCe résultat a été obtenu grâce à une nouvelle génération de réformes, engagée par l’Etat ivoirien, ce qui a contribué au retour de la Côte d\'Ivoire dans le top 10 des pays réformateurs dans le rapport Doing Business 2019.\n\nCes réformes ont favorisé la mise en place du système de déclaration de paiement en ligne des impôts appelé e-impôt, permettant à la Côte d\'Ivoire de devenir le premier pays en Afrique de l’Ouest francophone à introduire ce système dans la collecte des recettes fiscales. \n\nPour aller plus loin dans le processus de transformation structurelle de son économie par l’industrialisation, le gouvernement ivoirien a adopté en juillet 2015 une Charte pour l’amélioration de l’environnement des affaires. \n\nCette charte, axée sur une nouvelle génération de réformes, vise au renforcement des acquis, notamment par la dématérialisation des procédures administratives, l’optimisation de la fiscalité, l’accroissement de la transparence et l’efficacité de l’offre du service public.  \n\nDans cette optique, l’Etat a mise en place un portail unique et services à l’investisseur dénommé www.225.invest.ci qui fédère en son sein différents services offerts en ligne par les administrations publiques et structures compétentes aux investisseurs nationaux et internationaux.\n\nLa Côte d\'Ivoire a dans cet élan réalisé la plus forte progression sur le continent africain en matière de gouvernance au cours de ces dix dernières années selon le rapport 2018 de la Fondation Mo Ibrahim. Le pays occupe la 22è place sur 54 pays. \n\nLes entreprises relevant d’un régime réel d’imposition seront dès 2019 soumises à l’e-impôt, une plateforme de paiement des impôts en ligne, a annoncé fin octobre le directeur général des impôts, Abou Sié Ouattara , en marge d’un séminaire bilan de l’administration fiscale. \n\nLes services des impôts en Côte d\'Ivoire ont recouvré pour le troisième trimestre 2018 un montant de 530 milliards Fcfa.  Le cumul des recettes depuis début 2018 donne « un solde positif de 21,7 milliards Fcfa, grâce à des réalisations effectives de 1 641 milliards de Fcfa ».  \n\nAP/ls\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648540.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:5:\"\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Les principes du journalisme au centre d’une formation initiée par l’ambassade des Etats Unis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648544.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:06:34 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648544.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:5:\"\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"Côte d&amp;#8217;Ivoire: le Programme de vérification de la qualité des produits importés suspendu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648542.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:06:34 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648542.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:171:\"Journée Nationale des Assurances : un panel sur la sensibilisation des opérateurs économiques sur l’obligation d’assurance de responsabilité civile professionnelle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648490.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:101:\"https://news.abidjan.net/photos/photos/Panel-Sensibilisation-Assurance-Responsabilite-Civile-0000.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:05:36 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2363:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/Panel-Sensibilisation-Assurance-Responsabilite-Civile-0000.jpg\"/>Le dernier panel qui a meublé la deuxième journée nationale des assurances, fut celui sur la « Sensibilisation des opérateurs économiques sur l’obligation d’assurance de responsabilité civile professionnelle » animé par trois experts, MM. Kouakou Bah Simplice, Sous-directeur des assurances en charge de la délivrance des agréments, diplômé de l’Ecole Nationale de Statistiques et d’Economie Appliquée d’Abidjan (ENSEA) ; Diallo Daniel, Secrétaire Général de l’Association des Société d’Assurances de Côte d’Ivoire (ASACI), titulaire d’un Certificat d’Aptitude à Profession d’Avocat ; Coulibaly Niennenkariga Habib, Responsable de la commissions scientifique et formation de l’Association Nationale des Courtiers d’Assurances et de Réassurance de Côte d’Ivoire (ANCARCI), par ailleurs doctorant en Sciences Economiques et de Gestion à l’Université Félix Houphouët Boigny d’Abidjan Cocody.\n\nCes trois experts ont montré l’importance de l’assurance responsabilité civile professionnelle, qui selon eux, garantit les conséquences pécuniaires de la responsabilité civile encourue par les personnes couvertes au contrat. Ils ont tous démontré son importance dans la sauvegarde et la continuité des activités.\nMalheureusement les panélistes se sont inquiétés de la non souscription de cette assurance par les professionnels en Côte d’Ivoire. Selon les chiffres présentés, moins de 12% des professionnels disposent d’une assurance responsabilité civile professionnelle, alors que celle-ci est obligatoire selon les articles 1382 à 1386 du code civil.\n\nPour remédier à cette situation, les panélistes ont recommandé aux assureurs et à leurs partenaires de proposer et de vulgariser des produits adaptés et accessibles, mais également aux professionnels de tous les secteurs d’activités, de prendre conscience que leurs actes de négligence peuvent avoir un impact négatif sur tout un écosystème.\n\nPour rappel, ces journées nationales des assurances font partie d’un vaste programme de sensibilisation et de vulgarisation de l’assurance à l’endroit de toute la population, initié par la direction des assurances depuis 2015.\n\nPR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648490.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Deuil : Guillaume Soro chez les Sangaré, des accolades avec Simone Gbagbo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648547.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:52:\"https://news.abidjan.net/photos/photos/IMG_7680.jpeg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:02:01 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1843:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/IMG_7680.jpeg\"/>Guillaume Soro, président de l’Assemblée nationale ivoirienne, à la tête d’une délégation qu’il conduisait, a présenté ses condoléances à la famille biologique et politique de feu Aboudrahamane Sangaré, baron du Front populaire ivoirien décédé le samedi 03 novembre 2018.\n\nOn ne le dira jamais assez. Le décès de l’ex gardien du temple du Front populaire ivoirien, compagnon des premières heures de Laurent Gbagbo aura suscité la compassion de la classe politique ivoirienne, dans toutes ses composantes. L’ex chef de la rébellion armée en Côte d’Ivoire entre 2002 et 2011 s’est rendu personnellement au domicile de feu Aboudrahamane Sangaré, ce lundi 26 novembre 2018, pour y présenter ses condoléances à la famille biologique et politique du défunt. Guillaume Soro et l’ex première dame ivoirienne Simone Gbagbo, se sont à cette occasion fait une accolade, une grande première, 7 ans après la fin de la crise post-électorale qu’a connue la Côte d’Ivoire.\n\nCe n’est un secret pour personne que Guillaume Soro, alors premier ministre et patron de l’ex rébellion des Forces nouvelles, avait farouchement combattu le pouvoir de l’ex président ivoirien Laurent Gbagbo, jusqu’à sa chute le 11 avril 2011. Des barons du Front populaire ivoirien dont Aboudrahamane Sangaré, l’épouse de l’ex chef d’Etat, Simone Gbagbo, et Pascal Affi N’guessan et bien d’autres s’étaient plus tard retrouvés en prison. Rappelons que dès l’annonce du décès de l’ex gardien du temple du FPI, le deputé de Ferké avait rendu un hommage mérité au premier vice-président du Front populaire ivoirien qu’il avait qualifié de « combattant de la démocratie et des libertés individuelles ».\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648547.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"Formation professionnelle :  Le Centre des métiers de l’électricité obtient 98% de réussite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648523.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:55:\"https://news.abidjan.net/photos/photos/DSC_0232(15).jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Tue, 27 Nov 2018 00:01:32 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2592:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/DSC_0232(15).jpg\"/>Le Centre des Métiers de l’Electricité (CME) de Bingerville a connu un évènement particulier ce samedi 24 novembre 2018.  Le CME qui est un pôle d’excellence de formation est sous la gestion de la Compagnie ivoirienne d’électricité(CIE),  a célébré ses étudiants qui ont fait un taux record de 98% de réussite au Brevet de technicien supérieur dans la filière électrotechnique. \nLe mérite et l’excellence constituent des valeurs fortes pour la Compagnie ivoirienne d’électricité (CIE). Elle vient encore d’en faire la preuve. La deuxième promotion (2016-2018) de cet établissement a obtenu 98%  de réussite au BTS électrotechnique. Ce résultat est à comparer avec la moyenne nationale qui est de 57% dans cette filière.\n \nUne cérémonie de remise de prix à ces nouveaux diplômés a été organisée le samedi 24 novembre au sein de  l’établissement. \n \nLes récipiendaires ont reçu des trophées et des lots notamment des ordinateurs. Selon le directeur de la CIE, Dominique Kakou, cette réussite est le résultat et la juste récompense de leur travail et des espoirs placés en eux par leurs parents. C’est aussi le fruit d’un travail d’équipe et d’un cercle vertueux de partenaires. « Le mérite et l’excellence sont des valeurs qu’ont incarnés nos étudiants par leur réussite. Ils sont un véritable exemple », a-t-il indiqué. Avant de relever que ces bons résultats obtenus et  la perspective d’insertion professionnelle ont eu une incidence positive, notamment sur la proportion de filles qui est passée de 16% à 20% à la rentrée 2018-2019. M.Paul Ginies, directeur du CME, a quant à lui félicité le corps enseignant et les étudiants pour cet honneur. Il a également dit sa reconnaissance à toutes les structures qui accompagnent son  établissement dans sa quête de l’excellence. A l’instar de leurs étudiants, les professeurs ont été distingués pour avoir été des pédagogues performants. L’occasion était aussi belle pour souligner l’implication des différentes entreprises qui  ont participé, à travers des stages, à la qualité de la formation. Elles ont reçu des trophées. Etablissement d’excellence et de renommée internationale, le CME  a ouvert ses portes en 1970, à l’initiative du premier président de la République de Côte d’Ivoire feu Félix  Houphouet Boigny.   Il forme depuis 2015 au BTS/DUT électronique et ouvre  cette année le cycle des licences professionnelles.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648523.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Côte d’Ivoire - Mali : le premier ministre malien reçu par le président Alassane Ouattara\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648506.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:51:\"https://news.abidjan.net/photos/photos/_RPR2174.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Mon, 26 Nov 2018 23:59:35 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:524:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/_RPR2174.jpg\"/>Abidjan - En visite de travail en Côte d’Ivoire, le Premier Ministre du Mali, Soumeylou Boubèye Maïga, a été reçu en audience le dimanche 25 novembre 2018 à Abidjan par le Président ivoirien Alassane Ouattara.\n\nLes échanges ont porté sur le renforcement de la coopération entre les deux pays.\n\nPlus tôt dans la journée, le chef du gouvernement malien s’était entretenu avec son homologue ivoirien Amadou Gon Coulibaly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648506.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Niakara : la 2e édition du carnaval Kaha a pris fin dans la liesse populaire\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648534.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:61:\"https://news.abidjan.net/photos/photos/carnaval-Kaha-0035.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Mon, 26 Nov 2018 23:58:45 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4263:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/carnaval-Kaha-0035.jpg\"/>Les lampions se sont éteints sur la 2ème édition du Carnaval Kaha le 18 novembre 2018 à Niakara (Centre-Nord, région du Hambol) avec l’incinération de « Aba Carnaval » dans une ambiance populaire et carnavalesque. C’était en présence du corps préfectoral, de la chefferie traditionnelle Tagbana, des autorités coutumières et religieuses tout comme de nombreux cadres des départements de Katiola et de Niakara. ’’Venons célébrer la culture Tagbana’’. Tel était le thème de cette 2ème édition qui a tenu toutes ses promesses. Les populations venues des différents villages et sous-préfectures des départements de Niakara et de Katiola ont assisté aux différentes prestations de danses traditionnelles et masques Tagbana ( Hoyougou, Gotou, Nafiré, Djéréblé, Gbofé, Manja, Nagbogo, sita, Matougoula, M’man, Kapatchan, etc.).\n\nLes défilés des différentes couches socio-professionnelles et des majorettes ont agrémenté ces réjouissances carnavalesques. Visiblement heureux de cette forte mobilisation, le Commissaire Général du Carnaval Kaha, Dr. GUIBESSONGUI N’Datien Séverin, a affirmé lors de la cérémonie de clôture ceci: « nous avons montré au monde entier que nous sommes unis et rassemblés par la culture, autour de la culture et pour la culture. Soyons donc un peuple debout, un peuple digne et fier de sa culture, la culture Tagbana ».\n\nDans la foire commerciale située sur le site du Carnaval Kaha, le pagne traditionnel Tagbana était à l’honneur. La curiosité et l’attirance de sa découverte créaient des attroupements constants devant ce stand qui montrait le processus de tissage jusqu’à l’exposition et la vente de pagnes et tenues traditionnelles Tagbana. Sur ce site, les opérateurs économiques et les artisans qui ont pris des stands pour leur exposition commerciale et promotionnelle ont pu faire de bonnes affaires. Cet événement carnavalesque était un moment de partage, d’échanges et de promotion du patrimoine culturel du peuple Tagbana dans les départements de Katiola et de Niakara\n\nLe Carnaval Kaha a été l’occasion de promouvoir les artistes locaux Tagbana qui ont fait montre de leur talent et de leur créativité tout comme les coiffeuses durant le concours de la meilleure coiffeuse remporté par les coiffeuses de Katiola pour la coiffure artistique et moderne. C’est aussi avec enthousiasme que les femmes ont participé aux différents concours gastronomiques et du meilleur tchapalo (bière locale traditionnelle très prisée) afin de valoriser et promouvoir les mets traditionnels Tagbana. A l’issue du concours Miss Carnaval Kaha 2018, Mademoiselle Ouassa Séréna a été élue. Durant une année, elle contribuera à porter haut l’étendard de la culture Tagbana.\n\nLors de cette 2ème édition du Carnaval Kaha tenue à Niakara deux tables rondes ont eu lieu. L’une sur «la mutualité : état des lieux et perspectives » et l’autre sur « le développement du tourisme dans les départements de Niakara et de Katiola ». Le public a pu voir et apprécier les nombreuses opportunités et atouts touristiques de cette immense zone Tagbana. Quant au tournoi du Carnaval Kaha, la finale de football féminin a été remportée par la sous-préfecture de Niédiékaha au détriment de celle de Arikokaha tandis que la finale masculine qui a opposé les communes de Niakara et de Tafiré, s’est soldée par la victoire de Tafiré.\n\nLe Carnaval Kaha vise à constituer une plateforme de retrouvailles en vue de fédérer les énergies et booster le développement social, économique et culturel de la zone géographique Tagbana, comprenant les départements de Katiola et de Niakara. Il vise également à valoriser et à promouvoir les atouts culturels, touristiques, artistiques, gastronomiques et économiques de cette zone et à donner une visibilité au peuple Tagbana à travers sa richesse culturelle.\n\nLa 1ère édition du Carnaval Kaha de Niakara s’est déroulée du 05 au 11 novembre 2017 au stade Nalo Bamba autour du thème ’’Venons à Niakara pour découvrir le peuple Tagbana’’.\n\n \n\nInfo Service Communication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648534.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Les étudiants de la promotion 2018 du Graduate School of Management reçoivent leurs diplômes de fin de cycle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648487.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:95:\"https://news.abidjan.net/photos/photos/CRemise-Diplome-2018-Graduate-School-Management-0004.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Mon, 26 Nov 2018 23:56:32 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3643:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/CRemise-Diplome-2018-Graduate-School-Management-0004.jpg\"/>Les étudiants de Graduate School of Management (GSM) à Abidjan, en fin de cycle MBA, Bachelor et Licence professionnelle ont reçu ce samedi 24 novembre, leurs diplômes de fin de cycle.\n\nC’était une occasion de plus pour le président de Graduate school of Management (GSM), Bright Ayivor-Bedzrah  d’exhorter les gradués à croire en leurs rêves, peu importe les difficultés.\n\n \nInvestir dans la jeunesse africaine par la qualité de l’éducation telle est la vision de cet établissement afin de susciter des élites et favoriser l’excellence dans tous les secteurs d’activités. Former des leaders et impacter les générations sont autant d’objectifs développés le GSM.\n\n « Il ne faut pas que nous les africains soyons complexés par nos origines », a souhaité le directeur général de la franchise Afrique de l’Ouest de Coca Cola, Rocky Findley dans son introduction.\n\nParce que selon lui, l’Afrique a connu la colonisation, mais il n’est pas question que cela définisse qui nous sommes et qu’est ce que le monde nous propose dans la vie.\n\nDurant son intervention, il a souligné le fait que nous ne devons pas nous arrêter à la langue dont nous avons hérité pendant la colonisation. C’est dans ce sens qu’il a pu dire qu’il est super important de parler la langue qui gouverne le monde, c’est-à-dire l’anglais.\n\nC’est la langue la plus reconnue a-t-il affirmé, et la langue du système qui gouverne le monde.  S’adressant ainsi aux parents venus pour soutenir leurs enfants M. Rocky Findley a invité chacun d’eux à commencer à éduquer leurs enfants en anglais, parce que c’est de cette façon qu’on parvient à comprendre ce qui se passe dans le monde et ils pourront ajouter leur grain de sel personnel.\n\n \n« Si nous sommes suffisamment décomplexés et que nous savons ce que nous voulons pour ce continent, ils nous revient de nous poser la question ‘’comment faire pour impacter ce système pour le bien de ce continent africain afin que l’éducation que nous aurons reçu avec notre intelligence et notre mode de réflexion, comment challenger ce système pour qu’il travail, pour que nos enfants n’aient pas à parler avec ce même cas, avec les mêmes désavantages avec lesquels nous avons commencé avant d’arriver dans le monde actif », a indiqué le directeur général.\n\n \nC’est tout en félicitant les étudiants pour le travail abattu, pour le sérieux qu’ils ont mis dans leurs études et en remerciant les parents pour avoir soutenu ces étudiants jusqu’au bout de leur aventure que M. Findley a clos son propos. «C’est maintenant que le plus dur commence parce qu’il faut changer ce système » a-t-il terminé.\n\nQuant au représentant des étudiants, Stéphane Amangoua, il a tenu à remercier tous les parents d’avoir fait le choix d’investir dans leur éducation.\n\n\nLa remise de diplôme s’est faite à trois niveaux: Les MBA, BBA et LP, ainsi que la remise du prix des meilleurs étudiants.\n\nC’est dans une bonne ambiance qu’ont été distingués les candidats à l’excellence qui, un an durant, ont fait preuves d’abnégation et de persévérance.\n\nLe Graduate School of Management s’est donné pour mission d’être un centre international de haute qualité dans l’apprentissage et la préparation des femmes et des hommes capables d’occuper des postes de responsabilité dans les domaines de la gestion des affaires, de l’industrie et des organismes publics.\n\n\nAtapointe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648487.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Fin de carrière de Didier Drogba : Il reçoit l’hommage de ses anciens coéquipiers de l’équipe nationale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648478.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:77:\"https://news.abidjan.net/photos/photos/5882328e04f7e_GettyImages138525439.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Mon, 26 Nov 2018 23:54:59 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3003:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/5882328e04f7e_GettyImages138525439.jpg\"/>Depuis qu’il a annoncé qu’il met fin à sa carrière dans le football, l’ancien capitaine des Eléphants de Côte d’Ivoire Didier Drogba est objet d’hommages à travers le monde. Parmi ceux-ci, l’hommage de ses anciens coéquipiers des Eléphants de Côte d’Ivoire.\n\nDe lui, son cadet Yao Kouassi Gervais dit ‘’Gervinho’’ déclare que: ‘’Didier est un grand frère. Au début de ma carrière, il m’appelait souvent après mes matches en me disant : \"j’ai vu ton but ou tu as fait un bon match. Avec quelques mots d’encouragements .... Toutes ses remarques me boostaient. C’est un modèle, une source de motivation ... je pense que c’est comme un peu tous les Ivoiriens. Je ne me tromperais pas en disant que c’est l’Ivoirien le plus connu’’. Pour le sociétaire de Parme en série A italienne, Didier Drogba pour avoir représenté la Côte d’Ivoire comme il l’a fait, mérite ‘’une sortie honorable’’, à l’instar de ce que l’Angleterre a fait pour Wayne Rooney ou l’Allemagne pour Lukas Podolski.\n\nN’Dri Romaric a quant à lui loué les qualités humaines et le sens du leadership de son ex-capitaine. ‘’En équipe nationale et comme personne, on a une relation de respect. je dirai une relation spéciale’’, a-t-il affirmé.\n\n‘’Son humilité résume tout. C’est quelqu’un qui est toujours prêt à aider, toujours présent et surtout quelqu’un d’exemplaire. C’est un vrai grand frère. Je l’appelle le 11 national’’, poursuit Romaric. ‘’Logiquement on doit lui rendre hommage, si tant est que les autorités respectent ce qu’il a fait en tant que véritable ambassadeur de ce pays’’, conclut-il.\n\n\n‘’Des 6 ans passés ensemble à Chelsea et les 8 ans avec les Eléphants, j’ai que des beaux souvenirs. Pour moi c’est plus qu’un grand frère. Il me donne beaucoup de conseils. Son  avis est très important. Je pense qu’il aura l’hommage qui lui est dû à Stamford bridges. Pourquoi pas un match Chelsea vs Eléphants de côte d’Ivoire’’, a pour sa part déclaré Salomon Kalou.\n\nPour son aîné Bonaventure Kalou, les meilleurs souvenirs avec l’enfant de Niaprahio restent sans aucun doute la CAN en Égypte en 2006 ainsi que la première qualification de la Côte d’Ivoire pour un mondial la même année. ’’Il représente un bon exemple pour tous les aspirants footballeurs en particulier, et pour tous les jeunes Ivoiriens en général. C’est un exemple d’abnégation et de travail acharné, un repère car les jeunes Ivoiriens en manquent cruellement’’, a affirmé Bonaventure Kalou. Quant à une célébration nationale de la légende de Chelsea, le nouveau Maire de Vavoua estime que cela incombe à la faîtière, même s’il dit en douter ’’parce qu’en Côte d’Ivoire et en Afrique, on aime célébrer les morts’’.\n\nAtapointe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648478.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:7:\"\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"Ouverture de la troisième session de la sixième édition du programme de formation des Maîtres Formateurs pour la promotion du cajou : « le défi principal de la filière est la transformation » (expert)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648535.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:91:\"https://news.abidjan.net/photos/photos/6e-Programme-Maitre-Formateur-ComCashew-GIZ-0019.jpg\";s:4:\"type\";s:9:\"image/jpg\";s:6:\"length\";s:1:\"0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Mon, 26 Nov 2018 23:54:41 GMT\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3932:\" <img align=\"left\" hspace=\"4\" src=\"https://news.abidjan.net/photos/thumb/6e-Programme-Maitre-Formateur-ComCashew-GIZ-0019.jpg\"/>Du 26 au 30 novembre 2018, l’initiative du Cajou Compétitif (ComCashew), en collaboration avec l’Alliance du Cajou Africain (ACA), soutenu par le Conseil Coton Anacarde (CCA) de la Côte d’Ivoire organise la troisième session de la sixième édition du programme de formation des Maîtres Formateurs (PMF) pour la promotion de la chaîne de valeur de cajou.\n\n \nA l’ouverture de cette énième édition, la transformation de la noix de cajou en Afrique cristallisait les débats.\n\n \n« Pour lutter contre la pauvreté, il est important de développer des politiques et stratégies pour ne pas toujours parler de l’Afrique comme pourvoyeur de noix brutes de cajou, mais devrions envisager être premier transformateur et aussi augmenter la consommation de cajou et des produits dérivés » a dit Mary Adzanyo, Directrice de Développement du secteur privé de l’initiative Cajou Compétitif, GIZ/ComCashew.\n\nEt d’ajouter « Avec plus de 1,7 million de tonnes de noix brutes produites en 2017 en Afrique, le volume total transformé représente environ 10% de la production totale. La transformation d’au moins 50% du volume total créerait quelque 250000 emplois avec un chiffre d’affaires annuel de plus de deux milliards de dollars. »\n\n\nC’est pourquoi, Le renforcement des capacités est capital pour le développement des organisations des filières et « la coopération allemande à travers la GIZ a fait du renforcement des capacités l’un des éléments clés de ses interventions (…) Il s’agit de disposer des pools d’experts sur la chaine de valeur de l’anacarde en Afrique, de faciliter les échanges régionaux axés sur l’apprentissage et l’innovation. »\n\n\nPour le Directeur Général du Conseil Coton Anacarde, Dr Adama Coulibaly, le défi principal de la filière cajou est la transformation : « Sur la production nous n’avons plus rien à démontrer. La Côte d’Ivoire excelle dans plusieurs domaines mais il nous reste à gagner la bataille de la transformation » déplorant le fait que «nous ramassons nos noix de cajou, nous les mettons dans les sacs puis dans les conteneurs et nous les exportons en dehors du pays. Non. La Côte d’Ivoire ne peut pas se contenter de si peu durablement. Nous devons à court terme inverser la tendance, à moyen terme la consolider et à long terme la stabiliser. »\n\n \n\nIl a donc appelé tous les pays producteurs en particulier producteurs de la noix de cajou à mutualiser toutes leurs forces pour aller à une transformation réussie.\n\n \n\n« Si nous restons à exporter et que les deux principaux clients de noix brutes (l’Inde et le Vietnam) ne les prennent pas, ce sera un problème. Alors que plusieurs autres clients prennent les amendes, d’où l’intérêt de la transformation » a-t-il prévenu.\n\n \n\nLe programme (MTP) a pour objectif d&#8217;accroître les connaissances théoriques et les compétences pratiques des experts en anacarde et ainsi de promouvoir davantage la compétitivité du secteur du cajou africain.\n\n \n\nLe 26 octobre dernier, prenait fin la 3e session de la 5e édition du Programme des Maitres Formateurs avec 74 participants venant de 11 pays. Aujourd’hui à cette sixième édition ce sont 85 participants venant de 8 pays qui prennent part à la formation\n\n \n\nA ce jour, 365 experts dont environ 25% de femmes ont été formés et proviennent de 16 pays africains.\n\n \n\nLe programme offre une plate-forme pour 92 experts de cajou venant de 8 pays : Bénin, Burkina Faso, le Cameroun, la Côte d’Ivoire, le Ghana, le Mozambique, le Nigeria et la Sierra Leone pour partager leurs connaissances, discuter des meilleures pratiques et les leçons apprises ainsi que de construire des réseaux nationaux et régionaux pour la collaboration à l’avenir.\n\n\n\n Atapointe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://news.abidjan.net/h/648535.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:12:\"content-type\";s:8:\"text/xml\";s:16:\"content-encoding\";s:4:\"gzip\";s:13:\"last-modified\";s:29:\"Tue, 27 Nov 2018 09:48:14 GMT\";s:13:\"accept-ranges\";s:5:\"bytes\";s:4:\"etag\";s:18:\"\"f3ba4513686d41:0\"\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:6:\"server\";s:17:\"Microsoft-IIS/8.5\";s:12:\"x-powered-by\";s:7:\"ASP.NET\";s:18:\"x-powered-by-plesk\";s:8:\"PleskWin\";s:4:\"date\";s:29:\"Tue, 27 Nov 2018 10:17:35 GMT\";s:14:\"content-length\";s:5:\"40882\";}}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO `jmkn_options` VALUES("890", "_transient_timeout_feed_mod_43f94b1d114c2aa05a6543dbe51ef010", "1543357045", "no");
INSERT INTO `jmkn_options` VALUES("891", "_transient_feed_mod_43f94b1d114c2aa05a6543dbe51ef010", "1543313845", "no");
INSERT INTO `jmkn_options` VALUES("892", "_transient_timeout_feed_1345314506258d7535d36f779ca19c22", "1543357047", "no");
INSERT INTO `jmkn_options` VALUES("893", "_transient_feed_1345314506258d7535d36f779ca19c22", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"BAD - Postes vacants\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"http://www.afdb.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Postes vacants de la Banque africaine de développement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"TYPO3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"fr\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:18:{i:0;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"Directeur du Département, Énergies Renouvelables et Efficacité Énergétique (PERN)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/director-renewable-energy-and-energy-efficiency-pern0-3924/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/director-renewable-energy-and-energy-efficiency-pern0-3924/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Nov 2018 17:25:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Spécialiste du Financement des Partenariats Publics Privés (AWF)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/public-private-partnership-finance-expert-awf-3922/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/public-private-partnership-finance-expert-awf-3922/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Nov 2018 16:23:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Ingénieur Principal des Transports - RDGE3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-transport-engineer-rdge3-3920/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-transport-engineer-rdge3-3920/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Nov 2018 11:19:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Économiste Principale de la Santé - AHHD2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-health-economist-ahhd2-3918/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-health-economist-ahhd2-3918/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Nov 2018 11:06:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Expert(e) en chef des marchés régionaux de l’énergie - PESD1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-regional-energy-markets-expert-pesd1-3916/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-regional-energy-markets-expert-pesd1-3916/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Nov 2018 18:27:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"Chargé(e) Supérieur(e) de la Mobilisation des Ressources et des Partenariats - FIRM.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/senior-resource-mobilization-and-partnership-officer-firm-1-3914/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/senior-resource-mobilization-and-partnership-officer-firm-1-3914/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Nov 2018 18:24:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Chargé(e) principal(e) de protection sociale - RDGC2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-social-protection-officer-rdgc2-3912/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-social-protection-officer-rdgc2-3912/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Nov 2018 18:20:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Économiste de recherche principal - ECMR.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-research-economist-ecmr-2-3910/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-research-economist-ecmr-2-3910/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Nov 2018 16:40:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Chargé(e) Principal(e) du Risque Financier - FIFM1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-financial-risk-officer-fifm1-3908/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-financial-risk-officer-fifm1-3908/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 18:49:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Chargé(e) en chef du risque financier - FIFM1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-financial-risk-officer-fifm1-3906/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-financial-risk-officer-fifm1-3906/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 18:39:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Secrétaire/Réceptionniste - RDGC.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/secretary-receptionist-rdgc-0-3904/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/secretary-receptionist-rdgc-0-3904/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 18:32:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Chargé(e) principal(e) de la pêche - ECNR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-fishery-officer-ecnr-3902/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-fishery-officer-ecnr-3902/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 18:24:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Chargé(e) en chef de foresterie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-forestry-officer-ecnr-3900/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-forestry-officer-ecnr-3900/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Nov 2018 14:35:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"Chargé(e) de l’efficacité de développement et de l’assurance qualité - SNOQ2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/development-effectiveness-and-quality-assurance-officer-snoq2-3898/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/development-effectiveness-and-quality-assurance-officer-snoq2-3898/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 18:00:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Chargé(e) de la Gestion des cas et des Services Consultatifs - BCRM\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/case-management-and-advisory-services-officer-bcrm-3896/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/case-management-and-advisory-services-officer-bcrm-3896/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 17:54:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"Chargé(e) Supérieur(e) du Suivi et de l’Évaluation - CDSF\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/senior-monitoring-evaluation-officer-m-e-cdsf-3893/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/senior-monitoring-evaluation-officer-m-e-cdsf-3893/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 17:43:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"Charge de technologie et infrastructure de conférences et réunions - PSEG.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/conference-and-meetings-technology-and-facilities-officer-pseg-1-3892/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/conference-and-meetings-technology-and-facilities-officer-pseg-1-3892/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 17:43:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:4:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Directeur du Bureau de Coordination des États en Transition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/director-transition-states-coordination-office-3876/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/director-transition-states-coordination-office-3876/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Oct 2018 17:37:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:63:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:18:{s:4:\"date\";s:29:\"Tue, 27 Nov 2018 10:17:28 GMT\";s:6:\"server\";s:6:\"Apache\";s:10:\"set-cookie\";s:72:\"lang=fr; path=/; domain=.afdb.org; expires=Wed, 27-Nov-2019 10:17:28 GMT\";s:15:\"x-ua-compatible\";s:7:\"IE=edge\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:15:\"referrer-policy\";s:26:\"no-referrer-when-downgrade\";s:27:\"access-control-allow-origin\";s:1:\"*\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";s:16:\"content-language\";s:2:\"FR\";s:7:\"expires\";s:29:\"Tue, 27 Nov 2018 11:05:46 GMT\";s:13:\"cache-control\";s:26:\"max-age=2898, no-transform\";s:6:\"pragma\";s:6:\"public\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:14:\"content-length\";s:4:\"1582\";s:12:\"content-type\";s:30:\"application/xml; charset=UTF-8\";}}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO `jmkn_options` VALUES("894", "_transient_timeout_feed_mod_1345314506258d7535d36f779ca19c22", "1543357047", "no");
INSERT INTO `jmkn_options` VALUES("895", "_transient_feed_mod_1345314506258d7535d36f779ca19c22", "1543313847", "no");
INSERT INTO `jmkn_options` VALUES("896", "_transient_timeout_feed_4ca4784d0ae2dc857425d213e86e0f71", "1543357049", "no");
INSERT INTO `jmkn_options` VALUES("897", "_transient_feed_4ca4784d0ae2dc857425d213e86e0f71", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:4:\"\n  \n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:123:\"\n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n  \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"Export RSS des offres - Seulement les offres à la une : Non\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:20:{i:0;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=230&idOrigine=502&LCID=1036&offerReference=2018-256-230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:64:\"Achats Ventes Marketing/Support Commercial - Marketing - Réseau\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Alternance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Sèvres\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"2018-256-230 - Assistant communication digitale H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2316:\"<b>Métier : </b>Achats Ventes Marketing/Support Commercial - Marketing - Réseau<br />\n<b>Contrat : </b>Alternance<br />\n<b>Description du poste : </b><br />\nIntégré au sein de la direction de la communication du Groupe CFAO et rattaché au pôle Digital, tu seras en charge de :\n•	Contribuer à la transformation de la communication digitale de CFAO et à la mise en place de ses nouveaux outils/médias.\n•	Développer l\'audience et l\'engagement autour de l\'intranet du Groupe.\n•	Développer la notoriété du groupe à travers ses réseaux sociaux externes. \nTu interviendras aussi bien sur les outils digitaux internes qu\'externes. \n\nTes missions principales consisteront à : \n Côté intranet\n-	Animer quotidiennement l\'intranet, en soutenant le réseau de contributeurs et en étant force de proposition pour la création de nouveaux articles \n-	Participer à l\'élaboration du calendrier éditorial et à la création des contenus (rédaction, vidéos)\n-	Veiller à la bonne utilisation de l\'outil (accompagnement, modération…)\nCôté web externe\n-	Animer les réseaux sociaux du groupe (élaboration du calendrier éditorial, rédaction et production de contenus et de visuels, relais d\'article…) \n-	Travailler sur le projet de refonte des sites web du Groupe \n-	Etre support à l\'équipe communication digitale dans l\'ensemble de ses missions<br /><br />\nEtudiant en 1ère ou 2ème année de master en communication, en école ou université. \nSpécialisation dans le digital ou forte appétence pour le sujet. \nPremière expérience dans le community management et l\'animation de communautés souhaité. Maîtrise de l\'écosystème Social Media et des codes propres aux différentes communautés. \nAisance rédactionnelle et excellente maîtrise de l\'orthographe. \nMaîtrise de la suite Office et une bonne maitrise des outils PAO (suite Adobe). \nAnglais professionnel.\nNotions souhaitées sur Google Analytics, en référencement et en SEO. \nUne expérience en administration de site web (Wordpress, Drupal…) et des notions en HTML et CSS seraient un vrai plus. \nCurieux(se), dynamique, force de proposition. Un bon esprit d\'équipe ainsi que de bonnes qualités rédactionnelles sont essentiels au poste<br />\n<b>Lieu : </b>Sèvres<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Fri, 23 Nov 2018 23:43:21 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=224&idOrigine=502&LCID=1036&offerReference=2018-224\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:45:\"Achats Ventes Marketing/Resp Marque - Produit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Alternance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Sèvres\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"2018-224 - Assistant Responsable de Marques H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2045:\"<b>Métier : </b>Achats Ventes Marketing/Resp Marque - Produit<br />\n<b>Contrat : </b>Alternance<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre division Automotive, Equipment & Services, un(e) Assistant(e) Responsable de Marques, à compter du 1er Janvier 2019. \nVous serez rattaché(e) au Directeur et accompagné(e) par les Responsables de marques, vous aurez pour principales missions: \n\nMARKETING STRATEGIQUE & ETUDES DE MARCHES\n- Vérifier des bases de données marchés disponibles (volumes exports Monde vers Afrique)\n- Participer à l\'élaboration de l\'analyse marché et recommandations\n\nMARKETING OPERATIONNEL & ANIMATION RESEAU\n- Contrôler et analyser des reportings filiales \n- Participer à l\'élaboration et à l\'animation des plans marketing des filiales \n- Analyser les rapports marketings\n- Suivre les budgets publicitaires constructeurs et le budget marketing central siège du service\n- Supports de communication : création, production, suivi et archivage(Relations fournisseurs PLV et agences de communication)\n- Analyse des résultats des actions commerciales pour communication constructeurs\n- Aider à l\'élaboration des best practices et mémos marque pour les filiales\n\nRELATIONS FOURNISSEURS\n- Assurer la communication avec les constructeurs basés en Asie et en Europe\n- Participer à la préparation des réunions fournisseurs\n\nCOMPETENCES : \n- Maîtrise parfaite de l\'anglais\n- Suite Office : Bonne maîtrise d\'Excel impérative\n- Connaissances Photoshop ou Illustrator<br /><br />\nEtudiant en formation supérieure en Marketing / Commerce International (Ecole de Commerce, BAC+4 / +5), vous avez acquis une première expérience en stages/césure tournée vers l\'international, idéalement dans le secteur du deux roues ou automobile. Vous avez une fibre marketing et commerciale ainsi qu\'un excellent relationnel. Vous êtes très organisé, rigoureux, dynamique et savez travailler en toute autonomie. <br />\n<b>Lieu : </b>Sèvres<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Wed, 07 Nov 2018 14:20:47 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:47:\"\n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=225&idOrigine=502&LCID=1036&offerReference=AESRESPMQUE0918-225\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:45:\"Achats Ventes Marketing/Resp Marque - Produit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"AESRESPMQUE0918-225 - Responsable de Marques H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1898:\"<b>Métier : </b>Achats Ventes Marketing/Resp Marque - Produit<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre division Automotive, Equipment & Services, un(e) Responsable de Marques, il/elle sera chargé(e) de garantir la rentabilité et le développement des marques confiées sur son périmètre. Vous serez rattaché(e) au Directeur Général de la Business Unit et vous aurez pour principales missions : \n\nMARKETING STRATEGIQUE & ETUDES DE MARCHES\n-	Participer à l\'élaboration de l\'analyse marché et recommandations\n-	Assurer le suivi et la négociation quotidienne avec les fournisseurs\n-	Aider à l\'élaboration des best practices et mémos marque pour les filiales\n\nMARKETING OPERATIONNEL & ANIMATION RESEAU \n-	Participer à l\'élaboration et à l\'animation des plans marketing pays \n-	Négocier les budgets promotionnels\n-	Assurer le suivi des ratios du ou des stocks centraux\n-	Assurer la mise en place des différents supports de communication mise à disposition \n\nRELATIONS FOURNISSEURS\n-	Assurer la communication entre le Groupe et la filiale\n-	Etre un référent pour notre Siège en assurant la fiabilité des informations constructeurs transmises au Siège\n\nCOMPETENCES : \n-	Maîtrise parfaite de l\'anglais\n-	Suite Office : Bonne maîtrise d\'Excel impérative\n-	Connaissances Photoshop ou Illustrator<br /><br />\nDe formation supérieure en Marketing / Commerce International (Ecole de Commerce, BAC+4 / +5), Vous disposez d\'une expérience dans le secteur automobile sur des fonctions similaires tourné vers l\'international. \nVotre rigueur, votre goût pour le travail en équipe ainsi que vos capacités à animer votre périmètre seront autant d\'atout pour vous accompagner dans la conduite de votre activité.<br />\n<b>Niveau d\'études min. requis : </b>Bac+5<br />\n<b>Langue / Niveau : </b><br />\nAnglais : Courant<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 22 Oct 2018 11:11:58 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:47:\"\n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=232&idOrigine=502&LCID=1036&offerReference=AESWACH2018-232\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:60:\"Exploitation-Opérations/Dir - Resp Département - Activité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"AESWACH2018-232 - Directeur des Opérations - Filiale H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2024:\"<b>Métier : </b>Exploitation-Opérations/Dir - Resp Département - Activité<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre filiale de la division Automotive, Equipment & Services, un(e) Directeur des Opérations - Filiale.\n\nVous serez rattaché(e) au Directeur Générale de la filiale, et aurez pour principales missions: \n\nDEVELOPPEMENT COMMERCIAL / MARKETING\n-	Développer le CA et les parts de marché sur son périmètre d\'affectation\n-	Coordonner et manager l\'activité commerciale\n-	Contribuer à l\'élaboration des plans volumes à 5 ans (PMT)\n-	Mettre en œuvre la stratégie commerciale, tarifaire et marketing qui sera validée par le DG\n-	Assumer l\'animation quotidienne des marques sur son périmètre\n\nFINANCE / GESTION\n-	Piloter le budget de son activité (CA, marge, stock, rentabilité par site…)\n-	Répondre aux appels d\'offres\n-	Assurer le reporting mensuel et annuel\n-	Assumer la responsabilité du contrôle opérationnel (0 points rouges au PACI)\n\nMANAGEMENT\n-	Définir et proposer une organisation adéquate des équipes\n-	Définir et mettre en place des best practices et processus\n-	Assurer la continuelle adaptabilité et le développement des équipes\n\nCOMPETENCES : \n-	Maîtrise parfaite de l\'anglais\n-	Gestion commerciale, financière & marketing<br /><br />\nDe formation supérieure commerciale, vous justifiez d\'une expérience de 10 ans sur des fonctions similaires (Gestion d\'un service après-vente, d\'un atelier mécanique ou service de maintenance…), une connaissance du secteur automobile est fortement appréciée.\nVous êtes un manager confirmé reconnu pour votre capacité d\'analyse, votre sens du service client, ainsi que votre aisance relationnelle.\nOrganisé, rigoureux facilitateur et force de proposition sont autant d\'atouts qui vous seront utiles dans la prise en main de votre périmètre d\'affectation.<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n<b>Langue / Niveau : </b><br />\nAnglais : Bilingue<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Fri, 19 Oct 2018 14:04:34 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=231&idOrigine=502&LCID=1036&offerReference=203-231\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:38:\"Finance Juridique/Fusion - Acquisition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Stage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:6:\"SEVRES\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"203-231 - Chef de projet expansion H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1514:\"<b>Métier : </b>Finance Juridique/Fusion - Acquisition<br />\n<b>Contrat : </b>Stage<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre division Retail, un(e) Assistant(e) chef de projet expansion. Vous aurez pour principale missions :\n\n•	Elaborer des présentations Powerpoint de projets en vue des validations par les actionnaires (Carrefour, SGI, CFAO) \n\n•	Participer à la réalisation des études financières de projets en vue de leur validation par la Direction Financière\n\n•	Mettre à jour de l\'arborescence d\'archivage des projets en cours et Suivi des signatures des projets (Dossier remis à qui? quand?)\n\n•	Participer au pilotage des projets (mise à jour des retro plannings, diffusion des to-do list,et des compte-rendu de réunions)<br /><br />\n- De formation supérieure Niveau Master (Bac+ 4, Bac +5) ou année de césure d\'école de commerce ou d\'école d\'ingénieur, vous vous intéressez à l\'univers de la Grande distribution en général et à l\'Afrique en particulier. \n\n- Rigoureux et organisé, vous aimez travailler en équipe et faites preuve de réactivité et d\'autonomie\n\n- Votre créativité ainsi que vos qualités rédactionnelles vous permettront aussi de concevoir des supports de qualité à destination d\'interlocuteurs de haut niveau. \n\n- Très bonne maitrise des outils informatiques (Excel, PowerPoint, Sharepoint, MS Project, etc.) ;\n\n- Anglais courant requis.<br />\n<b>Lieu : </b>SEVRES<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 08 Oct 2018 09:50:11 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:47:\"\n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=223&idOrigine=502&LCID=1036&offerReference=AESDRPSCDI092018-223\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:43:\"Technique & Services/Pièces et-ou Services\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"AESDRPSCDI092018-223 - Directeur Pièces &amp; Service H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2639:\"<b>Métier : </b>Technique & Services/Pièces et-ou Services<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nNous recherchons pour la Division Automotive Equipment and Services West Africa un(e) Directeur Pièces & Services dans le cadre du développement de nos activités au sein de la Division Automotive Equipment and Services West Africa. \nVotre responsabilité sera d\'assurer le développement commercial et marketing de l\'activité Pièces & Services pour les marques confiées, en répondant aux différentes attentes de nos partenaires en matière de Services Après-Vente.\nVos principales missions s\'articuleront autour du :\nDEVELOPPEMENT DE L\'ACTIVITE\n•	Etablit et suit le budget\n•	Définit les niveaux de performance à atteindre en « Service client »\n•	Développe les plans Qualité\n•	Est responsable des actions de développement du CA, du portefeuille clients, de la coordination et du traitement des affaires\n•	Développe l\'image de marque de la filiale \n•	Analyse les chiffres de vente et propose les actions d\'animation et de développement des ventes\n•	Gère les stocks et les processus d\'approvisionnement auprès des fournisseurs\n•	Assure en « Pièces de rechange » les objectifs de taux de service sur stock\n•	Assure en atelier les objectifs de taux de satisfaction client, de délai de RDV, de conformité de la prestation.\nGESTION\n•	Gère les flux de commandes, les approvisionnements, les stocks et les livraisons\n•	Organise et prépare à l\'inventaire général du stock « Pièces de rechange »,\n•	Assure en atelier les objectifs de productivité, de rentabilité Main d\'œuvre.\nORGANISATION / MANAGEMENT\n•	Constitue, met en place les équipes pièces et service et les fait évoluer pour assurer un service client optimal\n•	Définit et suit les objectifs de vente des équipes P&S.\nANIMATION / FORMATION \n•	Anime des équipes P&S, les agents administratifs et les succursales pour la partie Service.\n•	Assure la formation continue des équipes<br /><br />\nNous recherchons pour ce poste un profil expérimenté, de formation Supérieure (Bac+3 ou 4) à dominante marketing, vous disposez déjà d\'une expérience tourné vers l\'international dans un service Pièces & Service.\nOrganisé(e), doté(e) de sens critique et analytique, vous disposez d\'un excellent relationnel et vous aimez travailler en équipe.\nLa maîtrise de l\'Anglais est indispensable, niveau courant exigé. \nMaîtrise des outils Office, notamment Excel et Powerpoint. <br />\n<b>Niveau d\'études min. requis : </b>Bac+3<br />\n<b>Langue / Niveau : </b><br />\nAnglais : Courant<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 10 Sep 2018 07:17:58 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=226&idOrigine=502&LCID=1036&offerReference=AESDCAPVEXP112018-226\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:66:\"Technique & Services/Dir - Resp Département - Activité Tech.Serv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:5:\"Accra\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"AESDCAPVEXP112018-226 - Directeur Commercial Après-Vente H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2645:\"<b>Métier : </b>Technique & Services/Dir - Resp Département - Activité Tech.Serv<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nNous recherchons pour une de nos filiales au sein de la division Automotive Equipment and Services, un(e) Directeur Commercial Après-Vente dans le cadre du développement de nos activités, basé au Ghana.\nVotre responsabilité sera d\'assurer la coordination entre les activités après-vente des divisions Automotive & Equipment afin de garantir la profitabilité et la satisfaction clientèle. Vos principales missions s\'articuleront autour de :\n\nDEVELOPPEMENT DE L\'ACTIVITE\n\n•	Développer le CA Après-Vente (Pièces de rechange, frais de maintenance, contrat de maintenance, Atelier délocalisé…)\n•	Développer le portefeuille client\n•	Développer la gamme de service\n•	Coordonner la stratégie pour l\'activité Pièces & Service en collaboration avec le Directeur de Service Après-Vente et le Directeur Supply Chain\n•	Proposer et mettre en place les actions commerciales pour les activités après-vente\n•	Visiter les clients et prospects afin d\'identifier leurs besoins\n•	Effectuer une veille concurrentielle constante afin de définir la politique tarifaire\n•	Proposer et amorcer les nouvelles opportunités commerciales pour les activités après-vente\n•	Effectuer le lien entre les constructeurs et les responsables de marque\n•	Effectuer le reporting mensuel des activités après-vente\n•	Superviser les stocks ainsi que les dettes clients en collaboration avec le Responsable de Service National et le Directeur Supply Chain\n\nORGANISATION / MANAGEMENT\n\n•	Constituer, développer et former le personnel qui composera les équipes commerciales après-vente\n\nANIMATION / FORMATION \n\n•	Organiser et animer les équipes commerciales après-vente\n•	Organiser le plan de formation pour les équipes commerciales après-vente\n•	Définir et suivre les objectifs pour les activités après-vente<br /><br />\nNous recherchons pour ce poste un profil expérimenté, de formation Supérieure (MBA, Ecoles de commerce, écoles d\'ingénieurs) en management opérationnel ou finance, avec une expérience significative dans la gestion d\'activité après-vente.\n\nVous disposez d\'un excellent relationnel, vous aimez travailler en équipe, dynamique, autonome et doté d\'excellentes capacités en communications, seront autant d\'atouts pour vous accompagner dans la conduite de votre activité.\n\nAnglais courant indispensable<br />\n<b>Lieu : </b>Accra<br />\n<b>Niveau d\'études min. requis : </b>Bac+5<br />\n<b>Langue / Niveau : </b><br />\nAnglais : Courant<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Wed, 01 Aug 2018 12:06:40 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:47:\"\n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=222&idOrigine=502&LCID=1036&offerReference=ARMCDIV092018-222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:45:\"Achats Ventes Marketing/Resp Marque - Produit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"ARMCDIV092018-222 - Assistant (e) Responsable de Marques H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2372:\"<b>Métier : </b>Achats Ventes Marketing/Resp Marque - Produit<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nNous recherchons pour la Division Automotive Equipment and Services West Africa un(e) Assistant(e) responsable de marques dans le cadre du développement de nos activités au sein de la Division Automotive Equipment and Services West Africa. \nVotre mission sera d\'assurer le développement commercial et marketing des marques automobiles ainsi que la consolidation et la synthèse des informations terrain, permettant d\'assurer un reporting de haute qualité entre les marques et les filiales de distribution CFAO. \nVotre rôle sera moteur dans le suivi des programmes des différents constructeurs partenaires de CFAO (lancement de nouveaux modèles, études de marchés…). \nVous gérerez également le quotidien de la relation avec les marques. \nVos principales missions s\'articuleront autour des dimensions définies ci-dessous :\n•	Participer au suivi des tarifs et reporter l\'information\n•	Participer à l\'administration des approvisionnements via l\'outil de prévision AZAP (création et paramétrage produits) \n•	Consolider les reportings fournisseurs (résultats des ventes, stocks…) \n•	Analyser les SEM (Commande de réapprovisionnement filiale) et les Rundown en binôme avec le Responsable de marques\n•	Suivre les affectations en binôme avec le Responsable de marques\n•	Participer à la préparation de présentations constructeurs dans le cadre des négociations\n•	Suivre budget publicité des filiales et des constructeurs\n•	Assurer la permanence pour la relation filiale / constructeur pour les opérations quotidiennes (missions et/ou vacances du Responsable de marques)<br /><br />\nNous recherchons pour ce poste un profil expérimenté, de formation Supérieure (Bac+3 ou 4) à dominante marketing, vous disposez déjà d\'une expérience tourné vers l\'international, idéalement dans l\'assistanat automobile.\nOrganisé(e) et rigoureux(se), doté(e) de sens critique et analytique, vous disposez d\'un excellent relationnel et vous aimez travailler en équipe.\nLa maîtrise de l\'Anglais est indispensable, niveau courant exigé. \nMaîtrise des outils Office, notamment Excel et Powerpoint. <br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n<b>Langue / Niveau : </b><br />\nAnglais : Courant<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Tue, 31 Jul 2018 08:51:54 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=221&idOrigine=502&LCID=1036&offerReference=2018-221\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:45:\"Finance Juridique/Juridique-Fiscal-Assurances\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Stage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"Sèvres (92)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"2018-221 - Stage Droit des Sociétés / Droits des Contrats H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1837:\"<b>Métier : </b>Finance Juridique/Juridique-Fiscal-Assurances<br />\n<b>Contrat : </b>Stage<br />\n<b>Description du poste : </b><br />\nDans un environnement international, votre stage s\'articulera autour des axes suivants :\n\n1.	Droit des sociétés (société holding et ses filiales) : Assistance à l\'organisation et au fonctionnement des réunions des organes de direction et de surveillance ainsi que des assemblées générales des actionnaires, assistance au suivi de la vie sociale des filiales : opérations ordinaires et extraordinaires (arrêté des comptes, actes juridiques, opérations sur le capital, constitution/liquidation/mise en sommeil/activation de sociétés, etc.), mise à jour des bases de données et bases documentaires internes (Sharepoint, Legalsuite) secrétariat juridique des sociétés, veille et recherches juridiques.\n\n2.	Droit des contrats : Assistance à la rédaction et à la négociation de contrats commerciaux tels que contrats de distribution, contrats d\'approvisionnement, contrats de licence de marque et de fabrication, contrats de licence de logiciels pour l\'ensemble des BU du groupe (Automobile, Equipement, Biens de consommation, Technologie et Energie), recherches et rédaction de notes en droit commercial général, assistance à la mise à jour des bases de données contrats (Legalsuite)\n<br /><br />\nVous êtes un(e) étudiant(e), niveau minimum Master 1 en droit, ayant reçu un enseignement solide en droit international des affaires, droit des sociétés, droit international des contrats et droit de la distribution.\n\nCapacité à travailler en anglais, forte propension à évoluer dans un contexte international.\n\nDémarrage : octobre 2018\n\nDurée : 6 mois\n\nRémunération: attractive<br />\n<b>Lieu : </b>Sèvres (92)<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Tue, 31 Jul 2018 08:49:47 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:122:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=206&idOrigine=502&LCID=1036&offerReference=AESWAARM092018-206\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:45:\"Achats Ventes Marketing/Resp Marque - Produit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Alternance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Sèvres\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"AESWAARM092018-206 - Assistant Responsable de Marque H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2136:\"<b>Métier : </b>Achats Ventes Marketing/Resp Marque - Produit<br />\n<b>Contrat : </b>Alternance<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre division Automotive, Equipment & Services, un(e) Assistant(e) Responsable de Marques, à compter du 24 Septembre 2018. Vous serez rattaché(e) au Directeur du Service Deux roues, et accompagné(e) par les Responsables de marques, vous aurez pour principales missions: \n\nMARKETING STRATEGIQUE & ETUDES DE MARCHES\n- Vérifier des bases de données marchés disponibles (volumes exports Monde vers Afrique)\n- Participer à l\'élaboration de l\'analyse marché et recommandations\n- Contribuer à l\'élaboration des plans volumes à 5 ans (PMT)\n\nMARKETING OPERATIONNEL & ANIMATION RESEAU (23 pays africains)\n- Contrôler et analyser des reportings filiales \n- Participer à l\'élaboration et à l\'animation des plans marketing des filiales \n- Analyser les rapports marketings\n- Suivre les budgets publicitaires constructeurs et le budget marketing central siège du service\n- Mise à jour des sites internet et suivi des réseaux sociaux\n- Supports de communication : création, production, suivi (Relations fournisseurs PLV et agences de communication)\n- Aider à l\'élaboration des best practices et mémos marque pour les filiales\n\nRELATIONS FOURNISSEURS\n- Assurer la communication avec les constructeurs basés en Asie et en Europe\n- Participer à la préparation des réunions fournisseurs\n\nCOMPETENCES \n- Maîtrise parfaite de l\'anglais\n- Le japonais serait un plus\n- Suite Office : Bonne maîtrise d\'Excel impérative\n- Connaissances Photoshop ou Illustrator<br /><br />\nEtudiant en formation supérieure en Marketing / Commerce International (Ecole de Commerce, BAC+4 / +5), vous avez acquis une première expérience en stages/césure tournée vers l\'international, idéalement dans le secteur du deux roues ou automobile. Vous avez une fibre marketing et commerciale. Vous êtes très organisé, rigoureux, dynamique et savez travailler en toute autonomie. Très bon relationnel.<br />\n<b>Lieu : </b>Sèvres<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 30 Jul 2018 15:10:10 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=220&idOrigine=502&LCID=1036&offerReference=AESARMSAV072018-220\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:45:\"Achats Ventes Marketing/Resp Marque - Produit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Alternance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Sèvres\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"AESARMSAV072018-220 - Assistant Responsables de Marques - SAV H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1877:\"<b>Métier : </b>Achats Ventes Marketing/Resp Marque - Produit<br />\n<b>Contrat : </b>Alternance<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre division Automotive, Equipment & Services, un(e) Assistant(e) Responsable de Marques Service Après-Vente, à compter du 1er Septembre 2018. Vous serez rattaché(e) au Directeur du Service, et accompagné(e) par les Responsables de marques, vous aurez pour principales missions: \n\nMARKETING STRATEGIQUE & ETUDES DE MARCHES\n- Vérifier des bases de données marchés disponibles (volumes exports Monde vers Afrique)\n- Participer à l\'élaboration de l\'analyse marché et recommandations\n\nMARKETING OPERATIONNEL & ANIMATION RESEAU\n- Contrôler et analyser des reportings filiales \n- Participer à l\'élaboration et à l\'animation des plans marketing des filiales \n- Analyser et archiver les rapports marketings pour transmission au constructeur\n- Mise en place de campagne de communication – Pièces & Services – Share Point\n- Supports de communication : création, production, suivi (Pochettes pour proforma et factures/Fiches produits argumentés/Books vendeurs/Brochures et tarifs /Contrats entretien – maintenance/Fiches Pays…)\n- Aider à l\'élaboration des best practices et mémos marque pour les filiales\n\nRELATIONS FOURNISSEURS\n- Participer à la préparation des réunions fournisseurs<br /><br />\nEtudiant en formation supérieure en Marketing / Commerce International (Ecole de Commerce, BAC+4 / +5), vous avez acquis une première expérience en stages/césure tournée vers l\'international, idéalement dans le secteur du deux roues ou automobile. Vous avez une fibre marketing et commerciale. Vous êtes très organisé, rigoureux, dynamique et savez travailler en toute autonomie. Très bon relationnel.<br />\n<b>Lieu : </b>Sèvres<br />\n<b>Niveau d\'études min. requis : </b>Bac+3<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 30 Jul 2018 11:38:27 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:47:\"\n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=203&idOrigine=502&LCID=1036&offerReference=2018-203\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:38:\"Administration/Assistante de Direction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Alternance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2018-203 - Assistant(e) Manager H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2186:\"<b>Métier : </b>Administration/Assistante de Direction<br />\n<b>Contrat : </b>Alternance<br />\n<b>Description du poste : </b><br />\nAu sein de nos équipes Supply Chain, vos missions seront les suivantes :\n- Assister le directeur et/ou les membres de l\'équipe dans leurs activités quotidiennes\n- Assurer les tâches administratives \n\nVous aurez pour responsabilité :\n\n- D\'assurer l\'assistanat du service : gestion des appels téléphoniques et des agendas, organisation des réunions, visioconférences et des déplacements.\n - De gérer le suivi budgétaire, contrôle des factures et saisie des notes de frais.\n- D\'organiser les évènements pour le service : petit déjeuner mensuel, team building et autres moments de convivialité selon les besoins.\n- De négocier avec les prestataires : agence de voyage, traiteurs, fournitures de bureau…\n- De préparer les dossiers (mise en forme de présentations, diaporama …) nécessaires au fonctionnement de la direction et gérer le classement de ces documents.\n- De garantir un accueil de qualité à l\'ensemble des interlocuteurs internes ou externes en veillant à les orienter et en leur apportant l\'assistance et le conseil nécessaire.<br /><br />\nTitulaire d\'un Baccalauréat, vous préparez un BTS SAM (support à l\'action managériale) dans le cadre d\'un contrat d\'apprentissage ou de professionnalisation d\'une durée de 24 mois.\n\nRigoureux(se), organisé(e) et méthodique, vous possédez idéalement une première expérience en secrétariat / assistanat de direction qui vous a permis de développer votre sens du service.\n\nVous avez démontré vos capacités de réactivité, de prise d\'initiatives et de discrétion dans une mission similaire et savez gérer les priorités.\n\nDisponible, vous aimez travailler en équipe et savez utiliser vos aptitudes de communication. Vous avez un excellent niveau d\'orthographe et une aisance rédactionnelle.\n\nLa maîtrise orale et écrite de l\'anglais sera appréciée.\nLa maîtrise des outils bureautiques (Outlook et Pack Office : Excel, Word, PowerPoint…) est indispensable.\n\nDémarrage Août / Septembre 2018.<br />\n<b>Niveau d\'études min. requis : </b>Bac/Bac+1<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 30 Jul 2018 09:15:17 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:116:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=166&idOrigine=502&LCID=1036&offerReference=STGConso-166\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:41:\"Finance Juridique/Reporting Consolidation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Stage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Sèvres\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"STGConso-166 - Gestionnaire de projet IFRS  H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1549:\"<b>Métier : </b>Finance Juridique/Reporting Consolidation<br />\n<b>Contrat : </b>Stage<br />\n<b>Description du poste : </b><br />\nAu sein du département de la Consolidation Groupe, vous assisterez l\'équipe sur les travaux récurrents de la consolidation mensuelle, tels que :\n\n1.La Formation aux filiales ;\n•	Organisation et animation de formations (Sharepoint / Webex) \n•	Plans d\'action ciblés \n•	Assistance à la collecte d\'informations \n\n2. La mise en œuvre et le suivi de la nouvelle norme IFRS ; \n•	Suivi de la collecte auprès des filiales du groupe\n•	Analyse des informations collectées et synthèse \n•	Etude d\'impacts pour le Groupe et établissement des supports de communication pour la Direction\n•	Mise en conformité de l\'information financière au regard de cette nouvelle norme\n\n3 La participation active au déploiement d\'un logiciel à toutes les filiales du Groupe ;\n•	Participation à la rédaction d\'un appel d\'offre \n•	Suivi du déploiement de l\'outil \n•	Formation à l\'utilisation du logiciel aux filiales <br /><br />\n- Diplômé d\'une ESC minimum ou équivalent universitaire avec une spécialisation en finance, comptabilité, gestion ou audit \n\nVous disposez :\n- d\'une première expérience dans une direction financière \n- d\'un bon niveau Excel\n- d\'un bon niveau d\'anglais professionnel\n\nNous recherchons un candidat dynamique ayant des qualités d\'autonomie et d\'esprit d\'équipe avec une forte culture projet.<br />\n<b>Lieu : </b>Sèvres<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Wed, 25 Jul 2018 12:13:36 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=219&idOrigine=502&LCID=1036&offerReference=2018-219\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:42:\"Supply Chain/Admin des ventes - Logistique\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Alternance\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"Sèvres (92)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"2018-219 - Assistant(e) Supply Chain H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1101:\"<b>Métier : </b>Supply Chain/Admin des ventes - Logistique<br />\n<b>Contrat : </b>Alternance<br />\n<b>Description du poste : </b><br />\nNous recherchons pour le service Supply Chain de la division Automotive, Equipment & Services, un(e) alternant(e) Logistique et Transport.\nIl/elle sera rattaché(e) au Directeur des Projets et des Opérations et aura pour principales missions : \n\nPROJETS LOGISTIQUES\nSupport aux projets conduits par le service. A titre d\'exemple, projet de dématérialisation de la liasse documentaire (CLOUD)\n\nACHATS TRANSPORTS ET LOGISTIQUES\nParticipation à la préparation des appels d\'offres (tous modes)\nAcquisition des techniques CFAO de cotation de logistique/ transport pour être en mesure de répondre aux demandes des services commerciaux<br /><br />\nProfil recherché\nMaster 1 / Master 2 en Logistique et Transport\nRigueur, Curiosité, polyvalence\n\nRythmes souhaité : \n- 4 jours par semaine en entreprise et 1 jour à l\'école\n- 1 semaine/ 3 semaines\n- 1 semaine/ 2 semaines.<br />\n<b>Lieu : </b>Sèvres (92)<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Tue, 24 Jul 2018 13:30:48 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=217&idOrigine=502&LCID=1036&offerReference=ARPSAES092018-217\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:64:\"Achats Ventes Marketing/Support Commercial - Marketing - Réseau\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Sèvres\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"ARPSAES092018-217 - Animateur Réseau Pièces &amp; Services H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1909:\"<b>Métier : </b>Achats Ventes Marketing/Support Commercial - Marketing - Réseau<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre division Automotive, Equipment & Services, un(e) Animateur Réseau Pièces & Services, il/elle sera chargé(e) de garantir la rentabilité et le développement des marques confiées de pièces de rechange. \nRattaché(e) au Directeur Pièces & Services, vous aurez pour principales missions : \n\n-	Réaliser les audits commerciaux et marketing sur les pièces de rechange et services au sein du Groupe\n-	Effectuer les rapports de missions\n-	Animer le suivi mensuel d\'activité Pièces & Service sur votre périmètre\n-	Etablir et suivre les plans d\'action marketing sur les pièces de rechange\n-	Assurer le suivi de la politique Qualité\n-	Proposer et suivre les actions de formations produits/techniques du réseau\n-	Suivre les projets de développement du réseau (Points services, Réseau de revendeur\n-	Superviser les monitorings techniques demandés par les constructeurs aux filiales\n\nCOMPETENCES : \n-	Maîtrise parfaite de l\'anglais\n-	Suite Office : Bonne maîtrise d\'Excel impérative\n-	Connaissances Photoshop ou Illustrator\n\nLe poste est basé à Sèvres (92) et peut nécessiter des déplacements ponctuels en France et/ou à l\'étranger.<br /><br />\nDe formation supérieure en Commerce International/Marketing (Ecole de Commerce, BAC+4 / +5), vous maîtrisez les différentes problématiques liées au commerce international.\nForce de proposition, dotée de qualités relationnelles, vos qualités d\'analyse et vos bonnes connaissances informatiques sont vos atouts pour réussir dans notre Groupe à forte vocation internationale.\n\nLa maîtrise de l\'anglais est indispensable.<br />\n<b>Lieu : </b>Sèvres<br />\n<b>Niveau d\'études min. requis : </b>Bac+3<br />\n<b>Langue / Niveau : </b><br />\nAnglais : Courant<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 09 Jul 2018 07:21:31 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=216&idOrigine=502&LCID=1036&offerReference=ADJRMVW092018-216\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:45:\"Achats Ventes Marketing/Resp Marque - Produit\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"Sèvres\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"ADJRMVW092018-216 - Adjoint(e) Responsable de Marque H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2174:\"<b>Métier : </b>Achats Ventes Marketing/Resp Marque - Produit<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre division Automotive, Equipment & Services, un(e) Adjoint(e) Responsable de Marques, il/elle sera chargé(e) de garantir la rentabilité et le développement de la marque Volkswagen. Vous serez rattaché(e) au Responsable de Marques et vous aurez pour principales missions : \n\nMARKETING STRATEGIQUE & ETUDES DE MARCHES\n-	Participer à l\'élaboration de l\'analyse marché et recommandations\n-	Assurer le suivi et la négociation quotidienne avec les fournisseurs\n\nMARKETING OPERATIONNEL & ANIMATION RESEAU \n-	Participer à l\'élaboration et à l\'animation des plans marketing des filiales \n-	Négocier les budgets promotionnels\n-	Etre un référent pour nos filiales en assurant la fiabilité des informations constructeurs \n-	Assurer le suivi des ratios du ou des stocks centraux\n-	Organiser la mise à disposition des supports de communication : (Relations fournisseurs PLV et agences de communication)\n-	Aider à l\'élaboration des best practices et mémos marque pour les filiales\n\nRELATIONS FOURNISSEURS\n-	Assurer la communication entre le constructeur et le Groupe\n-	Participer à la préparation des réunions fournisseurs\n\nCOMPETENCES : \n-	Maîtrise parfaite de l\'anglais\n-	Suite Office : Bonne maîtrise d\'Excel impérative\n-	Bonne connaissance des outils Photoshop et Illustrator\n\nDes déplacements ponctuels au sein des filiales du groupe sont à prévoir.<br /><br />\nDe formation supérieure en Marketing / Commerce International (Ecole de Commerce, BAC+4 / +5), vous maîtrisez les différentes problématiques liées au commerce international et avez acquis une première expérience tournée vers l\'international, idéalement dans le secteur du deux roues ou automobile.\n\nVotre esprit d\'analyse, votre goût pour le travail en équipe ainsi que vos capacités à animer votre périmètre seront autant d\'atout pour vous accompagner dans la conduite de votre activité.\n\nLa maîtrise de l\'anglais est indispensable.<br />\n<b>Lieu : </b>Sèvres<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Tue, 03 Jul 2018 13:21:04 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=214&idOrigine=502&LCID=1036&offerReference=2018-214\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:36:\"RH-COM-RSE/Paie - Admin du personnel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"CDI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"Sèvres (92)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"2018-214 - Compensation &amp; Benefits Specialist H/F \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1708:\"<b>Métier : </b>RH-COM-RSE/Paie - Admin du personnel<br />\n<b>Contrat : </b>CDI<br />\n<b>Description du poste : </b><br />\nDans le cadre d\'un remplacement suite à une mobilité interne, la Direction des Ressources Humaines du Groupe CFAO recherche son Compensation & Benefits Specialist. Rattaché(e) au Responsable Compensation & Benefits, vous accompagnerez l\'équipe dans la mise en œuvre de la politique Comp&Ben du Groupe sur un périmètre France et International. Vous serez plus particulièrement en charge des missions suivantes :\n\n•	Suivi et pilotage mensuel de la masse salariale, \n•	Participation active au process budgétaire (estimation, hypothèses, analyse des écarts),\n•	Participation à la revue annuelle des salaires et bonus pour la population France et Expatriés,\n•	Gestion de la politique de véhicules de fonction du Siège,\n•	Participation aux enquêtes de rémunération\n\nCes missions évolueront et seront enrichies à mesure de votre autonomie.<br /><br />\nDe formation Bac+4/5 type école de commerce ou contrôle de gestion sociale, vous justifiez d\'une première expérience (type alternance) en Compensation & Benefits et/ou Contrôle de gestion sociale dans un contexte international.\nVous avez une excellente maîtrise des outils informatiques (Excel en particulier), et un goût prononcé pour les chiffres. Vous êtes reconnu(e) pour votre esprit d\'analyse et de synthèse. \nVous êtes organisé, rigoureux, dynamique. Vous parlez anglais couramment, étant en communication directe avec vos interlocuteurs japonais et expatriés. \nLocalisation du poste : Sèvres (92)<br />\n<b>Lieu : </b>Sèvres (92)<br />\n<b>Niveau d\'études min. requis : </b>Bac+4<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 04 Jun 2018 09:14:44 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:47:\"\n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=212&idOrigine=502&LCID=1036&offerReference=2018-212\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:46:\"Achats Ventes Marketing/Dir Achats - Marketing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"VIE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"2018-212 - CATEGORY MANAGER COSMETIQUE &amp; HYGIENE Côte d&#039;Ivoire H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3831:\"<b>Métier : </b>Achats Ventes Marketing/Dir Achats - Marketing<br />\n<b>Contrat : </b>VIE<br />\n<b>Description du poste : </b><br />\nVous intégrez le pôle Commercial & Marketing de notre division ivoirienne spécialisée dans la production et distribution de produits de grande consommation sur différentes catégories.\nVous assurez un rôle transverse entre les équipes locales (Directeur Commercial & Marketing, Responsable des Ventes, Responsable Export, Supply Chain Manager, …), et les équipes Marketing & Développement au siège. \nLe candidat ou la candidate : \n(1)	Sera le/la garant(e) de la coordination locale et de la mise en œuvre des plans d\'actions promotionnels sur les catégories Cosmétique & Hygiène, pour nos marques propres et les marques de nos partenaires internationaux.\n(2)	Devra participer activement à la coordination et analyse marché pour le besoin des projets de développement menés par le siège sur le territoire pour les catégories Cosmétique et Hygiène. deux pôles Hygiène & Care \n\nPour cela vous: \n-	Analysez et réalisez la veille marché sur les familles de produits afin de suivre la stratégie de gamme adoptée et en identifier les évolutions ;\n-	Réalisez les revues de performance de marques pour les équipes siège, ainsi que les partenaires ;\n-	Déployez le plan d\'activation annuel pour chaque marque et en assurer la consistance et la réalisation dans le cadre défini ;\n-	Participez activement à la mise en avant et à l\'analyse des offres et des supports développés dans le cadre de mises en marché ou d\'opérations promotionnelles;\n-	Coordonnez et pilotez la production des outils et la mise en place opérationnelle des opérations d\'animation des points de vente;\n-	Suivez les budgets liés à chaque opération et en assurez un reporting régulier au équipes siège et partenaire ;\n-	Assurez le lien et la négociation avec les prestataires spécialisés (Agences de communication, graphistes, imprimeurs) pour développement d\'outils spécifiques ;\n-	Participez aux recommandations des stratégies de développement des gammes ;\n-	Participez à la définition des plans d\'activations annuels par marque/famille de produits ;\n-	Assurez un reporting mensuel des résultats & KPIs aux équipes sièges, terrain et partenaire ;\n-	Assurez la communication et la formation des produits auprès de la force commerciale.\n-	Participez au bon développement des stratégies d\'innovation & de rénovation des gammes de produits des marques propres en support du Responsable Marketing & Développement.\n-	Coordonnez l\'exécution et la mise en place du portefeuille de produits et des recommandations d\'assortiments par circuit ;\n-	Etes le relai des équipes siège sur l\'analyse et collecte d\'information pour les besoins d\'évaluation des projets de développement (relevé de prix, analyse concurrentielle, mise en place de panels de tests…).<br /><br />\nDe formation supérieure de type Bac+5 Ecole de Commerce, vous justifiez d\'une première expérience professionnelle ou d\'un stage d\'au moins 6 mois dans une fonction similaire en marketing opérationnel ou en category management dans l\'univers des produits de grande consommation. \nVous êtes une personne rigoureuse, organisée, dotée d\'un excellent relationnel, force de proposition et d\'initiatives afin d\'accompagner l\'évolution des compétences locales.\nVous êtes à l\'aise au sein d\'une organisation matricielle et avez la volonté de vous confronter à des sujets très opérationnels.\nVous avez d\'excellentes qualités analytiques et capacités rédactionnelles, vous êtes à l\'aise avec les chiffres et les environnements multiculturels.\n\nUne parfaite maitrise du Pack Office et de l\'anglais sont indispensables à la tenue du poste.<br />\n<b>Niveau d\'études min. requis : </b>Bac+5<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Tue, 29 May 2018 16:21:23 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:54:\"\n      \n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=195&idOrigine=502&LCID=1036&offerReference=2017-195\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:52:\"Direction Générale/Adjoint de Direction Générale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Stage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"Sèvres (92)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"2017-195 - Analyste Fusion &amp; Acquisition H/F\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1654:\"<b>Métier : </b>Direction Générale/Adjoint de Direction Générale<br />\n<b>Contrat : </b>Stage<br />\n<b>Description du poste : </b><br />\nLe département Développement et Planning Stratégique de CFAO recherche un(e) Stagiaire en Fusion & Acquisition pour une mission de 6 mois. Ce poste est basé à Sèvres (92). \n Vous assisterez le Directeur du Développement et du Planning Stratégique dans ses missions quotidiennes telles que : \n\n- La préparation et l\'exécution de transactions M&A\n- Le support aux projets de développement internes au groupe sur toutes les Business Units\n- La réalisation de présentations à destination du top management et du Conseil d\'Administration (plan stratégique moyen terme, étude d\'opportunités d\'investissement, point d\'avancement sur les transactions en cours, etc.) <br /><br />\nDe profil BAC+5, vous êtes étudiant d\'une grande école de commerce, école d\'ingénieur ou équivalent universitaire et recherchez un stage de fin d\'étude ou de césure d\'une durée de 6 mois ou plus. \n\n- Vous avez une première expérience de stage en banque d\'affaires, fonds de private equity ou en cabinet de conseil.\n\n- Vous faites preuve d\'une excellente capacité analytique et d\'une bonne aptitude de communication. Vous êtes rigoureux(se), proactif(ve) et avez une parfaite maitrise d\'Excel et de Powerpoint.\n\n- Vous parlez et écrivez couramment Anglais.\n\nVous êtes disponible à partir de septembre / octobre 2018.\n\nGratification attractive + Remboursement 50 % frais de transport + accès au restaurant d\'entreprise<br />\n<b>Lieu : </b>Sèvres (92)<br />\n<b>Niveau d\'études min. requis : </b>Bac+5<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Thu, 24 May 2018 08:08:08 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:47:\"\n      \n      \n      \n      \n      \n      \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=210&idOrigine=502&LCID=1036&offerReference=2018-210\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:30:\"Technique & Services/QSE - HSE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:3:\"VIE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"2018-210 - Animateur Performance / Excellence Opérationnelle H/F - RCI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2259:\"<b>Métier : </b>Technique & Services/QSE - HSE<br />\n<b>Contrat : </b>VIE<br />\n<b>Description du poste : </b><br />\nNous recherchons pour notre Direction des Opérations, un (e) Animateur (trice) performance opérationnelle Kaizen (Programme d\'amélioration continue) à compter du 1er juillet 2018. Rattaché(e) au Responsable KAIZEN au siège, et accompagné par les Directeurs de BU et de chaque Directeur Général de filiale, vous aurez pour principales missions: \n\nDEFINITION MISE EN PLACE DE LA DEMARCHE DE DEPLOIEMENT DE L\'EXCELLENCE OPERATIONNELLE / KAIZEN\n- Informer/former les Managers et leur équipe dans nos filiales sur la méthode et les outils KAIZEN,\n- Coordonner l\'ensemble des initiatives de progrès (plans d\'actions) sur les sites de votre zone de couverture en conformité avec cette démarche,\n\nGESTION DE PROJETS\n- Accompagner les managers et les équipes de nos filiales :\n* dans la mise en œuvre des actions l\'amélioration continue de leur management visuel de la performance,\n* dans le déploiement des outils KAIZEN /Lean,\n* dans l\'animation de workshops visant à développer l\'état d\'esprit d\'Amélioration Continue au plus près du terrain.\n- Aider à l\'élaboration des best practices et des mémos dans les filiales\n- Dispenser les formations nécessaires et assurer la montée en compétences des équipes dans la maîtrise des méthodes et outils d\'amélioration continue identifiés (KPI management, 5S, SMED, DMAIC, TPM, VSM...),\n\nSUIVI DES CHANTIERS KAIZEN \n- S\'assurer de la pérennité des actions, \n- Analyser les gains associés, en réalisant le suivi PDCA des groupes de travail. \n- Veiller au bon fonctionnement de l\'outil de pilotage des actions de progrès du site, et établir le reporting mensuel de performance pour chaque site.<br /><br />\nEtudiant en formation supérieure (BAC+4 / +5) type école d\'ingénieur ou école supérieure, vous avez acquis une première expérience en stages/césure tournée vers l\'international, idéalement en ayant utilisé des outils et méthodologies d\'amélioration continue, de gestion de projets et de résolution de problèmes.\nVous disposez également de solides connaissances techniques et en logistique.<br />\n<b>Niveau d\'études min. requis : </b>Bac+5<br />\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Mon, 07 May 2018 14:46:29 Z\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:13:\"cache-control\";s:20:\"public, max-age=3600\";s:12:\"content-type\";s:23:\"text/xml; charset=utf-8\";s:7:\"expires\";s:29:\"Tue, 27 Nov 2018 11:17:30 GMT\";s:4:\"vary\";s:21:\"Host, Accept-Encoding\";s:3:\"p3p\";s:14:\"CP=CAO PSA OUR\";s:4:\"date\";s:29:\"Tue, 27 Nov 2018 10:17:30 GMT\";s:14:\"content-length\";s:5:\"14442\";s:10:\"set-cookie\";s:111:\"BIGipServerREC_PRD_FO=!M5IXPRYmNfxNUvsQ6XT6Z3Y8rrTt6kG2gh9vQxFRlqtKP6WXIzYTUfxHNqw4mM+D9xAGK+O3WWhP72s=; path=/\";s:16:\"content-encoding\";s:4:\"gzip\";}}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO `jmkn_options` VALUES("898", "_transient_timeout_feed_mod_4ca4784d0ae2dc857425d213e86e0f71", "1543357049", "no");
INSERT INTO `jmkn_options` VALUES("899", "_transient_feed_mod_4ca4784d0ae2dc857425d213e86e0f71", "1543313849", "no");
INSERT INTO `jmkn_options` VALUES("921", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1543337993;s:7:\"checked\";a:19:{s:19:\"akismet/akismet.php\";s:3:\"4.1\";s:27:\"autoptimize/autoptimize.php\";s:5:\"2.4.2\";s:33:\"classic-editor/classic-editor.php\";s:3:\"0.5\";s:13:\"cmb2/init.php\";s:5:\"2.4.2\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.0.5\";s:25:\"duplicator/duplicator.php\";s:6:\"1.2.52\";s:9:\"hello.php\";s:3:\"1.7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:5:\"4.2.5\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:5:\"2.5.1\";s:39:\"siteorigin-panels/siteorigin-panels.php\";s:5:\"2.9.2\";s:53:\"re-add-underline-justify/re-add-underline-justify.php\";s:3:\"0.2\";s:49:\"read-more-excerpt-link/read-more-excerpt-link.php\";s:3:\"1.4\";s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";s:5:\"3.0.2\";s:23:\"sayidan-plugin/init.php\";s:5:\"1.6.2\";s:59:\"simple-scroll-to-top-button/simple-scroll-to-top-button.php\";s:4:\"4.25\";s:39:\"so-widgets-bundle/so-widgets-bundle.php\";s:6:\"1.13.3\";s:37:\"super-socializer/super_socializer.php\";s:6:\"7.12.4\";s:35:\"ultimate-member/ultimate-member.php\";s:6:\"2.0.33\";s:59:\"wp-filter-combine-rss-feeds/wp-filter-combine-rss-feeds.php\";s:5:\"0.3.3\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:18:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"4.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.4.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:27:\"autoptimize/autoptimize.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/autoptimize\";s:4:\"slug\";s:11:\"autoptimize\";s:6:\"plugin\";s:27:\"autoptimize/autoptimize.php\";s:11:\"new_version\";s:5:\"2.4.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/autoptimize/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/autoptimize.2.4.2.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:64:\"https://ps.w.org/autoptimize/assets/icon-128x128.png?rev=1864142\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/autoptimize/assets/banner-772x250.jpg?rev=1315920\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:3:\"0.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/classic-editor.0.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1750045\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1750045\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1750404\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1751803\";}s:11:\"banners_rtl\";a:0:{}}s:13:\"cmb2/init.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:18:\"w.org/plugins/cmb2\";s:4:\"slug\";s:4:\"cmb2\";s:6:\"plugin\";s:13:\"cmb2/init.php\";s:11:\"new_version\";s:5:\"2.4.2\";s:3:\"url\";s:35:\"https://wordpress.org/plugins/cmb2/\";s:7:\"package\";s:47:\"https://downloads.wordpress.org/plugin/cmb2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:57:\"https://ps.w.org/cmb2/assets/icon-256x256.png?rev=1081087\";s:2:\"1x\";s:57:\"https://ps.w.org/cmb2/assets/icon-128x128.png?rev=1081087\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/cmb2/assets/banner-1544x500.png?rev=1081087\";s:2:\"1x\";s:59:\"https://ps.w.org/cmb2/assets/banner-772x250.png?rev=1081087\";}s:11:\"banners_rtl\";a:0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.0.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";s:2:\"1x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.2.52\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.2.52.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}}s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:30:\"w.org/plugins/mailchimp-for-wp\";s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:6:\"plugin\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:11:\"new_version\";s:5:\"4.2.5\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/mailchimp-for-wp/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/mailchimp-for-wp.4.2.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/mailchimp-for-wp/assets/icon-256x256.png?rev=1224577\";s:2:\"1x\";s:69:\"https://ps.w.org/mailchimp-for-wp/assets/icon-128x128.png?rev=1224577\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/mailchimp-for-wp/assets/banner-772x250.png?rev=1184706\";}s:11:\"banners_rtl\";a:0:{}}s:47:\"one-click-demo-import/one-click-demo-import.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:35:\"w.org/plugins/one-click-demo-import\";s:4:\"slug\";s:21:\"one-click-demo-import\";s:6:\"plugin\";s:47:\"one-click-demo-import/one-click-demo-import.php\";s:11:\"new_version\";s:5:\"2.5.1\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/one-click-demo-import/\";s:7:\"package\";s:70:\"https://downloads.wordpress.org/plugin/one-click-demo-import.2.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-256x256.png?rev=1694310\";s:2:\"1x\";s:74:\"https://ps.w.org/one-click-demo-import/assets/icon-128x128.png?rev=1694310\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/one-click-demo-import/assets/banner-1544x500.png?rev=1694310\";s:2:\"1x\";s:76:\"https://ps.w.org/one-click-demo-import/assets/banner-772x250.png?rev=1694310\";}s:11:\"banners_rtl\";a:0:{}}s:39:\"siteorigin-panels/siteorigin-panels.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:31:\"w.org/plugins/siteorigin-panels\";s:4:\"slug\";s:17:\"siteorigin-panels\";s:6:\"plugin\";s:39:\"siteorigin-panels/siteorigin-panels.php\";s:11:\"new_version\";s:5:\"2.9.2\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/siteorigin-panels/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/siteorigin-panels.2.9.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/siteorigin-panels/assets/icon-256x256.png?rev=1044755\";s:2:\"1x\";s:70:\"https://ps.w.org/siteorigin-panels/assets/icon-128x128.png?rev=1044755\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/siteorigin-panels/assets/banner-772x250.jpg?rev=1044755\";}s:11:\"banners_rtl\";a:0:{}}s:53:\"re-add-underline-justify/re-add-underline-justify.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:38:\"w.org/plugins/re-add-underline-justify\";s:4:\"slug\";s:24:\"re-add-underline-justify\";s:6:\"plugin\";s:53:\"re-add-underline-justify/re-add-underline-justify.php\";s:11:\"new_version\";s:3:\"0.2\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/re-add-underline-justify/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/re-add-underline-justify.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:69:\"https://ps.w.org/re-add-underline-justify/assets/icon.svg?rev=1531779\";s:3:\"svg\";s:69:\"https://ps.w.org/re-add-underline-justify/assets/icon.svg?rev=1531779\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/re-add-underline-justify/assets/banner-1544x500.jpg?rev=1531789\";s:2:\"1x\";s:79:\"https://ps.w.org/re-add-underline-justify/assets/banner-772x250.jpg?rev=1531789\";}s:11:\"banners_rtl\";a:0:{}}s:49:\"read-more-excerpt-link/read-more-excerpt-link.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:36:\"w.org/plugins/read-more-excerpt-link\";s:4:\"slug\";s:22:\"read-more-excerpt-link\";s:6:\"plugin\";s:49:\"read-more-excerpt-link/read-more-excerpt-link.php\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/read-more-excerpt-link/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/read-more-excerpt-link.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:75:\"https://ps.w.org/read-more-excerpt-link/assets/icon-128x128.png?rev=1367673\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:77:\"https://ps.w.org/read-more-excerpt-link/assets/banner-772x250.png?rev=1367719\";}s:11:\"banners_rtl\";a:0:{}}s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:35:\"w.org/plugins/regenerate-thumbnails\";s:4:\"slug\";s:21:\"regenerate-thumbnails\";s:6:\"plugin\";s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";s:11:\"new_version\";s:5:\"3.0.2\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/regenerate-thumbnails/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/regenerate-thumbnails.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:74:\"https://ps.w.org/regenerate-thumbnails/assets/icon-128x128.png?rev=1753390\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/regenerate-thumbnails/assets/banner-1544x500.jpg?rev=1753390\";s:2:\"1x\";s:76:\"https://ps.w.org/regenerate-thumbnails/assets/banner-772x250.jpg?rev=1753390\";}s:11:\"banners_rtl\";a:0:{}}s:59:\"simple-scroll-to-top-button/simple-scroll-to-top-button.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:41:\"w.org/plugins/simple-scroll-to-top-button\";s:4:\"slug\";s:27:\"simple-scroll-to-top-button\";s:6:\"plugin\";s:59:\"simple-scroll-to-top-button/simple-scroll-to-top-button.php\";s:11:\"new_version\";s:4:\"4.25\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/simple-scroll-to-top-button/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/simple-scroll-to-top-button.4.25.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/simple-scroll-to-top-button/assets/icon-256x256.png?rev=1472436\";s:2:\"1x\";s:80:\"https://ps.w.org/simple-scroll-to-top-button/assets/icon-128x128.png?rev=1472436\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/simple-scroll-to-top-button/assets/banner-1544x500.png?rev=1908656\";s:2:\"1x\";s:82:\"https://ps.w.org/simple-scroll-to-top-button/assets/banner-772x250.png?rev=1908479\";}s:11:\"banners_rtl\";a:0:{}}s:39:\"so-widgets-bundle/so-widgets-bundle.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:31:\"w.org/plugins/so-widgets-bundle\";s:4:\"slug\";s:17:\"so-widgets-bundle\";s:6:\"plugin\";s:39:\"so-widgets-bundle/so-widgets-bundle.php\";s:11:\"new_version\";s:6:\"1.13.3\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/so-widgets-bundle/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/so-widgets-bundle.1.13.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/so-widgets-bundle/assets/icon-256x256.png?rev=1044942\";s:2:\"1x\";s:70:\"https://ps.w.org/so-widgets-bundle/assets/icon-128x128.png?rev=1044942\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/so-widgets-bundle/assets/banner-772x250.jpg?rev=1044942\";}s:11:\"banners_rtl\";a:0:{}}s:37:\"super-socializer/super_socializer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:30:\"w.org/plugins/super-socializer\";s:4:\"slug\";s:16:\"super-socializer\";s:6:\"plugin\";s:37:\"super-socializer/super_socializer.php\";s:11:\"new_version\";s:6:\"7.12.4\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/super-socializer/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/super-socializer.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/super-socializer/assets/icon-128x128.png?rev=1866723\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/super-socializer/assets/banner-772x250.png?rev=1866718\";}s:11:\"banners_rtl\";a:0:{}}s:35:\"ultimate-member/ultimate-member.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:29:\"w.org/plugins/ultimate-member\";s:4:\"slug\";s:15:\"ultimate-member\";s:6:\"plugin\";s:35:\"ultimate-member/ultimate-member.php\";s:11:\"new_version\";s:6:\"2.0.33\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/ultimate-member/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/ultimate-member.2.0.33.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/ultimate-member/assets/icon-256x256.png?rev=1667029\";s:2:\"1x\";s:68:\"https://ps.w.org/ultimate-member/assets/icon-128x128.png?rev=1667029\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/ultimate-member/assets/banner-1544x500.png?rev=1667029\";s:2:\"1x\";s:70:\"https://ps.w.org/ultimate-member/assets/banner-772x250.png?rev=1667029\";}s:11:\"banners_rtl\";a:0:{}}s:59:\"wp-filter-combine-rss-feeds/wp-filter-combine-rss-feeds.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:41:\"w.org/plugins/wp-filter-combine-rss-feeds\";s:4:\"slug\";s:27:\"wp-filter-combine-rss-feeds\";s:6:\"plugin\";s:59:\"wp-filter-combine-rss-feeds/wp-filter-combine-rss-feeds.php\";s:11:\"new_version\";s:5:\"0.3.3\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/wp-filter-combine-rss-feeds/\";s:7:\"package\";s:76:\"https://downloads.wordpress.org/plugin/wp-filter-combine-rss-feeds.0.3.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/wp-filter-combine-rss-feeds/assets/icon-256x256.png?rev=1802348\";s:2:\"1x\";s:80:\"https://ps.w.org/wp-filter-combine-rss-feeds/assets/icon-256x256.png?rev=1802348\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO `jmkn_options` VALUES("930", "_transient_timeout_feed_2dd0202377a060f0df35cceaacc2c13c", "1543357608", "no");
INSERT INTO `jmkn_options` VALUES("931", "_transient_feed_2dd0202377a060f0df35cceaacc2c13c", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://siteorigin.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Free WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Nov 2018 07:27:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=4.9.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Create a Custom 404 Page with Page Builder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://siteorigin.com/create-a-custom-404-page-with-page-builder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://siteorigin.com/create-a-custom-404-page-with-page-builder/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Nov 2018 15:43:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=136650\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:593:\"<p>If a page on your website no longer exists or if a link is incorrect, your users will see your 404 page. By default, your theme controls the content on your 404 page. Using <a href=\"https://wordpress.org/plugins/404page/\">404page plugin</a> and Page Builder by SiteOrigin, creating a custom 404 page is much quicker and easier than you might think.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/create-a-custom-404-page-with-page-builder/\">Create a Custom 404 Page with Page Builder</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6121:\"<p>If a page on your website no longer exists or if a link is incorrect, your users will see your 404 page. 404 Not Found is an HTTP response status code that means <em>the requested resource could not be found but may be available in the future. Subsequent requests by the client are permissible.</em> Ref: <a href=\"https://en.wikipedia.org/wiki/List_of_HTTP_status_codes\">Wikipedia</a>. </p>\n<p>By default, your theme controls the content on your 404 page. Using <a href=\"https://wordpress.org/plugins/404page/\">404page plugin</a> and Page Builder by SiteOrigin, creating a custom 404 page is much quicker and easier than you might think. Adding useful links, a search form and perhaps even a contact form is a great way to engage your users and hopefully help them find the content they were looking for.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/page-not-found/\">View the demo</a>.<br />\n<a href=\"https://siteorigin.com/wp-content/uploads/2018/11/404.json\">Download the demo JSON layout</a> (Right click and Save As).</p>\n<h3>Required Plugins</h3>\n<p><a href=\"https://wordpress.org/plugins/404page/\">404page – your smart custom 404 error page</a><br />\n<a href=\"https://wordpress.org/plugins/siteorigin-panels/\">Page Builder by SiteOrigin</a><br />\n<a href=\"https://wordpress.org/plugins/so-widgets-bundle/\">SiteOrigin Widgets Bundle</a></p>\n<p>Once Page Builder and the Widgets Bundle plugins are activated, go to <span class=\"adminized-section\"><span class=\"adminized-part\">Plugins</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">SiteOrigin Widgets</span></span> to activate the widgets you&#8217;d like to make use of. Not all of the widgets are activated by default.</p>\n<h3>Assigning a Custom 404 Page</h3>\n<p>Go to <span class=\"adminized-section\"><span class=\"adminized-part\">Pages</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Add New</span></span> to create your custom 404 page if you haven&#8217;t done so already. Next, with 404page plugin activated, go to <span class=\"adminized-section\"><span class=\"adminized-part\">Apppearance</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">404 Error Page</span></span>. Use the <span class=\"adminized-section\"><span class=\"adminized-part\">General: Page to be displayed as 404 page</span></span> setting to choose the page to be used as your custom 404 page.</p>\n<div id=\"attachment_137526\" style=\"width: 1674px\" class=\"wp-caption alignnone\"><img src=\"https://siteorigin.com/wp-content/uploads/2018/11/select-page.jpg\" alt=\"\" width=\"1664\" height=\"1566\" class=\"size-full wp-image-137526\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/11/select-page.jpg 1664w, https://siteorigin.com/wp-content/uploads/2018/11/select-page-300x282.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/11/select-page-768x723.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/11/select-page-699x658.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/11/select-page-1050x988.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/11/select-page-313x295.jpg 313w\" sizes=\"(max-width: 1664px) 100vw, 1664px\" /></p>\n<p class=\"wp-caption-text\">Use the drop-down menu provided to choose your page. Your page can be named anything, we chose 404 for ours but that isn&#8217;t necessary.</p>\n</div>\n<h3>Editing Your Custom 404 Page</h3>\n<p>Go to Pages and edit the page you&#8217;ve chosen to be your custom 404 page. Click on the Page Builder tab to edit your page using Page Builder by SiteOrigin. If you&#8217;d like to start with our demo page, <a href=\"https://siteorigin.com/wp-content/uploads/2018/11/404.json\">download the demo JSON layout</a> (Right click and Save As). Click <span class=\"adminized-section\"><span class=\"adminized-part\">Layouts</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Import/Export</span></span> to import the layout.</p>\n<div id=\"attachment_137527\" style=\"width: 2370px\" class=\"wp-caption alignnone\"><img src=\"https://siteorigin.com/wp-content/uploads/2018/11/custom-404-error-page-builder.jpg\" alt=\"\" width=\"2360\" height=\"1086\" class=\"size-full wp-image-137527\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/11/custom-404-error-page-builder.jpg 2360w, https://siteorigin.com/wp-content/uploads/2018/11/custom-404-error-page-builder-300x138.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/11/custom-404-error-page-builder-768x353.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/11/custom-404-error-page-builder-699x322.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/11/custom-404-error-page-builder-1050x483.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/11/custom-404-error-page-builder-313x144.jpg 313w\" sizes=\"(max-width: 2360px) 100vw, 2360px\" /></p>\n<p class=\"wp-caption-text\">Our custom 404 error page build in Page Builder.</p>\n</div>\n<p>Finally, test your 404 page by going to a URL you know doesn&#8217;t exist. For example <a href=\"http://demo.siteorigin.com/corp/nopagehere\">http://demo.siteorigin.com/corp/nopagehere</a>. You can also go to <span class=\"adminized-section\"><span class=\"adminized-part\">Appearance</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">404 Error Page</span></span> and click the <span class=\"adminized-section\"><span class=\"adminized-part\">Test 404 error</span></span> button.</p>\n<h3>Additional Features and a Helping Hand with SiteOrigin Premium</h3>\n<p><a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a> is a plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. SiteOrigin Premium also includes our next level email support service. If you need expert advice and quick replies, consider SiteOrigin Premium.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/create-a-custom-404-page-with-page-builder/\">Create a Custom 404 Page with Page Builder</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://siteorigin.com/create-a-custom-404-page-with-page-builder/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Create a Team Page with the SiteOrigin Features Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Oct 2018 10:05:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=133084\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:494:\"<p>In this tutorial, we\'ll create a simple and engaging \"Meet the Team\" page using Page Builder by SiteOrigin and the SiteOrigin Headline and Features Widget. Read the complete tutorial or jump ahead and use the prebuilt layout.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/\">Create a Team Page with the SiteOrigin Features Widget</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11896:\"<p>In this tutorial, we&#8217;ll create a simple and engaging &#8220;Meet the Team&#8221; page using Page Builder by SiteOrigin and the SiteOrigin Widget Bundle.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/meet-the-team/\">View the demo</a><br />\n<a href=\"#prebuilt\">Jump to the prebuilt layout</a></p>\n<h3>Required Plugins</h3>\n<p><a href=\"https://wordpress.org/plugins/siteorigin-panels/\">Page Builder by SiteOrigin</a><br />\n<a href=\"https://wordpress.org/plugins/so-widgets-bundle/\">SiteOrigin Widgets Bundle</a></p>\n<p>Once Page Builder and the Widgets Bundle plugins are activated, go to <span class=\"adminized-section\"><span class=\"adminized-part\">Plugins</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">SiteOrigin Widgets</span></span> and make sure that the <strong>Headline</strong> and <strong>Features</strong> widgets are activated.</p>\n<h3>Getting Started</h3>\n<p>Go to Pages and edit the page you&#8217;d like to use as your team page. If you haven&#8217;t created this page yet, go to <span class=\"adminized-section\"><span class=\"adminized-part\">Pages</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Add New</span></span> to get started. Once editing the page, if you&#8217;re using a SiteOrigin theme, scroll to the Page Settings meta box in the right column. For our <a href=\"https://demo.siteorigin.com/corp/meet-the-team/\">demo layout</a> we&#8217;ve set Page Layout to No Sidebar and disabled the Page Title. Adjusting page settings is optional, you&#8217;re free to set up your page as best suits your site design.</p>\n<p>If you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click the Add Row button and add a single column row to your page. Repeat the process to add a second row.</p>\n<h3>Adding the Widgets</h3>\n<p><img class=\"alignnone wp-image-135011\" src=\"https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-699x382.jpg\" alt=\"\" width=\"400\" height=\"219\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-699x382.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-300x164.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-768x420.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets-313x171.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/adding-siteorigin-widgets.jpg 927w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></p>\n<p>We&#8217;ve started our demo layout off with a Headline widget. To add a Headline widget, click in the first row you&#8217;ve created then click Add Widget. Once the Add Widget modal window appears, use the search field on the left to search for &#8220;headline&#8221;. Click the SiteOrigin Headline widget to insert it into the first row.</p>\n<p>In the second row, we&#8217;ll be inserting the SiteOrigin Features widget. Click the second row to select it, then Add Widget. Use the search field to search for &#8220;features&#8221;. Click the SiteOrigin Features widget to insert it.</p>\n<h3>Adding the Content</h3>\n<h4>SiteOrigin Headline Widget</h4>\n<p><img class=\"alignnone wp-image-135017\" src=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-238x300.jpg\" alt=\"\" width=\"400\" height=\"504\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-238x300.jpg 238w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-555x699.jpg 555w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget-313x394.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-headline-widget.jpg 734w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></p>\n<p>We&#8217;ll start out by editing the Headline widget and then move onto the Features widget. To edit the Headline widget, hover over it and click the Edit link. We&#8217;ve used the following settings:</p>\n<p><strong>Headline:</strong><br />\nText: Meet the Team<br />\nHTML Tag: H1<br />\nFont: Use theme font<br />\nFont Size: 32px<br />\nAlignment: Center</p>\n<p><strong>Subheadline:</strong><br />\nText: Lorem ipsum dolor sit amet, consectetur adipiscing elit. (This is placeholder text, replace it with a sub-headline that fits your team page)<br />\nHTML Tag: H2<br />\nFont: Use theme font<br />\nFont Size: 23px<br />\nAlignment: Center</p>\n<p><strong>Divider</strong><br />\nStyle: Solid<br />\nColor: #EEEEEE<br />\nThickness: 1<br />\nAlignment: Center<br />\nDivider Width: 80%</p>\n<p>Use FitText: Enabled<br />\nFitText Compressor Strength: 0,85</p>\n<p>The Headline widget isn&#8217;t necessary, you could also use the regular page title, it&#8217;s up to you.</p>\n<h4>SiteOrigin Features Widget</h4>\n<p><img class=\"alignnone wp-image-135026 size-large\" src=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-699x378.jpg\" alt=\"\" width=\"699\" height=\"378\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-699x378.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-300x162.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-768x415.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-1050x568.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members-313x169.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-features-widget-team-members.jpg 1345w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></p>\n<p>Next, we&#8217;ll add our team members using the Features widget. Hover over the widget and click Edit to get started.</p>\n<p>Before adding team members, let&#8217;s take a look at the general settings used in our demo.</p>\n<p><strong>Font Design</strong><br />\nAll settings were left at default values.</p>\n<p><strong>Other Settings</strong><br />\nContainer shape: None<br />\nContainer size: 150px<br />\nIcon Size: We&#8217;ve cleared this field and left it blank<br />\nFeatures per row: 3<br />\nResponsive layout: Enabled<br />\nLink feature title to more URL: Disabled<br />\nLink icon to more URL: Disabled<br />\nOpen more URL in new window: Disabled</p>\n<p>You&#8217;re now ready to add your team. Click the Add link in the Features section to add your first team member. Each feature can be opened, duplicated or deleted using the icons on the right. Features can also be dragged to re-order. The settings we&#8217;ve used in each feature are as follows:</p>\n<p>Container position: Top<br />\nIcon image: Used for the team member&#8217;s photo. Our photos were manually resized to 300px x 300px before uploading to the Media Library.<br />\nIcon image size: Full<br />\nTitle text: Used for the team member&#8217;s name.<br />\nText: Used for the team member description.</p>\n<h3>Rounding the Profile Images Using Custom CSS</h3>\n<p>Our team profile images are square. We&#8217;ve used Custom CSS to transform them into round images. Custom CSS can be added to our useful <a href=\"https://wordpress.org/plugins/so-css/\">SiteOrigin CSS plugin</a>. To round your profile images, follow these steps:</p>\n<p>1. Edit the row containing the SiteOrigin Features widget and open the Attributes section in the right column. Insert the following class name into the Row Class field:</p>\n<pre class=\"prettyprint \">meet-the-team</pre>\n<p>If you&#8217;re using the prebuilt layout provided later in this tutorial, this step isn&#8217;t necessary as the class name will already be added to the row containing the SiteOrigin Features widget.</p>\n<p><img class=\"alignnone wp-image-135022 size-medium\" src=\"https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-298x300.jpg\" alt=\"\" width=\"298\" height=\"300\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-298x300.jpg 298w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-150x150.jpg 150w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-313x315.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name-128x128.jpg 128w, https://siteorigin.com/wp-content/uploads/2018/10/page-builder-row-class-name.jpg 518w\" sizes=\"(max-width: 298px) 100vw, 298px\" /></p>\n<p>2. Go to <span class=\"adminized-section\"><span class=\"adminized-part\">Appearance</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Custom CSS</span></span> if you&#8217;re using SiteOrigin CSS plugin and insert the following rule:</p>\n<pre class=\"prettyprint \">.meet-the-team .sow-features-feature .sow-icon-image {\r\nborder-radius: 50%;\r\n}</pre>\n<p><strong>This step is necessary even if you&#8217;re using the prebuilt layout.</strong></p>\n<p><img class=\"alignnone wp-image-135019\" src=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-300x122.jpg\" alt=\"\" width=\"400\" height=\"163\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-300x122.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-768x313.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-699x285.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule-313x127.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-css-rounding-rule.jpg 975w\" sizes=\"(max-width: 400px) 100vw, 400px\" /></p>\n<h3>Additional Features and a Helping Hand with SiteOrigin Premium</h3>\n<p><a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a> is a plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. SiteOrigin Premium also includes our next level email support service. If you need expert advice and quick replies, consider SiteOrigin Premium.</p>\n<h3 id=\"prebuilt\">Using the Demo Layout</h3>\n<p><a href=\"https://demo.siteorigin.com/corp/meet-the-team/\">View the Demo</a>.<br />\n<a href=\"https://siteorigin.com/wp-content/uploads/2018/10/meet-the-team.json\">Download the demo layout (JSON file)</a>.</p>\n<p>If you&#8217;d like to make use of the demo layout, follow these steps:</p>\n<p>1. Download the above JSON file to your desktop.<br />\n2. Go to the page you&#8217;d like to use, if you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click <span class=\"adminized-section\"><span class=\"adminized-part\">Layouts</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Import/Export</span></span>.<br />\n3. Upload the layout file either by dragging and dropping or selecting it using the select button.<br />\n4. Click the Insert button bottom right.<br />\n5. To round your team images, add the following to <span class=\"adminized-section\"><span class=\"adminized-part\">Appearance</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Custom CSS</span></span>:</p>\n<pre class=\"prettyprint \">.meet-the-team .sow-features-feature .sow-icon-image {\r\nborder-radius: 50%;\r\n}</pre>\n<p>* Unfortunately, the Features widget doesn&#8217;t have the option of using external image URL&#8217;s. This means that the images from the demo layout won&#8217;t be imported.</p>\n<p>If you have any questions or comments, please let us know below, we&#8217;d love to hear from you.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/\">Create a Team Page with the SiteOrigin Features Widget</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://siteorigin.com/create-a-team-page-with-the-siteorigin-features-widget/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Introducing the Toggle Visibility Addon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://siteorigin.com/introducing-the-toggle-visibility-addon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://siteorigin.com/introducing-the-toggle-visibility-addon/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Oct 2018 09:01:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Announcements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=132899\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:485:\"<p>We\'re excited to announce the long-awaited Toggle Visibility addon for <a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a>. Toggle Visibility allows you to hide Page Builder rows and widgets based on the user\'s screen size.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/introducing-the-toggle-visibility-addon/\">Introducing the Toggle Visibility Addon</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3373:\"<p>We&#8217;re excited to announce the long-awaited Toggle Visibility addon for <a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a>. Once activated at <span class=\"adminized-section\"><span class=\"adminized-part\">SiteOrigin</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Premium Addons</span></span> you&#8217;ll see the Toggle Visibility section under Row Styles when editing a row and under Widget Styles when editing a widget. Toggle Visibility allows you to hide Page Builder rows and widgets based on the user&#8217;s screen size. </p>\n<p>The following options are available:</p>\n<p><strong>Hide Row/Widget</strong><br />\nEnabling this option will hide the row or widget on all devices. There are a few possible applications for this setting. Perhaps you have content on a page that you’d only like published at certain times of the year. Or perhaps you’re busy adding a new row to an existing page and don’t want it published just yet.</p>\n<p><strong>Hide on Desktop</strong><br />\nEnabling this option will hide the row or widget on desktop.</p>\n<p><strong>Hide on Tablet</strong><br />\nEnabling this option will hide the row or widget on tablet.</p>\n<p><strong>Hide on Mobile</strong><br />\nEnabling this option will hide the row or widget on mobile.</p>\n<p>By default, Page Builder sets the tablet breakpoint to <code>1024px</code> and the mobile breakpoint to <code>780px</code> These can be easily changed at <span class=\"adminized-section\"><span class=\"adminized-part\">Settings</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Page Builder</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Layout</span></span> using the Tablet Width and Mobile Width fields.</p>\n<p><a href=\"https://siteorigin.com/premium-documentation/plugin-addons/toggle-visibility/\">View the documentation</a>.</p>\n<p>The Toggle Visibility addon is available as part of <a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a>, a single plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. SiteOrigin Premium also includes our next level email support service.</p>\n<p><img src=\"https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon.jpg\" alt=\"\" width=\"2248\" height=\"1094\" class=\"alignnone size-full wp-image-133055\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon.jpg 2248w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-300x146.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-768x374.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-699x340.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-1050x511.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/10/toggle-visibility-addon-313x152.jpg 313w\" sizes=\"(max-width: 2248px) 100vw, 2248px\" /></p>\n<p>If you have any questions, please comment below. We look forward to hearing from you.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/introducing-the-toggle-visibility-addon/\">Introducing the Toggle Visibility Addon</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://siteorigin.com/introducing-the-toggle-visibility-addon/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"SiteOrigin Widgets in Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://siteorigin.com/siteorigin-widgets-in-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://siteorigin.com/siteorigin-widgets-in-gutenberg/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Oct 2018 09:21:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Announcements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=131660\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:512:\"<p>If you\'ve been giving Gutenberg a try, you might have already used the SiteOrigin Layout block which offers a full instance of Page Builder in Gutenberg. We\'re really excited to announce that from version <code>1.13.0</code>, the SiteOrigin Widgets Bundle is now also available as a block.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/siteorigin-widgets-in-gutenberg/\">SiteOrigin Widgets in Gutenberg</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5632:\"<p>Gutenberg will be the new WordPress editor from version 5.0; it&#8217;s currently being tested in plugin form. If you&#8217;ve been giving Gutenberg a try, you might have already used the SiteOrigin Layout block which offers a full instance of Page Builder in Gutenberg. We&#8217;re really excited to announce that from version <code>1.13.0</code>, the SiteOrigin Widgets Bundle is now also available as a block. The new Widgets Bundle block allows you to directly add SiteOrigin widgets to your Gutenberg pages.</p>\n<p><strong>Please, keep in mind that Gutenberg is in beta, we don&#8217;t recommend testing on production (live) sites.</strong></p>\n<h3>A Quick Recap: Adding a SiteOrigin Layout</h3>\n<p>If you&#8217;re testing Gutenberg and haven&#8217;t yet tried the SiteOrigin Layout block, it&#8217;s easy to add. On a Gutenberg page, click the plus icon and search for <em>siteorigin</em>. Click on the SiteOrigin Layout block to insert. If you&#8217;re browsing the available blocks, you&#8217;ll find the SiteOrigin Layout block in the Layout Elements section.</p>\n<div id=\"attachment_131918\" style=\"width: 709px\" class=\"wp-caption aligncenter\"><img class=\"size-large wp-image-131918\" src=\"https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-699x481.png\" alt=\"\" width=\"699\" height=\"481\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-699x481.png 699w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-300x206.png 300w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-768x528.png 768w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block-313x215.png 313w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-block.png 904w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></p>\n<p class=\"wp-caption-text\">Add a SiteOrigin Layout via the add block button.</p>\n</div>\n<p>Once you&#8217;ve used the SiteOrigin Layout block a few times, a shortcut icon will be available on the right.</p>\n<div id=\"attachment_131919\" style=\"width: 1926px\" class=\"wp-caption aligncenter\"><img class=\"wp-image-131919 size-full\" src=\"https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block.png\" alt=\"\" width=\"1916\" height=\"232\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block.png 1916w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-300x36.png 300w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-768x93.png 768w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-699x85.png 699w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-1050x127.png 1050w, https://siteorigin.com/wp-content/uploads/2018/10/add-siteorigin-layout-block-313x38.png 313w\" sizes=\"(max-width: 1916px) 100vw, 1916px\" /></p>\n<p class=\"wp-caption-text\">Once available, you can use the SiteOrigin Layout shortcut icon on the right to add a SiteOrigin Layout block.</p>\n</div>\n<h3>New Functionality: Adding a SiteOrigin Widget Block</h3>\n<p>There might be times when you&#8217;d like to add a SiteOrigin Widget to a Gutenberg page without first adding a SiteOrigin Layout block. To add a SiteOrigin Widget block, click the plus icon and search for <em>siteorigin</em>. Click on the SiteOrigin Widget block to insert. If you&#8217;re browsing the available blocks, you&#8217;ll find the SiteOrigin Widget block in the Widgets section.</p>\n<div id=\"attachment_132008\" style=\"width: 709px\" class=\"wp-caption alignnone\"><img src=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-699x632.jpg\" alt=\"\" width=\"699\" height=\"632\" class=\"size-large wp-image-132008\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-699x632.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-300x271.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-768x694.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-1050x949.jpg 1050w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block-313x283.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/10/siteorigin-widget-block.jpg 1120w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></p>\n<p class=\"wp-caption-text\">Add a SiteOrigin Widget via the add block button.</p>\n</div>\n<h3>Common Questions</h3>\n<p>Once WordPress 5.0 is released, existing Page Builder pages will remain in Page Builder. An option to migrate existing Page Builder pages to Gutenberg will be provided in the future for users that would like to do so. If you&#8217;d prefer to keep your Page Builder interface looking as it looks now (pre WP 5.0) we recommend installing the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor</a> plugin. This is a useful option for a wide range of users.</p>\n<h3>A Helping Hand with SiteOrigin Premium</h3>\n<p><a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a> is a plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. SiteOrigin Premium also includes our next level email support service. If you need expert advice and quick replies, consider SiteOrigin Premium.</p>\n<p>If you have any questions, please comment below. We look forward to hearing from you.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/siteorigin-widgets-in-gutenberg/\">SiteOrigin Widgets in Gutenberg</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://siteorigin.com/siteorigin-widgets-in-gutenberg/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Adding a Form to a Hero Image\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://siteorigin.com/adding-form-hero-image/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://siteorigin.com/adding-form-hero-image/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Sep 2018 12:24:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=126657\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:483:\"<p>Adding a form to your hero image is a great way to turn user attention into action. In this tutorial, we\'ll cover how to use Page Builder by SiteOrigin and the SiteOrigin Widgets Bundle to add a hero image (using the Layout Slider widget) and a contact form to your page.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/adding-form-hero-image/\">Adding a Form to a Hero Image</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11643:\"<p>Adding a form to your hero image is a great way to turn user attention into action. In this tutorial, we&#8217;ll cover how to use Page Builder by SiteOrigin and the SiteOrigin Widgets Bundle to add a hero image (using the Layout Slider widget) and a contact form to your page.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/hero-with-form-right/\">View the demo</a>.</p>\n<h3>Required Plugins</h3>\n<p><a href=\"https://wordpress.org/plugins/siteorigin-panels/\">Page Builder by SiteOrigin</a><br />\n<a href=\"https://wordpress.org/plugins/so-widgets-bundle/\">SiteOrigin Widgets Bundle</a></p>\n<p>Once Page Builder and the Widgets Bundle are activated, go to <span class=\"adminized-section\"><span class=\"adminized-part\">Plugins</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">SiteOrigin Widgets</span></span> and make sure that the <strong>Layout Slider</strong>, <strong>Headline</strong> and <strong>Contact Form</strong> widgets are activated.</p>\n<h3>Getting Started</h3>\n<p>Go to Pages and edit the page you&#8217;d like to insert your hero into. If you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click the Add Row button and add a single column row to your page. While editing the row, click the Layout tab on the right and set the Row Layout to Full Width Stretched.</p>\n<p>Next, select the row you&#8217;ve just created and click the Add Widget button. Because we need a Layout Builder within our hero we&#8217;re going to use the SiteOrigin Layout Slider widget. After clicking Add Widget, use the search bar at the top left to search for the SiteOrigin Layout Slider widget and insert it.</p>\n<p><img src=\"https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget.png\" alt=\"\" width=\"2398\" height=\"402\" class=\"alignnone size-full wp-image-127584\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget.png 2398w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-300x50.png 300w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-768x129.png 768w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-699x117.png 699w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-1050x176.png 1050w, https://siteorigin.com/wp-content/uploads/2018/09/layout-slider-widget-313x52.png 313w\" sizes=\"(max-width: 2398px) 100vw, 2398px\" /></p>\n<h3>Setting up the Layout Slider</h3>\n<p>Click on the SiteOrigin Layout Slider widget and then the edit link to open it. Before adding a frame, click on the Design and Layout tab to enter a few basic setup settings. For our <a href=\"https://demo.siteorigin.com/corp/hero-with-form-right/\">demo</a>, we&#8217;ve used the following:</p>\n<p><strong>Height:</strong> <code>780px</code><br />\n<strong>Top and bottom padding:</strong> <code>140px</code><br />\n<strong>Extra top padding:</strong> <em>Not populated</em><br />\n<strong>Side padding:</strong> <code>20px</code><br />\n<strong>Maximum container Width:</strong> <code>80%</code><br />\n<strong>Heading color:</strong> <code>#fff</code><br />\n<strong>Heading size:</strong> <code>54px</code><br />\n<strong>Heading shadow intensity:</strong> <code>50</code><br />\n<strong>Text size:</strong> <code>22px</code><br />\n<strong>Text color:</strong> <code>#fff</code></p>\n<p><img src=\"https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-574x699.png\" alt=\"\" width=\"574\" height=\"699\" class=\"alignnone size-large wp-image-127587\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-574x699.png 574w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-246x300.png 246w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-768x936.png 768w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-862x1050.png 862w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout-313x381.png 313w, https://siteorigin.com/wp-content/uploads/2018/09/design-and-layout.png 1244w\" sizes=\"(max-width: 574px) 100vw, 574px\" /></p>\n<h4>Adding a Frame and Contents</h4>\n<p>As with all SiteOrigin slider widgets, multiple frames (slides) can be added. In this example, we&#8217;ll just be adding a single frame. Click the Add link in the Slider Frames section to add a frame. Start out by opening the Background section and adding a background image. In our demo we&#8217;ve used:</p>\n<p><strong>Background image type:</strong> <code>Cover</code><br />\n<strong>Background image opacity:</strong> <code>20</code><br />\n<strong>Background color:</strong> <code>#000</code></p>\n<p>Our demo background images were sourced from <a href=\"https://unsplash.com/\">Unsplash</a>.</p>\n<p>With our frame background added, it&#8217;s time to add a headline and contact form. Click the Open Builder button, this will open a mini-instance of Page Builder. To set up your content, follow these steps:</p>\n<div id=\"attachment_127443\" style=\"width: 159px\" class=\"wp-caption alignright\"><img class=\"wp-image-127443 size-medium\" src=\"https://siteorigin.com/wp-content/uploads/2018/09/edit-row-149x300.png\" alt=\"\" width=\"149\" height=\"300\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/09/edit-row-149x300.png 149w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row-348x699.png 348w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row-522x1050.png 522w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row-313x629.png 313w, https://siteorigin.com/wp-content/uploads/2018/09/edit-row.png 614w\" sizes=\"(max-width: 149px) 100vw, 149px\" /></p>\n<p class=\"wp-caption-text\">Set row top padding to 100 and mobile padding to 0.</p>\n</div>\n<p>1. Click the Add Row button. For our demo we added a single row with two columns. Click and drag the column divider to change the widths. We&#8217;ve used <code>60%</code> for the left column and <code>40%</code> for the right. While editing the row, click the Layout tab on the right and set <code>100</code> for the top padding and <code>0</code> for right, bottom and left. Set Mobile Padding to <code>0</code>.</p>\n<p>2. Insert your widgets. Click on the left cell, then click the Add Widget button, use the search form at the top left to search for the SiteOrigin Headline widget. Repeat the same process for the right cell and insert the SiteOrigin Contact Form widget.</p>\n<p>3. Edit the Headline widget. Open the Headline section and insert your headline text, we&#8217;ve used <code>H1</code> for the headline HTML tag. For SEO your page should only contain one <code>H1</code> tag. If you&#8217;re using a <code>H1</code> tag anywhere else on your page then it&#8217;s best to make this <code>H2</code> or <code>H3</code> depending on your content structure. Next, open the Sub headline section and insert your sub headline. We&#8217;ve used <code>Paragraph</code> for the HTML tag. Finally, open the Divider section. We&#8217;ve set the Style setting <code>None</code> as we aren&#8217;t using the divider in this example. Click Done to save your changes.</p>\n<p>4. Edit the Contact Form widget. The Contact Form widget is quite settings rich so it might take a few moments to set up. Open the Settings section to set up your form basics such as email addresses, subject, success message and send button text. Next, add form fields as required. In our example, we&#8217;ve used a text field for name and an email address field. Finally, open the Design section and style your form as required. Once complete, click Done to save the Contact Form widget and then Done again to save the Layout Builder, lastly, click Done to save and exit the Layout Slider widget and then publish or update your page.</p>\n<div id=\"attachment_127593\" style=\"width: 3220px\" class=\"wp-caption alignnone\"><img src=\"https://siteorigin.com/wp-content/uploads/2018/09/layout-builder.png\" alt=\"\" width=\"3210\" height=\"424\" class=\"size-full wp-image-127593\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/09/layout-builder.png 3210w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-300x40.png 300w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-768x101.png 768w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-699x92.png 699w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-1050x139.png 1050w, https://siteorigin.com/wp-content/uploads/2018/09/layout-builder-313x41.png 313w\" sizes=\"(max-width: 3210px) 100vw, 3210px\" /></p>\n<p class=\"wp-caption-text\">Layout Builder contents</p>\n</div>\n<h3>Enhanced by SiteOrigin Premium</h3>\n<p><a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a> is a plugin that adds additional settings and functionality to SiteOrigin widgets, Page Builder and SiteOrign themes. It also includes our quick and helpful email support service. The following SiteOrigin Premium addons could be applied to engage users and provide additional functionality:</p>\n<p><strong>Block Animations</strong><br />\nThe Block Animations addon offers animation settings for rows and widgets. We&#8217;ve created a <a href=\"https://demo.siteorigin.com/corp/hero-with-form-right-block-animations/\">demo</a> showing a simple widget fade in with a slight delay. Read more about the settings available in the SiteOrigin Premium Block Animations addon it the <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/block-animations/\">documentation</a>.</p>\n<p><strong>Parallax Sliders</strong><br />\nThe Parallax Sliders addon offers parallax scrolling for the SiteOrigin Slider, Hero, and Layout Slider widget. We&#8217;ve created a <a href=\"https://demo.siteorigin.com/corp/hero-with-form-right-parallax-sliders/\">demo</a> showing the Layout Slider with a parallax scrolling effect. Read more about the settings available in the SiteOrigin Premium Parallax Sliders addon it the <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/parallax-sliders/\">documentation</a>.</p>\n<p><strong>Autoresponder</strong><br />\nThe SiteOrigin Premium Contact Form addon provides an autoresponder. Let users know you&#8217;ve received their email and provide a timeframe for response. Read more about the settings available in the SiteOrigin Contact Form addon in the <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/contact-form-fields/\">documentation</a>. </p>\n<h3>Using the Demo Layout</h3>\n<p><a href=\"https://demo.siteorigin.com/corp/hero-with-form-right/\">View the demo</a>.<br />\n<a href=\"https://siteorigin.com/wp-content/uploads/2018/09/hero-with-form-right.json\">Download the demo layout (JSON file)</a>.</p>\n<p>If you&#8217;d like to make use of the demo layout, follow these steps:</p>\n<p>1. Download the above JSON file to your desktop.<br />\n2. Go to the page you&#8217;d like to use, if you haven&#8217;t activated Page Builder on this page yet, click on the Page Builder tab and then in the Page Builder toolbar, click <span class=\"adminized-section\"><span class=\"adminized-part\">Layouts</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Import/Export</span></span>.<br />\n3. Upload the layout either by dragging and dropping or selecting it using the select button.<br />\n4. Finally, click the Insert button bottom right.</p>\n<p>If you have any questions or comments, please let us know below, we&#8217;d love to hear from you.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/adding-form-hero-image/\">Adding a Form to a Hero Image</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://siteorigin.com/adding-form-hero-image/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"One Page Navigation with Page Builder and Corp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://siteorigin.com/one-page-navigation-with-page-builder-corp/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://siteorigin.com/one-page-navigation-with-page-builder-corp/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Jul 2018 08:20:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=119494\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:570:\"<p>One-page navigation allows users to easily access content in long landing pages or one-page websites. SiteOrigin Corp offers integrated one-page navigation with menu highlighting and smooth scroll. In this tutorial, we\'ll explain how to set up a one-page website or landing page using Page Builder by SiteOrigin and Corp.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/one-page-navigation-with-page-builder-corp/\">One Page Navigation with Page Builder and Corp</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7720:\"<p>One-page navigation allows users to easily access content in long landing pages or one-page websites. SiteOrigin Corp offers integrated one-page navigation with menu highlighting and smooth scroll. In this tutorial, we&#8217;ll explain how to set up a one-page website or landing page using Page Builder by SiteOrigin and Corp.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/one-page-demo/\">View the demo</a>.</p>\n<h3>Create Your Page</h3>\n<p>In this tutorial, we&#8217;ll be using the WordPress plugin <a href=\"https://wordpress.org/plugins/siteorigin-panels/\">Page Builder by SiteOrigin</a> and theme, <a href=\"https://wordpress.org/themes/siteorigin-corp/\">SiteOrigin Corp</a>.</p>\n<p>If you haven&#8217;t already created a page, go to <span class=\"adminized-section\"><span class=\"adminized-part\">Pages</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Add New</span></span>, create a new page and click on the Page Builder tab to get started. </p>\n<p>If you&#8217;d like to use the demo page content, you can <a href=\"https://siteorigin.com/wp-content/uploads/2018/07/one-page-demo-export.json\">download it here</a> (right click and save as). Import the JSON file from <span class=\"adminized-section\"><span class=\"adminized-part\">Layouts</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Import/Export</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Select Import File</span></span>.</p>\n<h3>Adding Row ID&#8217;s</h3>\n<p>One you have a populated page, either with your own content or with the demo content listed above, it&#8217;s time to insert our row ID&#8217;s. Row ID&#8217;s will be used to link to each section of the page. Edit the first row you&#8217;d like your menu to link to and click the Attributes tab on the right, use the Row ID field to insert an ID that&#8217;ll be used later in your menu. For example, in our demo, the first row we&#8217;re linking to is the Services row. The ID used is <code>services</code>. You can insert any name or number.</p>\n<p><img src=\"https://siteorigin.com/wp-content/uploads/2018/07/row-id.png\" alt=\"\" width=\"754\" height=\"474\" class=\"alignnone size-full wp-image-119817\" style=\"max-width:50%;\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/07/row-id.png 754w, https://siteorigin.com/wp-content/uploads/2018/07/row-id-300x189.png 300w, https://siteorigin.com/wp-content/uploads/2018/07/row-id-699x439.png 699w, https://siteorigin.com/wp-content/uploads/2018/07/row-id-313x197.png 313w\" sizes=\"(max-width: 754px) 100vw, 754px\" /></p>\n<p>Add a row ID for every row in your page that you&#8217;d like to link to.</p>\n<h3>Create Your Menu</h3>\n<p>Go to <span class=\"adminized-section\"><span class=\"adminized-part\">Appearance</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Menus</span></span>, click the &#8220;create a new menu&#8221; link if you don&#8217;t already have a menu added. Once named, save your menu to the Header Menu theme location. Next, add your anchor links, these will direct users to the various sections of your one-page website. Click the Custom Links tab on the left to add a link. In the URL field, add the name of your first section ID with a hash before it. For example, if the first row you&#8217;d like to link to has the ID <code>services</code>, you&#8217;d add <code>#services</code> to the URL field. The Link Text field is the text your users will see, insert the link text for the anchor you&#8217;re linking to.</p>\n<p><img src=\"https://siteorigin.com/wp-content/uploads/2018/07/custom-link.png\" alt=\"\" width=\"944\" height=\"1162\" class=\"alignnone size-full wp-image-119847\" style=\"max-width:50%;\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/07/custom-link.png 944w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-244x300.png 244w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-768x945.png 768w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-568x699.png 568w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-853x1050.png 853w, https://siteorigin.com/wp-content/uploads/2018/07/custom-link-313x385.png 313w\" sizes=\"(max-width: 944px) 100vw, 944px\" /></p>\n<h3>Creating One-Page Navigation in Multi-Page Website</h3>\n<p>Creating an anchor menu as we&#8217;ve described in the above paragraph is quite simple for a one-page website. But what if your one-pager is part of a larger website? In that case, you&#8217;d need a separate menu. In our Corp demo, we&#8217;ve done exactly that, the one-page demo has one menu and the rest of the website has another. If you&#8217;d like to know how this was done, read on. </p>\n<p>The plugin we&#8217;ve used for this is called <a href=\"https://wordpress.org/plugins/menu-items-visibility-control/\">Menu Items Visibility Control</a>. Once installed and activated, it adds a Visibility field to each menu item. In each menu item at <span class=\"adminized-section\"><span class=\"adminized-part\">Appearance</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Menus</span></span> we&#8217;ve set the visibility to either show or be hidden on the one-pager. To do this, you&#8217;ll need to know the ID of your one-pager. Go to Pages, edit the page concerned and check the URL, within the URL is a number, that&#8217;s the page ID. In the case of our demo, the ID is <code>288</code>. The below conditional statements can be used in your menu, simply replace our page ID (288), with yours.</p>\n<p><strong>Show this item on page ID 288</strong><br />\n<code>is_page( 288 )</code></p>\n<p><strong>Hide this item on page ID 288</strong><br />\n<code>! is_page( 288 )</code></p>\n<p><img src=\"https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility.png\" alt=\"\" width=\"1346\" height=\"828\" class=\"alignnone size-full wp-image-119852\" style=\"width:75%\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility.png 1346w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-300x185.png 300w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-768x472.png 768w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-699x430.png 699w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-1050x646.png 1050w, https://siteorigin.com/wp-content/uploads/2018/07/menu-visibility-313x193.png 313w\" sizes=\"(max-width: 1346px) 100vw, 1346px\" /></p>\n<p>If you&#8217;d prefer to have your one-page links visible throughout your site then there is no need to use Menu Item Visibility. An additional consideration is that users might access your one-page links from another page. To ensure your anchor links work, use absolute URLs when adding Custom Links to your menu. This means that instead of adding anchor links such as <code>#services</code>, you&#8217;ll need to add the page URL in addition to the anchor link. Using our Services example from earlier in this post, we&#8217;d add <code>http://demo.siteorigin.com/corp/one-page-demo/#services</code>.</p>\n<p><strong>Page URL:</strong> http://demo.siteorigin.com/corp/one-page-demo/<br />\n<strong>Anchor Link:</strong> #services<br />\n<strong>Combined URL:</strong> http://demo.siteorigin.com/corp/one-page-demo/#services</p>\n<p>Hopefully, you&#8217;ve found this post useful. Please, let us know if you have any questions below, we&#8217;ll do our best to assist.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/one-page-navigation-with-page-builder-corp/\">One Page Navigation with Page Builder and Corp</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://siteorigin.com/one-page-navigation-with-page-builder-corp/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"27\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Announcing the Tooltip Addon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://siteorigin.com/announcing-the-tooltip-addon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://siteorigin.com/announcing-the-tooltip-addon/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jul 2018 07:28:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:13:\"Announcements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=118318\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<p>The Tooltip addon for <a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a> is here! Tooltips appear on hover or mouse click and are a great way to display additional image information without taking up space. To see the Tooltip addon in use, <a href=\"https://demo.siteorigin.com/premium/tooltip-addon/\" target=\"_blank\" rel=\"nofollow\">view the demo</a> and hover over any of the images.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/announcing-the-tooltip-addon/\">Announcing the Tooltip Addon</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1546:\"<p>The Tooltip addon for <a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a> is here! Tooltips appear on hover or mouse click and are a great way to display additional image information without taking up space. To see the Tooltip addon in use, <a href=\"https://demo.siteorigin.com/premium/tooltip-addon/\" target=\"_blank\" rel=\"nofollow\">view the demo</a> and hover over any of the images.</p>\n<p>We first had the idea for a tooltip addon while building a portfolio website as part of a SiteOrigin <a href=\"https://siteorigin.com/pack/\">Site Pack</a>. Tooltips are an awesome addition for designers and photographers displaying their work or any image that needs a credit or additional information added on hover or click. The Tooltip addon is available for the SiteOrigin Image, Image Grid, and Simple Masonry widgets.</p>\n<p>If you&#8217;re already using SiteOrigin Premium and have updated to version 1.4.1, you can go to <span class=\"adminized-section\"><span class=\"adminized-part\">SiteOrigin</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Premium Addons</span></span> to activate and adjust the global settings. Find out more about how to use the Tooltip addon in the <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/tooltip/\">documentation</a>.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/announcing-the-tooltip-addon/\">Announcing the Tooltip Addon</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://siteorigin.com/announcing-the-tooltip-addon/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Four New Blog Layouts Added to Corp Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2018 17:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:13:\"Announcements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://siteorigin.com/?p=115595\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:524:\"<p>We\'re excited to announce four new blog layouts for our Corp theme. This brings the total available blog layouts to five. Choose between the following for your posts page, Standard, Grid, Offset, Alternate or Masonry. We\'ve also included a new search results layout in this update.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/\">Four New Blog Layouts Added to Corp Theme</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Andrew Misplon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6940:\"<p>We&#8217;re excited to announce four new blog layouts for our latest theme, <a href=\"https://siteorigin.com/theme/corp\">Corp</a>. Choose the layout that&#8217;s the best fit for your blog and archive pages.</p>\n<p><a href=\"https://wordpress.org/themes/siteorigin-corp/\">Download Corp</a>, a fully featured free WordPress theme.<br />\n<a href=\"https://demo.siteorigin.com/corp/\">View the Corp demo</a>.</p>\n<h3>Standard Layout</h3>\n<p><a href=\"https://demo.siteorigin.com/corp/standard-blog-layout/\">View the demo</a>.</p>\n<p>The Standard layout features a classic blog look with a large featured image followed by a title, post meta, and content.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/standard-blog-layout/\"><img class=\"alignnone size-large wp-image-115786\" src=\"https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-633x699.jpg\" alt=\"\" width=\"633\" height=\"699\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-633x699.jpg 633w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-272x300.jpg 272w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-768x848.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard-313x346.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-standard.jpg 770w\" sizes=\"(max-width: 633px) 100vw, 633px\" /></a></p>\n<h3>Grid Layout</h3>\n<p><a href=\"https://demo.siteorigin.com/corp/grid-blog-layout/\">View the demo</a>.</p>\n<p>This is the blog layout Corp launched with, it offers a structured grid pattern, great for blogs with lots of content.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/grid-blog-layout/\"><img class=\"alignnone size-large wp-image-115787\" src=\"https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-699x441.jpg\" alt=\"\" width=\"699\" height=\"441\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-699x441.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-300x189.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-768x485.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid-313x198.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-grid.jpg 800w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></a></p>\n<h3>Offset Layout</h3>\n<p><a href=\"https://demo.siteorigin.com/corp/offset-blog-layout/\">View the demo</a>.</p>\n<p>The Offset layout features the post author, categories and comment count in an offset left column, great for highlighting post author contributions.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/offset-blog-layout/\"><img src=\"https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-676x699.jpg\" alt=\"\" width=\"676\" height=\"699\" class=\"alignnone size-large wp-image-115801\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-676x699.jpg 676w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-290x300.jpg 290w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-768x794.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout-313x324.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/new-offset-layout.jpg 800w\" sizes=\"(max-width: 676px) 100vw, 676px\" /></a></p>\n<h3>Alternate Layout</h3>\n<p><a href=\"https://demo.siteorigin.com/corp/alternate-blog-layout/\">View the demo</a>.</p>\n<p>This layout displays your post in horizontal containers, alternating the side the featured image is positioned on. Like the Grid layout, it&#8217;s also useful for active sites, looking to display more content on each page of their blog.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/alternate-blog-layout/\"><img class=\"alignnone size-large wp-image-115783\" src=\"https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-699x489.jpg\" alt=\"\" width=\"699\" height=\"489\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-699x489.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-300x210.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-768x538.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate-313x219.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/corp-demo-alternate.jpg 800w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></a></p>\n<h3>Masonry Layout</h3>\n<p><a href=\"https://demo.siteorigin.com/corp/masonry-blog-layout/\">View the demo</a>.</p>\n<p>The Masonry layout offers a more creative take on the grid layout. The post category is displayed on the featured image, the featured images aren&#8217;t uniform in height and when resizing the screen, the grid layout cascades into place.</p>\n<p><a href=\"https://demo.siteorigin.com/corp/masonry-blog-layout/\"><img src=\"https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-699x544.jpg\" alt=\"\" width=\"699\" height=\"544\" class=\"alignnone size-large wp-image-115806\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-699x544.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-300x234.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-768x598.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp-313x244.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/new-masonry-corp.jpg 800w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></a></p>\n<h3>Search Results</h3>\n<p>We&#8217;ve also improved Corp&#8217;s search results page. Search results now make use of a very similar layout to the Alternate post loop, just without the alternating featured image.</p>\n<p><img src=\"https://siteorigin.com/wp-content/uploads/2018/06/new-search-699x311.jpg\" alt=\"\" width=\"699\" height=\"311\" class=\"alignnone size-large wp-image-115803\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/new-search-699x311.jpg 699w, https://siteorigin.com/wp-content/uploads/2018/06/new-search-300x134.jpg 300w, https://siteorigin.com/wp-content/uploads/2018/06/new-search-768x342.jpg 768w, https://siteorigin.com/wp-content/uploads/2018/06/new-search-313x139.jpg 313w, https://siteorigin.com/wp-content/uploads/2018/06/new-search.jpg 800w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></p>\n<h3>SiteOrigin Premium</h3>\n<p>If you&#8217;d like to remove the footer attribution, add Ajax comments and enjoy quick email support, SiteOrigin Premium is for you. <a href=\"https://siteorigin.com/downloads/premium/\">Find out more</a>.</p>\n<p>Corp is now a fully featured theme, complete with multiple blog loops and a completely customized WooCommerce design. If you have any questions or requests, please let us know below.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/\">Four New Blog Layouts Added to Corp Theme</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://siteorigin.com/four-new-blog-layouts-added-to-corp-theme/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Create a Fullscreen Slider with the SiteOrigin Hero Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 08 Jun 2018 10:59:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"tutorial\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://siteorigin.com/?p=113044\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:442:\"<p>This guide will outline how to create a fullscreen slider with the SiteOrigin Hero widget and how you can take your fullscreen slider to the next level with SiteOrigin Premium.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/\">Create a Fullscreen Slider with the SiteOrigin Hero Widget</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Alex S\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11224:\"<p>This guide will outline how to create a fullscreen slider with the SiteOrigin Hero widget and how you can take your fullscreen slider to the next level with <a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a>.</p>\n<h3>Let&#8217;s Get Started</h3>\n<p>We&#8217;ll be using <a href=\"https://wordpress.org/plugins/siteorigin-panels/\">Page Builder by SiteOrigin</a> and the <a href=\"https://wordpress.org/plugins/so-widgets-bundle/\">SiteOrigin Widgets Bundle</a> plugins. You can check these plugins are activated from the Plugins menu item. Go to <span class=\"adminized-section\"><span class=\"adminized-part\">Plugins</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">SiteOrigin Widgets</span></span> and ensure the Hero widget is activated.<span id=\"more-113044\"></span></p>\n<p>Create a new page and enable Page Builder, or open an existing page. Add a new row and SiteOrigin Hero Image widget to that row. We need to set the row you&#8217;re using is set to Full Width Stretch, which will allow for the Hero widget to be the full width of the page. To do this, open the row containing the newly added Hero widget by clicking the wrench button above the row.</p>\n<p><img class=\"wp-image-113480 size-large aligncenter\" src=\"https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-699x142.png\" alt=\"image with row wrench icon hovered on\" width=\"699\" height=\"142\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-699x142.png 699w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-300x61.png 300w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-768x156.png 768w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-1050x213.png 1050w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-313x64.png 313w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-600x122.png 600w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1-1200x244.png 1200w, https://siteorigin.com/wp-content/uploads/2018/06/9PIZeAn-1.png 1486w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></p>\n<p>Go to the Row Styles Sidebar on the right and open the Layout settings group. Set the <span class=\"adminized-section\"><span class=\"adminized-part\">Row Layout</span></span> to <span class=\"adminized-section\"><span class=\"adminized-part\">Full Width Stretched</span></span>. For reference, here&#8217;s what each row Layout does:</p>\n<p><img class=\"wp-image-113481 size-medium alignright\" src=\"https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-300x208.png\" alt=\"Image of cursor on on the Row Layout drop-down\" width=\"300\" height=\"208\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-300x208.png 300w, https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-313x217.png 313w, https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1-600x415.png 600w, https://siteorigin.com/wp-content/uploads/2018/06/Zgsowcb-1-1.png 662w\" sizes=\"(max-width: 300px) 100vw, 300px\" /></p>\n<p><strong>Standard:</strong> The standard layout provided by your theme.</p>\n<p><strong>Full Width:</strong> This row layout will stretch the row to the full width of the browser, and add a content container that&#8217;s sized based on the standard container. This row layout is perfect for making full-width backgrounds while still allowing the widgets within the row to maintain the consistent placement of the rest of the page.</p>\n<p><strong>Full Width Stretched:</strong> This row layout is the full width of the page. It&#8217;s perfect for making widgets (such as the Hero widget) full width rather than just the row background.</p>\n<p>Close the row and open the SiteOrigin Hero widget by hovering on top of the Hero widget and clicking edit.</p>\n<p><img class=\"wp-image-113483 size-large aligncenter\" src=\"https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-699x112.png\" alt=\"image of hero widget with edit hovered on\" width=\"699\" height=\"112\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-699x112.png 699w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-300x48.png 300w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-768x123.png 768w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-1050x168.png 1050w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-313x50.png 313w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-600x96.png 600w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1-1200x192.png 1200w, https://siteorigin.com/wp-content/uploads/2018/06/ojjt7X0-1.png 1488w\" sizes=\"(max-width: 699px) 100vw, 699px\" /></p>\n<p>Open the Design and Layout settings group and set the Height to <span class=\"adminized-section\"><span class=\"adminized-part\">100vh</span></span>. The <span class=\"adminized-section\"><span class=\"adminized-part\">V</span></span> in <span class=\"adminized-section\"><span class=\"adminized-part\">VH</span></span> stands for <a href=\"https://developer.mozilla.org/en-US/docs/Web/CSS/length#Viewport-percentage_lengths\">Viewport Percentage Length</a> and <span class=\"adminized-section\"><span class=\"adminized-part\">H</span></span> means height. Basically, <span class=\"adminized-section\"><span class=\"adminized-part\">100vh</span></span> is the entire height of the browser regardless of device so it&#8217;s exactly what you&#8217;re after for a fullscreen slider.</p>\n<p>That&#8217;s all the setup required to build fullscreen sliders with the SiteOrigin Hero widget. Now you simply need to set up the rest of the slider as desired &#8211; add content, tweak spacing, etc. As a point reference, for fullscreen sliders, we recommend using slide background images that are at least <span class=\"adminized-section\"><span class=\"adminized-part\">1920 x 1080</span></span> in dimensions. <span class=\"adminized-section\"><span class=\"adminized-part\">1920 x 1080</span></span> is an extremely popular resolution so it&#8217;ll cover the vast majority of use cases.</p>\n<h3>SiteOrigin Premium Enhancements</h3>\n<p><a href=\"https://siteorigin.com/downloads/premium/\">SiteOrigin Premium</a> adds a number of enhancements to your website and the Hero widget benefits greatly from these enhancements. You&#8217;re able to create a fullscreen slider with parallax with <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/parallax-sliders/\">the Parallax Sliders plugin addon</a> and add transitional Content Animations with the <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/hero/\">Hero plugin addon</a>. If you have SiteOrigin Premium, please ensure you&#8217;ve activated relevant functionality by navigating to <span class=\"adminized-section\"><span class=\"adminized-part\">SiteOrigin</span><span class=\"adminized-arrow icon-arrow-right\"></span><span class=\"adminized-part\">Premium Addons</span></span> and activating <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/parallax-sliders/\">Parallax Sliders</a> and <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/hero/\">Hero Addon</a>.</p>\n<h4>Fullscreen Parallax Sliders</h4>\n<p>SiteOrigin Premium adds the ability to allow your slide backgrounds to <a href=\"https://siteorigin.com/fixed-vs-parallax-background-images/\">parallax</a>. Before proceeding, it&#8217;s worth noting that parallax images require a vertically larger image than normal so ensure your image is vertically larger than you would normally use or the parallax effect may be very minor. We recommend using an image that&#8217;s more than <span class=\"adminized-section\"><span class=\"adminized-part\">1440px</span></span> in height. If your images result in blank spacing beneath the image, your image is too small to for a fullscreen Parallax. If the parallax isn&#8217;t very noticeable, that means the image isn&#8217;t large enough.</p>\n<p>To set a slider background as parallax, please open your hero widget and open a frame you would like to apply a parallax too. Open the Background settings group and set <span class=\"adminized-section\"><span class=\"adminized-part\">Background Type</span></span> to <span class=\"adminized-section\"><span class=\"adminized-part\">Parallax</span></span>. Repeat this process for the rest of the slides you wish to parallax.</p>\n<p>You can <a href=\"https://demo.siteorigin.com/premium/hero-addon/\">preview this functionality here</a>.</p>\n<h3>Hero Content Animations</h3>\n<p>To allow you to make really beautiful sliders that stand out, we recently released an update for the SiteOrigin Premium which adds transitional Content Animations for the SiteOrigin Hero widget. This functionality will allow you to add transitional effects for the text of your slider.</p>\n<p>To give your slide a context animation, please open your hero widget and open a frame you would like to apply a content animation too. Open the Content Animation settings group. You have access to all of the standard <a href=\"https://siteorigin.com/premium-documentation/plugin-addons/block-animations/\">Block Animation</a> options but the key difference is there&#8217;s a new Animation Event &#8211; Frame Display. This event is triggered every time the slide changes so the animation will continually animate.</p>\n<p>You can <a href=\"https://demo.siteorigin.com/premium/hero-addon/#parallax-sliders\">preview this functionality here</a>.</p>\n<h3>Responsive Notes</h3>\n<p>To ensure setup is as easy as possible, we use <span class=\"adminized-section\"><span class=\"adminized-part\">background-size: cover;</span></span> to allow for all images to fill the entire area of the hero widget. This prevents having to resize images manually. This functionality works by ensuring the image is always the same height of the area/slide its been applied to and to ensure this the browser can (and will) clip the sides of the image off. This can be problematic on mobile because if you use a height that&#8217;s too large, or add too much text it may result in parts of your image being hidden on mobile.</p>\n<p>To lower the impact of the slides being clipped off, you should use an image with a central focus, which is an image where the focus of the image is in the middle (or at least towards the middle). Alternatively, you could apply a <span class=\"adminized-section\"><span class=\"adminized-part\">Responsive Height</span></span> that works better for your image than the Height setting does. We&#8217;re unable to recommend a <span class=\"adminized-section\"><span class=\"adminized-part\">Responsive Height</span></span> as it depends solely on the image you&#8217;re using so you&#8217;ll need to try a number of different values to see what works for you and your image.</p>\n<p>Alternatively, give <a href=\"https://smartslider3.com/?source=siteorigin\">Smart Slider 3</a> a try as it handles slides in a different manner.</p>\n<p>If you have any questions or run into any issues, please feel free to leave a comment and we&#8217;ll lend a hand.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/\">Create a Fullscreen Slider with the SiteOrigin Hero Widget</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://siteorigin.com/create-fullscreen-slider-siteorigin-hero-widget/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"GDPR and SiteOrigin Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://siteorigin.com/gdpr-and-siteorigin-products/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://siteorigin.com/gdpr-and-siteorigin-products/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2018 12:32:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Announcements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://siteorigin.com/?p=109960\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:580:\"<p>General Data Protection Regulation (GDPR) is European Union law on data protection and privacy for all individuals within the European Union. It addresses the export of personal data outside the EU. We\'ve assembled a brief guide on what sort of information you might need to add to your privacy policy to comply with GDPR when using SiteOrigin themes and plugins.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/gdpr-and-siteorigin-products/\">GDPR and SiteOrigin Products</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Alex S\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5829:\"<p>General Data Protection Regulation (GDPR) is European Union law on data protection and privacy for all individuals within the European Union. It addresses the export of personal data outside the EU. We&#8217;ve assembled a brief guide on what sort of information you might need to add to your privacy policy to comply with GDPR when using SiteOrigin themes and plugins.</p>\n<p><strong>Disclaimer:</strong> this post is by no means legal advice. If unsure, please seek professional consultation.</p>\n<h3>What is GDPR?</h3>\n<p>The General Data Protection Regulation (GDPR) is a legal framework that sets guidelines for the collection and processing of personal information of individuals within the European Union (EU).</p>\n<p>Read the full definition on <a href=\"https://en.wikipedia.org/wiki/General_Data_Protection_Regulation\">Wikipedia</a>.</p>\n<h3>Does GDPR Affect Me and My Website?</h3>\n<p>If your company is based in the European Union (EU), or you do business with EU citizens, the GDPR does affect you and your website so you need to comply. With that said, it would be a good idea comply with the regulations regardless, as it&#8217;s possible countries outside of the EU will implement similar legislation in the future.</p>\n<p><span id=\"more-109960\"></span></p>\n<h4>SiteOrigin CSS Plugin and SiteOrigin Themes</h4>\n<p>Good News! SiteOrigin CSS and SiteOrigin themes comply with the GDPR as none of them collect, store or transmit any user information. However, if you&#8217;re making use of Google Fonts in SiteOrigin CSS or SiteOrigin themes, you&#8217;ll need to make a note of this in your privacy policy. Google is GDPR compliant, <a href=\"https://privacy.google.com/businesses/compliance/\">find out more</a>.</p>\n<p>(Google Fonts can only be added from within SiteOrigin CSS using the Web Font Selector in SiteOrigin Premium.)</p>\n<h4>SiteOrigin Page Builder: Layouts Directory</h4>\n<p>The only GDPR concern in SiteOrigin Page Builder is the Layouts Directory. By default, all images in prebuilt layouts are hosted on layouts.siteorigin.com. We recommend changing these images as soon as possible. If you decide not to, you&#8217;ll need to make mention of these images in your privacy policy.</p>\n<h4>SiteOrigin Widgets Bundle</h4>\n<p>Certain widgets include Google Fonts if you decide to use any of those fonts you&#8217;ll need to mention that in your privacy policy. Google is GDPR compliant, <a href=\"https://privacy.google.com/businesses/compliance/\">find out more</a>.</p>\n<h4>SiteOrigin Contact Form Widget</h4>\n<p>While the SiteOrigin Contact Form widget doesn&#8217;t store data, it does handle user submitted data. As such, it&#8217;s a good idea to ask for consent before transmitting this data.</p>\n<p>To ask for consent, add a checkbox to your contact form and use the following values:</p>\n<p><strong>Field Type:</strong> Checkboxes<br />\n<strong>Required Field:</strong> Required (This field must be required)<br />\n<strong>Add an Option and set the Value to:</strong><br />\nPlease tick to consent to your data being stored temporarily, as per our privacy policy.</p>\n<p><img class=\"alignnone size-full wp-image-109968\" src=\"https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup.png\" alt=\"\" width=\"1604\" height=\"1024\" srcset=\"https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup.png 1604w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-300x192.png 300w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-768x490.png 768w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-699x446.png 699w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-1050x670.png 1050w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-313x200.png 313w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-600x383.png 600w, https://siteorigin.com/wp-content/uploads/2018/05/siteorigin-contact-form-GDPR-setup-1200x766.png 1200w\" sizes=\"(max-width: 1604px) 100vw, 1604px\" /></p>\n<p>If you choose to <strong>Log IP Address</strong>, you&#8217;ll need to mention this in your privacy policy. Logging the user&#8217;s IP Address simply includes the IP in the email, you&#8217;ll need to mention that it&#8217;s included, but not stored anywhere.</p>\n<p>If you&#8217;re using SiteOrigin Premium, the Contact From plugin addon allows you to add autoresponder functionality to email the user on form submission. If you use this functionality you&#8217;ll need to mention this in your privacy policy alongside your contact form information.</p>\n<h4>SiteOrigin Google Maps Widget</h4>\n<p>If you use the SiteOrigin Google Maps widget, you&#8217;ll need to mention that you use Google Maps in your privacy policy and that while you don&#8217;t personally collect this data, Google may. Google is GDPR compliant, <a href=\"https://privacy.google.com/businesses/compliance/\">find out more</a>.</p>\n<h4>SiteOrigin Video Player</h4>\n<p>If you embed any external video, such as from YouTube or Vimeo, you&#8217;ll need to mention this in your privacy policy. Be sure to check if the video you&#8217;re embedding is hosted on a service that is GDPR compliant.</p>\n<h3>Summary</h3>\n<p>Hopefully, this gives you a better idea of what GDPR is and how SiteOrigin themes and plugins might influence the creation of your website&#8217;s data management and privacy policy.</p>\n<p>If you have any questions or concerns, please feel free to leave a comment.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://siteorigin.com/gdpr-and-siteorigin-products/\">GDPR and SiteOrigin Products</a> appeared first on <a rel=\"nofollow\" href=\"https://siteorigin.com\">SiteOrigin</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://siteorigin.com/gdpr-and-siteorigin-products/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"50\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:28:\"https://siteorigin.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:16:{s:4:\"date\";s:29:\"Tue, 27 Nov 2018 10:26:50 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"set-cookie\";s:131:\"__cfduid=dc43cd4c3f26e615e0ff4a49543bdd9b61543314410; expires=Wed, 27-Nov-19 10:26:50 GMT; path=/; domain=.siteorigin.com; HttpOnly\";s:13:\"cache-control\";s:22:\"public, max-age=432000\";s:7:\"expires\";s:29:\"Sun, 02 Dec 2018 10:26:50 GMT\";s:12:\"x-robots-tag\";s:15:\"noindex, follow\";s:4:\"link\";s:59:\"<https://siteorigin.com/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"last-modified\";s:29:\"Tue, 27 Nov 2018 07:27:21 GMT\";s:4:\"etag\";s:39:\"\"831ba8f67db3f6fa04c668b58d190dde-gzip\"\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"x-cache\";s:4:\"MISS\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:9:\"expect-ct\";s:87:\"max-age=604800, report-uri=\"https://report-uri.cloudflare.com/cdn-cgi/beacon/expect-ct\"\";s:6:\"server\";s:10:\"cloudflare\";s:6:\"cf-ray\";s:20:\"4803e61a6fe1c671-MAD\";}}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO `jmkn_options` VALUES("932", "_transient_timeout_feed_mod_2dd0202377a060f0df35cceaacc2c13c", "1543357609", "no");
INSERT INTO `jmkn_options` VALUES("933", "_transient_feed_mod_2dd0202377a060f0df35cceaacc2c13c", "1543314409", "no");
INSERT INTO `jmkn_options` VALUES("935", "_transient_timeout_feed_3ca2a73478cc83bbe37e39039b345a78", "1543357614", "no");
INSERT INTO `jmkn_options` VALUES("936", "_transient_feed_3ca2a73478cc83bbe37e39039b345a78", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"https://wpfr.net\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Site officiel de la communauté\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Nov 2018 10:32:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Think WP, le documentaire vidéo sur WordPress enfin disponible !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BFWuQgyALjg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://wpfr.net/thinkwp-documentaire-video-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 13:03:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2220300\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1538:\"Découvrez WordPress en 30 minutes au travers de ce documentaire inédit d&#8217;interviews de la communauté française. Sur une idée originale de Déborah Donnier, entrepreneurs, chefs d&#8217;entreprises, freelances, agences web, développeurs, intégrateurs&#8230; de toute la France se succèdent pour nous parler de notre CMS favori WordPress. Financé uniquement par des dons et sponsors, le projet Think<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BFWuQgyALjg:KhIgVVs-X9Q:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BFWuQgyALjg:KhIgVVs-X9Q:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BFWuQgyALjg:KhIgVVs-X9Q:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BFWuQgyALjg:KhIgVVs-X9Q:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BFWuQgyALjg:KhIgVVs-X9Q:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BFWuQgyALjg:KhIgVVs-X9Q:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BFWuQgyALjg\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Benjamin Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wpfr.net/thinkwp-documentaire-video-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wpfr.net/thinkwp-documentaire-video-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WP BootCamp 2018 : retours sur la deuxième édition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/73jXJKLX5xI/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Oct 2018 06:05:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2215483\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1487:\"Soutenu par l&#8217;association WordPress Francophone, retours sur la seconde édition du WP BootCamp. Qu&#8217;est ce que le WP BootCamp ? Le WP BootCamp est un événement réunissant des passionnés de WordPress et du web en général sur un week-end de 3 jours. L&#8217;édition 2018, portée par Rémi Corson, Aurélien Denis et Benjamin Denis, se déroula<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=73jXJKLX5xI:kXAjLDU4P-c:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=73jXJKLX5xI:kXAjLDU4P-c:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=73jXJKLX5xI:kXAjLDU4P-c:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/73jXJKLX5xI\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Benjamin Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wpfr.net/wp-bootcamp-2018-retours-sur-la-deuxieme-edition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Tout savoir sur l’arrivée de Gutenberg en quelques points essentiels\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/i6NQjnc9uiQ/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpfr.net/wordpress-gutenberg/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2018 09:00:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"éditeur visuel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2117903\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1474:\"Gutenberg arrive à grand pas, alors voici un résumé de tout ce qu&#8217;il faut savoir sur le nouvel éditeur visuel de WordPress au travers de questions / réponses ! Difficile de marcher tranquillement dans le quartier WordPress sans entendre parler de ce fameux Gutenberg ! C&#8217;est un nouvel éditeur ? C&#8217;est un nouveau page builder<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i6NQjnc9uiQ:TQYicJ8IHdE:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i6NQjnc9uiQ:TQYicJ8IHdE:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i6NQjnc9uiQ:TQYicJ8IHdE:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/i6NQjnc9uiQ\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"maximebj\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wpfr.net/wordpress-gutenberg/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"13\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"https://wpfr.net/wordpress-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Résultats des élections du bureau 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/qvTDw6NqY5Q/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wpfr.net/resultats-elections-bureau-2018/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Mar 2018 08:00:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2107099\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1521:\"Suite à la votation électronique qui s&#8217;est déroulée du 24 février au 3 mars 2018, nous vous communiquons les résultats pour l&#8217;élection du bureau 2018. Vous avez été 40% des adhérents à participer au vote, soit 85 suffrages exprimés. C&#8217;est pratiquement autant de votants que l&#8217;an passé avec un nombre d&#8217;adhérents moins élevé, l&#8217;abstention reste<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=qvTDw6NqY5Q:LD0dZBWRJa4:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=qvTDw6NqY5Q:LD0dZBWRJa4:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=qvTDw6NqY5Q:LD0dZBWRJa4:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/qvTDw6NqY5Q\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wpfr.net/resultats-elections-bureau-2018/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"13\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wpfr.net/resultats-elections-bureau-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Liste des candidats au bureau 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/mYCnwrPtTAY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wpfr.net/liste-candidats-bureau-2018/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Feb 2018 11:45:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2092699\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1508:\"Les élections pour le renouvellement du bureau auront lieu du 24 février au 3 mars 2018 par voie électronique. Nous vous communiquons dès à présent la liste des candidats validée par l&#8217;actuel bureau, classés par ordre alphabétique. Les candidats Willy Bahuaud Présentation Je suis développeur full-stack. Après quelques années passées en agence à Nantes, j’ai<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=mYCnwrPtTAY:g4F7i0PDxEQ:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=mYCnwrPtTAY:g4F7i0PDxEQ:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=mYCnwrPtTAY:g4F7i0PDxEQ:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/mYCnwrPtTAY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://wpfr.net/liste-candidats-bureau-2018/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wpfr.net/liste-candidats-bureau-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WPFR sponsor du WP Tech Lyon !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/kVgok7MJrJM/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wpfr.net/wpfr-sponsor-wptech-lyon/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 Feb 2018 07:00:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"Evènements\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2082223\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1507:\"L’association WPFR est fière de vous annoncer qu’elle sponsorise WP Tech 2018 qui aura lieu le 28 avril à Lyon. Le WP Tech est une journée de conférences et d’ateliers exclusivement consacrée aux aspects techniques de WordPress. Vous y découvrirez des outils pour améliorer vos méthodes de travail, apprendrez de nouvelles méthodes de développements d’extensions,<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kVgok7MJrJM:wfMH9NuDwps:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=kVgok7MJrJM:wfMH9NuDwps:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=kVgok7MJrJM:wfMH9NuDwps:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/kVgok7MJrJM\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://wpfr.net/wpfr-sponsor-wptech-lyon/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://wpfr.net/wpfr-sponsor-wptech-lyon/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Loi anti-fraude et l’e-commerce : les informations officielles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/KBb85wMEo0g/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wpfr.net/loi-anti-fraude-et-le-commerce-les-informations-officielles/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 31 Jan 2018 14:51:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Extensions\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:21:\"WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:15:\"Loi anti-fraude\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2072415\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1503:\"Cette nouvelle loi a fait couler pas mal d&#8217;encre ces derniers temps et afin d&#8217;apporter des réponses concrètes et officielles, nous nous sommes penchés sur le sujet en profondeur. Voici donc ce qu&#8217;il en ressort officiellement : Les plateformes e-commerce open source sont bien concernées par la loi anti-fraude Que ce soit WooCommerce, Magento, Prestashop,<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KBb85wMEo0g:NZq1YCx1Y5E:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=KBb85wMEo0g:NZq1YCx1Y5E:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=KBb85wMEo0g:NZq1YCx1Y5E:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/KBb85wMEo0g\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"maximebj\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://wpfr.net/loi-anti-fraude-et-le-commerce-les-informations-officielles/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"39\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wpfr.net/loi-anti-fraude-et-le-commerce-les-informations-officielles/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"L’élection du bureau WPFR 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/BC2q8usn6uA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wpfr.net/election-bureau-wpfr-2018/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 15 Jan 2018 11:30:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2041252\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1530:\"Comme annoncé lors de l’assemblée générale du 12 décembre 2017, l&#8217;heure des élections a sonné. Le bureau actuellement en place voit son mandat terminé, de nouvelles élections doivent donc avoir lieu afin de le renouveler  Ces élections sont prévues pour le 26 février 2018 et nous invitons les membres l&#8217;association désireux d&#8217;occuper des responsabilités nationales à<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BC2q8usn6uA:rovaWM-7xzU:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=BC2q8usn6uA:rovaWM-7xzU:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=BC2q8usn6uA:rovaWM-7xzU:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/BC2q8usn6uA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wpfr.net/election-bureau-wpfr-2018/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wpfr.net/election-bureau-wpfr-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"PHP Tour Montpellier 2018 : WPFR est partenaire !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/i_ty7z2Kg6A/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Jan 2018 10:12:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2035309\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1489:\"WPFR est fière d&#8217;être partenaire du PHP Tour Montpellier 2018 qui se tiendra les 17 et 18 mai. Cet évènement porté par l&#8217;AFUP (Association Française des Utilisateurs de PHP) rassemble une sélection d&#8217;orateurs reconnus du monde PHP. Et comme vous le savez, WordPress repose en grande partie sur le langage PHP. Si vous êtes développeurs,<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i_ty7z2Kg6A:5FE8vgrgZLs:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=i_ty7z2Kg6A:5FE8vgrgZLs:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=i_ty7z2Kg6A:5FE8vgrgZLs:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/i_ty7z2Kg6A\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Aurélien Denis\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wpfr.net/php-tour-montpellier-2018-wpfr-partenaire/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Le point sur les certifications WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://feedproxy.google.com/~r/WordpressFrancophone/~3/SbTm014V92I/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wpfr.net/point-certifications-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 11 Dec 2017 17:15:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:16:\"Association WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://wpfr.net/?p=2001761\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1552:\"Le sujet des certifications WordPress est de retour en cette fin d&#8217;année pour faire un point de situation. L&#8217;association s&#8217;est penchée dessus et voici les conclusions actuelles. Pour rappel, j&#8217;avais émis l&#8217;idée en 2016 de faire certifier les formations WordPress. D&#8217;autres idées ont ensuite suivi, dont notamment celle d&#8217;inscrire WordPress au Registre National des Certifications<div class=\"btn btn-default read-more text-uppercase\">Lire la suite <span class=\"meta-nav\"><i class=\"fa fa-caret-right\"></i></span></div><div class=\"feedflare\">\n<a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:yIl2AUoC8zA\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=yIl2AUoC8zA\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:V_sGLiPBpWU\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=SbTm014V92I:Cd3SuKi-siI:V_sGLiPBpWU\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:qj6IDK7rITs\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?d=qj6IDK7rITs\" border=\"0\"></img></a> <a href=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?a=SbTm014V92I:Cd3SuKi-siI:gIN9vFwOqvQ\"><img src=\"http://feeds.feedburner.com/~ff/WordpressFrancophone?i=SbTm014V92I:Cd3SuKi-siI:gIN9vFwOqvQ\" border=\"0\"></img></a>\n</div><img src=\"http://feeds.feedburner.com/~r/WordpressFrancophone/~4/SbTm014V92I\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"maximebj\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wpfr.net/point-certifications-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"11\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wpfr.net/point-certifications-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:48:\"http://feeds.feedburner.com/WordpressFrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:4:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:20:\"wordpressfrancophone\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:14:\"emailServiceId\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordpressFrancophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:18:\"feedburnerHostname\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://feedburner.google.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"feedFlare\";a:9:{i:0;a:5:{s:4:\"data\";s:24:\"Subscribe with NewsGator\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:112:\"http://www.newsgator.com/ngs/subscriber/subext.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://www.newsgator.com/images/ngsub1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:24:\"Subscribe with Bloglines\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:77:\"http://www.bloglines.com/sub/http://feeds.feedburner.com/WordpressFrancophone\";s:3:\"src\";s:48:\"http://www.bloglines.com/images/sub_modern11.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:23:\"Subscribe with Netvibes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:98:\"http://www.netvibes.com/subscribe.php?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:39:\"//www.netvibes.com/img/add2netvibes.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:21:\"Subscribe with Google\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:93:\"http://fusion.google.com/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:51:\"http://buttons.googlesyndication.com/fusion/add.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:25:\"Subscribe with Pageflakes\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:101:\"http://www.pageflakes.com/subscribe.aspx?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:87:\"http://www.pageflakes.com/ImageFile.ashx?instanceId=Static_4&fileName=ATP_blu_91x17.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:21:\"Subscribe with Plusmo\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:86:\"http://www.plusmo.com/add?url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:43:\"http://plusmo.com/res/graphics/fbplusmo.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:23:\"Subscribe with Live.com\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:81:\"http://www.live.com/?add=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:141:\"http://tkfiles.storage.msn.com/x1piYkpqHC_35nIp1gLE68-wvzLZO8iXl_JMledmJQXP-XTBOLfmQv4zhj4MhcWEJh_GtoBIiAl1Mjh-ndp9k47If7hTaFno0mxW9_i3p_5qQw\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:25:\"Subscribe with Mon Yahoo!\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:99:\"https://add.my.yahoo.com/content?lg=fr&url=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:60:\"http://us.i1.yimg.com/us.yimg.com/i/us/my/bn/intatm_fr_1.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:25:\"Subscribe with Excite MIX\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"http://mix.excite.eu/add?feedurl=http%3A%2F%2Ffeeds.feedburner.com%2FWordpressFrancophone\";s:3:\"src\";s:42:\"http://image.excite.co.uk/mix/addtomix.gif\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"H/DGBmWVeykB3uo+FdUcvDTqndA\";s:13:\"last-modified\";s:29:\"Tue, 27 Nov 2018 10:26:05 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Tue, 27 Nov 2018 10:26:56 GMT\";s:7:\"expires\";s:29:\"Tue, 27 Nov 2018 10:26:56 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:7:\"alt-svc\";s:40:\"quic=\":443\"; ma=2592000; v=\"44,43,39,35\"\";}}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO `jmkn_options` VALUES("937", "_transient_timeout_feed_mod_3ca2a73478cc83bbe37e39039b345a78", "1543357614", "no");
INSERT INTO `jmkn_options` VALUES("938", "_transient_feed_mod_3ca2a73478cc83bbe37e39039b345a78", "1543314414", "no");
INSERT INTO `jmkn_options` VALUES("939", "_transient_timeout_feed_76f8d9281c01f21e505004d0986f50c6", "1543357615", "no");
INSERT INTO `jmkn_options` VALUES("940", "_transient_feed_76f8d9281c01f21e505004d0986f50c6", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:5:\"\n		\n	\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:79:\"\n		\n		\n		\n		\n		\n		\n					\n						\n						\n						\n						\n						\n						\n						\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Planète WordPress Francophone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"https://wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Toute l’actualité de WordPress en français !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:8:{i:0;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Weglot : traduire son WordPress en plusieurs langues\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://feedproxy.google.com/~r/wpfr/~3/xdYPzVy-9Wk/weglot-traduire-wordpress-31147.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://boiteaweb.fr/weglot-traduire-wordpress-31147.html\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Nov 2018 07:30:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:473:\"\n		        Avec plus de 29% du web, WordPress est présent partout dans le monde. Mais lorsqu’il s’agit de traduire votre site web et de le rendre multilingue cela a longtemps été un processus complexe et pénible. J&#8217;ai longtemps utilisé WPML car c&#8217;était LE plugin à l&#8217;époque de mes débuts en 2010. Puis sur d&#8217;autres sites comme&#160;…\nThe post Weglot : traduire son WordPress en plusieurs langues appeared first on BoiteAWeb.		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:694:\"<p>Avec plus de 29% du web, WordPress est présent partout dans le monde. Mais lorsqu’il s’agit de traduire votre site web et de le rendre multilingue cela a longtemps été un processus complexe et pénible. J&#8217;ai longtemps utilisé WPML car c&#8217;était LE plugin à l&#8217;époque de mes débuts en 2010. Puis sur d&#8217;autres sites comme&#160;…</p>\n<p>The post <a rel=\"nofollow\" href=\"https://boiteaweb.fr/weglot-traduire-wordpress-31147.html\">Weglot : traduire son WordPress en plusieurs langues</a> appeared first on <a rel=\"nofollow\" href=\"https://boiteaweb.fr\">BoiteAWeb</a>.</p><img src=\"http://feeds.feedburner.com/~r/wpfr/~4/xdYPzVy-9Wk\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://boiteaweb.fr/weglot-traduire-wordpress-31147.html\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"Wix ou WordPress ? Le comparatif ultime pour faire un choix éclairé\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://feedproxy.google.com/~r/wpfr/~3/K48yrt5AAOU/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://wpmarmite.com/wix-ou-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=wix-ou-wordpress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Nov 2018 07:00:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"\n		        \nBatman contre Superman. Danaerys Targaryen contre John Snow. MacDonald’s contre Burger King. Il est des combats mythiques, millénaires, où chaque équipe trouve toujours un argument à avancer à l’autre pour...\nL’article Wix ou WordPress ? Le comparatif ultime pour faire un choix éclairé est apparu en premier sur WP Marmite.		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:724:\"<p><img width=\"1500\" height=\"750\" src=\"https://wpmarmite.com/wp-content/uploads/2018/11/wp-wix.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"\" /></p>\n<p>Batman contre Superman. Danaerys Targaryen contre John Snow. MacDonald’s contre Burger King. Il est des combats mythiques, millénaires, où chaque équipe trouve toujours un argument à avancer à l’autre pour...</p>\n<p>L’article <a rel=\"nofollow\" href=\"https://wpmarmite.com/wix-ou-wordpress/\">Wix ou WordPress ? Le comparatif ultime pour faire un choix éclairé</a> est apparu en premier sur <a rel=\"nofollow\" href=\"https://wpmarmite.com\">WP Marmite</a>.</p><img src=\"http://feeds.feedburner.com/~r/wpfr/~4/K48yrt5AAOU\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"https://wpmarmite.com/wix-ou-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=wix-ou-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Compare Affiliated Product débarque sur le dépôt WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://feedproxy.google.com/~r/wpfr/~3/mdHsjhFPVl0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://www.thivinfo.com/blog/compare-affiliated-product-debarque-sur-le-depot-wordpress/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Nov 2018 17:46:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:715:\"\n		        Compare Affiliated Products est une extension WordPress que thivinfo.com a développé d&#8217;abord en version payante et que vous pouvez acheter sur ce site. La version payante propose de comparer les prix de produits disponible dans différents programmes d&#8217;affiliation mené par les plateformes Awin et Effiliation. La version gratuite, disponible sur le dépôt WordPress propose d&#8217; afficher le prix de produit en vente chez Amazon via le programme Amazon Affiliates. A chaque vente générée par un de vos visiteurs vous serez donc rémunéré. Pour afficher le prix Amazon d&#8217;un produit, utilisez simplement le code court (shortcode) avec le code ASIN: Présentation…		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:785:\"Compare Affiliated Products est une extension WordPress que thivinfo.com a développé d&#8217;abord en version payante et que vous pouvez acheter sur ce site. La version payante propose de comparer les prix de produits disponible dans différents programmes d&#8217;affiliation mené par les plateformes Awin et Effiliation. La version gratuite, disponible sur le dépôt WordPress propose d&#8217; afficher le prix de produit en vente chez Amazon via le programme Amazon Affiliates. A chaque vente générée par un de vos visiteurs vous serez donc rémunéré. Pour afficher le prix Amazon d&#8217;un produit, utilisez simplement le code court (shortcode) avec le code ASIN: Présentation…<img src=\"http://feeds.feedburner.com/~r/wpfr/~4/mdHsjhFPVl0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://www.thivinfo.com/blog/compare-affiliated-product-debarque-sur-le-depot-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WordCamp Bordeaux 2019, l’évènement éco-responsable\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://feedproxy.google.com/~r/wpfr/~3/DW-RAGgXsKw/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://2019.bordeaux.wordcamp.org/2018/11/17/wordcamp-bordeaux-2019-evenement-eco-responsable/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Nov 2018 14:31:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:447:\"\n		        Du bordeaux au vert Conscient de l’impact énergétique que représente WordPress dans l’empreinte carbone du Web, le WordCamp Bordeaux 2019 s’inscrit dans une démarche éco-responsable et locale. Une attention toute particulière a été portée à l’ensemble des étapes de l’organisation de l’évènement : choix des partenaires et des prestataires, définition des sujets de conférences, conception [&#8230;]		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordCamp Bordeaux\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2698:\"<h2>Du bordeaux au vert</h2>\n<p>Conscient de l’impact énergétique que représente WordPress dans l’empreinte carbone du Web, le WordCamp Bordeaux 2019 s’inscrit dans une démarche éco-responsable et locale.</p>\n<p>Une attention toute particulière a été portée à l’ensemble des étapes de l’organisation de l’évènement : choix des partenaires et des prestataires, définition des sujets de conférences, conception du site et des goodies&#8230;<span id=\"more-2076\"></span></p>\n<p>Cette initiative débouchera sur la publication d’un <strong>livre vert</strong> compilant nos réflexions, les bonnes pratiques, ainsi que les difficultés rencontrées. Ce document, disponible gratuitement au téléchargement, pourra, nous l’espérons, servir de base de travail aux professionnel·e·s du Web, et créer une dynamique pour aider à réduire l’impact de nos conceptions Web sur l’environnement.</p>\n<blockquote class=\"energie\"><p><i></i><br />\nAvec 7% de la consommation mondiale d’électricité, le Web est le troisième consommateur d’énergie, après la Chine et les Etats-Unis (<a href=\"https://www.greenpeace.fr/il-est-temps-de-renouveler-internet/\">chiffres Greenpeace</a>)</p></blockquote>\n<h2>Un évènement accessible</h2>\n<p>Le WordCamp Bordeaux se déroulera en plein cœur de Bordeaux dans le Centre de Congrès Cité Mondiale. Un site particulièrement apprécié pour son emplacement en plein cœur du quartier des Chartrons et l’architecture du Bordeaux XVIII<sup>e</sup>, classée au patrimoine mondial de l’UNESCO, qui l’entoure.</p>\n<p>Idéalement situé, cet espace nous permet de proposer une programmation ambitieuse, en plaçant l’expérience des participants au cœur de l’évènement. L’amphithéatre accueille les conférences et les salles annexes les ateliers du jour. La sonorisation haute qualité et les écrans disposés dans les deux salles garantissent à chaque participant·e une expérience optimale, y compris pour les personnes en situation de handicap.</p>\n<p>Ce lieu nous permettra de réunir pas moins de 300 personnes pour cette journée d’échanges et de partage.</p>\n<blockquote class=\"a11y\"><p>Environ 21 % de la population, soit 12 à 15 millions de personnes, est en situation de handicap en France (<a href=\"https://informations.handicap.fr/art-infos-handicap-archives-703-476.php\">chiffres INSEE</a>).</p></blockquote>\n<p>Ne tardez plus et rendez-vous le 23 mars 2019 à la Cité Mondiale !</p>\n<p class=\"aligncenter\"><a class=\"button\" href=\"https://2019.bordeaux.wordcamp.org/billets/\">Je prends ma place</a></p><img src=\"http://feeds.feedburner.com/~r/wpfr/~4/DW-RAGgXsKw\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://2019.bordeaux.wordcamp.org/2018/11/17/wordcamp-bordeaux-2019-evenement-eco-responsable/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"BEAPI Maintenance Mode est sur wp.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://feedproxy.google.com/~r/wpfr/~3/qNzXBdFTGHI/beapi-maintenance-mode-est-sur-wp-org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://blog.beapi.fr/beapi-maintenance-mode-est-sur-wp-org\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Nov 2018 16:28:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:214:\"\n		        N\'avez-vous jamais voulu mettre rapidement et facilement votre site WordPress en mode maintenance ?\nCet article BEAPI Maintenance Mode est sur wp.org est apparu en premier sur Be API Tech blog.		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4920:\"<blockquote><p><em>N&rsquo;avez-vous jamais voulu mettre rapidement et facilement votre site WordPress en mode maintenance ?</em></p></blockquote>\n<p><span id=\"more-655\"></span></p>\n<p><span class=\"wpsdc-drop-cap\">M</span>ais pourquoi avoir créé une énième <a href=\"https://beapi.fr/offre/plugin-extension/\">extension WordPress</a> de maintenance ? Surtout qu&rsquo;il y en a déjà certaines qui font très bien le travail, le code est propre, il y a la possibilité de personnaliser l&rsquo;écran de maintenance, etc.</p>\n<p><a href=\"https://wordpress.org/plugins/beapi-maintenance-mode\" target=\"_blank\" rel=\"noopener\"><img class=\"alignnone wp-image-657 size-full\" src=\"https://i2.wp.com/blog.beapi.fr/wp-content/uploads/2018/11/beapi-maintenance-mode-cover.jpg?resize=660%2C214&#038;ssl=1\" alt=\"\" width=\"660\" height=\"214\" /></a></p>\n<h2>Qu&rsquo;offre BEAPI Maintenance Mode de plus ?</h2>\n<p>Nous avons l&rsquo;habitude à <a href=\"https://beapi.fr\" target=\"_blank\" rel=\"noopener\">Be API</a> de gérer les <a href=\"https://beapi.fr/offre/multisites-wordpress/\">multisites</a> de nos clients grands comptes et de ce fait nous recherchons régulièrement une manière de faire pour industrialiser et simplifier nos déploiements, développements, etc. C&rsquo;est dans ce contexte que <a href=\"https://wordpress.org/plugins/beapi-maintenance-mode\" target=\"_blank\" rel=\"noopener\">BEAPI Maintenance Mode</a> est né.</p>\n<p>Certains aspects ont donc été « designé » pour répondre aux besoins de nos clients et sont mis en avant pour leur plus grand confort.</p>\n<h2>Des utilisations diverses</h2>\n<p>Seuls les utilisateurs connectés continueront leur navigation habituelle sans ne rien se rendre compte. Alors que les autres tomberont sur l&rsquo;écran de maintenance, ce qui peut donc offrir des cas d&rsquo;utilisations divers :</p>\n<ul>\n<li>lors du déploiement d’une nouvelle feature et le client veut prendre le temps de valider/contribuer</li>\n<li>cacher un site de préproduction</li>\n<li>dans un contexte de multisite, un site n’est pas encore prêt/contribué pour le public. Il est rendu invisible durant un laps de temps indéterminé</li>\n<li>Voir plus si affinités …</li>\n</ul>\n<h2>Pas d&rsquo;options dans le back-office !</h2>\n<p>L&rsquo;extension est simple as pie, on l&rsquo;active et elle fait ce que l&rsquo;on attend d&rsquo;elle. Il n&rsquo;y a aucun réglage à réaliser. L&rsquo;écran de maintenance est donc un peu « rude » mais c&rsquo;est volontaire !</p>\n<p><img class=\"wp-image-658 size-large aligncenter\" src=\"https://i2.wp.com/blog.beapi.fr/wp-content/uploads/2018/11/beapi-maintenance-mode-template.png?resize=660%2C477&#038;ssl=1\" alt=\"\" width=\"660\" height=\"477\" /></p>\n<p>Néanmoins, comme l&rsquo;extension est developer friendly, il est possible de personnaliser dans le code cet écran avec un template personnalisé. C&rsquo;est-à-dire appliquer une UX, DA, charte graphique relative au site.</p>\n<p>Dans un contexte <strong>multisite</strong>, vous serez donc ravis de pouvoir enfin pouvoir activer/désactiver la fonctionnalité en un seul clique sans avoir à reconfigurer sur une 10aine de sites les mêmes réglages.</p>\n<h2>SEO Friendly</h2>\n<p>Les enjeux SEO sont respectés, car l&rsquo;activation de l&rsquo;extension de maintenance renverra un code d&rsquo;erreur 503. Ce qui signifie que les robots des moteurs de recherches auront pour indication de ne pas indexer votre page de maintenance mais surtout ne pas perdre le travail déjà réalisé.</p>\n<p>Les contenus du site ne seront donc plus du tout accessibles et cela sera valable non pas uniquement sur le site mais également dans les flux RSS ou Atom.</p>\n<h2>Processus de connexion, déconnexion, activation</h2>\n<p>Il est important de souligner que malgré l&rsquo;activation du mode maintenance, les processus de connexion et déconnexion continueront de fonctionner. Par ailleurs, dans un contexte multisite, le processus d’activation d’un utilisateur fonctionnera également, <strong>chose qu&rsquo;aucune autre extension ne supporte actuellement</strong>.</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://wordpress.org/plugins/beapi-maintenance-mode/\">BEAPI &#8211; Maintenance Mode</a></p></blockquote>\n<p></p>\n<hr />\n<p>Profitez donc dès maintenant de l&rsquo;occasion pour installer l&rsquo;extension directement depuis votre back-office et si vous rencontrez des bugs n&rsquo;hésitez pas à nous les <a href=\"https://github.com/BeAPI/beapi-maintenance-mode/issues/new\" target=\"_blank\" rel=\"noopener\">remonter.</a></p>\n<p>Cet article <a rel=\"nofollow\" href=\"https://blog.beapi.fr/beapi-maintenance-mode-est-sur-wp-org\">BEAPI Maintenance Mode est sur wp.org</a> est apparu en premier sur <a rel=\"nofollow\" href=\"https://blog.beapi.fr\">Be API Tech blog</a>.</p><img src=\"http://feeds.feedburner.com/~r/wpfr/~4/qNzXBdFTGHI\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://blog.beapi.fr/beapi-maintenance-mode-est-sur-wp-org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"CGA Plugin Helper\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://feedproxy.google.com/~r/wpfr/~3/bbCF_XvYIKY/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://www.echodesplugins.li-an.fr/plugins/cga-plugin-helper/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 11 Nov 2018 07:27:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"\n		        Exporter et importer une bibliothèque d’extensions		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Exporter et importer une bibliothèque d’extensions<img src=\"http://feeds.feedburner.com/~r/wpfr/~4/bbCF_XvYIKY\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://www.echodesplugins.li-an.fr/plugins/cga-plugin-helper/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Gutenberg arrive, êtes-vous prêt ?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://feedproxy.google.com/~r/wpfr/~3/_rf2xdpAUf0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wpformation.com/gutenberg-arrive-etes-vous-pret/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Nov 2018 08:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:573:\"\n		        La sortie de WordPress 5.0 approche à grands pas. Cette nouvelle version marque un gros changement dans l’univers du CMS, avec l’arrivée du nouvel éditeur visuel nommé Gutenberg. Alors, même s’il ne fait pas l’unanimité pour le moment, il est intéressant de comprendre comment il fonctionne sous le capot afin d’être capable de créer ses [&#8230;]\n\nL’article Gutenberg arrive, êtes-vous prêt ? est apparu en premier sur WPFormation. Tutoriels WordPress, Formation WordPress, Woocommerce, SEO. Abonnez-vous pour ne rien manquer !\n		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WP Formation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1401:\"<p><img width=\"2000\" height=\"1654\" src=\"https://wpformation.com/wp-content/uploads/2018/11/capture-2018-11-08-a-14.12.13.jpg\" class=\"attachment-Large size-Large wp-post-image\" alt=\"\" style=\"margin-left: 0px;margin-right: auto;margin-top:10px;margin-bottom:10px;max-width: 640px;max-height: 400px\" />La sortie de WordPress 5.0 approche à grands pas. Cette nouvelle version marque un gros changement dans l’univers du CMS, avec l’arrivée du nouvel éditeur visuel nommé Gutenberg. Alors, même s’il ne fait pas l’unanimité pour le moment, il est intéressant de comprendre comment il fonctionne sous le capot afin d’être capable de créer ses [&#8230;]</p>\n<hr />\nL’article <a rel=\"nofollow\" href=\"https://wpformation.com/gutenberg-arrive-etes-vous-pret/\">Gutenberg arrive, êtes-vous prêt ?</a> est apparu en premier sur <a href=\"https://wpformation.com/\">WPFormation</a>.<br /> <a href=\"https://wpformation.com/wordpress/\">Tutoriels WordPress</a>, <a href=\"https://wpformation.com/formation-wordpress/\">Formation WordPress</a>, <a href=\"https://wpformation.com/formation-woocommerce-e-commerce/\">Woocommerce</a>, <a href=\"https://wpformation.com/formation-wordpress-pro/\">SEO</a>. <a href=\"https://wpformation.com/abonnement-newsletter-wpf/\">Abonnez-vous</a> pour ne rien manquer !</p>\n<hr /><img src=\"http://feeds.feedburner.com/~r/wpfr/~4/_rf2xdpAUf0\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wpformation.com/gutenberg-arrive-etes-vous-pret/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:84:\"\n		        \n		        \n		        \n		        \n		        \n		        \n		        \n		    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Quel plugin d’opt-in choisir pour capturer des emails sur WordPress ?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"http://feedproxy.google.com/~r/wpfr/~3/5IO-dD_tDAA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wpmarmite.com/optin-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=optin-wordpress\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 07 Nov 2018 07:00:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"\n		        \nJe vais vous poser une question, mais je suis persuadé de connaître votre réponse. Aimeriez-vous transformer les visiteurs de votre site en abonnés à votre liste email ? Si vous...\nL’article Quel plugin d&rsquo;opt-in choisir pour capturer des emails sur WordPress ? est apparu en premier sur WP Marmite.		        \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:702:\"<p><img width=\"1500\" height=\"750\" src=\"https://wpmarmite.com/wp-content/uploads/2018/11/email-optin.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"\" /></p>\n<p>Je vais vous poser une question, mais je suis persuadé de connaître votre réponse. Aimeriez-vous transformer les visiteurs de votre site en abonnés à votre liste email ? Si vous...</p>\n<p>L’article <a rel=\"nofollow\" href=\"https://wpmarmite.com/optin-wordpress/\">Quel plugin d&rsquo;opt-in choisir pour capturer des emails sur WordPress ?</a> est apparu en premier sur <a rel=\"nofollow\" href=\"https://wpmarmite.com\">WP Marmite</a>.</p><img src=\"http://feeds.feedburner.com/~r/wpfr/~4/5IO-dD_tDAA\" height=\"1\" width=\"1\" alt=\"\"/>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wpmarmite.com/optin-wordpress/?utm_source=rss&#038;utm_medium=rss&%23038;utm_campaign=optin-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:52:\"http://backend.userland.com/creativeCommonsRssModule\";a:1:{s:7:\"license\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://creativecommons.org/licenses/by-nc-sa/3.0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:32:\"http://feeds.feedburner.com/wpfr\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:4:\"wpfr\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"HjVJ9l3exES6nuvFfpg5iZPbgrw\";s:13:\"last-modified\";s:29:\"Tue, 27 Nov 2018 10:25:27 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Tue, 27 Nov 2018 10:26:57 GMT\";s:7:\"expires\";s:29:\"Tue, 27 Nov 2018 10:26:57 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:7:\"alt-svc\";s:40:\"quic=\":443\"; ma=2592000; v=\"44,43,39,35\"\";}}s:5:\"build\";s:14:\"20130911040210\";}", "no");
INSERT INTO `jmkn_options` VALUES("941", "_transient_timeout_feed_mod_76f8d9281c01f21e505004d0986f50c6", "1543357615", "no");
INSERT INTO `jmkn_options` VALUES("942", "_transient_feed_mod_76f8d9281c01f21e505004d0986f50c6", "1543314415", "no");
INSERT INTO `jmkn_options` VALUES("943", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1543357615", "no");
INSERT INTO `jmkn_options` VALUES("944", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/BFWuQgyALjg/\'>Think WP, le documentaire vidéo sur WordPress enfin disponible !</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wpfr/~3/xdYPzVy-9Wk/weglot-traduire-wordpress-31147.html\'>Weglot : traduire son WordPress en plusieurs langues</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wpfr/~3/K48yrt5AAOU/\'>Wix ou WordPress ? Le comparatif ultime pour faire un choix éclairé</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/wpfr/~3/mdHsjhFPVl0/\'>Compare Affiliated Product débarque sur le dépôt WordPress</a></li></ul></div>", "no");
INSERT INTO `jmkn_options` VALUES("1205", "_site_transient_timeout_theme_roots", "1543339791", "no");
INSERT INTO `jmkn_options` VALUES("1206", "_site_transient_theme_roots", "a:5:{s:13:\"sayidan-child\";s:7:\"/themes\";s:7:\"sayidan\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO `jmkn_options` VALUES("1210", "duplicator_ui_view_state", "a:3:{s:22:\"dup-pack-storage-panel\";s:1:\"1\";s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:24:\"dup-pack-installer-panel\";s:1:\"1\";}", "yes");
INSERT INTO `jmkn_options` VALUES("1216", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-27 17:13:43\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.26\";s:10:\"VersionPHP\";s:6:\"5.6.25\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20181127_yamoussoukroinphbalumni\";s:4:\"Hash\";s:35:\"bcf2e9ff9cdff5cb1497_20181127171343\";s:8:\"NameHash\";s:68:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:37:\"C:/wamp64/www/alumni/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://localhost:5050/alumni/wp-snapshots/\";s:8:\"ScanFile\";s:78:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:20:\"C:/wamp64/www/alumni\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-11-27 17:13:43\";s:7:\"Version\";s:6:\"1.2.52\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.6.26\";s:10:\"VersionPHP\";s:6:\"5.6.25\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20181127_yamoussoukroinphbalumni\";s:4:\"Hash\";s:35:\"bcf2e9ff9cdff5cb1497_20181127171343\";s:8:\"NameHash\";s:68:\"20181127_yamoussoukroinphbalumni_bcf2e9ff9cdff5cb1497_20181127171343\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:37:\"C:/wamp64/www/alumni/wp-snapshots/tmp\";s:8:\"StoreURL\";s:42:\"http://localhost:5050/alumni/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:1;s:14:\"OptsSecurePass\";s:12:\"YXplcnR5MTIz\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:58;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:29:\"C:/wamp64/www/alumni/wp-admin\";i:1;s:39:\"C:/wamp64/www/alumni/wp-content/uploads\";i:2;s:41:\"C:/wamp64/www/alumni/wp-content/languages\";i:3;s:39:\"C:/wamp64/www/alumni/wp-content/plugins\";i:4;s:38:\"C:/wamp64/www/alumni/wp-content/themes\";i:5;s:32:\"C:/wamp64/www/alumni/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}", "yes");
INSERT INTO `jmkn_options` VALUES("1227", "_transient_is_multi_author", "0", "yes");
INSERT INTO `jmkn_options` VALUES("1242", "um_cached_users_queue", "0", "no");

/* INSERT TABLE DATA: jmkn_postmeta */
INSERT INTO `jmkn_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `jmkn_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `jmkn_postmeta` VALUES("7", "7", "_form", "<label> Your Name (required)\n    [text* your-name] </label>\n\n<label> Your Email (required)\n    [email* your-email] </label>\n\n<label> Subject\n    [text your-subject] </label>\n\n<label> Your Message\n    [textarea your-message] </label>\n\n[submit \"Send\"]");
INSERT INTO `jmkn_postmeta` VALUES("8", "7", "_mail", "a:8:{s:7:\"subject\";s:43:\"Yamoussoukro INP-HB ALUMNI \"[your-subject]\"\";s:6:\"sender\";s:34:\"[your-name] <jmakdesign@gmail.com>\";s:4:\"body\";s:193:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Yamoussoukro INP-HB ALUMNI (http://localhost:5050/alumni)\";s:9:\"recipient\";s:20:\"jmakdesign@gmail.com\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `jmkn_postmeta` VALUES("9", "7", "_mail_2", "a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:43:\"Yamoussoukro INP-HB ALUMNI \"[your-subject]\"\";s:6:\"sender\";s:49:\"Yamoussoukro INP-HB ALUMNI <jmakdesign@gmail.com>\";s:4:\"body\";s:135:\"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on Yamoussoukro INP-HB ALUMNI (http://localhost:5050/alumni)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:30:\"Reply-To: jmakdesign@gmail.com\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";i:0;s:13:\"exclude_blank\";i:0;}");
INSERT INTO `jmkn_postmeta` VALUES("10", "7", "_messages", "a:8:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";}");
INSERT INTO `jmkn_postmeta` VALUES("11", "7", "_additional_settings", NULL);
INSERT INTO `jmkn_postmeta` VALUES("12", "7", "_locale", "fr_FR");
INSERT INTO `jmkn_postmeta` VALUES("13", "8", "_um_custom_fields", "a:6:{s:10:\"user_login\";a:15:{s:5:\"title\";s:8:\"Username\";s:7:\"metakey\";s:10:\"user_login\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:8:\"Username\";s:8:\"required\";i:1;s:6:\"public\";i:1;s:8:\"editable\";i:0;s:8:\"validate\";s:15:\"unique_username\";s:9:\"min_chars\";i:3;s:9:\"max_chars\";i:24;s:8:\"position\";s:1:\"1\";s:6:\"in_row\";s:9:\"_um_row_1\";s:10:\"in_sub_row\";s:1:\"0\";s:9:\"in_column\";s:1:\"1\";s:8:\"in_group\";s:0:\"\";}s:10:\"user_email\";a:13:{s:5:\"title\";s:14:\"E-mail Address\";s:7:\"metakey\";s:10:\"user_email\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:14:\"E-mail Address\";s:8:\"required\";i:0;s:6:\"public\";i:1;s:8:\"editable\";i:1;s:8:\"validate\";s:12:\"unique_email\";s:8:\"position\";s:1:\"4\";s:6:\"in_row\";s:9:\"_um_row_1\";s:10:\"in_sub_row\";s:1:\"0\";s:9:\"in_column\";s:1:\"1\";s:8:\"in_group\";s:0:\"\";}s:13:\"user_password\";a:16:{s:5:\"title\";s:8:\"Password\";s:7:\"metakey\";s:13:\"user_password\";s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:8:\"required\";i:1;s:6:\"public\";i:1;s:8:\"editable\";i:1;s:9:\"min_chars\";i:8;s:9:\"max_chars\";i:30;s:15:\"force_good_pass\";i:1;s:18:\"force_confirm_pass\";i:1;s:8:\"position\";s:1:\"5\";s:6:\"in_row\";s:9:\"_um_row_1\";s:10:\"in_sub_row\";s:1:\"0\";s:9:\"in_column\";s:1:\"1\";s:8:\"in_group\";s:0:\"\";}s:10:\"first_name\";a:12:{s:5:\"title\";s:10:\"First Name\";s:7:\"metakey\";s:10:\"first_name\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:10:\"First Name\";s:8:\"required\";i:0;s:6:\"public\";i:1;s:8:\"editable\";i:1;s:8:\"position\";s:1:\"2\";s:6:\"in_row\";s:9:\"_um_row_1\";s:10:\"in_sub_row\";s:1:\"0\";s:9:\"in_column\";s:1:\"1\";s:8:\"in_group\";s:0:\"\";}s:9:\"last_name\";a:12:{s:5:\"title\";s:9:\"Last Name\";s:7:\"metakey\";s:9:\"last_name\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Last Name\";s:8:\"required\";i:0;s:6:\"public\";i:1;s:8:\"editable\";i:1;s:8:\"position\";s:1:\"3\";s:6:\"in_row\";s:9:\"_um_row_1\";s:10:\"in_sub_row\";s:1:\"0\";s:9:\"in_column\";s:1:\"1\";s:8:\"in_group\";s:0:\"\";}s:9:\"_um_row_1\";a:4:{s:4:\"type\";s:3:\"row\";s:2:\"id\";s:9:\"_um_row_1\";s:8:\"sub_rows\";s:1:\"1\";s:4:\"cols\";s:1:\"1\";}}");
INSERT INTO `jmkn_postmeta` VALUES("14", "8", "_um_mode", "register");
INSERT INTO `jmkn_postmeta` VALUES("15", "8", "_um_core", "register");
INSERT INTO `jmkn_postmeta` VALUES("16", "8", "_um_register_use_custom_settings", "0");
INSERT INTO `jmkn_postmeta` VALUES("17", "9", "_um_custom_fields", "a:3:{s:8:\"username\";a:13:{s:5:\"title\";s:18:\"Username or E-mail\";s:7:\"metakey\";s:8:\"username\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:18:\"Username or E-mail\";s:8:\"required\";i:1;s:6:\"public\";i:1;s:8:\"editable\";i:0;s:8:\"validate\";s:24:\"unique_username_or_email\";s:8:\"position\";s:1:\"1\";s:6:\"in_row\";s:9:\"_um_row_1\";s:10:\"in_sub_row\";s:1:\"0\";s:9:\"in_column\";s:1:\"1\";s:8:\"in_group\";s:0:\"\";}s:13:\"user_password\";a:16:{s:5:\"title\";s:8:\"Password\";s:7:\"metakey\";s:13:\"user_password\";s:4:\"type\";s:8:\"password\";s:5:\"label\";s:8:\"Password\";s:8:\"required\";i:1;s:6:\"public\";i:1;s:8:\"editable\";i:1;s:9:\"min_chars\";i:8;s:9:\"max_chars\";i:30;s:15:\"force_good_pass\";i:1;s:18:\"force_confirm_pass\";i:1;s:8:\"position\";s:1:\"2\";s:6:\"in_row\";s:9:\"_um_row_1\";s:10:\"in_sub_row\";s:1:\"0\";s:9:\"in_column\";s:1:\"1\";s:8:\"in_group\";s:0:\"\";}s:9:\"_um_row_1\";a:4:{s:4:\"type\";s:3:\"row\";s:2:\"id\";s:9:\"_um_row_1\";s:8:\"sub_rows\";s:1:\"1\";s:4:\"cols\";s:1:\"1\";}}");
INSERT INTO `jmkn_postmeta` VALUES("18", "9", "_um_mode", "login");
INSERT INTO `jmkn_postmeta` VALUES("19", "9", "_um_core", "login");
INSERT INTO `jmkn_postmeta` VALUES("20", "9", "_um_login_use_custom_settings", "0");
INSERT INTO `jmkn_postmeta` VALUES("21", "10", "_um_custom_fields", "a:1:{s:9:\"_um_row_1\";a:4:{s:4:\"type\";s:3:\"row\";s:2:\"id\";s:9:\"_um_row_1\";s:8:\"sub_rows\";s:1:\"1\";s:4:\"cols\";s:1:\"1\";}}");
INSERT INTO `jmkn_postmeta` VALUES("22", "10", "_um_mode", "profile");
INSERT INTO `jmkn_postmeta` VALUES("23", "10", "_um_core", "profile");
INSERT INTO `jmkn_postmeta` VALUES("24", "10", "_um_profile_use_custom_settings", "0");
INSERT INTO `jmkn_postmeta` VALUES("25", "11", "_um_template", "members");
INSERT INTO `jmkn_postmeta` VALUES("26", "11", "_um_mode", "directory");
INSERT INTO `jmkn_postmeta` VALUES("27", "11", "_um_has_profile_photo", "0");
INSERT INTO `jmkn_postmeta` VALUES("28", "11", "_um_has_cover_photo", "0");
INSERT INTO `jmkn_postmeta` VALUES("29", "11", "_um_show_social", "0");
INSERT INTO `jmkn_postmeta` VALUES("30", "11", "_um_show_userinfo", "0");
INSERT INTO `jmkn_postmeta` VALUES("31", "11", "_um_show_tagline", "0");
INSERT INTO `jmkn_postmeta` VALUES("32", "11", "_um_search", "0");
INSERT INTO `jmkn_postmeta` VALUES("33", "11", "_um_userinfo_animate", "1");
INSERT INTO `jmkn_postmeta` VALUES("34", "11", "_um_sortby", "user_registered_desc");
INSERT INTO `jmkn_postmeta` VALUES("35", "11", "_um_profile_photo", "1");
INSERT INTO `jmkn_postmeta` VALUES("36", "11", "_um_cover_photos", "1");
INSERT INTO `jmkn_postmeta` VALUES("37", "11", "_um_show_name", "1");
INSERT INTO `jmkn_postmeta` VALUES("38", "11", "_um_search_filters", "");
INSERT INTO `jmkn_postmeta` VALUES("39", "11", "_um_directory_header", "{total_users} Members");
INSERT INTO `jmkn_postmeta` VALUES("40", "11", "_um_directory_header_single", "{total_users} Member");
INSERT INTO `jmkn_postmeta` VALUES("41", "11", "_um_directory_no_users", "We are sorry. We cannot find any users who match your search criteria.");
INSERT INTO `jmkn_postmeta` VALUES("42", "11", "_um_profiles_per_page", "12");
INSERT INTO `jmkn_postmeta` VALUES("43", "11", "_um_profiles_per_page_mobile", "6");
INSERT INTO `jmkn_postmeta` VALUES("44", "11", "_um_core", "members");
INSERT INTO `jmkn_postmeta` VALUES("45", "12", "_edit_lock", "1542907805:1");
INSERT INTO `jmkn_postmeta` VALUES("46", "13", "_wp_attached_file", "2018/11/favicon.png");
INSERT INTO `jmkn_postmeta` VALUES("47", "13", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:32;s:6:\"height\";i:32;s:4:\"file\";s:19:\"2018/11/favicon.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("48", "14", "_wp_attached_file", "2018/11/cropped-favicon.png");
INSERT INTO `jmkn_postmeta` VALUES("49", "14", "_wp_attachment_context", "site-icon");
INSERT INTO `jmkn_postmeta` VALUES("50", "14", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:27:\"2018/11/cropped-favicon.png\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-512x331.png\";s:5:\"width\";i:512;s:6:\"height\";i:331;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-290x290.png\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-262x179.png\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:25:\"cropped-favicon-93x93.png\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"sayidan-blog\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-512x405.png\";s:5:\"width\";i:512;s:6:\"height\";i:405;s:9:\"mime-type\";s:9:\"image/png\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-272x182.png\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-270\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-270x270.png\";s:5:\"width\";i:270;s:6:\"height\";i:270;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-192\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-192x192.png\";s:5:\"width\";i:192;s:6:\"height\";i:192;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"site_icon-180\";a:4:{s:4:\"file\";s:27:\"cropped-favicon-180x180.png\";s:5:\"width\";i:180;s:6:\"height\";i:180;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"site_icon-32\";a:4:{s:4:\"file\";s:25:\"cropped-favicon-32x32.png\";s:5:\"width\";i:32;s:6:\"height\";i:32;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("51", "12", "_wp_trash_meta_status", "publish");
INSERT INTO `jmkn_postmeta` VALUES("52", "12", "_wp_trash_meta_time", "1542907820");
INSERT INTO `jmkn_postmeta` VALUES("53", "15", "_wp_attached_file", "2018/11/default-logo.png");
INSERT INTO `jmkn_postmeta` VALUES("54", "15", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:61;s:6:\"height\";i:43;s:4:\"file\";s:24:\"2018/11/default-logo.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("55", "16", "_edit_lock", "1542907893:1");
INSERT INTO `jmkn_postmeta` VALUES("56", "16", "_wp_trash_meta_status", "publish");
INSERT INTO `jmkn_postmeta` VALUES("57", "16", "_wp_trash_meta_time", "1542907917");
INSERT INTO `jmkn_postmeta` VALUES("58", "17", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("59", "17", "_edit_lock", "1542909241:1");
INSERT INTO `jmkn_postmeta` VALUES("60", "17", "_the_champ_meta", "a:5:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;s:7:\"counter\";i:0;s:16:\"vertical_counter\";i:0;s:11:\"fb_comments\";i:0;}");
INSERT INTO `jmkn_postmeta` VALUES("61", "17", "um_content_restriction", "a:8:{s:26:\"_um_custom_access_settings\";s:1:\"0\";s:14:\"_um_accessible\";s:1:\"0\";s:19:\"_um_noaccess_action\";s:1:\"0\";s:30:\"_um_restrict_by_custom_message\";s:1:\"0\";s:27:\"_um_restrict_custom_message\";s:0:\"\";s:19:\"_um_access_redirect\";s:1:\"0\";s:23:\"_um_access_redirect_url\";s:0:\"\";s:28:\"_um_access_hide_from_queries\";s:1:\"0\";}");
INSERT INTO `jmkn_postmeta` VALUES("71", "20", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("72", "20", "_menu_item_menu_item_parent", "0");
INSERT INTO `jmkn_postmeta` VALUES("73", "20", "_menu_item_object_id", "2");
INSERT INTO `jmkn_postmeta` VALUES("74", "20", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("75", "20", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("76", "20", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("77", "20", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("78", "20", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("89", "22", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("90", "22", "_menu_item_menu_item_parent", "20");
INSERT INTO `jmkn_postmeta` VALUES("91", "22", "_menu_item_object_id", "11");
INSERT INTO `jmkn_postmeta` VALUES("92", "22", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("93", "22", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("94", "22", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("95", "22", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("96", "22", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("98", "23", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("99", "23", "_menu_item_menu_item_parent", "20");
INSERT INTO `jmkn_postmeta` VALUES("100", "23", "_menu_item_object_id", "7");
INSERT INTO `jmkn_postmeta` VALUES("101", "23", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("102", "23", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("103", "23", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("104", "23", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("105", "23", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("107", "24", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("108", "24", "_menu_item_menu_item_parent", "20");
INSERT INTO `jmkn_postmeta` VALUES("109", "24", "_menu_item_object_id", "10");
INSERT INTO `jmkn_postmeta` VALUES("110", "24", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("111", "24", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("112", "24", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("113", "24", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("114", "24", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("116", "25", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("117", "25", "_menu_item_menu_item_parent", "20");
INSERT INTO `jmkn_postmeta` VALUES("118", "25", "_menu_item_object_id", "9");
INSERT INTO `jmkn_postmeta` VALUES("119", "25", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("120", "25", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("121", "25", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("122", "25", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("123", "25", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("125", "26", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("126", "26", "_menu_item_menu_item_parent", "0");
INSERT INTO `jmkn_postmeta` VALUES("127", "26", "_menu_item_object_id", "3");
INSERT INTO `jmkn_postmeta` VALUES("128", "26", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("129", "26", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("130", "26", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("131", "26", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("132", "26", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("134", "27", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("135", "27", "_menu_item_menu_item_parent", "26");
INSERT INTO `jmkn_postmeta` VALUES("136", "27", "_menu_item_object_id", "14");
INSERT INTO `jmkn_postmeta` VALUES("137", "27", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("138", "27", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("139", "27", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("140", "27", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("141", "27", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("143", "28", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("144", "28", "_menu_item_menu_item_parent", "26");
INSERT INTO `jmkn_postmeta` VALUES("145", "28", "_menu_item_object_id", "13");
INSERT INTO `jmkn_postmeta` VALUES("146", "28", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("147", "28", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("148", "28", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("149", "28", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("150", "28", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("152", "29", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("153", "29", "_menu_item_menu_item_parent", "26");
INSERT INTO `jmkn_postmeta` VALUES("154", "29", "_menu_item_object_id", "15");
INSERT INTO `jmkn_postmeta` VALUES("155", "29", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("156", "29", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("157", "29", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("158", "29", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("159", "29", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("161", "30", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("162", "30", "_menu_item_menu_item_parent", "26");
INSERT INTO `jmkn_postmeta` VALUES("163", "30", "_menu_item_object_id", "12");
INSERT INTO `jmkn_postmeta` VALUES("164", "30", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("165", "30", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("166", "30", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("167", "30", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("168", "30", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("170", "31", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("171", "31", "_menu_item_menu_item_parent", "0");
INSERT INTO `jmkn_postmeta` VALUES("172", "31", "_menu_item_object_id", "5");
INSERT INTO `jmkn_postmeta` VALUES("173", "31", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("174", "31", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("175", "31", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("176", "31", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("177", "31", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("179", "32", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("180", "32", "_menu_item_menu_item_parent", "31");
INSERT INTO `jmkn_postmeta` VALUES("181", "32", "_menu_item_object_id", "22");
INSERT INTO `jmkn_postmeta` VALUES("182", "32", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("183", "32", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("184", "32", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("185", "32", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("186", "32", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("188", "33", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("189", "33", "_menu_item_menu_item_parent", "31");
INSERT INTO `jmkn_postmeta` VALUES("190", "33", "_menu_item_object_id", "23");
INSERT INTO `jmkn_postmeta` VALUES("191", "33", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("192", "33", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("193", "33", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("194", "33", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("195", "33", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("197", "34", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("198", "34", "_menu_item_menu_item_parent", "31");
INSERT INTO `jmkn_postmeta` VALUES("199", "34", "_menu_item_object_id", "24");
INSERT INTO `jmkn_postmeta` VALUES("200", "34", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("201", "34", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("202", "34", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("203", "34", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("204", "34", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("206", "35", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("207", "35", "_menu_item_menu_item_parent", "31");
INSERT INTO `jmkn_postmeta` VALUES("208", "35", "_menu_item_object_id", "25");
INSERT INTO `jmkn_postmeta` VALUES("209", "35", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("210", "35", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("211", "35", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("212", "35", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("213", "35", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("215", "36", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("216", "36", "_menu_item_menu_item_parent", "0");
INSERT INTO `jmkn_postmeta` VALUES("217", "36", "_menu_item_object_id", "4");
INSERT INTO `jmkn_postmeta` VALUES("218", "36", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("219", "36", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("220", "36", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("221", "36", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("222", "36", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("224", "37", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("225", "37", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("226", "37", "_menu_item_object_id", "21");
INSERT INTO `jmkn_postmeta` VALUES("227", "37", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("228", "37", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("229", "37", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("230", "37", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("231", "37", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("233", "38", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("234", "38", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("235", "38", "_menu_item_object_id", "16");
INSERT INTO `jmkn_postmeta` VALUES("236", "38", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("237", "38", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("238", "38", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("239", "38", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("240", "38", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("242", "39", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("243", "39", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("244", "39", "_menu_item_object_id", "17");
INSERT INTO `jmkn_postmeta` VALUES("245", "39", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("246", "39", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("247", "39", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("248", "39", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("249", "39", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("251", "40", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("252", "40", "_menu_item_menu_item_parent", "26");
INSERT INTO `jmkn_postmeta` VALUES("253", "40", "_menu_item_object_id", "18");
INSERT INTO `jmkn_postmeta` VALUES("254", "40", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("255", "40", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("256", "40", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("257", "40", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("258", "40", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("260", "41", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("261", "41", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("262", "41", "_menu_item_object_id", "20");
INSERT INTO `jmkn_postmeta` VALUES("263", "41", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("264", "41", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("265", "41", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("266", "41", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("267", "41", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("269", "42", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("270", "42", "_menu_item_menu_item_parent", "26");
INSERT INTO `jmkn_postmeta` VALUES("271", "42", "_menu_item_object_id", "19");
INSERT INTO `jmkn_postmeta` VALUES("272", "42", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("273", "42", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("274", "42", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("275", "42", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("276", "42", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("278", "43", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("279", "43", "_menu_item_menu_item_parent", "0");
INSERT INTO `jmkn_postmeta` VALUES("280", "43", "_menu_item_object_id", "1");
INSERT INTO `jmkn_postmeta` VALUES("281", "43", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("282", "43", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("283", "43", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("284", "43", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("285", "43", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("286", "43", "_menu_item_orphaned", "1542910133");
INSERT INTO `jmkn_postmeta` VALUES("296", "45", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("297", "45", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("298", "45", "_menu_item_object_id", "26");
INSERT INTO `jmkn_postmeta` VALUES("299", "45", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("300", "45", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("301", "45", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("302", "45", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("303", "45", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("305", "46", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("306", "46", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("307", "46", "_menu_item_object_id", "27");
INSERT INTO `jmkn_postmeta` VALUES("308", "46", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("309", "46", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("310", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("311", "46", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("312", "46", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("314", "47", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("315", "47", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("316", "47", "_menu_item_object_id", "28");
INSERT INTO `jmkn_postmeta` VALUES("317", "47", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("318", "47", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("319", "47", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("320", "47", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("321", "47", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("323", "48", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("324", "48", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("325", "48", "_menu_item_object_id", "29");
INSERT INTO `jmkn_postmeta` VALUES("326", "48", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("327", "48", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("328", "48", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("329", "48", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("330", "48", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("332", "49", "_menu_item_type", "taxonomy");
INSERT INTO `jmkn_postmeta` VALUES("333", "49", "_menu_item_menu_item_parent", "26");
INSERT INTO `jmkn_postmeta` VALUES("334", "49", "_menu_item_object_id", "30");
INSERT INTO `jmkn_postmeta` VALUES("335", "49", "_menu_item_object", "category");
INSERT INTO `jmkn_postmeta` VALUES("336", "49", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("337", "49", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("338", "49", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("339", "49", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("341", "50", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("342", "50", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("343", "50", "um_content_restriction", "a:8:{s:26:\"_um_custom_access_settings\";s:1:\"0\";s:14:\"_um_accessible\";s:1:\"0\";s:19:\"_um_noaccess_action\";s:1:\"0\";s:30:\"_um_restrict_by_custom_message\";s:1:\"0\";s:27:\"_um_restrict_custom_message\";s:0:\"\";s:19:\"_um_access_redirect\";s:1:\"0\";s:23:\"_um_access_redirect_url\";s:0:\"\";s:28:\"_um_access_hide_from_queries\";s:1:\"0\";}");
INSERT INTO `jmkn_postmeta` VALUES("344", "50", "_edit_lock", "1543338532:1");
INSERT INTO `jmkn_postmeta` VALUES("345", "52", "_edit_lock", "1542971245:1");
INSERT INTO `jmkn_postmeta` VALUES("346", "52", "_wp_trash_meta_status", "publish");
INSERT INTO `jmkn_postmeta` VALUES("347", "52", "_wp_trash_meta_time", "1542971262");
INSERT INTO `jmkn_postmeta` VALUES("348", "53", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("349", "53", "_edit_lock", "1542984801:1");
INSERT INTO `jmkn_postmeta` VALUES("350", "53", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("351", "53", "sayidan_text", "Test test\r\n\r\ntest");
INSERT INTO `jmkn_postmeta` VALUES("352", "53", "sayidan_location", "Yamoussoukro");
INSERT INTO `jmkn_postmeta` VALUES("353", "53", "sayidan_latlon", "43,50");
INSERT INTO `jmkn_postmeta` VALUES("354", "53", "sayidan_time", "1541599200");
INSERT INTO `jmkn_postmeta` VALUES("356", "57", "_um_core", "user");
INSERT INTO `jmkn_postmeta` VALUES("357", "58", "_um_core", "login");
INSERT INTO `jmkn_postmeta` VALUES("358", "59", "_um_core", "register");
INSERT INTO `jmkn_postmeta` VALUES("359", "60", "_um_core", "members");
INSERT INTO `jmkn_postmeta` VALUES("360", "61", "_um_core", "logout");
INSERT INTO `jmkn_postmeta` VALUES("361", "62", "_um_core", "account");
INSERT INTO `jmkn_postmeta` VALUES("362", "63", "_um_core", "password-reset");
INSERT INTO `jmkn_postmeta` VALUES("363", "64", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("364", "65", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:10:\"Event test\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:9:\"upcomming\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"128095bf80d4a48cf0420170939\";s:19:\"_sow_form_timestamp\";s:13:\"1542983028807\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6e5be42c-96ce-44a6-ba2f-0c7250ed8075\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:29:\"sayidan_events_widget-6510000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("365", "64", "_the_champ_meta", "a:5:{s:7:\"sharing\";i:0;s:16:\"vertical_sharing\";i:0;s:7:\"counter\";i:0;s:16:\"vertical_counter\";i:0;s:11:\"fb_comments\";i:0;}");
INSERT INTO `jmkn_postmeta` VALUES("366", "64", "um_content_restriction", "a:8:{s:26:\"_um_custom_access_settings\";s:1:\"0\";s:14:\"_um_accessible\";s:1:\"0\";s:19:\"_um_noaccess_action\";s:1:\"0\";s:30:\"_um_restrict_by_custom_message\";s:1:\"0\";s:27:\"_um_restrict_custom_message\";s:0:\"\";s:19:\"_um_access_redirect\";s:1:\"0\";s:23:\"_um_access_redirect_url\";s:0:\"\";s:28:\"_um_access_hide_from_queries\";s:1:\"0\";}");
INSERT INTO `jmkn_postmeta` VALUES("367", "64", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:10:\"Event test\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:9:\"upcomming\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"128095bf80d4a48cf0420170939\";s:19:\"_sow_form_timestamp\";s:13:\"1542983028807\";s:2:\"id\";s:29:\"sayidan_events_widget-6410000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6e5be42c-96ce-44a6-ba2f-0c7250ed8075\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("368", "66", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:10:\"Event test\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:9:\"upcomming\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"128095bf80d4a48cf0420170939\";s:19:\"_sow_form_timestamp\";s:13:\"1542983028807\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6e5be42c-96ce-44a6-ba2f-0c7250ed8075\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:29:\"sayidan_events_widget-6410000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("369", "64", "_title", "on");
INSERT INTO `jmkn_postmeta` VALUES("370", "64", "_narrow_content", "on");
INSERT INTO `jmkn_postmeta` VALUES("371", "64", "_edit_lock", "1542984643:1");
INSERT INTO `jmkn_postmeta` VALUES("372", "67", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:10:\"Event test\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:9:\"upcomming\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"128095bf80d4a48cf0420170939\";s:19:\"_sow_form_timestamp\";s:13:\"1542983028807\";s:2:\"id\";s:29:\"sayidan_events_widget-6710000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6e5be42c-96ce-44a6-ba2f-0c7250ed8075\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("373", "68", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:10:\"Event test\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:9:\"upcomming\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"128095bf80d4a48cf0420170939\";s:19:\"_sow_form_timestamp\";s:13:\"1542983028807\";s:2:\"id\";s:29:\"sayidan_events_widget-6410000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6e5be42c-96ce-44a6-ba2f-0c7250ed8075\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("383", "70", "_menu_item_type", "post_type");
INSERT INTO `jmkn_postmeta` VALUES("384", "70", "_menu_item_menu_item_parent", "36");
INSERT INTO `jmkn_postmeta` VALUES("385", "70", "_menu_item_object_id", "59");
INSERT INTO `jmkn_postmeta` VALUES("386", "70", "_menu_item_object", "page");
INSERT INTO `jmkn_postmeta` VALUES("387", "70", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("388", "70", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("389", "70", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("390", "70", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("392", "59", "_edit_lock", "1542983759:1");
INSERT INTO `jmkn_postmeta` VALUES("408", "79", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("409", "79", "_edit_lock", "1542984609:1");
INSERT INTO `jmkn_postmeta` VALUES("410", "80", "_wp_attached_file", "2018/11/event.jpg");
INSERT INTO `jmkn_postmeta` VALUES("411", "80", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:550;s:6:\"height\";i:232;s:4:\"file\";s:17:\"2018/11/event.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"event-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"event-300x127.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:127;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:17:\"event-290x232.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:232;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:17:\"event-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:15:\"event-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"event-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("412", "79", "_thumbnail_id", "80");
INSERT INTO `jmkn_postmeta` VALUES("413", "81", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:11:\"Evènements\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"251915bf813a3c357a302728383\";s:19:\"_sow_form_timestamp\";s:13:\"1542984679996\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"f3bd05b7-dcce-492a-a292-7923a6a7ee9b\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:29:\"sayidan_events_widget-8110000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("414", "79", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("415", "79", "um_content_restriction", "a:8:{s:26:\"_um_custom_access_settings\";s:1:\"0\";s:14:\"_um_accessible\";s:1:\"0\";s:19:\"_um_noaccess_action\";s:1:\"0\";s:30:\"_um_restrict_by_custom_message\";s:1:\"0\";s:27:\"_um_restrict_custom_message\";s:0:\"\";s:19:\"_um_access_redirect\";s:1:\"0\";s:23:\"_um_access_redirect_url\";s:0:\"\";s:28:\"_um_access_hide_from_queries\";s:1:\"0\";}");
INSERT INTO `jmkn_postmeta` VALUES("416", "79", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:11:\"Evènements\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"251915bf813a3c357a302728383\";s:19:\"_sow_form_timestamp\";s:13:\"1542984679996\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"f3bd05b7-dcce-492a-a292-7923a6a7ee9b\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:29:\"sayidan_events_widget-7910000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("417", "82", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:10:{s:5:\"title\";s:11:\"Evènements\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:6:\"header\";b:1;s:10:\"pagination\";b:1;s:12:\"_sow_form_id\";s:27:\"251915bf813a3c357a302728383\";s:19:\"_sow_form_timestamp\";s:13:\"1542984679996\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"f3bd05b7-dcce-492a-a292-7923a6a7ee9b\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:29:\"sayidan_events_widget-7910000\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("418", "79", "_narrow_content", "on");
INSERT INTO `jmkn_postmeta` VALUES("419", "64", "_wp_trash_meta_status", "publish");
INSERT INTO `jmkn_postmeta` VALUES("420", "64", "_wp_trash_meta_time", "1542984782");
INSERT INTO `jmkn_postmeta` VALUES("421", "64", "_wp_desired_post_slug", "64-2");
INSERT INTO `jmkn_postmeta` VALUES("422", "53", "_thumbnail_id", "80");
INSERT INTO `jmkn_postmeta` VALUES("423", "53", "sayidan_animate", "on");
INSERT INTO `jmkn_postmeta` VALUES("424", "84", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("425", "84", "_edit_lock", "1542985501:1");
INSERT INTO `jmkn_postmeta` VALUES("426", "84", "_thumbnail_id", "80");
INSERT INTO `jmkn_postmeta` VALUES("427", "84", "_the_champ_meta", "a:2:{s:16:\"vertical_sharing\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("428", "84", "sayidan_text", "Rencontre entre diplômé(e)s de l\'Ecole Supérieure d\'Industrie ce samedi 04/11/2018 à partir de 10h à l\'auditorium....");
INSERT INTO `jmkn_postmeta` VALUES("429", "84", "sayidan_animate", "on");
INSERT INTO `jmkn_postmeta` VALUES("430", "84", "sayidan_location", "Abidjan");
INSERT INTO `jmkn_postmeta` VALUES("431", "84", "sayidan_latlon", "5.363536, -3.960257");
INSERT INTO `jmkn_postmeta` VALUES("432", "84", "sayidan_time", "1543449600");
INSERT INTO `jmkn_postmeta` VALUES("433", "86", "_menu_item_type", "post_type");
INSERT INTO `jmkn_postmeta` VALUES("434", "86", "_menu_item_menu_item_parent", "20");
INSERT INTO `jmkn_postmeta` VALUES("435", "86", "_menu_item_object_id", "79");
INSERT INTO `jmkn_postmeta` VALUES("436", "86", "_menu_item_object", "page");
INSERT INTO `jmkn_postmeta` VALUES("437", "86", "_menu_item_target", "");
INSERT INTO `jmkn_postmeta` VALUES("438", "86", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `jmkn_postmeta` VALUES("439", "86", "_menu_item_xfn", "");
INSERT INTO `jmkn_postmeta` VALUES("440", "86", "_menu_item_url", "");
INSERT INTO `jmkn_postmeta` VALUES("442", "88", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:13:{s:5:\"title\";s:0:\"\";s:15:\"images_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:4:\"text\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:12:\"_sow_form_id\";s:27:\"131085bf8197229588511436435\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:22:\"sayidan_gallery_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b36fb24f-853d-4435-9575-d999eca69dd3\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_gallery_widget-8810000\";s:11:\"option_name\";s:29:\"widget_sayidan_gallery_widget\";}i:1;a:9:{s:16:\"autoplay_timeout\";b:0;s:10:\"a_repeater\";a:1:{i:0;a:7:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:0;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"251155bf8198c038c4201164710\";s:19:\"_sow_form_timestamp\";s:13:\"1542986317035\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"9f1caa9e-d82b-4367-90c1-46d71ac73030\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:9:\"auto_play\";b:0;s:4:\"loop\";b:0;s:2:\"id\";s:29:\"sayidan_slider_widget-8810001\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";}i:2;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:27:\"sayidan_news_widget-8810002\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("443", "50", "panels_data", "a:3:{s:7:\"widgets\";a:7:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:3:{s:2:\"id\";s:34:\"sayidan_singleevent_widget-5010001\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:3:\"url\";s:63:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;s:2:\"id\";s:11:\"rss-5010003\";s:11:\"option_name\";s:10:\"widget_rss\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"4125ee10-d764-4c35-883b-07b878139145\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:9:{s:5:\"title\";s:11:\"OFFRES CFAO\";s:3:\"url\";s:61:\"http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;s:2:\"id\";s:11:\"rss-5010004\";s:11:\"option_name\";s:10:\"widget_rss\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"e679c23e-b649-4856-b1c9-b6096b942330\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:9:{s:5:\"title\";s:27:\"ACTUALITES EN COTE D\'IVOIRE\";s:3:\"url\";s:44:\"http://news.abidjan.net/xml/actu_all_rss.xml\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;s:2:\"id\";s:11:\"rss-5010005\";s:11:\"option_name\";s:10:\"widget_rss\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"9f50b5fa-5e2c-4a72-8b02-3c6998dccac9\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:6;a:9:{s:9:\"auto_play\";b:1;s:4:\"loop\";b:1;s:16:\"autoplay_timeout\";b:0;s:10:\"a_repeater\";a:16:{i:0;a:7:{s:5:\"title\";s:7:\"Docteur\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:268;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:7:\"Docteur\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:1;a:7:{s:5:\"title\";s:5:\"ESCAE\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:273;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:2;a:7:{s:5:\"title\";s:3:\"ESI\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:274;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:3;a:7:{s:5:\"title\";s:4:\"ESTP\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:275;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:4;a:7:{s:5:\"title\";s:4:\"ESMG\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:276;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:5;a:7:{s:5:\"title\";s:3:\"ESA\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:277;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:6;a:7:{s:5:\"title\";s:7:\"Docteur\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:268;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:7;a:7:{s:5:\"title\";s:7:\"Docteur\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:278;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:8;a:7:{s:5:\"title\";s:7:\"Docteur\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:279;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:9;a:7:{s:5:\"title\";s:7:\"Docteur\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:281;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:10;a:7:{s:5:\"title\";s:9:\"Rencontre\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:282;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:11;a:7:{s:5:\"title\";s:6:\"INP-HB\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:283;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:12;a:7:{s:5:\"title\";s:7:\"Docteur\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:284;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:13;a:7:{s:5:\"title\";s:7:\"Docteur\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:285;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:14;a:7:{s:5:\"title\";s:6:\"INP-HB\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:287;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:15;a:7:{s:5:\"title\";s:6:\"INP-HB\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:288;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"176055bfd28bb82508043527999\";s:19:\"_sow_form_timestamp\";s:13:\"1543318604820\";s:2:\"id\";s:29:\"sayidan_slider_widget-5010006\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"d87fd991-27b0-41cc-8c57-a5cbb728756e\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("444", "89", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:13:{s:5:\"title\";s:0:\"\";s:15:\"images_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:4:\"text\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:12:\"_sow_form_id\";s:27:\"131085bf8197229588511436435\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:22:\"sayidan_gallery_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b36fb24f-853d-4435-9575-d999eca69dd3\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_gallery_widget-5010000\";s:11:\"option_name\";s:29:\"widget_sayidan_gallery_widget\";}i:1;a:9:{s:16:\"autoplay_timeout\";b:0;s:10:\"a_repeater\";a:1:{i:0;a:7:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:0;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"251155bf8198c038c4201164710\";s:19:\"_sow_form_timestamp\";s:13:\"1542986317035\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"9f1caa9e-d82b-4367-90c1-46d71ac73030\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:9:\"auto_play\";b:0;s:4:\"loop\";b:0;s:2:\"id\";s:29:\"sayidan_slider_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";}i:2;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:27:\"sayidan_news_widget-5010002\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("445", "50", "_title", "on");
INSERT INTO `jmkn_postmeta` VALUES("446", "50", "_narrow_content", "on");
INSERT INTO `jmkn_postmeta` VALUES("447", "1", "_wp_trash_meta_status", "publish");
INSERT INTO `jmkn_postmeta` VALUES("448", "1", "_wp_trash_meta_time", "1542987691");
INSERT INTO `jmkn_postmeta` VALUES("449", "1", "_wp_desired_post_slug", "bonjour-tout-le-monde");
INSERT INTO `jmkn_postmeta` VALUES("450", "1", "_wp_trash_meta_comments_status", "a:1:{i:1;s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("451", "92", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("452", "92", "_edit_lock", "1543313955:1");
INSERT INTO `jmkn_postmeta` VALUES("453", "93", "_wp_attached_file", "2018/11/img.jpg");
INSERT INTO `jmkn_postmeta` VALUES("454", "93", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:300;s:6:\"height\";i:199;s:4:\"file\";s:15:\"2018/11/img.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:15:\"img-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"img-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:15:\"img-290x199.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:15:\"img-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:13:\"img-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:15:\"img-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"5\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:11:\"NIKON D3200\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:10:\"1496061608\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:2:\"52\";s:3:\"iso\";s:3:\"400\";s:13:\"shutter_speed\";s:6:\"0.0125\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"1\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("455", "92", "_thumbnail_id", "247");
INSERT INTO `jmkn_postmeta` VALUES("458", "92", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("459", "92", "um_content_restriction", "a:8:{s:26:\"_um_custom_access_settings\";s:1:\"0\";s:14:\"_um_accessible\";s:1:\"0\";s:19:\"_um_noaccess_action\";s:1:\"0\";s:30:\"_um_restrict_by_custom_message\";s:1:\"0\";s:27:\"_um_restrict_custom_message\";s:0:\"\";s:19:\"_um_access_redirect\";s:1:\"0\";s:23:\"_um_access_redirect_url\";s:0:\"\";s:28:\"_um_access_hide_from_queries\";s:1:\"0\";}");
INSERT INTO `jmkn_postmeta` VALUES("460", "95", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("461", "95", "_edit_lock", "1543314268:1");
INSERT INTO `jmkn_postmeta` VALUES("462", "96", "_wp_attached_file", "2018/11/polytech.jpg");
INSERT INTO `jmkn_postmeta` VALUES("463", "96", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:638;s:4:\"file\";s:20:\"2018/11/polytech.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"polytech-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"polytech-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"polytech-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:20:\"polytech-583x573.jpg\";s:5:\"width\";i:583;s:6:\"height\";i:573;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:20:\"polytech-569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"sayidan-story-large\";a:4:{s:4:\"file\";s:20:\"polytech-960x637.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:637;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:20:\"polytech-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:20:\"polytech-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:18:\"polytech-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"sayidan-blog\";a:4:{s:4:\"file\";s:20:\"polytech-750x405.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"polytech-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("464", "95", "_thumbnail_id", "96");
INSERT INTO `jmkn_postmeta` VALUES("467", "95", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("468", "95", "um_content_restriction", "a:8:{s:26:\"_um_custom_access_settings\";s:1:\"0\";s:14:\"_um_accessible\";s:1:\"0\";s:19:\"_um_noaccess_action\";s:1:\"0\";s:30:\"_um_restrict_by_custom_message\";s:1:\"0\";s:27:\"_um_restrict_custom_message\";s:0:\"\";s:19:\"_um_access_redirect\";s:1:\"0\";s:23:\"_um_access_redirect_url\";s:0:\"\";s:28:\"_um_access_hide_from_queries\";s:1:\"0\";}");
INSERT INTO `jmkn_postmeta` VALUES("477", "87", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:13:{s:5:\"title\";s:0:\"\";s:15:\"images_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:4:\"text\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:12:\"_sow_form_id\";s:27:\"131085bf8197229588511436435\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:22:\"sayidan_gallery_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b36fb24f-853d-4435-9575-d999eca69dd3\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_gallery_widget-5010000\";s:11:\"option_name\";s:29:\"widget_sayidan_gallery_widget\";}i:1;a:9:{s:16:\"autoplay_timeout\";b:0;s:10:\"a_repeater\";a:1:{i:0;a:7:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:0;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"251155bf8198c038c4201164710\";s:19:\"_sow_form_timestamp\";s:13:\"1542986317035\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"9f1caa9e-d82b-4367-90c1-46d71ac73030\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:9:\"auto_play\";b:0;s:4:\"loop\";b:0;s:2:\"id\";s:29:\"sayidan_slider_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";}i:2;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:27:\"sayidan_news_widget-5010002\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("478", "102", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:13:{s:5:\"title\";s:0:\"\";s:15:\"images_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:4:\"text\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:12:\"_sow_form_id\";s:27:\"131085bf8197229588511436435\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"pagination\";b:0;s:2:\"id\";s:31:\"sayidan_gallery_widget-10210000\";s:11:\"option_name\";s:29:\"widget_sayidan_gallery_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:22:\"sayidan_gallery_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b36fb24f-853d-4435-9575-d999eca69dd3\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:9:{s:9:\"auto_play\";b:1;s:4:\"loop\";b:1;s:16:\"autoplay_timeout\";d:5;s:10:\"a_repeater\";a:3:{i:0;a:7:{s:5:\"title\";s:8:\"Drogba 1\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:101;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:1;a:7:{s:5:\"title\";s:8:\"Drogba 2\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:100;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:2;a:7:{s:5:\"title\";s:8:\"Drogba 3\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:99;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"251155bf8198c038c4201164710\";s:19:\"_sow_form_timestamp\";s:13:\"1542988706960\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"9f1caa9e-d82b-4367-90c1-46d71ac73030\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:30:\"sayidan_slider_widget-10210001\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";}i:2;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-10210002\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("479", "103", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:13:{s:5:\"title\";s:0:\"\";s:15:\"images_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:4:\"text\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:12:\"_sow_form_id\";s:27:\"131085bf8197229588511436435\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_gallery_widget-5010000\";s:11:\"option_name\";s:29:\"widget_sayidan_gallery_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:22:\"sayidan_gallery_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b36fb24f-853d-4435-9575-d999eca69dd3\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:9:{s:9:\"auto_play\";b:1;s:4:\"loop\";b:1;s:16:\"autoplay_timeout\";d:5;s:10:\"a_repeater\";a:3:{i:0;a:7:{s:5:\"title\";s:8:\"Drogba 1\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:101;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:1;a:7:{s:5:\"title\";s:8:\"Drogba 2\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:100;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:2;a:7:{s:5:\"title\";s:8:\"Drogba 3\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:99;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"251155bf8198c038c4201164710\";s:19:\"_sow_form_timestamp\";s:13:\"1542988706960\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"9f1caa9e-d82b-4367-90c1-46d71ac73030\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:29:\"sayidan_slider_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";}i:2;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010002\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("482", "105", "_wp_attached_file", "2018/11/INPHB-4.jpg");
INSERT INTO `jmkn_postmeta` VALUES("483", "105", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:730;s:6:\"height\";i:547;s:4:\"file\";s:19:\"2018/11/INPHB-4.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"INPHB-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"INPHB-4-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:19:\"INPHB-4-583x547.jpg\";s:5:\"width\";i:583;s:6:\"height\";i:547;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:19:\"INPHB-4-569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:19:\"INPHB-4-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:19:\"INPHB-4-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:17:\"INPHB-4-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"sayidan-blog\";a:4:{s:4:\"file\";s:19:\"INPHB-4-730x405.jpg\";s:5:\"width\";i:730;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:19:\"INPHB-4-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("484", "106", "_wp_attached_file", "2018/11/images-1-1-e1530095022779.jpg");
INSERT INTO `jmkn_postmeta` VALUES("485", "106", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:580;s:6:\"height\";i:360;s:4:\"file\";s:37:\"2018/11/images-1-1-e1530095022779.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:37:\"images-1-1-e1530095022779-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:37:\"images-1-1-e1530095022779-300x186.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:186;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:37:\"images-1-1-e1530095022779-569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:37:\"images-1-1-e1530095022779-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:37:\"images-1-1-e1530095022779-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:35:\"images-1-1-e1530095022779-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:37:\"images-1-1-e1530095022779-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("486", "107", "_wp_attached_file", "2018/11/11633390.jpg");
INSERT INTO `jmkn_postmeta` VALUES("487", "107", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:500;s:6:\"height\";i:375;s:4:\"file\";s:20:\"2018/11/11633390.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"11633390-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"11633390-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:20:\"11633390-500x331.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:20:\"11633390-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:20:\"11633390-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:18:\"11633390-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:20:\"11633390-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("488", "108", "_wp_attached_file", "2018/11/inphb.jpg");
INSERT INTO `jmkn_postmeta` VALUES("489", "108", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:600;s:6:\"height\";i:400;s:4:\"file\";s:17:\"2018/11/inphb.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"inphb-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"inphb-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:17:\"inphb-583x400.jpg\";s:5:\"width\";i:583;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:17:\"inphb-569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:17:\"inphb-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:17:\"inphb-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:15:\"inphb-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:17:\"inphb-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("490", "109", "_wp_attached_file", "2018/11/INP-HB-CI.jpg");
INSERT INTO `jmkn_postmeta` VALUES("491", "109", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:634;s:6:\"height\";i:374;s:4:\"file\";s:21:\"2018/11/INP-HB-CI.jpg\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"INP-HB-CI-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"INP-HB-CI-300x177.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:177;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:21:\"INP-HB-CI-583x374.jpg\";s:5:\"width\";i:583;s:6:\"height\";i:374;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:21:\"INP-HB-CI-569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:21:\"INP-HB-CI-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:21:\"INP-HB-CI-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:19:\"INP-HB-CI-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:21:\"INP-HB-CI-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("492", "110", "_wp_attached_file", "2018/11/beded5272d48bc02bc6b093086c287c2_XL.jpg");
INSERT INTO `jmkn_postmeta` VALUES("493", "110", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:738;s:6:\"height\";i:492;s:4:\"file\";s:47:\"2018/11/beded5272d48bc02bc6b093086c287c2_XL.jpg\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-583x492.jpg\";s:5:\"width\";i:583;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:45:\"beded5272d48bc02bc6b093086c287c2_XL-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"sayidan-blog\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-738x405.jpg\";s:5:\"width\";i:738;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:47:\"beded5272d48bc02bc6b093086c287c2_XL-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("494", "111", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:13:{s:5:\"title\";s:0:\"\";s:15:\"images_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:4:\"text\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:12:\"_sow_form_id\";s:27:\"131085bf8197229588511436435\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"pagination\";b:0;s:2:\"id\";s:31:\"sayidan_gallery_widget-11110000\";s:11:\"option_name\";s:29:\"widget_sayidan_gallery_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:22:\"sayidan_gallery_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b36fb24f-853d-4435-9575-d999eca69dd3\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:9:{s:9:\"auto_play\";b:1;s:4:\"loop\";b:1;s:16:\"autoplay_timeout\";d:5;s:10:\"a_repeater\";a:6:{i:0;a:7:{s:5:\"title\";s:7:\"Image 1\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:110;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:1;a:7:{s:5:\"title\";s:7:\"Image 2\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:109;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:2;a:7:{s:5:\"title\";s:7:\"Image 3\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:108;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:3;a:7:{s:5:\"title\";s:7:\"Image 4\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:107;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:4;a:7:{s:5:\"title\";s:7:\"Image 5\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:106;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:5;a:7:{s:5:\"title\";s:2:\"Im\";s:8:\"subtitle\";s:7:\"Image 6\";s:5:\"image\";i:105;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"251155bf8198c038c4201164710\";s:19:\"_sow_form_timestamp\";s:13:\"1542989325481\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"9f1caa9e-d82b-4367-90c1-46d71ac73030\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:30:\"sayidan_slider_widget-11110001\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";}i:2;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-11110002\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("495", "112", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:13:{s:5:\"title\";s:0:\"\";s:15:\"images_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:4:\"text\";s:0:\"\";s:4:\"icon\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:12:\"_sow_form_id\";s:27:\"131085bf8197229588511436435\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_gallery_widget-5010000\";s:11:\"option_name\";s:29:\"widget_sayidan_gallery_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:22:\"sayidan_gallery_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b36fb24f-853d-4435-9575-d999eca69dd3\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:9:{s:9:\"auto_play\";b:1;s:4:\"loop\";b:1;s:16:\"autoplay_timeout\";d:5;s:10:\"a_repeater\";a:6:{i:0;a:7:{s:5:\"title\";s:7:\"Image 1\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:110;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:1;a:7:{s:5:\"title\";s:7:\"Image 2\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:109;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:2;a:7:{s:5:\"title\";s:7:\"Image 3\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:108;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:3;a:7:{s:5:\"title\";s:7:\"Image 4\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:107;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:4;a:7:{s:5:\"title\";s:7:\"Image 5\";s:8:\"subtitle\";s:0:\"\";s:5:\"image\";i:106;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}i:5;a:7:{s:5:\"title\";s:2:\"Im\";s:8:\"subtitle\";s:7:\"Image 6\";s:5:\"image\";i:105;s:14:\"image_fallback\";s:0:\"\";s:11:\"button_text\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:10:\"visibility\";b:0;}}s:12:\"_sow_form_id\";s:27:\"251155bf8198c038c4201164710\";s:19:\"_sow_form_timestamp\";s:13:\"1542989325481\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_slider_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"9f1caa9e-d82b-4367-90c1-46d71ac73030\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:29:\"sayidan_slider_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_slider_widget\";}i:2;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010002\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("496", "113", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:28:\"sayidan_news_widget-11310000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("497", "114", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("498", "115", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-11510000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:133:\"post_type=post&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-11510001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("499", "116", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:133:\"post_type=post&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("500", "117", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-11710000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:179:\"post_type=page&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992735146\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-11710001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("501", "118", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:179:\"post_type=page&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992735146\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("502", "119", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-11910000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-11910001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("503", "120", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("504", "121", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-12110000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:2:\"id\";s:26:\"sow-post-carousel-12110001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("505", "122", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("506", "123", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("507", "123", "_edit_lock", "1542993854:1");
INSERT INTO `jmkn_postmeta` VALUES("508", "123", "wpfcrf_feed_url_source", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("509", "123", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("510", "125", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("511", "125", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/senior-monitoring-evaluation-officer-m-e-cdsf-3893/");
INSERT INTO `jmkn_postmeta` VALUES("512", "125", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("513", "125", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("514", "125", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("515", "125", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("516", "126", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("517", "126", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/case-management-and-advisory-services-officer-bcrm-3896/");
INSERT INTO `jmkn_postmeta` VALUES("518", "126", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("519", "126", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("520", "126", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("521", "126", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("522", "127", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("523", "127", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/development-effectiveness-and-quality-assurance-officer-snoq2-3898/");
INSERT INTO `jmkn_postmeta` VALUES("524", "127", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("525", "127", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("526", "127", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("527", "127", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("528", "128", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("529", "128", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-forestry-officer-ecnr-3900/");
INSERT INTO `jmkn_postmeta` VALUES("530", "128", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("531", "128", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("532", "128", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("533", "128", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("534", "129", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("535", "129", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/conference-and-meetings-technology-and-facilities-officer-pseg-1-3892/");
INSERT INTO `jmkn_postmeta` VALUES("536", "129", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("537", "129", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("538", "129", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("539", "129", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("540", "130", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("541", "130", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/post-editing-and-proofreading-officer-english-language-chls0-3890/");
INSERT INTO `jmkn_postmeta` VALUES("542", "130", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("543", "130", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("544", "130", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("545", "130", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("546", "131", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("547", "131", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/director-transition-states-coordination-office-3876/");
INSERT INTO `jmkn_postmeta` VALUES("548", "131", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("549", "131", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("550", "131", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("551", "131", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("552", "132", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("553", "132", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/division-manager-microeconomic-institutional-and-development-impact-ecmr-2-3880/");
INSERT INTO `jmkn_postmeta` VALUES("554", "132", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("555", "132", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("556", "132", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("557", "132", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("558", "133", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("559", "133", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/post-editing-and-proofreading-officer-french-language-chls0-3888/");
INSERT INTO `jmkn_postmeta` VALUES("560", "133", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("561", "133", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("562", "133", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("563", "133", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("564", "134", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("565", "134", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-fishery-officer-ecnr-3902/");
INSERT INTO `jmkn_postmeta` VALUES("566", "134", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("567", "134", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("568", "134", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("569", "134", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("570", "135", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("571", "135", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/secretary-receptionist-rdgc-0-3904/");
INSERT INTO `jmkn_postmeta` VALUES("572", "135", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("573", "135", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("574", "135", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("575", "135", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("576", "136", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("577", "136", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-regional-energy-markets-expert-pesd1-3916/");
INSERT INTO `jmkn_postmeta` VALUES("578", "136", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("579", "136", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("580", "136", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("581", "136", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("582", "137", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("583", "137", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-health-economist-ahhd2-3918/");
INSERT INTO `jmkn_postmeta` VALUES("584", "137", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("585", "137", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("586", "137", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("587", "137", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("588", "138", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("589", "138", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-transport-engineer-rdge3-3920/");
INSERT INTO `jmkn_postmeta` VALUES("590", "138", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("591", "138", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("592", "138", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("593", "138", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("594", "139", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("595", "139", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/public-private-partnership-finance-expert-awf-3922/");
INSERT INTO `jmkn_postmeta` VALUES("596", "139", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("597", "139", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("598", "139", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("599", "139", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("600", "140", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("601", "140", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/senior-resource-mobilization-and-partnership-officer-firm-1-3914/");
INSERT INTO `jmkn_postmeta` VALUES("602", "140", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("603", "140", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("604", "140", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("605", "140", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("606", "141", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("607", "141", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-social-protection-officer-rdgc2-3912/");
INSERT INTO `jmkn_postmeta` VALUES("608", "141", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("609", "141", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("610", "141", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("611", "141", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("612", "142", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("613", "142", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/chief-financial-risk-officer-fifm1-3906/");
INSERT INTO `jmkn_postmeta` VALUES("614", "142", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("615", "142", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("616", "142", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("617", "142", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("618", "143", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("619", "143", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-financial-risk-officer-fifm1-3908/");
INSERT INTO `jmkn_postmeta` VALUES("620", "143", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("621", "143", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("622", "143", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("623", "143", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("624", "144", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("625", "144", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/principal-research-economist-ecmr-2-3910/");
INSERT INTO `jmkn_postmeta` VALUES("626", "144", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("627", "144", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("628", "144", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("629", "144", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("630", "145", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("631", "145", "wpfcrf_feed_post_url", "https://www.afdb.org/fr/about-us/careers/current-vacancies/director-renewable-energy-and-energy-efficiency-pern0-3924/");
INSERT INTO `jmkn_postmeta` VALUES("632", "145", "wpfcrf_feed_source_name", "POSTES VACANTS BAD");
INSERT INTO `jmkn_postmeta` VALUES("633", "145", "wpfcrf_feed_source_id", "123");
INSERT INTO `jmkn_postmeta` VALUES("634", "145", "wpfcrf_feed_source_link", "https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/");
INSERT INTO `jmkn_postmeta` VALUES("635", "145", "wpfcrf_feed_source_slug", "postes-vacants-bad");
INSERT INTO `jmkn_postmeta` VALUES("636", "146", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-14610000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:2:\"id\";s:26:\"sow-post-carousel-14610001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("637", "147", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("638", "149", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-14910000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:2:\"id\";s:26:\"sow-post-carousel-14910001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:3:\"url\";s:63:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/\";s:5:\"items\";i:10;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;s:11:\"panels_info\";a:6:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"c413f025-6f7c-4174-a298-a5ae8bf477f1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:12:\"rss-14910002\";s:11:\"option_name\";s:10:\"widget_rss\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("639", "150", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542992814108\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:3:\"url\";s:63:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/\";s:5:\"items\";i:10;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;s:11:\"panels_info\";a:6:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"c413f025-6f7c-4174-a298-a5ae8bf477f1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:11:\"rss-5010002\";s:11:\"option_name\";s:10:\"widget_rss\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("640", "151", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-15110000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:189:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994719611\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-15110001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:2;a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:3:\"url\";s:63:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/\";s:5:\"items\";i:10;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;s:2:\"id\";s:12:\"rss-15110002\";s:11:\"option_name\";s:10:\"widget_rss\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"c413f025-6f7c-4174-a298-a5ae8bf477f1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:143:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994806903\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-15110003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("641", "152", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:189:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994719611\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:2;a:9:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:3:\"url\";s:63:\"https://www.afdb.org/fr/about-us/careers/current-vacancies/rss/\";s:5:\"items\";i:10;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;s:2:\"id\";s:11:\"rss-5010002\";s:11:\"option_name\";s:10:\"widget_rss\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"c413f025-6f7c-4174-a298-a5ae8bf477f1\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:143:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994806903\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("642", "153", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-15310000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-15310001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:143:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994806903\";s:2:\"id\";s:26:\"sow-post-carousel-15310002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("643", "154", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:143:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994806903\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("644", "155", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-15510000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-15510001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-15510002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("645", "156", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("646", "157", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:26:\"sow-post-carousel-15710000\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-15710001\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-15710002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("647", "158", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:25:\"sow-post-carousel-5010000\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010001\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("648", "159", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-15910000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-15910001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:26:\"sow-post-carousel-15910002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("649", "160", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("650", "161", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:28:\"sayidan_news_widget-16110000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-16110001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:26:\"sow-post-carousel-16110002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("651", "162", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("652", "163", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:28:\"sayidan_news_widget-16310000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-16310001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:8:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:26:\"sow-post-carousel-16310002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:8:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("653", "164", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:8:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542994943630\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:8:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}s:10:\"cell_index\";i:0;}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:3:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("654", "165", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("655", "165", "_edit_lock", "1542997079:1");
INSERT INTO `jmkn_postmeta` VALUES("656", "165", "wpfcrf_feed_url_source", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("657", "165", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("658", "166", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("659", "166", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=226&idOrigine=502&LCID=1036&offerReference=AESDCAPVEXP112018-226");
INSERT INTO `jmkn_postmeta` VALUES("660", "166", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("661", "166", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("662", "166", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("663", "166", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("664", "167", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("665", "167", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=222&idOrigine=502&LCID=1036&offerReference=ARMCDIV092018-222");
INSERT INTO `jmkn_postmeta` VALUES("666", "167", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("667", "167", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("668", "167", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("669", "167", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("670", "168", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("671", "168", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=221&idOrigine=502&LCID=1036&offerReference=2018-221");
INSERT INTO `jmkn_postmeta` VALUES("672", "168", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("673", "168", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("674", "168", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("675", "168", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("676", "169", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("677", "169", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=206&idOrigine=502&LCID=1036&offerReference=AESWAARM092018-206");
INSERT INTO `jmkn_postmeta` VALUES("678", "169", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("679", "169", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("680", "169", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("681", "169", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("682", "170", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("683", "170", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=223&idOrigine=502&LCID=1036&offerReference=AESDRPSCDI092018-223");
INSERT INTO `jmkn_postmeta` VALUES("684", "170", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("685", "170", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("686", "170", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("687", "170", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("688", "171", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("689", "171", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=231&idOrigine=502&LCID=1036&offerReference=203-231");
INSERT INTO `jmkn_postmeta` VALUES("690", "171", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("691", "171", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("692", "171", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("693", "171", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("694", "172", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("695", "172", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=224&idOrigine=502&LCID=1036&offerReference=2018-224");
INSERT INTO `jmkn_postmeta` VALUES("696", "172", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("697", "172", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("698", "172", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("699", "172", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("700", "173", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("701", "173", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=225&idOrigine=502&LCID=1036&offerReference=AESRESPMQUE0918-225");
INSERT INTO `jmkn_postmeta` VALUES("702", "173", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("703", "173", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("704", "173", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("705", "173", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("706", "174", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("707", "174", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=232&idOrigine=502&LCID=1036&offerReference=AESWACH2018-232");
INSERT INTO `jmkn_postmeta` VALUES("708", "174", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("709", "174", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("710", "174", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("711", "174", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("712", "175", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("713", "175", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=220&idOrigine=502&LCID=1036&offerReference=AESARMSAV072018-220");
INSERT INTO `jmkn_postmeta` VALUES("714", "175", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("715", "175", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("716", "175", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("717", "175", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("718", "176", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("719", "176", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=203&idOrigine=502&LCID=1036&offerReference=2018-203");
INSERT INTO `jmkn_postmeta` VALUES("720", "176", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("721", "176", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("722", "176", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("723", "176", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("724", "177", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("725", "177", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=212&idOrigine=502&LCID=1036&offerReference=2018-212");
INSERT INTO `jmkn_postmeta` VALUES("726", "177", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("727", "177", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("728", "177", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("729", "177", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("730", "178", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("731", "178", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=195&idOrigine=502&LCID=1036&offerReference=2017-195");
INSERT INTO `jmkn_postmeta` VALUES("732", "178", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("733", "178", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("734", "178", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("735", "178", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("736", "179", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("737", "179", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=210&idOrigine=502&LCID=1036&offerReference=2018-210");
INSERT INTO `jmkn_postmeta` VALUES("738", "179", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("739", "179", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("740", "179", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("741", "179", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("742", "180", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("743", "180", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=214&idOrigine=502&LCID=1036&offerReference=2018-214");
INSERT INTO `jmkn_postmeta` VALUES("744", "180", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("745", "180", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("746", "180", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("747", "180", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("748", "181", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("749", "181", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=216&idOrigine=502&LCID=1036&offerReference=ADJRMVW092018-216");
INSERT INTO `jmkn_postmeta` VALUES("750", "181", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("751", "181", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("752", "181", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("753", "181", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("754", "182", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("755", "182", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=166&idOrigine=502&LCID=1036&offerReference=STGConso-166");
INSERT INTO `jmkn_postmeta` VALUES("756", "182", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("757", "182", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("758", "182", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("759", "182", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("760", "183", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("761", "183", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=219&idOrigine=502&LCID=1036&offerReference=2018-219");
INSERT INTO `jmkn_postmeta` VALUES("762", "183", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("763", "183", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("764", "183", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("765", "183", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("766", "184", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("767", "184", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=217&idOrigine=502&LCID=1036&offerReference=ARPSAES092018-217");
INSERT INTO `jmkn_postmeta` VALUES("768", "184", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("769", "184", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("770", "184", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("771", "184", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("772", "185", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("773", "185", "wpfcrf_feed_post_url", "http://cfao.profils.org/Pages/Offre/detailoffre.aspx?idOffre=230&idOrigine=502&LCID=1036&offerReference=2018-256-230");
INSERT INTO `jmkn_postmeta` VALUES("774", "185", "wpfcrf_feed_source_name", "OFFRES CFAO");
INSERT INTO `jmkn_postmeta` VALUES("775", "185", "wpfcrf_feed_source_id", "165");
INSERT INTO `jmkn_postmeta` VALUES("776", "185", "wpfcrf_feed_source_link", "http://careers.cfaogroup.com/handlers/offerRss.ashx?LCID=1036");
INSERT INTO `jmkn_postmeta` VALUES("777", "185", "wpfcrf_feed_source_slug", "offres-cfao");
INSERT INTO `jmkn_postmeta` VALUES("778", "186", "_wp_attached_file", "2018/11/CFAO-logo_2.png");
INSERT INTO `jmkn_postmeta` VALUES("779", "186", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1389;s:6:\"height\";i:453;s:4:\"file\";s:23:\"2018/11/CFAO-logo_2.png\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"CFAO-logo_2-300x98.png\";s:5:\"width\";i:300;s:6:\"height\";i:98;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-768x250.png\";s:5:\"width\";i:768;s:6:\"height\";i:250;s:9:\"mime-type\";s:9:\"image/png\";}s:5:\"large\";a:4:{s:4:\"file\";s:24:\"CFAO-logo_2-1024x334.png\";s:5:\"width\";i:1024;s:6:\"height\";i:334;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-583x453.png\";s:5:\"width\";i:583;s:6:\"height\";i:453;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-569x331.png\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-290x290.png\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-262x179.png\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:21:\"CFAO-logo_2-93x93.png\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"sayidan-blog\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-750x405.png\";s:5:\"width\";i:750;s:6:\"height\";i:405;s:9:\"mime-type\";s:9:\"image/png\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:23:\"CFAO-logo_2-272x182.png\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("780", "187", "_wp_attached_file", "2018/11/Logo-BAD-620x330.png");
INSERT INTO `jmkn_postmeta` VALUES("781", "187", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:620;s:6:\"height\";i:330;s:4:\"file\";s:28:\"2018/11/Logo-BAD-620x330.png\";s:5:\"sizes\";a:8:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"Logo-BAD-620x330-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"Logo-BAD-620x330-300x160.png\";s:5:\"width\";i:300;s:6:\"height\";i:160;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:28:\"Logo-BAD-620x330-583x330.png\";s:5:\"width\";i:583;s:6:\"height\";i:330;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:28:\"Logo-BAD-620x330-569x330.png\";s:5:\"width\";i:569;s:6:\"height\";i:330;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:28:\"Logo-BAD-620x330-290x290.png\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:9:\"image/png\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:28:\"Logo-BAD-620x330-262x179.png\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:26:\"Logo-BAD-620x330-93x93.png\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:9:\"image/png\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:28:\"Logo-BAD-620x330-272x182.png\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("782", "188", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-18810000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-18810001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-18810002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-18810003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:3:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:5:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("783", "189", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:2;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:3:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:5:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("784", "190", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:28:\"sayidan_news_widget-19010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-19010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-19010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:26:\"sow-post-carousel-19010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:4:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("785", "191", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542987328633\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:4:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("786", "192", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:11:\"show_header\";b:0;s:2:\"id\";s:28:\"sayidan_news_widget-19210000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-19210001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:2:\"id\";s:26:\"sow-post-carousel-19210002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:26:\"sow-post-carousel-19210003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:4:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("787", "193", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:11:\"show_header\";b:0;s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:2:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:4:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("788", "194", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("789", "194", "wpfcrf_feed_url_source", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("790", "194", "_the_champ_meta", "a:5:{s:7:\"sharing\";s:1:\"1\";s:16:\"vertical_sharing\";s:1:\"1\";s:7:\"counter\";s:1:\"1\";s:16:\"vertical_counter\";s:1:\"1\";s:11:\"fb_comments\";s:1:\"1\";}");
INSERT INTO `jmkn_postmeta` VALUES("791", "194", "_edit_lock", "1543244447:1");
INSERT INTO `jmkn_postmeta` VALUES("792", "195", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("793", "195", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648373.html");
INSERT INTO `jmkn_postmeta` VALUES("794", "195", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("795", "195", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("796", "195", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("797", "195", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("798", "196", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("799", "196", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648378.html");
INSERT INTO `jmkn_postmeta` VALUES("800", "196", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("801", "196", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("802", "196", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("803", "196", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("804", "197", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("805", "197", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648384.html");
INSERT INTO `jmkn_postmeta` VALUES("806", "197", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("807", "197", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("808", "197", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("809", "197", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("810", "198", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("811", "198", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648369.html");
INSERT INTO `jmkn_postmeta` VALUES("812", "198", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("813", "198", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("814", "198", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("815", "198", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("816", "199", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("817", "199", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648382.html");
INSERT INTO `jmkn_postmeta` VALUES("818", "199", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("819", "199", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("820", "199", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("821", "199", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("822", "200", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("823", "200", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648365.html");
INSERT INTO `jmkn_postmeta` VALUES("824", "200", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("825", "200", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("826", "200", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("827", "200", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("828", "201", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("829", "201", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648347.html");
INSERT INTO `jmkn_postmeta` VALUES("830", "201", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("831", "201", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("832", "201", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("833", "201", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("834", "202", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("835", "202", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648385.html");
INSERT INTO `jmkn_postmeta` VALUES("836", "202", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("837", "202", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("838", "202", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("839", "202", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("840", "203", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("841", "203", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648386.html");
INSERT INTO `jmkn_postmeta` VALUES("842", "203", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("843", "203", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("844", "203", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("845", "203", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("846", "204", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("847", "204", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648383.html");
INSERT INTO `jmkn_postmeta` VALUES("848", "204", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("849", "204", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("850", "204", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("851", "204", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("852", "205", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("853", "205", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648366.html");
INSERT INTO `jmkn_postmeta` VALUES("854", "205", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("855", "205", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("856", "205", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("857", "205", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("858", "206", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("859", "206", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648367.html");
INSERT INTO `jmkn_postmeta` VALUES("860", "206", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("861", "206", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("862", "206", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("863", "206", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("864", "207", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("865", "207", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648390.html");
INSERT INTO `jmkn_postmeta` VALUES("866", "207", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("867", "207", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("868", "207", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("869", "207", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("870", "208", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("871", "208", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648389.html");
INSERT INTO `jmkn_postmeta` VALUES("872", "208", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("873", "208", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("874", "208", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("875", "208", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("876", "209", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("877", "209", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648387.html");
INSERT INTO `jmkn_postmeta` VALUES("878", "209", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("879", "209", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("880", "209", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("881", "209", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("882", "210", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("883", "210", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648388.html");
INSERT INTO `jmkn_postmeta` VALUES("884", "210", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("885", "210", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("886", "210", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("887", "210", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("888", "211", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("889", "211", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648381.html");
INSERT INTO `jmkn_postmeta` VALUES("890", "211", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("891", "211", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("892", "211", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("893", "211", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("894", "212", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("895", "212", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648380.html");
INSERT INTO `jmkn_postmeta` VALUES("896", "212", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("897", "212", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("898", "212", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("899", "212", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("900", "213", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("901", "213", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648129.html");
INSERT INTO `jmkn_postmeta` VALUES("902", "213", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("903", "213", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("904", "213", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("905", "213", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("906", "214", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("907", "214", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648345.html");
INSERT INTO `jmkn_postmeta` VALUES("908", "214", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("909", "214", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("910", "214", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("911", "214", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("912", "215", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("913", "215", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648368.html");
INSERT INTO `jmkn_postmeta` VALUES("914", "215", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("915", "215", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("916", "215", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("917", "215", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("918", "216", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("919", "216", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648370.html");
INSERT INTO `jmkn_postmeta` VALUES("920", "216", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("921", "216", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("922", "216", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("923", "216", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("924", "217", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("925", "217", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648362.html");
INSERT INTO `jmkn_postmeta` VALUES("926", "217", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("927", "217", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("928", "217", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("929", "217", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("930", "218", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("931", "218", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648356.html");
INSERT INTO `jmkn_postmeta` VALUES("932", "218", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("933", "218", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("934", "218", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("935", "218", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("936", "219", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("937", "219", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648354.html");
INSERT INTO `jmkn_postmeta` VALUES("938", "219", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("939", "219", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("940", "219", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("941", "219", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("942", "220", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("943", "220", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648376.html");
INSERT INTO `jmkn_postmeta` VALUES("944", "220", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("945", "220", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("946", "220", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("947", "220", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("948", "221", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("949", "221", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648374.html");
INSERT INTO `jmkn_postmeta` VALUES("950", "221", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("951", "221", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("952", "221", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("953", "221", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("954", "222", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("955", "222", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648375.html");
INSERT INTO `jmkn_postmeta` VALUES("956", "222", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("957", "222", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("958", "222", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("959", "222", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("960", "223", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("961", "223", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648377.html");
INSERT INTO `jmkn_postmeta` VALUES("962", "223", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("963", "223", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("964", "223", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("965", "223", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("966", "224", "wpfcrf_related_post_type", "wpfcrf_sources");
INSERT INTO `jmkn_postmeta` VALUES("967", "224", "wpfcrf_feed_post_url", "https://news.abidjan.net/h/648379.html");
INSERT INTO `jmkn_postmeta` VALUES("968", "224", "wpfcrf_feed_source_name", "ACTUALITES COTE D’IVOIRE");
INSERT INTO `jmkn_postmeta` VALUES("969", "224", "wpfcrf_feed_source_id", "194");
INSERT INTO `jmkn_postmeta` VALUES("970", "224", "wpfcrf_feed_source_link", "http://news.abidjan.net/xml/actu_all_rss.xml");
INSERT INTO `jmkn_postmeta` VALUES("971", "224", "wpfcrf_feed_source_slug", "actualites-cote-divoire");
INSERT INTO `jmkn_postmeta` VALUES("972", "225", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:28:\"sayidan_news_widget-22510000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-22510001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:2:\"id\";s:26:\"sow-post-carousel-22510002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:26:\"sow-post-carousel-22510003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:10:{s:5:\"title\";s:4:\"ACTU\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"194185bf842c9c6f84084043469\";s:19:\"_sow_form_timestamp\";s:13:\"1542996698062\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"3ed57206-d6a0-42f6-8f78-1969fdb3698a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-22510004\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:3:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:6:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("973", "226", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:187:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542995973105\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:10:{s:5:\"title\";s:4:\"ACTU\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"194185bf842c9c6f84084043469\";s:19:\"_sow_form_timestamp\";s:13:\"1542996698062\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"3ed57206-d6a0-42f6-8f78-1969fdb3698a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010004\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}}s:5:\"grids\";a:3:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:6:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("974", "227", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:28:\"sayidan_news_widget-22710000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-22710001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:6:\"medium\";s:5:\"posts\";s:189:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542996882498\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:26:\"sow-post-carousel-22710002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:26:\"sow-post-carousel-22710003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:10:{s:5:\"title\";s:4:\"ACTU\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"194185bf842c9c6f84084043469\";s:19:\"_sow_form_timestamp\";s:13:\"1542996698062\";s:2:\"id\";s:26:\"sow-post-carousel-22710004\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"3ed57206-d6a0-42f6-8f78-1969fdb3698a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:6:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("975", "228", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:18:\"POSTES VACANTS BAD\";s:17:\"default_thumbnail\";i:187;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:6:\"medium\";s:5:\"posts\";s:189:\"post_type=wpfcrf_sources&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"205645bf83b502348f507626580\";s:19:\"_sow_form_timestamp\";s:13:\"1542996882498\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:4:\"grid\";i:1;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"59198be7-8fac-4ec6-9a76-785fac53a733\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";}i:3;a:10:{s:5:\"title\";s:10:\"OFFRE CFAO\";s:17:\"default_thumbnail\";i:186;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"104405bf83f6c668c5275931937\";s:19:\"_sow_form_timestamp\";s:13:\"1542995890737\";s:2:\"id\";s:25:\"sow-post-carousel-5010003\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:1;s:4:\"cell\";i:1;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"7ef2951a-c65b-4b17-b9fa-c2579a997e1f\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:10:{s:5:\"title\";s:4:\"ACTU\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:141:\"post_type=wpfcrf_feeds&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":[],\"to\":[]}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"194185bf842c9c6f84084043469\";s:19:\"_sow_form_timestamp\";s:13:\"1542996698062\";s:2:\"id\";s:25:\"sow-post-carousel-5010004\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:2;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"3ed57206-d6a0-42f6-8f78-1969fdb3698a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:3:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}i:1;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}i:2;a:2:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}}}s:10:\"grid_cells\";a:6:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}i:2;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:3;a:4:{s:4:\"grid\";i:1;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:4;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:0;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}i:5;a:4:{s:4:\"grid\";i:2;s:5:\"index\";i:1;s:6:\"weight\";d:0.5;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("976", "229", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:28:\"sayidan_news_widget-22910000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-22910001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}}s:10:\"grid_cells\";a:2:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("977", "230", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010001\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}}s:10:\"grid_cells\";a:2:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("978", "231", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:28:\"sayidan_news_widget-23110000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:8:{s:5:\"title\";s:6:\"egrhty\";s:16:\"records_per_page\";s:1:\"2\";s:12:\"_sow_form_id\";s:27:\"109375bf846e58075a447168859\";s:19:\"_sow_form_timestamp\";s:13:\"1542997762323\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"2b05c527-0621-45eb-8772-61701d640aff\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:11:\"show_header\";b:0;s:2:\"id\";s:28:\"sayidan_news_widget-23110001\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:2;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:26:\"sow-post-carousel-23110002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}}s:10:\"grid_cells\";a:2:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("979", "232", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:4:\"News\";s:16:\"records_per_page\";s:1:\"4\";s:12:\"_sow_form_id\";s:27:\"122165bf81e2e4f0ef079176256\";s:19:\"_sow_form_timestamp\";s:13:\"1542996144150\";s:11:\"show_header\";b:0;s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"b81c566b-4d2d-4a21-93da-788c103b901a\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:8:{s:5:\"title\";s:6:\"egrhty\";s:16:\"records_per_page\";s:1:\"2\";s:12:\"_sow_form_id\";s:27:\"109375bf846e58075a447168859\";s:19:\"_sow_form_timestamp\";s:13:\"1542997762323\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"2b05c527-0621-45eb-8772-61701d640aff\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:11:\"show_header\";b:0;s:2:\"id\";s:27:\"sayidan_news_widget-5010001\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}i:2;a:10:{s:5:\"title\";s:0:\"\";s:17:\"default_thumbnail\";i:0;s:26:\"default_thumbnail_fallback\";s:0:\"\";s:10:\"image_size\";s:20:\"sow-carousel-default\";s:5:\"posts\";s:180:\"post_type=event&date_type=specific&date_query={\"after\":\"\",\"before\":\"\"}&date_query_relative={\"from\":{\"value\":0,\"unit\":\"days\"},\"to\":{\"value\":0,\"unit\":\"days\"}}&orderby=date&order=DESC\";s:12:\"_sow_form_id\";s:27:\"273585bf832dd5bebf889912297\";s:19:\"_sow_form_timestamp\";s:13:\"1542994845865\";s:2:\"id\";s:25:\"sow-post-carousel-5010002\";s:11:\"option_name\";s:24:\"widget_sow-post-carousel\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:37:\"SiteOrigin_Widget_PostCarousel_Widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:1;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"6d3df95e-7706-4db2-9eb2-5f12e74e486c\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:4:{s:5:\"cells\";i:2;s:5:\"style\";a:3:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";s:14:\"cell_alignment\";s:10:\"flex-start\";}s:5:\"ratio\";d:0.33333332999999998;s:15:\"ratio_direction\";s:5:\"right\";}}s:10:\"grid_cells\";a:2:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";d:0.75000000187500004;s:5:\"style\";a:0:{}}i:1;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:1;s:6:\"weight\";d:0.24999999812500001;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("980", "233", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:3:{s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:0:{}}s:2:\"id\";s:28:\"sayidan_news_widget-23310000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("981", "234", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:3:{s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:0:{}}s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("982", "235", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:28:\"sayidan_news_widget-23510000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("983", "236", "panels_data", "a:3:{s:7:\"widgets\";a:1:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("984", "237", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-23710000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:9:\"upcomming\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-23710001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("985", "238", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:9:\"upcomming\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("986", "239", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-23910000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-23910001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("987", "240", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("988", "243", "_edit_last", "1");
INSERT INTO `jmkn_postmeta` VALUES("989", "243", "_edit_lock", "1543250316:1");
INSERT INTO `jmkn_postmeta` VALUES("994", "247", "_wp_attached_file", "2018/11/120-t-l-charg-.jpg");
INSERT INTO `jmkn_postmeta` VALUES("995", "247", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:6016;s:6:\"height\";i:4000;s:4:\"file\";s:26:\"2018/11/120-t-l-charg-.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--768x511.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:511;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"120-t-l-charg--1024x681.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:681;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--583x573.jpg\";s:5:\"width\";i:583;s:6:\"height\";i:573;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"sayidan-story-large\";a:4:{s:4:\"file\";s:27:\"120-t-l-charg--1536x637.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:637;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:24:\"120-t-l-charg--93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"sayidan-blog\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--750x405.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:26:\"120-t-l-charg--272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("998", "248", "panels_data", "a:3:{s:7:\"widgets\";a:7:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-24810000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-24810001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:9:{s:16:\"records_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:12:\"_sow_form_id\";s:27:\"246815bfd1d75312e5007880498\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_career_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"f83b8b27-2b0e-4fff-8cbe-620e16e785f7\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:11:\"show_filter\";b:0;s:2:\"id\";s:30:\"sayidan_career_widget-24810002\";s:11:\"option_name\";s:28:\"widget_sayidan_career_widget\";}i:3;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"search_bar\";b:0;s:2:\"id\";s:33:\"sayidan_directory_widget-24810003\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";}i:4;a:8:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:12:\"_sow_form_id\";s:26:\"47285bfd1d8d7887a603300297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:23:\"sayidan_ourstory_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"c17a7553-7c92-49b9-8862-6f37e22ab08d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:32:\"sayidan_ourstory_widget-24810004\";s:11:\"option_name\";s:30:\"widget_sayidan_ourstory_widget\";}i:5;a:6:{s:7:\"evet_id\";b:0;s:12:\"_sow_form_id\";s:27:\"138675bfd1da4cbc5b875122808\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"b6d753d1-445e-433b-8e0a-d6b82f5ba9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:35:\"sayidan_singleevent_widget-24810005\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";}i:6;a:3:{s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}s:2:\"id\";s:28:\"sayidan_info_widget-24810006\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("999", "249", "panels_data", "a:3:{s:7:\"widgets\";a:7:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:9:{s:16:\"records_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:12:\"_sow_form_id\";s:27:\"246815bfd1d75312e5007880498\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_career_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"f83b8b27-2b0e-4fff-8cbe-620e16e785f7\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:11:\"show_filter\";b:0;s:2:\"id\";s:29:\"sayidan_career_widget-5010002\";s:11:\"option_name\";s:28:\"widget_sayidan_career_widget\";}i:3;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"search_bar\";b:0;s:2:\"id\";s:32:\"sayidan_directory_widget-5010003\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";}i:4;a:8:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:12:\"_sow_form_id\";s:26:\"47285bfd1d8d7887a603300297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:23:\"sayidan_ourstory_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"c17a7553-7c92-49b9-8862-6f37e22ab08d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:31:\"sayidan_ourstory_widget-5010004\";s:11:\"option_name\";s:30:\"widget_sayidan_ourstory_widget\";}i:5;a:6:{s:7:\"evet_id\";b:0;s:12:\"_sow_form_id\";s:27:\"138675bfd1da4cbc5b875122808\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"b6d753d1-445e-433b-8e0a-d6b82f5ba9b0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:34:\"sayidan_singleevent_widget-5010005\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";}i:6;a:3:{s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:6;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}s:2:\"id\";s:27:\"sayidan_info_widget-5010006\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1000", "250", "panels_data", "a:3:{s:7:\"widgets\";a:6:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-25010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-25010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:9:{s:16:\"records_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:12:\"_sow_form_id\";s:27:\"246815bfd1d75312e5007880498\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"show_filter\";b:0;s:2:\"id\";s:30:\"sayidan_career_widget-25010002\";s:11:\"option_name\";s:28:\"widget_sayidan_career_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_career_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"f83b8b27-2b0e-4fff-8cbe-620e16e785f7\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:33:\"sayidan_directory_widget-25010003\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:8:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:12:\"_sow_form_id\";s:26:\"47285bfd1d8d7887a603300297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:32:\"sayidan_ourstory_widget-25010004\";s:11:\"option_name\";s:30:\"widget_sayidan_ourstory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:23:\"sayidan_ourstory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"c17a7553-7c92-49b9-8862-6f37e22ab08d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:3:{s:2:\"id\";s:28:\"sayidan_info_widget-25010005\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1001", "251", "panels_data", "a:3:{s:7:\"widgets\";a:6:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:9:{s:16:\"records_per_page\";b:0;s:8:\"category\";s:0:\"\";s:4:\"type\";s:6:\"normal\";s:12:\"_sow_form_id\";s:27:\"246815bfd1d75312e5007880498\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"show_filter\";b:0;s:2:\"id\";s:29:\"sayidan_career_widget-5010002\";s:11:\"option_name\";s:28:\"widget_sayidan_career_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_career_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"f83b8b27-2b0e-4fff-8cbe-620e16e785f7\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:32:\"sayidan_directory_widget-5010003\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:8:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:12:\"_sow_form_id\";s:26:\"47285bfd1d8d7887a603300297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:31:\"sayidan_ourstory_widget-5010004\";s:11:\"option_name\";s:30:\"widget_sayidan_ourstory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:23:\"sayidan_ourstory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"c17a7553-7c92-49b9-8862-6f37e22ab08d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:5;a:3:{s:2:\"id\";s:27:\"sayidan_info_widget-5010005\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:5;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1002", "252", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-25210000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-25210001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:33:\"sayidan_directory_widget-25210002\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:8:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:12:\"_sow_form_id\";s:26:\"47285bfd1d8d7887a603300297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:32:\"sayidan_ourstory_widget-25210003\";s:11:\"option_name\";s:30:\"widget_sayidan_ourstory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:23:\"sayidan_ourstory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"c17a7553-7c92-49b9-8862-6f37e22ab08d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:3:{s:2:\"id\";s:28:\"sayidan_info_widget-25210004\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1003", "253", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:32:\"sayidan_directory_widget-5010002\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:8:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:12:\"_sow_form_id\";s:26:\"47285bfd1d8d7887a603300297\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:31:\"sayidan_ourstory_widget-5010003\";s:11:\"option_name\";s:30:\"widget_sayidan_ourstory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:23:\"sayidan_ourstory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"c17a7553-7c92-49b9-8862-6f37e22ab08d\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:4;a:3:{s:2:\"id\";s:27:\"sayidan_info_widget-5010004\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1004", "254", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-25410000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-25410001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:33:\"sayidan_directory_widget-25410002\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:3:{s:2:\"id\";s:28:\"sayidan_info_widget-25410003\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1005", "255", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:32:\"sayidan_directory_widget-5010002\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:3:{s:2:\"id\";s:27:\"sayidan_info_widget-5010003\";s:11:\"option_name\";s:26:\"widget_sayidan_info_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_info_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"36da8732-83ac-4b37-8ad3-d42d7e9d9790\";s:5:\"style\";a:0:{}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1006", "256", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-25610000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-25610001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:33:\"sayidan_directory_widget-25610002\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1007", "257", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:4:\"auto\";s:8:\"category\";s:0:\"\";s:16:\"records_per_page\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"323785bfd1d7eb486a541913902\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:10:\"search_bar\";b:0;s:2:\"id\";s:32:\"sayidan_directory_widget-5010002\";s:11:\"option_name\";s:31:\"widget_sayidan_directory_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:24:\"sayidan_directory_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"9999ee69-ca48-4589-9084-be5c950ae8e4\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1008", "258", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-25810000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-25810001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1009", "259", "panels_data", "a:3:{s:7:\"widgets\";a:2:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1010", "260", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-26010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-26010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:3:{s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}s:2:\"id\";s:35:\"sayidan_singleevent_widget-26010002\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1011", "261", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010001\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:3:{s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}s:2:\"id\";s:34:\"sayidan_singleevent_widget-5010002\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1012", "262", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:3:{s:2:\"id\";s:35:\"sayidan_singleevent_widget-26210000\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:1;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-26210001\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-26210002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1013", "263", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:3:{s:2:\"id\";s:34:\"sayidan_singleevent_widget-5010000\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:1;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010001\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1014", "264", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-26410000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:3:{s:2:\"id\";s:35:\"sayidan_singleevent_widget-26410001\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-26410002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1015", "265", "panels_data", "a:3:{s:7:\"widgets\";a:3:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:3:{s:2:\"id\";s:34:\"sayidan_singleevent_widget-5010001\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1016", "266", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-26610000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:3:{s:2:\"id\";s:35:\"sayidan_singleevent_widget-26610001\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-26610002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:0:\"\";s:5:\"image\";i:0;s:14:\"image_fallback\";s:0:\"\";s:9:\"animation\";s:6:\"zoomIn\";s:12:\"_sow_form_id\";s:27:\"224605bfd2462c2c50719117192\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:22:\"sayidan_feature_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"0389e5d3-2abf-4a55-90cf-4629856ef806\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:31:\"sayidan_feature_widget-26610003\";s:11:\"option_name\";s:29:\"widget_sayidan_feature_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1017", "267", "panels_data", "a:3:{s:7:\"widgets\";a:4:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:3:{s:2:\"id\";s:34:\"sayidan_singleevent_widget-5010001\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:10:{s:5:\"title\";s:0:\"\";s:5:\"image\";i:0;s:14:\"image_fallback\";s:0:\"\";s:9:\"animation\";s:6:\"zoomIn\";s:12:\"_sow_form_id\";s:27:\"224605bfd2462c2c50719117192\";s:19:\"_sow_form_timestamp\";s:0:\"\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:22:\"sayidan_feature_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"0389e5d3-2abf-4a55-90cf-4629856ef806\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:10:\"a_repeater\";a:0:{}s:2:\"id\";s:30:\"sayidan_feature_widget-5010003\";s:11:\"option_name\";s:29:\"widget_sayidan_feature_widget\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1018", "268", "_wp_attached_file", "2018/11/45167940_1931495970299998_410503254640689152_n.jpg");
INSERT INTO `jmkn_postmeta` VALUES("1019", "268", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:960;s:6:\"height\";i:638;s:4:\"file\";s:58:\"2018/11/45167940_1931495970299998_410503254640689152_n.jpg\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-768x510.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:510;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"sayidan-square\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-583x573.jpg\";s:5:\"width\";i:583;s:6:\"height\";i:573;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-story\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-569x331.jpg\";s:5:\"width\";i:569;s:6:\"height\";i:331;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:19:\"sayidan-story-large\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-960x637.jpg\";s:5:\"width\";i:960;s:6:\"height\";i:637;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"sayidan-gallery\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-290x290.jpg\";s:5:\"width\";i:290;s:6:\"height\";i:290;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"sayidan-minified\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-262x179.jpg\";s:5:\"width\";i:262;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"sayidan-thumb\";a:4:{s:4:\"file\";s:56:\"45167940_1931495970299998_410503254640689152_n-93x93.jpg\";s:5:\"width\";i:93;s:6:\"height\";i:93;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"sayidan-blog\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-750x405.jpg\";s:5:\"width\";i:750;s:6:\"height\";i:405;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:20:\"sow-carousel-default\";a:4:{s:4:\"file\";s:58:\"45167940_1931495970299998_410503254640689152_n-272x182.jpg\";s:5:\"width\";i:272;s:6:\"height\";i:182;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `jmkn_postmeta` VALUES("1020", "269", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:28:\"sayidan_news_widget-26910000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:3:{s:2:\"id\";s:35:\"sayidan_singleevent_widget-26910001\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:30:\"sayidan_events_widget-26910002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:3;a:13:{s:5:\"title\";s:0:\"\";s:8:\"subtitle\";s:0:\"\";s:4:\"text\";s:0:\"\";s:4:\"type\";s:14:\"alumni_stories\";s:5:\"image\";i:268;s:14:\"image_fallback\";s:0:\"\";s:10:\"button_url\";s:1:\"#\";s:11:\"button_text\";s:0:\"\";s:12:\"_sow_form_id\";s:27:\"299445bfd24c7b6792278165849\";s:19:\"_sow_form_timestamp\";s:13:\"1543317611741\";s:11:\"panels_info\";a:6:{s:5:\"class\";s:21:\"sayidan_banner_widget\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:3;s:9:\"widget_id\";s:36:\"87966bcf-88b2-4395-9990-cabc935a1407\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:30:\"sayidan_banner_widget-26910003\";s:11:\"option_name\";s:28:\"widget_sayidan_banner_widget\";}i:4;a:9:{s:5:\"title\";s:0:\"\";s:3:\"url\";s:0:\"\";s:5:\"items\";i:10;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:1;s:9:\"show_date\";i:1;s:11:\"panels_info\";a:6:{s:5:\"class\";s:13:\"WP_Widget_RSS\";s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:4;s:9:\"widget_id\";s:36:\"d54637d4-e2eb-4378-8cd5-48f583b7dcd0\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}s:2:\"id\";s:12:\"rss-26910004\";s:11:\"option_name\";s:10:\"widget_rss\";}}s:5:\"grids\";a:1:{i:0;a:2:{s:5:\"cells\";i:1;s:5:\"style\";a:0:{}}}s:10:\"grid_cells\";a:1:{i:0;a:4:{s:4:\"grid\";i:0;s:5:\"index\";i:0;s:6:\"weight\";i:1;s:5:\"style\";a:0:{}}}}");
INSERT INTO `jmkn_postmeta` VALUES("1021", "270", "panels_data", "a:3:{s:7:\"widgets\";a:5:{i:0;a:8:{s:5:\"title\";s:0:\"\";s:16:\"records_per_page\";s:1:\"4\";s:11:\"show_header\";b:1;s:12:\"_sow_form_id\";s:27:\"145635bf8478143dec672034230\";s:19:\"_sow_form_timestamp\";s:13:\"1542997895676\";s:2:\"id\";s:27:\"sayidan_news_widget-5010000\";s:11:\"option_name\";s:26:\"widget_sayidan_news_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:19:\"sayidan_news_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:0;s:9:\"widget_id\";s:36:\"8fe78c10-458d-4cd9-94f0-9ae108cce374\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b:0;s:18:\"background_display\";s:4:\"tile\";}}}i:1;a:3:{s:2:\"id\";s:34:\"sayidan_singleevent_widget-5010001\";s:11:\"option_name\";s:33:\"widget_sayidan_singleevent_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:26:\"sayidan_singleevent_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:1;s:9:\"widget_id\";s:36:\"6da2f188-67e8-4516-b1c7-049c2c36435b\";s:5:\"style\";a:0:{}}}i:2;a:10:{s:5:\"title\";s:0:\"\";s:8:\"category\";s:0:\"\";s:6:\"events\";s:3:\"all\";s:12:\"_sow_form_id\";s:27:\"120655bf847a043e81361371995\";s:19:\"_sow_form_timestamp\";s:13:\"1542997967816\";s:6:\"header\";b:0;s:10:\"pagination\";b:0;s:2:\"id\";s:29:\"sayidan_events_widget-5010002\";s:11:\"option_name\";s:28:\"widget_sayidan_events_widget\";s:11:\"panels_info\";a:7:{s:5:\"class\";s:21:\"sayidan_events_widget\";s:3:\"raw\";b:0;s:4:\"grid\";i:0;s:4:\"cell\";i:0;s:2:\"id\";i:2;s:9:\"widget_id\";s:36:\"823676ff-70fc-4b44-9d2e-db908824a549\";s:5:\"style\";a:2:{s:27:\"background_image_attachment\";b